/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.diagnostics.collect;

import com.sun.enterprise.admin.server.core.jmx.AppServerMBeanServerFactory;
import com.sun.enterprise.admin.server.core.jmx.InitException;
import com.sun.enterprise.admin.util.ArrayConversion;
import com.sun.enterprise.admin.util.ClassUtil;
import com.sun.enterprise.diagnostics.DiagnosticException;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonitoringInfoHelper {
    private static final String LIST_COMMAND = "list";
    private static final String LIST_OPERATION = "dottedNameList";
    private static final String LIST_MONITORING_OPERATION = "dottedNameMonitoringList";
    private static final String GET_COMMAND = "get";
    private static final String GET_OPERATION = "dottedNameGet";
    private static final String GET_MONITORING_OPERATION = "dottedNameMonitoringGet";
    public static final String STRING_ARRAY = new String[0].getClass().getName();
    private static final String MONITOR_OPTION = "monitor";
    private static final String OBJECT_NAME = "com.sun.appserv:name=dotted-name-get-set,type=dotted-name-support";
    private static final String PROPERTY_STRING = "property|system-property";
    public static final String SECURE = "secure";
    private ArrayList<String> operands;
    private String name;
    private HashMap options = new HashMap();
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.tools.admin");
    private ArrayList<String> output;
    private static String OUTER_ARRAY_DELIM = System.getProperty("line.separator");
    private static String INNER_ARRAY_DELIM = ",";

    public void setOperands(ArrayList<String> operands) {
        this.operands = operands;
    }

    public ArrayList<String> getOperands() {
        return this.operands;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setOptions(HashMap options) {
        this.options = options;
    }

    public String getOption(String optionName) {
        if (!this.optionNameExist(optionName)) {
            return null;
        }
        return (String)this.options.get(optionName);
    }

    private boolean optionNameExist(String optionName) {
        return this.options.containsKey(optionName);
    }

    public void setOption(String optionName, String optionValue) {
        this.options.put(optionName, optionValue);
    }

    protected boolean getBooleanOption(String optionName) {
        return Boolean.valueOf(this.getOption(optionName));
    }

    public void runCommand(ArrayList<String> result) throws DiagnosticException {
        this.output = result;
        Object[] params = this.getDottedNamesParam(!this.getName().equals(LIST_COMMAND));
        String[] types = new String[]{STRING_ARRAY};
        String operationName = this.getOperation();
        try {
            MBeanServer mbs = AppServerMBeanServerFactory.getMBeanServerInstance();
            Object[] returnValues = (Object[])mbs.invoke(new ObjectName(OBJECT_NAME), operationName, params, types);
            if (operationName.indexOf("List") >= 0) {
                this.displayResultFromList((String[])returnValues);
            } else {
                String[] userArgs = (String[])params[0];
                this.displayResultFromGetOrSet(userArgs, returnValues);
            }
        }
        catch (InitException ie) {
            logger.log(Level.WARNING, "Initialization exception occurred while getting MBean Server Instance", ie);
            throw new DiagnosticException(ie.getMessage());
        }
        catch (Exception e) {
            String msg = this.getExceptionMessage(e);
            if (msg != null) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
            throw new DiagnosticException(e.getMessage());
        }
    }

    private void displayResultFromGetOrSet(String[] inputs, Object[] returnValues) throws Exception {
        if (returnValues.length == 1) {
            Object result = returnValues[0];
            if (result instanceof Exception) {
                throw (Exception)result;
            }
            if (result.getClass() == Attribute[].class) {
                Attribute[] attrs = (Attribute[])result;
                if (attrs.length == 0) {
                    throw new AttributeNotFoundException("NoWildcardMatches");
                }
                this.printMessage(this.stringify(attrs, OUTER_ARRAY_DELIM));
            } else {
                this.printMessage(this.stringify(result, OUTER_ARRAY_DELIM));
            }
        } else {
            Attribute[] attrs;
            for (Attribute attr : attrs = this.collectAllAttributes(returnValues)) {
                this.addToResults(attr.getName() + " = " + attr.getValue());
            }
            for (int i = 0; i < returnValues.length; ++i) {
                if (!(returnValues[i] instanceof Exception)) continue;
                Exception e = (Exception)returnValues[i];
                String msg = "ErrorInGetSet " + inputs[i] + e.getLocalizedMessage();
                this.printMessage(msg);
            }
        }
    }

    private Attribute[] collectAllAttributes(Object[] results) {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        for (Object result : results) {
            if (result instanceof Attribute) {
                attrs.put(((Attribute)result).getName(), result);
                continue;
            }
            if (result instanceof Attribute[]) {
                Attribute[] list = (Attribute[])result;
                for (int attrIndex = 0; attrIndex < list.length; ++attrIndex) {
                    Attribute attr = list[attrIndex];
                    attrs.put(attr.getName(), attr);
                }
                continue;
            }
            assert (result instanceof Exception);
        }
        Attribute[] attrsArray = new Attribute[attrs.size()];
        attrs.values().toArray(attrsArray);
        Arrays.sort(attrsArray, new AttributeComparator());
        return attrsArray;
    }

    private Object[] getDottedNamesParam(boolean convertUnderscore) {
        ArrayList<String> dottedNames = this.getOperands();
        String[] dottedNamesArray = new String[dottedNames.size()];
        for (int ii = 0; ii < dottedNames.size(); ++ii) {
            dottedNamesArray[ii] = convertUnderscore ? this.convertUnderscoreToHyphen(dottedNames.get(ii)) : dottedNames.get(ii);
        }
        return new Object[]{dottedNamesArray};
    }

    private String getOperation() {
        if (this.getName().equals(GET_COMMAND)) {
            if (this.getBooleanOption(MONITOR_OPTION)) {
                return GET_MONITORING_OPERATION;
            }
            return GET_OPERATION;
        }
        if (this.getName().equals(LIST_COMMAND)) {
            if (this.getBooleanOption(MONITOR_OPTION)) {
                return LIST_MONITORING_OPERATION;
            }
            return LIST_OPERATION;
        }
        return null;
    }

    private void printMessage(String msg) {
        logger.log(Level.INFO, msg, "INFO");
    }

    private void addToResults(String msg) {
        if (this.output != null) {
            this.output.add(msg);
        }
    }

    private String getExceptionMessage(Exception e) {
        String msg = null;
        if (e instanceof RuntimeMBeanException) {
            RuntimeMBeanException rmbe = (RuntimeMBeanException)e;
            msg = rmbe.getTargetException().getLocalizedMessage();
        } else if (e instanceof RuntimeOperationsException) {
            RuntimeOperationsException roe = (RuntimeOperationsException)e;
            msg = roe.getTargetException().getLocalizedMessage();
        } else {
            msg = e.getLocalizedMessage();
        }
        if (msg == null || msg.length() == 0) {
            msg = e.getMessage();
        }
        if (msg == null || msg.length() == 0) {
            msg = e.getClass().getName();
        }
        return msg;
    }

    private String stringifyArray(Object[] a, String delim) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < a.length; ++i) {
            buf.append(this.stringify(a[i], INNER_ARRAY_DELIM));
            if (i == a.length - 1) continue;
            buf.append(delim);
        }
        return buf.toString();
    }

    private String stringify(Object o, String delim) {
        String result = null;
        if (o == null) {
            result = "";
        } else if (o instanceof Attribute) {
            Attribute attr = (Attribute)o;
            result = attr.getName() + " = " + this.stringify(attr.getValue(), INNER_ARRAY_DELIM);
        } else if (ClassUtil.objectIsPrimitiveArray(o)) {
            Object[] objectList = ArrayConversion.toAppropriateType(o);
            result = this.stringifyArray(objectList, delim);
        } else if (ClassUtil.objectIsArray(o)) {
            result = this.stringifyArray((Object[])o, delim);
        } else if (o instanceof Exception) {
            Exception e = (Exception)o;
            result = this.getExceptionMessage(e);
        } else {
            result = o.toString();
        }
        return result;
    }

    private void displayResultFromList(String[] result) {
        if (result.length == 0) {
            String displayOperands = this.stringify(this.getDottedNamesParam(true), INNER_ARRAY_DELIM);
            this.printMessage("EmptyList - " + displayOperands);
        } else {
            for (String value : result) {
                this.addToResults(value);
            }
        }
    }

    public String convertUnderscoreToHyphen(String param) {
        int begIndex;
        int endIndex = param.indexOf(61);
        int n = begIndex = endIndex > 0 ? param.lastIndexOf(46, endIndex) : param.lastIndexOf(46);
        if (begIndex < 1 || this.checkPropertyToConvert(param.substring(0, begIndex))) {
            return param;
        }
        if (endIndex > 0) {
            return param.substring(0, begIndex) + param.substring(begIndex, endIndex).replace('_', '-') + param.substring(endIndex);
        }
        return param.substring(0, begIndex) + param.substring(begIndex).replace('_', '-');
    }

    public boolean checkPropertyToConvert(String param) {
        int index = param.lastIndexOf(46);
        if (index < 0) {
            return false;
        }
        String elementName = param.substring(index + 1);
        return elementName.matches(PROPERTY_STRING);
    }

    private final class AttributeComparator
    implements Comparator {
        private AttributeComparator() {
        }

        public int compare(Object o1, Object o2) {
            Attribute attr1 = (Attribute)o1;
            Attribute attr2 = (Attribute)o2;
            return attr1.getName().compareTo(attr2.getName());
        }

        public boolean equals(Object other) {
            return other instanceof AttributeComparator;
        }
    }
}

