/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop;

import com.sun.corba.ee.pept.transport.ContactInfo;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.transport.CorbaContactInfoList;
import com.sun.corba.ee.spi.transport.IIOPPrimaryToContactInfo;
import com.sun.corba.ee.spi.transport.SocketInfo;
import com.sun.logging.LogDomains;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IIOPPrimaryToContactInfoImpl
implements IIOPPrimaryToContactInfo {
    private static Logger _logger = null;
    public final String baseMsg = IIOPPrimaryToContactInfoImpl.class.getName();
    private Map map = new HashMap();
    private boolean debugChecked = false;
    private boolean debug = false;

    public synchronized void reset(ContactInfo primary) {
        try {
            if (this.debug) {
                this.dprint(".reset: " + this.getKey(primary));
            }
            this.map.remove(this.getKey(primary));
        }
        catch (Throwable t) {
            _logger.log(Level.WARNING, "Problem in " + this.baseMsg + ".reset", t);
            RuntimeException rte = new RuntimeException(this.baseMsg + ".reset error");
            rte.initCause(t);
            throw rte;
        }
    }

    public synchronized boolean hasNext(ContactInfo primary, ContactInfo previous, List contactInfos) {
        try {
            boolean result;
            if (!this.debugChecked) {
                this.debugChecked = true;
                boolean bl = this.debug = ((ORB)primary.getBroker()).transportDebugFlag || _logger.isLoggable(Level.FINE);
            }
            if (this.debug) {
                this.dprint(".hasNext->: " + this.formatKeyPreviousList(this.getKey(primary), previous, contactInfos));
            }
            if (previous == null) {
                result = true;
            } else {
                int previousIndex = contactInfos.indexOf(previous);
                int contactInfosSize = contactInfos.size();
                if (this.debug) {
                    this.dprint(".hasNext: " + previousIndex + " " + contactInfosSize);
                }
                if (previousIndex < 0) {
                    RuntimeException rte = new RuntimeException("Problem in " + this.baseMsg + ".hasNext: previousIndex: " + previousIndex);
                    _logger.log(Level.SEVERE, "Problem in " + this.baseMsg + ".hasNext: previousIndex: " + previousIndex, rte);
                    throw rte;
                }
                boolean bl = result = contactInfosSize - 1 > previousIndex;
            }
            if (this.debug) {
                this.dprint(".hasNext<-: " + result);
            }
            return result;
        }
        catch (Throwable t) {
            _logger.log(Level.WARNING, "Problem in " + this.baseMsg + ".hasNext", t);
            RuntimeException rte = new RuntimeException(this.baseMsg + ".hasNext error");
            rte.initCause(t);
            throw rte;
        }
    }

    public synchronized ContactInfo next(ContactInfo primary, ContactInfo previous, List contactInfos) {
        try {
            String debugMsg = null;
            if (this.debug) {
                debugMsg = "";
                this.dprint(".next->: " + this.formatKeyPreviousList(this.getKey(primary), previous, contactInfos));
                this.dprint(".next: map: " + this.formatMap(this.map));
            }
            Object result = null;
            if (previous == null) {
                result = this.map.get(this.getKey(primary));
                if (result == null) {
                    if (this.debug) {
                        debugMsg = ".next<-: initialize map: ";
                    }
                    result = contactInfos.get(0);
                    this.map.put(this.getKey(primary), result);
                } else {
                    int position;
                    if (this.debug) {
                        this.dprint(".next: primary mapped to: " + result);
                    }
                    if ((position = contactInfos.indexOf(result)) == -1) {
                        if (this.debug) {
                            this.dprint(".next: cannot find mapped entry in current list.  Removing mapped entry and trying .next again.");
                        }
                        this.reset(primary);
                        return this.next(primary, previous, contactInfos);
                    }
                    result = contactInfos.get(position);
                    if (this.debug) {
                        debugMsg = ".next<-: mapped: ";
                    }
                }
            } else {
                result = contactInfos.get(contactInfos.indexOf(previous) + 1);
                this.map.put(this.getKey(primary), result);
                _logger.log(Level.INFO, "IIOP failover to: " + result);
                if (this.debug) {
                    debugMsg = ".next<-: update map:  " + contactInfos.indexOf(previous) + " " + contactInfos.size() + " ";
                }
            }
            if (this.debug) {
                this.dprint(debugMsg + result);
            }
            return (ContactInfo)result;
        }
        catch (Throwable t) {
            _logger.log(Level.WARNING, "Problem in " + this.baseMsg + ".next", t);
            RuntimeException rte = new RuntimeException(this.baseMsg + ".next error");
            rte.initCause(t);
            throw rte;
        }
    }

    private Object getKey(ContactInfo contactInfo) {
        if (((SocketInfo)((Object)contactInfo)).getPort() == 0) {
            return ((CorbaContactInfoList)contactInfo.getContactInfoList()).getEffectiveTargetIOR();
        }
        return contactInfo;
    }

    private String formatKeyPreviousList(Object key, ContactInfo previous, List list) {
        String result = "\n  key     : " + key + "\n  previous: " + previous + "\n  list:";
        Iterator i = list.iterator();
        int count = 1;
        while (i.hasNext()) {
            result = result + "\n    " + count++ + "  " + i.next();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String formatMap(Map map) {
        String result = "";
        Map map2 = map;
        synchronized (map2) {
            Iterator i = map.entrySet().iterator();
            if (!i.hasNext()) {
                return "empty";
            }
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                result = result + "\n    key  : " + entry.getKey() + "\n    value: " + entry.getValue() + "\n";
            }
        }
        return result;
    }

    private void dprint(String msg) {
        _logger.log(Level.FINE, msg);
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.resource.corba");
    }
}

