/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jms;

import com.sun.appserv.server.util.Version;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.JmsService;
import com.sun.enterprise.jms.JmsProviderLifecycle;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import com.sun.messaging.jmq.jmsspi.JMSAdmin;
import com.sun.messaging.jmq.jmsspi.JMSAdminFactory;
import java.util.logging.Logger;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Topic;

public class IASJmsUtil {
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.jms");
    public static final String MDB_CONTAINER_QUEUE_XACF = "MDB_CONTAINER_QUEUE_CF__jmsxa_default";
    public static final String MDB_CONTAINER_TOPIC_XACF = "MDB_CONTAINER_TOPIC_CF__jmsxa_default";
    public static final String MQ_DIR_NAME = "imq";
    private static String DEFAULT_SERVER = "server";
    private static String DEFAULT_MQ_INSTANCE = "imqbroker";
    public static final String DEFAULT_USER = "admin";
    public static final String DEFAULT_PASSWORD = "admin";
    public static final String DEFAULT_MAX_ACTIVE_CONSUMERS = "-1";
    public static final String MAX_ACTIVE_CONSUMERS_ATTRIBUTE = "MaxNumActiveConsumers";
    public static final String MAX_ACTIVE_CONSUMERS_PROPERTY = "maxNumActiveConsumers";
    private static StringManager _sm = StringManager.getManager(IASJmsUtil.class);
    private static final boolean debug = false;

    public static String getXAConnectionFactoryName(String connectionFactoryName) {
        return "JMSXA" + connectionFactoryName + "__jmsxa";
    }

    public static String getDestinationName(Destination destination) {
        String name = null;
        try {
            name = destination instanceof Queue ? ((Queue)destination).getQueueName() : ((Topic)destination).getTopicName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return name;
    }

    public static void checkVersion(JMSAdmin ja) {
        float version = 0.0f;
        String vs = "?.?";
        try {
            vs = ja.getVersion();
            version = Float.parseFloat(vs);
        }
        catch (Exception e) {
            throw new RuntimeException("Error detected while parsing JMS provider SPI version string (" + vs + ").");
        }
        if ((double)version < 2.0 || (double)version >= 3.0) {
            throw new RuntimeException("Incorrect JMS Provider SPI version detected (" + vs + ")." + " Please make sure that you are using the correct" + " version of the JMS provider.");
        }
    }

    public static JMSAdminFactory getJMSAdminFactory() throws Exception {
        JMSAdminFactory jmsAdminFactory = null;
        Class<?> jmsAdminFactoryClass = Class.forName("com.sun.messaging.jmq.admin.jmsspi.JMSAdminFactoryImpl");
        jmsAdminFactory = (JMSAdminFactory)jmsAdminFactoryClass.newInstance();
        IASJmsUtil.checkVersion(jmsAdminFactory.getJMSAdmin());
        return jmsAdminFactory;
    }

    protected static JMSAdmin getJMSAdmin() throws Exception {
        JMSAdmin jmsAdmin = JmsProviderLifecycle.getJMSAdmin();
        if (jmsAdmin == null) {
            jmsAdmin = IASJmsUtil.getJMSAdminFactory().getJMSAdmin();
        }
        return jmsAdmin;
    }

    public static void validateJMSSelector(String selector) throws Exception, JMSException {
        IASJmsUtil.getJMSAdmin().validateJMSSelector(selector);
    }

    public static String clientIDPropertyName() throws Exception {
        return IASJmsUtil.getJMSAdmin().clientIDPropertyName();
    }

    public static Object wrapJMSConnectionFactoryObject(Object obj) throws Exception, JMSException {
        return IASJmsUtil.getJMSAdmin().wrapJMSConnectionFactoryObject(obj);
    }

    public static String getBrokerInstanceName(String asDomain, String asInstance, JmsService js) {
        ElementProperty[] jmsProperties = js.getElementProperty();
        String instanceName = null;
        String suffix = null;
        if (jmsProperties != null) {
            for (int ii = 0; ii < jmsProperties.length; ++ii) {
                ElementProperty p = jmsProperties[ii];
                String name = p.getName();
                if (name.equals("instance-name")) {
                    instanceName = p.getValue();
                }
                if (name.equals("instance-name-suffix")) {
                    suffix = p.getValue();
                }
                if (!name.equals("append-version") || !Boolean.valueOf(p.getValue()).booleanValue()) continue;
                suffix = Version.getMajorVersion() + "_" + Version.getMinorVersion();
            }
        }
        if (instanceName != null) {
            return instanceName;
        }
        instanceName = asInstance.equals(DEFAULT_SERVER) ? DEFAULT_MQ_INSTANCE : asDomain + "_" + asInstance;
        if (suffix != null) {
            instanceName = instanceName + "_" + suffix;
        }
        return instanceName;
    }

    public static String getDefaultMaxActiveConsumers() {
        return DEFAULT_MAX_ACTIVE_CONSUMERS;
    }

    public static String getMaxActiveConsumersProperty() {
        return MAX_ACTIVE_CONSUMERS_PROPERTY;
    }

    public static String getMaxActiveConsumersAttribute() {
        return MAX_ACTIVE_CONSUMERS_ATTRIBUTE;
    }
}

