/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.util;

import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.j2ee.J2EECluster;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.jmx.MBeanServerConnectionSource;
import com.sun.appserv.management.util.misc.SetUtil;
import com.sun.appserv.server.util.Version;
import com.sun.enterprise.ManagementObjectManager;
import com.sun.enterprise.admin.common.MBeanServerFactory;
import com.sun.enterprise.admin.mbeans.DomainStatus;
import com.sun.enterprise.admin.mbeans.DomainStatusHelper;
import com.sun.enterprise.admin.meta.MBeanRegistry;
import com.sun.enterprise.admin.meta.MBeanRegistryFactory;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.io.DescriptorConstants;
import com.sun.enterprise.management.agent.MEJB;
import com.sun.enterprise.management.agent.MEJBUtility;
import com.sun.enterprise.management.j2ee.DASJ2EEServerImpl;
import com.sun.enterprise.management.j2ee.J2EEClusterImpl;
import com.sun.enterprise.management.model.AppClientModuleMdl;
import com.sun.enterprise.management.model.EJBModuleMdl;
import com.sun.enterprise.management.model.EJBWebServiceEndpointMdl;
import com.sun.enterprise.management.model.EntityBeanMdl;
import com.sun.enterprise.management.model.J2EEApplicationMdl;
import com.sun.enterprise.management.model.J2EEDomainMdl;
import com.sun.enterprise.management.model.J2EEServerMdl;
import com.sun.enterprise.management.model.JCAConnectionFactoryMdl;
import com.sun.enterprise.management.model.JCAManagedConnectionFactoryMdl;
import com.sun.enterprise.management.model.JCAResourceMdl;
import com.sun.enterprise.management.model.JDBCDataSourceMdl;
import com.sun.enterprise.management.model.JMSResourceMdl;
import com.sun.enterprise.management.model.MessageDrivenBeanMdl;
import com.sun.enterprise.management.model.ResourceAdapterMdl;
import com.sun.enterprise.management.model.ResourceAdapterModuleMdl;
import com.sun.enterprise.management.model.ServletMdl;
import com.sun.enterprise.management.model.ServletWebServiceEndpointMdl;
import com.sun.enterprise.management.model.StatefulSessionBeanMdl;
import com.sun.enterprise.management.model.StatelessSessionBeanMdl;
import com.sun.enterprise.management.model.TransactionServiceMdl;
import com.sun.enterprise.management.model.WebModuleMdl;
import com.sun.enterprise.management.support.BootUtil;
import com.sun.enterprise.management.util.J2EEModuleCallBackImpl;
import com.sun.enterprise.management.util.StartStopCallback;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.util.io.FileUtils;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.naming.InitialContext;

public class J2EEManagementObjectManager
implements ManagementObjectManager {
    private MEJB mejbRef = null;
    private MEJBUtility mejbUtility = null;
    private static MBeanServer server = null;
    private static String domain = J2EEDomainMdl.DOMAINNAME;
    private static final String QUEUE = "javax.jms.Queue";
    private static final String TOPIC = "javax.jms.Topic";
    private static final String DEFAULT_VIRTUAL_SERVER = "server";
    private static Logger _logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static boolean _bHtmlAdaptorServerRegistered;

    private static void initMBeanServer() {
        try {
            server = MBeanServerFactory.getMBeanServer();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void registerHTMLAdaptor() {
        if (_bHtmlAdaptorServerRegistered) {
            return;
        }
        try {
            String strPort = System.getProperty("html.adaptor.port");
            if (strPort == null || strPort.trim().length() < 1) {
                return;
            }
            int port = new Integer(strPort.trim());
            Class<?> cl = Class.forName("com.sun.jdmk.comm.HtmlAdaptorServer");
            Constructor<?> contr = cl.getConstructor(Integer.TYPE);
            Object adaptor = contr.newInstance(new Integer(port));
            Method method = cl.getMethod("start", new Class[0]);
            ObjectName htmlAdaptorObjectName = new ObjectName("Adaptor:name=html,port=" + port);
            server.registerMBean(adaptor, htmlAdaptorObjectName);
            method.invoke(adaptor, new Object[0]);
            _bHtmlAdaptorServerRegistered = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public MEJBUtility getMEJBUtility() {
        if (this.mejbUtility == null) {
            this.mejbUtility = MEJBUtility.getMEJBUtility();
        }
        return this.mejbUtility;
    }

    public void registerJ2EEDomain() {
        this.instantiateAndRegisterRuntimeMBean("J2EEDomain", null);
        this.registerDomainStatusMBean();
    }

    public void registerJ2EEServer() {
        J2EEServerMdl managedServerMdlObject = new J2EEServerMdl(ApplicationServer.getServerContext().getInstanceName(), Version.getVersion());
        this.instantiateAndRegisterRuntimeMBean("J2EEServer", managedServerMdlObject);
    }

    public void registerJCAConnectionFactory(String jcaResName, String jcaConnFactName, String managedConFact) {
        JCAConnectionFactoryMdl managedBean = new JCAConnectionFactoryMdl(jcaResName, ApplicationServer.getServerContext().getInstanceName(), jcaConnFactName, managedConFact);
        this.instantiateAndRegisterRuntimeMBean("JCAConnectionFactory", managedBean, jcaResName, jcaConnFactName);
    }

    public void registerJCAManagedConnectionFactory(String connFactName) {
        JCAManagedConnectionFactoryMdl managedBean = new JCAManagedConnectionFactoryMdl(connFactName, ApplicationServer.getServerContext().getInstanceName());
        this.instantiateAndRegisterRuntimeMBean("JCAManagedConnectionFactory", managedBean, connFactName);
    }

    public void registerJCAResource(String name, String raName, String username, String password, String[] propNames, String[] propValues) {
        JCAResourceMdl managedBean = new JCAResourceMdl(name, ApplicationServer.getServerContext().getInstanceName(), raName, username, password, propNames, propValues);
        this.instantiateAndRegisterRuntimeMBean("JCAResource", managedBean, raName, name);
    }

    public void registerAdminObjectResource(String name, String raName, String resType, String[] propNames, String[] propValues) {
        if (QUEUE.equals(resType) || TOPIC.equals(resType)) {
            this.registerJMSResource(name, resType, null, null, propNames, propValues);
        }
    }

    public void registerJDBCDataSource(String dsJndiName, String dsName, String url, String username, String password, String[] propNames, String[] propValues) {
        JDBCDataSourceMdl managedBean = new JDBCDataSourceMdl(dsJndiName, dsName, url, username, ApplicationServer.getServerContext().getInstanceName(), password, propNames, propValues);
        this.instantiateAndRegisterRuntimeMBean("JDBCDataSource", managedBean, dsJndiName, dsJndiName);
    }

    public void registerJDBCDriver(String name) {
        this.instantiateAndRegisterRuntimeMBean("JDBCDriver", null, name);
    }

    public void registerJDBCResource(String name) {
        this.instantiateAndRegisterRuntimeMBean("JDBCResource", null, name);
    }

    public void registerJMSResource(String name, String resType, String username, String password, String[] propNames, String[] propValues) {
        JMSResourceMdl managedBean = new JMSResourceMdl(name, ApplicationServer.getServerContext().getInstanceName(), resType, username, password, propNames, propValues);
        this.instantiateAndRegisterRuntimeMBean("JMSResource", managedBean, name);
    }

    public void registerJNDIResource(String name) {
        this.instantiateAndRegisterRuntimeMBean("JNDIResource", null, name);
    }

    public void registerJTAResource(String name) {
        this.instantiateAndRegisterRuntimeMBean("JTAResource", null, name);
    }

    public void registerJVM() {
        this.instantiateAndRegisterRuntimeMBean("JVM", null, this.getJVMId());
    }

    public void registerJavaMailResource(String name) {
        this.instantiateAndRegisterRuntimeMBean("JavaMailResource", null, name);
    }

    public void registerRMI_IIOPResource(String name) {
        this.instantiateAndRegisterRuntimeMBean("RMI_IIOPResource", null, name);
    }

    MEJB getMEJB() throws Exception {
        if (this.mejbRef == null) {
            InitialContext ic = new InitialContext();
            Object object = ic.lookup(System.getProperty("mejb.name", "ejb/mgmt/MEJB"));
        }
        return this.mejbRef;
    }

    public void unregisterStandAloneModule(String moduleType, String name) {
        try {
            this.unregisterStandAloneAndItsComponents(moduleType, name);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void unregisterStandAloneAndItsComponents(String moduleType, String moduleName) throws Exception {
    }

    public void unregisterJCAResource(String moduleName) throws Exception {
    }

    public void unregisterAdminObjectResource(String name, String resourceType) throws Exception {
        if (QUEUE.equals(resourceType) || TOPIC.equals(resourceType)) {
            this.unregisterResource(name, "JMSResource");
        }
    }

    public void unregisterJMSResource(String name) throws Exception {
        this.unregisterResource(name, "JMSResource");
    }

    public void unregisterJavaMailResource(String name) throws Exception {
        this.unregisterResource(name, "JavaMailResource");
    }

    public void unregisterJDBCResource(String name) throws Exception {
        this.unregisterResource(name, "JDBCResource");
    }

    void unregisterResource(String name, String type) throws Exception {
        MBeanRegistry registry = MBeanRegistryFactory.getRuntimeMBeanRegistry();
        String domainName = ApplicationServer.getServerContext().getDefaultDomainName();
        String serverName = ApplicationServer.getServerContext().getInstanceName();
        String[] location = new String[]{domainName, serverName, name};
        ObjectName on = registry.getMbeanObjectName(type, location);
        if (on == null) {
            return;
        }
        MBeanServer mbs = AdminService.getAdminService().getAdminContext().getMBeanServer();
        if (mbs.isRegistered(on)) {
            mbs.unregisterMBean(on);
        }
    }

    public Object getModuleUserData(String moduleID, int moduleType) throws Exception {
        return null;
    }

    public void setModuleUserData(String moduleID, Object obj, int moduleType) throws Exception {
    }

    private ObjectName getManagedObjectModule(String moduleID, int moduleType) throws Exception {
        return null;
    }

    public void registerConfigJ2EEServer(String instance) {
        throw new RuntimeException(">>>>>>>>>>>>>>>>>>>> registerConfigJ2EEServer not implemented <<<<<<<<<<<<<<<<<");
    }

    private void instantiateAndRegisterRuntimeMBean(String type, Object managed) {
        this.instantiateAndRegisterRuntimeMBean(type, managed, null, null, null);
    }

    private void instantiateAndRegisterRuntimeMBean(String type, Object managed, String name) {
        this.instantiateAndRegisterRuntimeMBean(type, managed, null, null, name);
    }

    private void instantiateAndRegisterRuntimeMBean(String type, Object managed, String parentName, String name) {
        this.instantiateAndRegisterRuntimeMBean(type, managed, null, parentName, name);
    }

    private void instantiateAndRegisterRuntimeMBean(String type, Object managed, String grandParentName, String parentName, String name) {
        MBeanRegistry registry = MBeanRegistryFactory.getRuntimeMBeanRegistry();
        String domainName = ApplicationServer.getServerContext().getDefaultDomainName();
        String serverName = ApplicationServer.getServerContext().getInstanceName();
        try {
            if (grandParentName != null) {
                registry.instantiateMBean(type, new String[]{domainName, serverName, grandParentName, parentName, name}, managed, AdminService.getAdminService().getAdminContext().getAdminConfigContext(), true);
            } else if (parentName != null) {
                registry.instantiateMBean(type, new String[]{domainName, serverName, parentName, name}, managed, AdminService.getAdminService().getAdminContext().getAdminConfigContext(), true);
            } else if (name != null) {
                registry.instantiateMBean(type, new String[]{domainName, serverName, name}, managed, AdminService.getAdminService().getAdminContext().getAdminConfigContext(), true);
            } else {
                registry.instantiateMBean(type, new String[]{domainName, serverName}, managed, AdminService.getAdminService().getAdminContext().getAdminConfigContext(), true);
            }
        }
        catch (Exception e) {
            System.out.println("Exception msg:" + e.getMessage());
            e.printStackTrace();
        }
    }

    public void createAppMBean(Application application, String serverName, String appLocation) throws MBeanException {
        String xmlDesc = null;
        String j2eeDDLocation = application.getGeneratedXMLDirectory() + File.separator + DescriptorConstants.APPLICATION_DD_ENTRY;
        xmlDesc = this.getStringForDDxml(j2eeDDLocation);
        StartStopCallback sscb = new StartStopCallback();
        J2EEModuleCallBackImpl module = new J2EEModuleCallBackImpl(application.getRegistrationName(), application.getRegistrationName(), serverName, xmlDesc, sscb);
        J2EEApplicationMdl managedResource = new J2EEApplicationMdl(module, application);
        this.instantiateAndRegisterRuntimeMBean("J2EEApplication", managedResource, application.getRegistrationName());
    }

    public void deleteAppMBean(Application application, String serverName) throws MBeanException {
        try {
            String namePattern = domain + ":" + "j2eeType=J2EEApplication" + "," + "name=" + application.getRegistrationName() + "," + "J2EEServer=" + serverName + "," + "*";
            ObjectName objName = this.findObjectName(namePattern);
            if (objName != null) {
                this.unregister(objName);
            }
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    public void createAppMBeanModules(Application application, String serverName, String appLocation) throws MBeanException {
        boolean registerComponents = false;
        Set ejbBundles = application.getEjbBundleDescriptors();
        for (EjbBundleDescriptor bundleDesc : ejbBundles) {
            this.registerEjbModuleAndItsComponents(bundleDesc, serverName, registerComponents, appLocation);
        }
        Set rarBundles = application.getRarDescriptors();
        for (ConnectorDescriptor bundleDesc : rarBundles) {
            this.registerResourceAdapterModuleAndItsComponents(bundleDesc, serverName, registerComponents, appLocation);
        }
        Set appClientBundles = application.getApplicationClientDescriptors();
        for (ApplicationClientDescriptor bundleDesc : appClientBundles) {
            this.registerAppClient(bundleDesc, serverName, appLocation);
        }
    }

    public void createAppMBeans(Application application, String serverName, String appLocation) throws MBeanException {
        boolean registerComponents = true;
        Set ejbBundles = application.getEjbBundleDescriptors();
        for (EjbBundleDescriptor bundleDesc : ejbBundles) {
            this.registerEjbModuleAndItsComponents(bundleDesc, serverName, registerComponents, appLocation);
        }
        Set rarBundles = application.getRarDescriptors();
        for (ConnectorDescriptor bundleDesc : rarBundles) {
            this.registerResourceAdapterModuleAndItsComponents(bundleDesc, serverName, registerComponents, appLocation);
        }
        Set appClientBundles = application.getApplicationClientDescriptors();
        for (ApplicationClientDescriptor bundleDesc : appClientBundles) {
            this.registerAppClient(bundleDesc, serverName, appLocation);
        }
    }

    public void registerEjbModuleAndItsComponents(EjbBundleDescriptor ejbBundleDescriptor, String serverName, boolean registerComponents, String appLocation) throws MBeanException {
        this.createEJBModuleMBean(ejbBundleDescriptor, serverName, appLocation);
        if (registerComponents) {
            this.createEJBMBeans(ejbBundleDescriptor, serverName);
        }
    }

    public void registerWebModuleAndItsComponents(WebBundleDescriptor webBundleDescriptor, String serverName, boolean registerComponents, String appLocation) throws MBeanException {
        String xmlDesc = this.getStringForDDxml(this.getModuleLocation(webBundleDescriptor, "WebModule"));
        String applicationName = "null";
        if (webBundleDescriptor.getApplication() != null && !webBundleDescriptor.getModuleDescriptor().isStandalone() && (applicationName = webBundleDescriptor.getApplication().getRegistrationName()) == null) {
            applicationName = "null";
        }
        this.createWebModuleMBean(webBundleDescriptor.getModuleID(), applicationName, serverName, xmlDesc);
        if (registerComponents) {
            this.createWebMBeans(webBundleDescriptor, serverName);
        }
        try {
            this.createWSEndpointMBeans(webBundleDescriptor, serverName);
        }
        catch (MBeanException mbe) {
            _logger.log(Level.WARNING, "admin.registerWebModuleAndItsComponents exception", mbe);
        }
    }

    public void registerResourceAdapterModuleAndItsComponents(ConnectorDescriptor bundleDesc, String serverName, boolean registerComponents, String appLocation) throws MBeanException {
        this.createRARModuleMBean(bundleDesc, serverName, appLocation);
        if (registerComponents) {
            this.createRARMBeans(bundleDesc, serverName);
        }
    }

    public void registerAppClient(ApplicationClientDescriptor bundleDesc, String serverName, String appLocation) throws MBeanException {
        String xmlDesc = this.getStringForDDxml(this.getModuleLocation(bundleDesc, "AppClientModule"));
        String applicationName = "null";
        if (bundleDesc.getApplication() != null && !bundleDesc.getModuleDescriptor().isStandalone() && (applicationName = bundleDesc.getApplication().getRegistrationName()) == null) {
            applicationName = "null";
        }
        this.createAppClientModuleMBean(this.getModuleName(bundleDesc), applicationName, serverName, xmlDesc);
    }

    public void unregisterAppClient(ApplicationClientDescriptor bundleDesc, String serverName) throws MBeanException {
        String applicationName = "null";
        if (bundleDesc.getApplication() != null && !bundleDesc.getModuleDescriptor().isStandalone() && (applicationName = bundleDesc.getApplication().getRegistrationName()) == null) {
            applicationName = "null";
        }
        this.deleteAppClientModuleMBean(this.getModuleName(bundleDesc), applicationName, serverName);
    }

    public void deleteAppMBeans(Application application, String serverName) throws MBeanException {
        try {
            String namePattern = domain + ":" + "j2eeType=J2EEApplication" + "," + "name=" + application.getRegistrationName() + "," + "J2EEServer=" + serverName + "," + "*";
            ObjectName objName = this.findObjectName(namePattern);
            if (objName != null) {
                String[] modulesArr = (String[])server.getAttribute(objName, "modules");
                ObjectName[] deployedModules = this.toObjectNameArray(modulesArr);
                for (int moduleIndex = 0; moduleIndex < deployedModules.length; ++moduleIndex) {
                    this.unregisterModuleAndItsComponents(deployedModules[moduleIndex]);
                }
            }
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    public void unregisterModuleAndItsComponents(ObjectName objectName) throws MBeanException {
        ObjectName[] comps = this.getComponents(objectName);
        for (int compsIndex = 0; compsIndex < comps.length; ++compsIndex) {
            this.unregister(comps[compsIndex]);
        }
        this.unregister(objectName);
    }

    private ObjectName[] getComponents(ObjectName module) throws MBeanException {
        ObjectName[] components = null;
        try {
            if (module.getKeyProperty("j2eeType").equals("AppClientModule")) {
                components = new ObjectName[]{};
            } else if (module.getKeyProperty("j2eeType").equals("EJBModule")) {
                components = this.toObjectNameArray((String[])server.getAttribute(module, "ejbs"));
            } else if (module.getKeyProperty("j2eeType").equals("WebModule")) {
                components = this.toObjectNameArray((String[])server.getAttribute(module, "servlets"));
            } else if (module.getKeyProperty("j2eeType").equals("ResourceAdapterModule")) {
                components = this.toObjectNameArray((String[])server.getAttribute(module, "resourceAdapters"));
            }
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
        return components;
    }

    public void createEJBModuleMBean(EjbBundleDescriptor ejbBundleDescriptor, String serverName, String appLocation) throws MBeanException {
        String xmlDesc = this.getStringForDDxml(this.getModuleLocation(ejbBundleDescriptor, "EJBModule"));
        String moduleName = this.getModuleName(ejbBundleDescriptor);
        String applicationName = this.getApplicationName(ejbBundleDescriptor);
        StartStopCallback sscb = new StartStopCallback();
        J2EEModuleCallBackImpl module = new J2EEModuleCallBackImpl(moduleName, applicationName, serverName, xmlDesc, sscb);
        EJBModuleMdl managedResource = new EJBModuleMdl(module, ejbBundleDescriptor);
        this.instantiateAndRegisterRuntimeMBean("EJBModule", managedResource, null, applicationName, moduleName);
        try {
            this.createWSEndpointMBeans(ejbBundleDescriptor, serverName);
        }
        catch (MBeanException mbe) {
            _logger.log(Level.WARNING, "admin.registerEjbModuleAndItsComponents exception", mbe);
        }
    }

    public void deleteEJBModuleMBean(EjbBundleDescriptor ejbBundleDescriptor, String serverName) throws MBeanException {
        String moduleName = this.getModuleName(ejbBundleDescriptor);
        String applicationName = this.getApplicationName(ejbBundleDescriptor);
        try {
            String namePattern = domain + ":" + "j2eeType=EJBModule" + "," + "name=" + moduleName + "," + "J2EEApplication=" + applicationName + "," + "J2EEServer=" + serverName + "," + "*";
            ObjectName objName = this.findObjectName(namePattern);
            if (objName != null) {
                this.unregister(objName);
            }
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    public void createEJBMBeans(EjbBundleDescriptor ejbBundleDescriptor, String serverName) throws MBeanException {
        Set ejbs = ejbBundleDescriptor.getEjbs();
        for (EjbDescriptor nextDescriptor : ejbs) {
            this.createEJBMBean(nextDescriptor, serverName);
        }
    }

    public void deleteEJBMBeans(EjbBundleDescriptor ejbBundleDescriptor, String serverName) throws MBeanException {
        Set ejbs = ejbBundleDescriptor.getEjbs();
        for (EjbDescriptor nextDescriptor : ejbs) {
            this.deleteEJBMBean(nextDescriptor, serverName);
        }
    }

    public void createWSEndpointMBeans(BundleDescriptor bundleDescriptor, String serverName) throws MBeanException {
        WebServicesDescriptor wss;
        if (bundleDescriptor == null) {
            return;
        }
        String ctxRoot = null;
        if (bundleDescriptor instanceof WebBundleDescriptor) {
            ctxRoot = ((WebBundleDescriptor)bundleDescriptor).getContextRoot();
        }
        if ((wss = bundleDescriptor.getWebServices()) != null) {
            Collection<WebServiceEndpoint> wsEps = wss.getEndpoints();
            for (WebServiceEndpoint nextDescriptor : wsEps) {
                this.createWSEndpointMBean(ctxRoot, nextDescriptor, serverName);
            }
        }
    }

    public void deleteWSEndpointMBeans(BundleDescriptor bundleDescriptor, String serverName) throws MBeanException {
        WebServicesDescriptor wsd;
        if (bundleDescriptor == null) {
            return;
        }
        String ctxRoot = null;
        if (bundleDescriptor instanceof WebBundleDescriptor) {
            ctxRoot = ((WebBundleDescriptor)bundleDescriptor).getContextRoot();
        }
        if ((wsd = bundleDescriptor.getWebServices()) == null) {
            return;
        }
        Collection<WebServiceEndpoint> wsEps = wsd.getEndpoints();
        for (WebServiceEndpoint nextDescriptor : wsEps) {
            try {
                this.deleteWSEndpointMBean(ctxRoot, nextDescriptor, serverName);
            }
            catch (MBeanException mbe) {
                _logger.log(Level.WARNING, "admin.deleteEJBMBeans exception", mbe);
            }
        }
    }

    public void createEJBMBean(EjbDescriptor ejbDescriptor, String serverName) throws MBeanException {
        String ejbName = ejbDescriptor.getName();
        String ejbType = ejbDescriptor.getType();
        String ejbSessionType = null;
        if (ejbType.equals("Session")) {
            ejbSessionType = ((EjbSessionDescriptor)ejbDescriptor).getSessionType();
        }
        String moduleName = this.getModuleName(ejbDescriptor.getEjbBundleDescriptor());
        String appName = this.getApplicationName(ejbDescriptor.getEjbBundleDescriptor());
        Object ejbMB = null;
        String j2eeType = null;
        if (ejbType.equals("Entity")) {
            j2eeType = "EntityBean";
        } else if (ejbType.equals("Message-driven")) {
            j2eeType = "MessageDrivenBean";
        } else if (ejbType.equals("Session")) {
            if (ejbSessionType.equals("Stateless")) {
                j2eeType = "StatelessSessionBean";
            } else if (ejbSessionType.equals("Stateful")) {
                j2eeType = "StatefulSessionBean";
            }
        }
        if (ejbType.equals("Entity")) {
            EntityBeanMdl managedResource = new EntityBeanMdl(ejbName, moduleName, appName, serverName);
            this.instantiateAndRegisterRuntimeMBean("EntityBean", managedResource, appName, moduleName, ejbName);
        } else if (ejbType.equals("Message-driven")) {
            MessageDrivenBeanMdl managedResource = new MessageDrivenBeanMdl(ejbName, moduleName, appName, serverName);
            this.instantiateAndRegisterRuntimeMBean("MessageDrivenBean", managedResource, appName, moduleName, ejbName);
        } else if (ejbType.equals("Session")) {
            if (ejbSessionType.equals("Stateless")) {
                StatelessSessionBeanMdl managedResource = new StatelessSessionBeanMdl(ejbName, moduleName, appName, serverName);
                this.instantiateAndRegisterRuntimeMBean("StatelessSessionBean", managedResource, appName, moduleName, ejbName);
            } else if (ejbSessionType.equals("Stateful")) {
                StatefulSessionBeanMdl managedResource = new StatefulSessionBeanMdl(ejbName, moduleName, appName, serverName);
                this.instantiateAndRegisterRuntimeMBean("StatefulSessionBean", managedResource, appName, moduleName, ejbName);
            }
        }
    }

    public void deleteEJBMBean(EjbDescriptor ejbDescriptor, String serverName) throws MBeanException {
        String ejbName = ejbDescriptor.getName();
        String ejbType = ejbDescriptor.getType();
        String ejbSessionType = null;
        if (ejbType.equals("Session")) {
            ejbSessionType = ((EjbSessionDescriptor)ejbDescriptor).getSessionType();
        }
        String moduleName = this.getModuleName(ejbDescriptor.getEjbBundleDescriptor());
        String appName = this.getApplicationName(ejbDescriptor.getEjbBundleDescriptor());
        String j2eeType = null;
        if (ejbType.equals("Entity")) {
            j2eeType = "EntityBean";
        } else if (ejbType.equals("Message-driven")) {
            j2eeType = "MessageDrivenBean";
        } else if (ejbType.equals("Session")) {
            if (ejbSessionType.equals("Stateless")) {
                j2eeType = "StatelessSessionBean";
            } else if (ejbSessionType.equals("Stateful")) {
                j2eeType = "StatefulSessionBean";
            }
        }
        try {
            String namePattern = domain + ":" + "j2eeType=" + j2eeType + "," + "name=" + ejbName + "," + "EJBModule=" + moduleName + "," + "J2EEApplication=" + appName + "," + "J2EEServer=" + serverName + "," + "*";
            ObjectName objName = this.findObjectName(namePattern);
            if (objName != null) {
                this.unregister(objName);
            }
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    public void createWSEndpointMBean(String ctxRoot, WebServiceEndpoint wsDescriptor, String serverName) throws MBeanException {
        BundleDescriptor bd = wsDescriptor.getBundleDescriptor();
        boolean isEjb = false;
        if (bd instanceof EjbBundleDescriptor) {
            isEjb = true;
        }
        String epName = wsDescriptor.getEndpointName();
        String appName = this.getApplicationName(bd);
        String regName = bd.getApplication().getRegistrationName();
        String moduleName = this.getModuleName(bd);
        if (ctxRoot != null) {
            ServletWebServiceEndpointMdl managedResource = new ServletWebServiceEndpointMdl(epName, moduleName, regName, serverName, bd.getApplication().isVirtual(), isEjb);
            String cRoot = null;
            cRoot = ctxRoot.length() > 0 && ctxRoot.charAt(0) != '/' ? "/" + ctxRoot : ctxRoot;
            this.instantiateAndRegisterRuntimeMBean(managedResource.getMBeanName(), managedResource, appName, "//server" + cRoot, epName);
        } else {
            EJBWebServiceEndpointMdl managedResource = new EJBWebServiceEndpointMdl(epName, moduleName, regName, serverName, bd.getApplication().isVirtual(), isEjb);
            this.instantiateAndRegisterRuntimeMBean(managedResource.getMBeanName(), managedResource, appName, moduleName, epName);
        }
    }

    public void deleteWSEndpointMBean(String ctxRoot, WebServiceEndpoint wsDescriptor, String serverName) throws MBeanException {
        String epName = wsDescriptor.getEndpointName();
        BundleDescriptor bd = wsDescriptor.getBundleDescriptor();
        String moduleName = this.getModuleName(bd);
        String appName = this.getApplicationName(bd);
        try {
            String namePattern = null;
            if (bd instanceof EjbBundleDescriptor) {
                namePattern = domain + ":" + "j2eeType=WebServiceEndpoint," + "name=" + epName + "," + "EJBModule=" + moduleName + "," + "J2EEApplication=" + appName + "," + "J2EEServer=" + serverName + "," + "*";
            } else if (bd instanceof WebBundleDescriptor) {
                namePattern = domain + ":" + "j2eeType=WebServiceEndpoint," + "name=" + epName + "," + "WebModule=" + "//" + DEFAULT_VIRTUAL_SERVER + ctxRoot + "," + "J2EEApplication=" + appName + "," + "J2EEServer=" + serverName + "," + "*";
            }
            ObjectName objName = this.findObjectName(namePattern);
            if (objName != null) {
                this.unregister(objName);
            }
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    public void createWebModuleMBean(String appName, String parentName, String serverName, String deploymentDescriptor) throws MBeanException {
        StartStopCallback sscb = new StartStopCallback();
        J2EEModuleCallBackImpl module = new J2EEModuleCallBackImpl(appName, parentName, serverName, deploymentDescriptor, sscb);
        WebModuleMdl managedResource = new WebModuleMdl(module);
        this.instantiateAndRegisterRuntimeMBean("WebModule", managedResource, null, parentName, appName);
    }

    public void deleteWebModuleMBean(String appName, String parentName, String serverName) throws MBeanException {
        try {
            String namePattern = domain + ":" + "j2eeType=WebModule" + "," + "name=" + appName + "," + "J2EEApplication=" + parentName + "," + "J2EEServer=" + serverName + "," + "*";
            ObjectName objName = this.findObjectName(namePattern);
            if (objName != null) {
                this.unregister(objName);
            }
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    public void createWebMBeans(WebBundleDescriptor webBundleDescriptor, String serverName) throws MBeanException {
        Set set = webBundleDescriptor.getWebComponentDescriptorsSet();
        String applicationName = webBundleDescriptor.getApplication().getRegistrationName();
        if (applicationName == null) {
            applicationName = "null";
        }
        for (WebComponentDescriptor nextDescriptor : set) {
            this.createWebMBean(nextDescriptor.getCanonicalName(), webBundleDescriptor.getModuleID(), applicationName, serverName);
        }
    }

    public void deleteWebMBeans(WebBundleDescriptor webBundleDescriptor, String serverName) throws MBeanException {
        Set set = webBundleDescriptor.getWebComponentDescriptorsSet();
        String applicationName = webBundleDescriptor.getApplication().getRegistrationName();
        if (applicationName == null) {
            applicationName = "null";
        }
        for (WebComponentDescriptor nextDescriptor : set) {
            this.deleteWebMBean(nextDescriptor.getCanonicalName(), webBundleDescriptor.getModuleID(), applicationName, serverName);
        }
    }

    public void createWebMBean(String servletName, String moduleName, String appName, String serverName) throws MBeanException {
        ServletMdl managedResource = new ServletMdl(servletName, moduleName, appName, serverName);
        this.instantiateAndRegisterRuntimeMBean("Servlet", managedResource, appName, moduleName, servletName);
    }

    public void deleteWebMBean(String servletName, String moduleName, String appName, String serverName) throws MBeanException {
        if (server == null) {
            J2EEManagementObjectManager.initMBeanServer();
        }
        try {
            String namePattern = domain + ":" + "j2eeType=Servlet" + "," + "name=" + servletName + "," + "WebModule=" + moduleName + "," + "J2EEApplication=" + appName + "," + "J2EEServer=" + serverName + "," + "*";
            ObjectName objName = this.findObjectName(namePattern);
            if (objName != null) {
                this.unregister(objName);
            }
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    public void createRARModuleMBean(ConnectorDescriptor bundleDesc, String serverName, String appLocation) throws MBeanException {
        String modLocation = "";
        if (bundleDesc.getModuleDescriptor().isStandalone()) {
            modLocation = appLocation + File.separator + DescriptorConstants.RAR_DD_ENTRY;
        } else {
            String moduleName = FileUtils.makeFriendlyFileName(bundleDesc.getModuleDescriptor().getArchiveUri());
            modLocation = appLocation + File.separator + moduleName + File.separator + DescriptorConstants.RAR_DD_ENTRY;
        }
        String xmlDesc = this.getStringForDDxml(modLocation);
        String applicationName = this.getApplicationName(bundleDesc);
        String resAdName = this.getModuleName(bundleDesc);
        StartStopCallback sscb = new StartStopCallback();
        J2EEModuleCallBackImpl module = new J2EEModuleCallBackImpl(resAdName, applicationName, serverName, xmlDesc, sscb);
        ResourceAdapterModuleMdl managedResource = new ResourceAdapterModuleMdl(module, resAdName);
        this.instantiateAndRegisterRuntimeMBean("ResourceAdapterModule", managedResource, null, applicationName, resAdName);
    }

    public void deleteRARModuleMBean(ConnectorDescriptor cd, String serverName) throws MBeanException {
        String moduleName = this.getModuleName(cd);
        String applicationName = this.getApplicationName(cd);
        try {
            String namePattern = domain + ":" + "j2eeType=ResourceAdapterModule" + "," + "name=" + moduleName + "," + "J2EEApplication=" + applicationName + "," + "J2EEServer=" + serverName + "," + "*";
            ObjectName objName = this.findObjectName(namePattern);
            if (objName != null) {
                this.unregister(objName);
            }
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    public void createRARMBeans(ConnectorDescriptor cd, String serverName) throws MBeanException {
        this.createRARMBean(cd, serverName);
    }

    public void deleteRARMBeans(ConnectorDescriptor cd, String serverName) throws MBeanException {
        this.deleteRARMBean(cd, serverName);
    }

    public void createRARMBean(ConnectorDescriptor cd, String serverName) throws MBeanException {
        String rarName = cd.getName();
        String moduleName = this.getModuleName(cd);
        String appName = this.getApplicationName(cd);
        ResourceAdapterMdl managedResource = new ResourceAdapterMdl(rarName, moduleName, appName, serverName);
        this.instantiateAndRegisterRuntimeMBean("ResourceAdapter", managedResource, appName, moduleName, rarName);
    }

    public void deleteRARMBean(ConnectorDescriptor cd, String serverName) throws MBeanException {
        String rarName = cd.getName();
        String moduleName = this.getModuleName(cd);
        String appName = this.getApplicationName(cd);
        try {
            String namePattern = domain + ":" + "j2eeType=ResourceAdapter" + "," + "name=" + rarName + "," + "ResourceAdapterModule=" + moduleName + "," + "J2EEApplication=" + appName + "," + "J2EEServer=" + serverName + "," + "*";
            ObjectName objName = this.findObjectName(namePattern);
            if (objName != null) {
                this.unregister(objName);
            }
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    public void createAppClientModuleMBean(String appName, String parentName, String serverName, String deploymentDescriptor) throws MBeanException {
        StartStopCallback sscb = new StartStopCallback();
        J2EEModuleCallBackImpl module = new J2EEModuleCallBackImpl(appName, parentName, serverName, deploymentDescriptor, sscb);
        AppClientModuleMdl managedResource = new AppClientModuleMdl(module);
        this.instantiateAndRegisterRuntimeMBean("AppClientModule", managedResource, null, parentName, appName);
    }

    public void deleteAppClientModuleMBean(String applicationName, String parentName, String serverName) throws MBeanException {
        try {
            String namePattern = domain + ":" + "j2eeType=AppClientModule" + "," + "name=" + applicationName + "," + "J2EEApplication=" + parentName + "," + "J2EEServer=" + serverName + "," + "*";
            ObjectName objName = this.findObjectName(namePattern);
            if (objName != null) {
                this.unregister(objName);
            }
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    public void setApplicationState(int state, Application application, String serverName) throws MBeanException {
        String applicationName = application.getRegistrationName();
        String namePattern = domain + ":" + "j2eeType=J2EEApplication" + "," + "name=" + applicationName + "," + "J2EEServer=" + serverName + "," + "*";
        ObjectName objName = this.findObjectName(namePattern);
        if (objName != null) {
            this.setState(objName, state);
        }
    }

    public void setRARModuleState(int state, ConnectorDescriptor connectorDescriptor, String serverName) throws MBeanException {
        String moduleName = this.getModuleName(connectorDescriptor);
        String applicationName = this.getApplicationName(connectorDescriptor);
        String namePattern = domain + ":" + "j2eeType=ResourceAdapterModule" + "," + "name=" + moduleName + "," + "J2EEApplication=" + applicationName + "," + "J2EEServer=" + serverName + "," + "*";
        ObjectName objName = this.findObjectName(namePattern);
        if (objName != null) {
            this.setState(objName, state);
        }
    }

    public void setEJBModuleState(int state, EjbBundleDescriptor ejbBundleDescriptor, String serverName) throws MBeanException {
        String moduleName = this.getModuleName(ejbBundleDescriptor);
        String applicationName = this.getApplicationName(ejbBundleDescriptor);
        String namePattern = domain + ":" + "j2eeType=EJBModule" + "," + "name=" + moduleName + "," + "J2EEApplication=" + applicationName + "," + "J2EEServer=" + serverName + "," + "*";
        ObjectName objName = this.findObjectName(namePattern);
        if (objName != null) {
            this.setState(objName, state);
        }
    }

    private void setState(ObjectName objName, int state) throws MBeanException {
        try {
            if (server.isRegistered(objName)) {
                Integer stateValueObj = new Integer(state);
                server.setAttribute(objName, new Attribute("state", stateValueObj));
            }
        }
        catch (InstanceNotFoundException infe) {
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    public Integer getState(String namePattern) throws MBeanException {
        ObjectName objName = this.findObjectName(namePattern);
        if (objName != null) {
            try {
                Integer intObj = (Integer)server.getAttribute(objName, "state");
                return intObj;
            }
            catch (InstanceNotFoundException infe) {
            }
            catch (Exception e) {
                throw new MBeanException(e);
            }
        }
        return null;
    }

    private void register(Object object, ObjectName objectName) throws MBeanException {
        if (server == null) {
            J2EEManagementObjectManager.initMBeanServer();
        }
        try {
            if (!server.isRegistered(objectName)) {
                server.registerMBean(object, objectName);
            }
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    public void unregister(ObjectName objectName) throws MBeanException {
        try {
            if (server.isRegistered(objectName)) {
                server.unregisterMBean(objectName);
            }
        }
        catch (InstanceNotFoundException infe) {
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    public ObjectName[] toObjectNameArray(String[] strings) throws MBeanException {
        if (strings != null) {
            ObjectName[] objectNames = new ObjectName[strings.length];
            for (int i = 0; i < strings.length; ++i) {
                try {
                    objectNames[i] = new ObjectName(strings[i]);
                    continue;
                }
                catch (MalformedObjectNameException mne) {
                    throw new MBeanException(mne);
                }
            }
            return objectNames;
        }
        return new ObjectName[0];
    }

    public String getModuleName(BundleDescriptor bd) throws MBeanException {
        String moduleName = null;
        moduleName = bd.getModuleDescriptor().isStandalone() ? bd.getApplication().getRegistrationName() : bd.getModuleDescriptor().getArchiveUri();
        return moduleName;
    }

    private String getModuleLocation(BundleDescriptor bd, String j2eeType) throws MBeanException {
        String moduleName = null;
        String modLocation = null;
        String ddRoot = bd.getApplication().getGeneratedXMLDirectory();
        if (bd.getModuleDescriptor().isStandalone()) {
            moduleName = bd.getApplication().getRegistrationName();
            if (j2eeType.equals("AppClientModule")) {
                modLocation = ddRoot + File.separator + DescriptorConstants.APP_CLIENT_DD_ENTRY;
            } else if (j2eeType.equals("EJBModule")) {
                modLocation = ddRoot + File.separator + DescriptorConstants.EJB_DD_ENTRY;
            } else if (j2eeType.equals("WebModule")) {
                modLocation = ddRoot + File.separator + DescriptorConstants.WEB_DD_ENTRY;
            } else if (j2eeType.equals("ResourceAdapterModule")) {
                modLocation = ddRoot + File.separator + DescriptorConstants.RAR_DD_ENTRY;
            }
        } else {
            moduleName = FileUtils.makeFriendlyFileName(bd.getModuleDescriptor().getArchiveUri());
            if (j2eeType.equals("AppClientModule")) {
                modLocation = ddRoot + File.separator + moduleName + File.separator + DescriptorConstants.APP_CLIENT_DD_ENTRY;
            } else if (j2eeType.equals("EJBModule")) {
                modLocation = ddRoot + File.separator + moduleName + File.separator + DescriptorConstants.EJB_DD_ENTRY;
            } else if (j2eeType.equals("WebModule")) {
                modLocation = ddRoot + File.separator + moduleName + File.separator + DescriptorConstants.WEB_DD_ENTRY;
            } else if (j2eeType.equals("ResourceAdapterModule")) {
                modLocation = ddRoot + File.separator + moduleName + File.separator + DescriptorConstants.RAR_DD_ENTRY;
            }
        }
        return modLocation;
    }

    public String getApplicationName(BundleDescriptor bd) {
        String applicationName = "null";
        if (bd.getModuleDescriptor().isStandalone()) {
            return applicationName;
        }
        if (bd.getApplication() != null && (applicationName = bd.getApplication().getRegistrationName()) == null) {
            applicationName = "null";
        }
        return applicationName;
    }

    public ObjectName findObjectName(String namePattern) throws MBeanException {
        ObjectName[] objNameArr = this.findObjectNames(namePattern);
        if (objNameArr != null && objNameArr.length > 0) {
            if (objNameArr.length > 1) {
                throw new MBeanException(new Exception("Found more than one mBean matchin the given object name pattern"));
            }
            return objNameArr[0];
        }
        return null;
    }

    private ObjectName[] findObjectNames(String namePattern) throws MBeanException {
        ObjectName[] objNameArr = null;
        ObjectName objNamePattern = null;
        try {
            objNamePattern = new ObjectName(namePattern);
        }
        catch (MalformedObjectNameException mfone) {
            throw new MBeanException(mfone);
        }
        Set<Object> s = new HashSet();
        s = server.queryNames(objNamePattern, null);
        if (s != null) {
            objNameArr = s.toArray(new ObjectName[s.size()]);
            return objNameArr;
        }
        return objNameArr;
    }

    private String getStringForDDxml(String fileName) throws MBeanException {
        String string;
        InputStreamReader fr = null;
        try {
            if (!new File(fileName).exists()) {
                _logger.log(Level.FINE, "Descriptor does not exist " + fileName);
                String string2 = null;
                return string2;
            }
            fr = new FileReader(fileName);
            StringWriter sr = new StringWriter();
            char[] buf = new char[1024];
            int len = 0;
            while (len != -1) {
                try {
                    len = fr.read(buf, 0, buf.length);
                }
                catch (EOFException eof) {
                    break;
                }
                if (len == -1) continue;
                sr.write(buf, 0, len);
            }
            fr.close();
            sr.close();
            string = sr.toString();
        }
        catch (FileNotFoundException fnfe) {
            throw new MBeanException(fnfe);
        }
        catch (IOException ioe) {
            throw new MBeanException(ioe);
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException ioe) {}
            }
        }
        return string;
    }

    public String getJ2eeTypeForEjb(EjbDescriptor ejbDescriptor) throws MBeanException {
        String ejbType = ejbDescriptor.getType();
        String ejbSessionType = null;
        if (ejbType.equals("Session")) {
            ejbSessionType = ((EjbSessionDescriptor)ejbDescriptor).getSessionType();
        }
        String j2eeType = null;
        if (ejbType.equals("Entity")) {
            j2eeType = "EntityBean";
        } else if (ejbType.equals("Message-driven")) {
            j2eeType = "MessageDrivenBean";
        } else if (ejbType.equals("Session")) {
            if (ejbSessionType.equals("Stateless")) {
                j2eeType = "StatelessSessionBean";
            } else if (ejbSessionType.equals("Stateful")) {
                j2eeType = "StatefulSessionBean";
            }
        }
        return j2eeType;
    }

    private void registerDomainStatusMBean() {
        try {
            ObjectName on = DomainStatusHelper.getDomainStatusObjectName();
            server.registerMBean(new DomainStatus(), on);
            Object[] params = new Object[]{ApplicationServer.getServerContext().getInstanceName(), new Integer(1)};
            String[] signature = new String[]{"java.lang.String", "java.lang.Integer"};
            server.invoke(on, "setstate", params, signature);
        }
        catch (MalformedObjectNameException mne) {
            throw new RuntimeException(mne);
        }
        catch (InstanceNotFoundException infe) {
            throw new RuntimeException(infe);
        }
        catch (InstanceAlreadyExistsException iae) {
            throw new RuntimeException(iae);
        }
        catch (MBeanRegistrationException mre) {
            throw new RuntimeException(mre);
        }
        catch (NotCompliantMBeanException ncmbe) {
            throw new RuntimeException(ncmbe);
        }
        catch (MBeanException mbe) {
            throw new RuntimeException(mbe);
        }
        catch (ReflectionException rfe) {
            throw new RuntimeException(rfe);
        }
    }

    public void registerDasJ2EEServers() {
        String[] allServers = this.getAllServerNamesInDomain();
        if (allServers == null || allServers.length == 0) {
            return;
        }
        for (int i = 0; i < allServers.length; ++i) {
            this.registerDasJ2EEServer(allServers[i]);
        }
    }

    private String[] getAllServerNamesInDomain() {
        ConfigContext configContext = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
        Server[] serverArr = null;
        try {
            serverArr = ServerHelper.getServersInDomain(configContext);
        }
        catch (ConfigException ce) {
            ce.printStackTrace();
            _logger.log(Level.WARNING, "admin.get_servers_in_domain_error", ce);
        }
        if (serverArr == null || serverArr.length == 0) {
            return null;
        }
        String[] strServerArr = new String[serverArr.length];
        for (int i = 0; i < serverArr.length; ++i) {
            strServerArr[i] = serverArr[i].getName();
        }
        return strServerArr;
    }

    public void registerDasJ2EEServer(String serverName) {
        DomainStatusHelper dsh = new DomainStatusHelper();
        try {
            if (!server.isRegistered(dsh.getDomainStatusObjectName())) {
                this.registerDomainStatusMBean();
            }
            try {
                dsh.getstate(serverName);
            }
            catch (Exception e) {
                Object[] params = new Object[]{serverName, new Integer(0)};
                String[] signature = new String[]{"java.lang.String", "java.lang.Integer"};
                server.invoke(dsh.getDomainStatusObjectName(), "setstate", params, signature);
            }
            ObjectName on = new ObjectName(this.getServerBaseON(true, serverName));
            DASJ2EEServerImpl ds = new DASJ2EEServerImpl();
            ObjectInstance oi = server.registerMBean(ds, on);
            server.addNotificationListener(dsh.getDomainStatusObjectName(), oi.getObjectName(), null, null);
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
            _logger.log(Level.WARNING, "admin.registerDasJ2EEServer exception", e);
        }
        catch (InstanceAlreadyExistsException iae) {
        }
        catch (InstanceNotFoundException infe) {
            infe.printStackTrace();
            _logger.log(Level.WARNING, "admin.registerDasJ2EEServer exception", infe);
        }
        catch (MBeanRegistrationException mre) {
            mre.printStackTrace();
            _logger.log(Level.WARNING, "admin.registerDasJ2EEServer exception", mre);
        }
        catch (NotCompliantMBeanException ncmbe) {
            ncmbe.printStackTrace();
            _logger.log(Level.WARNING, "admin.registerDasJ2EEServer exception", ncmbe);
        }
        catch (MBeanException mbe) {
            mbe.printStackTrace();
            _logger.log(Level.WARNING, "admin.registerDasJ2EEServer exception", mbe);
        }
        catch (ReflectionException rfe) {
            rfe.printStackTrace();
            _logger.log(Level.WARNING, "admin.registerDasJ2EEServer exception", rfe);
        }
    }

    public void unregisterDasJ2EEServer(String serverName) {
        try {
            ObjectName onPattern = new ObjectName(this.getServerBaseON(true, serverName) + ",*");
            Set<Object> s = new HashSet();
            s = server.queryNames(onPattern, null);
            if (s != null && s.size() > 0) {
                ObjectName[] objNameArr = s.toArray(new ObjectName[s.size()]);
                server.unregisterMBean(objNameArr[0]);
            }
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
            _logger.log(Level.WARNING, "admin.unregisterDASJ2EEServer exception", e);
        }
        catch (InstanceNotFoundException infe) {
            _logger.log(Level.FINE, "admin.unregisterDASJ2EEServer exception", infe);
        }
        catch (MBeanException mbe) {
            _logger.log(Level.FINE, "admin.unregisterDASJ2EEServer exception", mbe);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            _logger.log(Level.FINE, "admin.unregisterDASJ2EEServer exception", ex);
        }
    }

    public String getServerBaseON(boolean amx, String serverName) {
        String domainName = null;
        if (amx) {
            try {
                ObjectName pattern = Util.newObjectNamePattern("*", "name=mbean-loader");
                Set<ObjectName> names = server.queryNames(pattern, null);
                assert (names.size() == 1);
                ObjectName loaderON = SetUtil.getSingleton(names);
                domainName = (String)server.getAttribute(loaderON, "AdministrativeDomainName");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            domainName = ApplicationServer.getServerContext().getDefaultDomainName();
        }
        return this.getServerBaseON(domainName, serverName);
    }

    public void registerTransactionService() {
        TransactionServiceMdl ts = new TransactionServiceMdl();
        this.instantiateAndRegisterRuntimeMBean("TransactionService", ts);
    }

    private String getServerBaseON(String domainName, String serverName) {
        return domainName + ":" + "j2eeType=J2EEServer,name=" + serverName;
    }

    public void registerAllJ2EEClusters() {
        try {
            Cluster[] clusters = ClusterHelper.getClustersInDomain(this.getAdminConfigContext());
            if (null == clusters || clusters.length == 0) {
                return;
            }
            ArrayList<String> al = new ArrayList<String>(clusters.length);
            for (int i = 0; i < clusters.length; ++i) {
                al.add(clusters[i].getName());
            }
            String[] sa = al.toArray(new String[0]);
            this._registerJ2EEClusters(sa);
        }
        catch (ConfigException ce) {
            throw new RuntimeException(ce.getMessage());
        }
    }

    public void registerJ2EECluster(String clusterName) {
        try {
            if (!ClusterHelper.isACluster(this.getAdminConfigContext(), clusterName)) {
                throw new RuntimeException(clusterName + " is not a valid cluster.");
            }
        }
        catch (ConfigException ce) {
            throw new RuntimeException(ce.getMessage());
        }
        this._registerJ2EEClusters(new String[]{clusterName});
    }

    public void unregisterJ2EECluster(String clusterName) {
        if (null == clusterName || "".equals(clusterName)) {
            throw new IllegalArgumentException();
        }
        ObjectName on = null;
        MBeanServer mbs = this.getAdminMBeanServer();
        ProxyFactory proxyFactory = ProxyFactory.getInstance(new MBeanServerConnectionSource(mbs));
        Set proxies = proxyFactory.getDomainRoot().getQueryMgr().queryJ2EETypeSet("X-J2EECluster");
        for (J2EECluster cluster : proxies) {
            if (!cluster.getName().equals(clusterName)) continue;
            on = Util.getObjectName(cluster);
            break;
        }
        try {
            mbs.unregisterMBean(on);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private void _registerJ2EEClusters(String[] clusters) {
        ConfigContext ctx = this.getAdminConfigContext();
        MBeanServer mbs = this.getAdminMBeanServer();
        String amxJMXDomain = BootUtil.getInstance().getAMXJMXDomainName();
        String j2eeTypeProp = "j2eeType=X-J2EECluster";
        for (int i = 0; i < clusters.length; ++i) {
            String nameProp = "name=" + clusters[i];
            String props = Util.concatenateProps("j2eeType=X-J2EECluster", nameProp);
            ObjectName on = JMXUtil.newObjectName(amxJMXDomain, props);
            try {
                mbs.registerMBean(new J2EEClusterImpl(null), on);
                _logger.info(on + " is registered.");
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    private ConfigContext getAdminConfigContext() {
        return AdminService.getAdminService().getAdminContext().getAdminConfigContext();
    }

    private MBeanServer getAdminMBeanServer() {
        return AdminService.getAdminService().getAdminContext().getMBeanServer();
    }

    private String getJVMId() {
        String serverName = ApplicationServer.getServerContext().getInstanceName();
        return serverName + System.currentTimeMillis();
    }

    static {
        if (server == null) {
            J2EEManagementObjectManager.initMBeanServer();
        }
        if (server != null) {
            J2EEManagementObjectManager.registerHTMLAdaptor();
        }
        _bHtmlAdaptorServerRegistered = false;
    }
}

