/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.naming.java;

import com.sun.enterprise.Switch;
import com.sun.enterprise.distributedtx.TransactionSynchronizationRegistryImpl;
import com.sun.enterprise.distributedtx.UserTransactionImpl;
import com.sun.enterprise.naming.NamingManagerImpl;
import com.sun.enterprise.naming.SerialContext;
import com.sun.enterprise.transaction.TransactionManagerHelper;
import com.sun.enterprise.util.ORBManager;
import com.sun.logging.LogDomains;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;

public final class javaURLContext
implements Context,
Cloneable {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.naming");
    private static final String ORB_STRING = "java:comp/ORB";
    private static final String HANDLE_DELEGATE = "java:comp/HandleDelegate";
    private static final String USER_TX = "java:comp/UserTransaction";
    private static final String EJB_CONTEXT = "java:comp/EJBContext";
    private static final String EJB_TIMER_SERVICE = "java:comp/TimerService";
    private static final String TRANSACTION_SYNC_REGISTRY = "java:comp/TransactionSynchronizationRegistry";
    private static final String TRANSACTION_MGR = "java:pm/TransactionManager";
    public static final String APPSERVER_TRANSACTION_MGR = "java:appserver/TransactionManager";
    private static final boolean debug = false;
    private NamingManagerImpl namingManager;
    private Hashtable myEnv;
    private String myName = "";
    private SerialContext serialContext = null;

    public javaURLContext(Hashtable environment) throws NamingException {
        Hashtable hashtable = this.myEnv = environment != null ? (Hashtable)environment.clone() : null;
        if (this.namingManager == null) {
            this.namingManager = (NamingManagerImpl)Switch.getSwitch().getNamingManager();
        }
    }

    public javaURLContext(String name, Hashtable env) throws NamingException {
        this(env);
        this.myName = name;
    }

    public javaURLContext(Hashtable env, SerialContext serialContext) throws NamingException {
        this(env);
        this.serialContext = serialContext;
    }

    public javaURLContext addStickyContext(SerialContext serialContext) throws NamingException {
        try {
            javaURLContext jCtx = (javaURLContext)this.clone();
            jCtx.serialContext = serialContext;
            return jCtx;
        }
        catch (CloneNotSupportedException ex) {
            NamingException ne = new NamingException("problem with cloning javaURLContext instance");
            ne.initCause(ex);
            throw ne;
        }
    }

    public Object lookup(String name) throws NamingException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "In javaURLContext.lookup, name = " + name + " serialcontext..." + this.serialContext);
        }
        if (name.equals("")) {
            return new javaURLContext(this.myName, this.myEnv);
        }
        String fullName = name;
        if (!this.myName.equals("")) {
            fullName = this.myName.equals("java:") ? this.myName + name : this.myName + "/" + name;
        }
        try {
            if (fullName.startsWith("java:comp/env")) {
                return this.namingManager.lookup(fullName, this.serialContext);
            }
            if (fullName.equals(ORB_STRING)) {
                return ORBManager.getORB();
            }
            if (fullName.equals(USER_TX)) {
                return new UserTransactionImpl();
            }
            if (fullName.equals(EJB_TIMER_SERVICE)) {
                return Switch.getSwitch().getContainerFactory().getEJBContextObject("javax.ejb.TimerService");
            }
            if (fullName.equals(EJB_CONTEXT)) {
                return Switch.getSwitch().getContainerFactory().getEJBContextObject("javax.ejb.EJBContext");
            }
            if (fullName.equals(HANDLE_DELEGATE)) {
                return Switch.getSwitch().getHandleDelegate();
            }
            if (fullName.equals(TRANSACTION_MGR)) {
                return Switch.getSwitch().getContainerFactory().getTransactionMgr();
            }
            if (fullName.equals(APPSERVER_TRANSACTION_MGR)) {
                return TransactionManagerHelper.getTransactionManager();
            }
            if (fullName.equals(TRANSACTION_SYNC_REGISTRY)) {
                return TransactionSynchronizationRegistryImpl.getInstance();
            }
            return this.namingManager.lookup(fullName, this.serialContext);
        }
        catch (NamingException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw (NamingException)new NameNotFoundException("No object bound for " + fullName).initCause(ex);
        }
    }

    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    public void bind(String name, Object obj) throws NamingException {
        throw new NamingException("java:comp namespace cannot be modified");
    }

    public void bind(Name name, Object obj) throws NamingException {
        throw new NamingException("java:comp namespace cannot be modified");
    }

    public void rebind(String name, Object obj) throws NamingException {
        throw new NamingException("java:comp namespace cannot be modified");
    }

    public void rebind(Name name, Object obj) throws NamingException {
        throw new NamingException("java:comp namespace cannot be modified");
    }

    public void unbind(String name) throws NamingException {
        throw new NamingException("java:comp namespace cannot be modified");
    }

    public void unbind(Name name) throws NamingException {
        throw new NamingException("java:comp namespace cannot be modified");
    }

    public void rename(String oldname, String newname) throws NamingException {
        throw new NamingException("java:comp namespace cannot be modified");
    }

    public void rename(Name oldname, Name newname) throws NamingException {
        throw new NamingException("java:comp namespace cannot be modified");
    }

    public void destroySubcontext(String name) throws NamingException {
        throw new NamingException("java:comp namespace cannot be modified");
    }

    public void destroySubcontext(Name name) throws NamingException {
        throw new NamingException("java:comp namespace cannot be modified");
    }

    public Context createSubcontext(String name) throws NamingException {
        throw new NamingException("java:comp namespace cannot be modified");
    }

    public Context createSubcontext(Name name) throws NamingException {
        throw new NamingException("java:comp namespace cannot be modified");
    }

    public NamingEnumeration list(String name) throws NamingException {
        if (name.equals("")) {
            if (this.namingManager == null) {
                throw new NamingException();
            }
            return this.namingManager.list(this.myName);
        }
        Object target = this.lookup(name);
        if (target instanceof Context) {
            return ((Context)target).list("");
        }
        throw new NotContextException(name + " cannot be listed");
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        if (name.equals("")) {
            if (this.namingManager == null) {
                throw new NamingException();
            }
            return this.namingManager.listBindings(this.myName);
        }
        Object target = this.lookup(name);
        if (target instanceof Context) {
            return ((Context)target).listBindings("");
        }
        throw new NotContextException(name + " cannot be listed");
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    public NameParser getNameParser(String name) throws NamingException {
        if (this.namingManager == null) {
            throw new NamingException();
        }
        return this.namingManager.getNameParser();
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser(name.toString());
    }

    public String composeName(String name, String prefix) throws NamingException {
        Name result = this.composeName(new CompositeName(name), new CompositeName(prefix));
        return result.toString();
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        if (this.myEnv == null) {
            this.myEnv = new Hashtable(5, 0.75f);
        }
        return this.myEnv.put(propName, propVal);
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        if (this.myEnv == null) {
            return null;
        }
        return this.myEnv.remove(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this.myEnv == null) {
            this.myEnv = new Hashtable(3, 0.75f);
        }
        return this.myEnv;
    }

    public void close() throws NamingException {
        this.myEnv = null;
    }

    public String getNameInNamespace() throws NamingException {
        return this.myName;
    }
}

