/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.repository;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.PersistenceManagerFactoryResource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.repository.CustomResource;
import com.sun.enterprise.repository.ExternalJndiResource;
import com.sun.enterprise.repository.IASJdbcResource;
import com.sun.enterprise.repository.IASJdbcXAResource;
import com.sun.enterprise.repository.J2EEResource;
import com.sun.enterprise.repository.J2EEResourceBase;
import com.sun.enterprise.repository.J2EEResourceCollection;
import com.sun.enterprise.repository.J2EEResourceCollectionImpl;
import com.sun.enterprise.repository.J2EEResourceException;
import com.sun.enterprise.repository.J2EEResourceFactory;
import com.sun.enterprise.repository.JdbcConnectionPool;
import com.sun.enterprise.repository.JdbcDriver;
import com.sun.enterprise.repository.JdbcResource;
import com.sun.enterprise.repository.JdbcXAResource;
import com.sun.enterprise.repository.JmsCnxFactoryResource;
import com.sun.enterprise.repository.JmsDestinationResource;
import com.sun.enterprise.repository.MailResource;
import com.sun.enterprise.repository.PMFResource;
import com.sun.enterprise.repository.ResourceProperty;
import com.sun.enterprise.repository.ResourcePropertyImpl;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IASJ2EEResourceFactoryImpl
implements J2EEResourceFactory {
    private static Logger _logger = null;
    static final String JMS_QUEUE = "javax.jms.Queue";
    static final String JMS_TOPIC = "javax.jms.Topic";
    static final String JMS_QUEUE_CONNECTION_FACTORY = "javax.jms.QueueConnectionFactory";
    static final String JMS_TOPIC_CONNECTION_FACTORY = "javax.jms.TopicConnectionFactory";
    public static final String CUSTOM_RES_TYPE = "custom-resource";
    public static final String EXT_JNDI_RES_TYPE = "external-jndi-resource";
    public static final String JDBC_RES_TYPE = "jdbc-resource";
    public static final String MAIL_RES_TYPE = "mail-resource";
    public static final String JMS_RES_TYPE = "jms-resource";
    public static final String PMF_RES_TYPE = "persistence-manager-factory-resource";
    public static final String JDBC_CONN_POOL_RES_TYPE = "jdbc-connection-pool";
    public static final String CONNECTOR_CONN_POOL_TYPE = "connector-connection-pool";
    private ConfigContext ctx = null;
    private Resources rBean = null;
    private String serverName = null;
    private static J2EEResourceCollection resources;

    public J2EEResourceCollection loadDefaultResourceCollection() throws J2EEResourceException {
        if (resources != null) {
            return resources;
        }
        return this.loadResourceCollection(null);
    }

    public J2EEResourceCollection loadResourceCollection(String resourcesURL) throws J2EEResourceException {
        resources = new J2EEResourceCollectionImpl();
        ServerContext sc = ApplicationServer.getServerContext();
        if (sc == null) {
            _logger.log(Level.FINE, "Not Running in server. Returning empty resources...");
            return resources;
        }
        this.serverName = sc.getInstanceName();
        try {
            this.ctx = sc.getConfigContext();
            this.rBean = ServerBeansFactory.getDomainBean(this.ctx).getResources();
            if (this.rBean == null) {
                this.rBean = new Resources();
            }
        }
        catch (ConfigException ce) {
            _logger.log(Level.SEVERE, "enterprise.empty_resource", ce);
            _logger.log(Level.FINE, "Error initializing context. Returning empty resources...");
            return resources;
        }
        try {
            _logger.log(Level.FINE, "Loading Jdbc Connection Pool==========");
            this.loadJdbcConnectionPool(resources);
            _logger.log(Level.FINE, "Loading Jdbc Resource==========");
            this.loadJdbcResource(resources);
            _logger.log(Level.FINE, "Loading PMF Resource==========");
            this.loadPMFResource(resources);
            _logger.log(Level.FINE, "Loading Custom Resource==========");
            this.loadCustomResource(resources);
            _logger.log(Level.FINE, "Loading External Jndi Resource==========");
            this.loadExternalJndiResource(resources);
            _logger.log(Level.FINE, "Loading Mail Resource==========");
            this.loadMailResource(resources);
        }
        catch (ConfigException ce) {
            _logger.log(Level.SEVERE, "enterprise.config_exception", ce);
            _logger.log(Level.FINE, "Error Loading resources: " + ce.getMessage());
            throw new J2EEResourceException(ce);
        }
        return resources;
    }

    public void storeDefaultResourceCollection(J2EEResourceCollection resources) throws J2EEResourceException {
        this.storeResourceCollection(resources, null);
    }

    public void storeResourceCollection(J2EEResourceCollection resources, String resourcesURL) throws J2EEResourceException {
    }

    public J2EEResource createResource(int type, String name) {
        J2EEResourceBase resource = null;
        switch (type) {
            case 1: {
                resource = new JmsDestinationResource(name);
                break;
            }
            case 2: {
                resource = new JmsCnxFactoryResource(name);
                break;
            }
            case 3: {
                resource = new JdbcResource(name);
                break;
            }
            case 4: {
                resource = new JdbcXAResource(name);
                break;
            }
            case 5: {
                resource = new JdbcDriver(name);
                break;
            }
            case 8: {
                resource = new JdbcConnectionPool(name);
                break;
            }
            case 9: {
                resource = new PMFResource(name);
                break;
            }
            case 11: {
                resource = new CustomResource(name);
                break;
            }
            case 10: {
                resource = new ExternalJndiResource(name);
                break;
            }
            case 12: {
                resource = new MailResource(name);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return resource;
    }

    public ResourceProperty createProperty(String name) {
        return new ResourcePropertyImpl(name);
    }

    private boolean isJdbcPoolReferenced(String poolName) throws ConfigException {
        com.sun.enterprise.config.serverbeans.JdbcResource[] jdbcBeans = this.rBean.getJdbcResource();
        if (jdbcBeans == null) {
            return false;
        }
        for (int i = 0; i < jdbcBeans.length; ++i) {
            String pool;
            com.sun.enterprise.config.serverbeans.JdbcResource next = jdbcBeans[i];
            if (!this.isReferenced(next.getJndiName()) || (pool = next.getPoolName()) == null || !pool.equals(poolName)) continue;
            return true;
        }
        return false;
    }

    private boolean isReferenced(String resourceName) throws ConfigException {
        return ServerHelper.serverReferencesResource(this.ctx, this.serverName, resourceName);
    }

    private void loadJdbcResource(J2EEResourceCollection resources) throws ConfigException {
        com.sun.enterprise.config.serverbeans.JdbcResource[] jBeanSet = this.rBean.getJdbcResource();
        if (jBeanSet == null) {
            return;
        }
        for (int i = 0; i < jBeanSet.length; ++i) {
            com.sun.enterprise.config.serverbeans.JdbcResource next = jBeanSet[i];
            if (!this.isReferenced(next.getJndiName())) {
                _logger.fine("Skipping Jdbc Resource: " + next.getJndiName() + ". It is not used by server: " + this.serverName);
                continue;
            }
            if (!next.isEnabled()) {
                this.logMessageIfNotEnabled(next.getJndiName(), JDBC_RES_TYPE);
                continue;
            }
            String poolName = next.getPoolName();
            JdbcConnectionPool jcp = (JdbcConnectionPool)resources.getResourceByName(8, poolName);
            if (jcp == null) {
                _logger.log(Level.WARNING, "enterprise.connection_pool_does_not_exist", poolName);
                _logger.log(Level.WARNING, "enterprise.error_loading_jdbc_resource", next.getJndiName());
                _logger.info("Error loading Jdbc Resource:" + next.getJndiName() + ". skipping...");
                continue;
            }
            boolean isXA = jcp.isXA();
            J2EEResourceBase jr = null;
            if (isXA) {
                jr = new IASJdbcXAResource(next.getJndiName());
                ((IASJdbcXAResource)jr).setJdbcConnectionPool(jcp);
            } else {
                jr = new IASJdbcResource(next.getJndiName());
                ((IASJdbcResource)jr).setJdbcConnectionPool(jcp);
            }
            jr.setEnabled(next.isEnabled());
            resources.addResource(jr);
        }
    }

    private void loadJdbcConnectionPool(J2EEResourceCollection resources) throws ConfigException {
        com.sun.enterprise.config.serverbeans.JdbcConnectionPool[] jBeanSet = this.rBean.getJdbcConnectionPool();
        if (jBeanSet == null) {
            return;
        }
        for (int i = 0; i < jBeanSet.length; ++i) {
            com.sun.enterprise.config.serverbeans.JdbcConnectionPool next = jBeanSet[i];
            if (!this.isJdbcPoolReferenced(next.getName())) {
                _logger.fine("Skipping Jdbc Pool:" + next.getName() + ". It is not used by server: " + this.serverName);
                continue;
            }
            JdbcConnectionPool jr = IASJ2EEResourceFactoryImpl.loadJdbcConnectionPool(next);
            resources.addResource(jr);
        }
    }

    public static JdbcConnectionPool loadJdbcConnectionPool(com.sun.enterprise.config.serverbeans.JdbcConnectionPool jcp) throws ConfigException {
        JdbcConnectionPool jr = new JdbcConnectionPool(jcp.getName());
        jr.setDatasourceClassname(jcp.getDatasourceClassname());
        jr.setMaxPoolSize(jcp.getMaxPoolSize());
        jr.setSteadyPoolSize(jcp.getSteadyPoolSize());
        jr.setMaxWaitTimeInMillis(jcp.getMaxWaitTimeInMillis());
        jr.setPoolResizeQuantity(jcp.getPoolResizeQuantity());
        jr.setIdleTimeoutInSeconds(jcp.getIdleTimeoutInSeconds());
        jr.setIsConnectionValidationRequired(jcp.isIsConnectionValidationRequired());
        jr.setConnectionValidationMethod(jcp.getConnectionValidationMethod());
        jr.setValidationTableName(jcp.getValidationTableName());
        jr.setFailAllConnections(jcp.isFailAllConnections());
        jr.setResType(jcp.getResType());
        jr.setTransactionIsolationLevel(jcp.getTransactionIsolationLevel());
        jr.setIsIsolationLevelGuaranteed(jcp.isIsIsolationLevelGuaranteed());
        ElementProperty[] s = jcp.getElementProperty();
        if (s != null) {
            for (int j = 0; j < s.length; ++j) {
                ElementProperty ep = s[j];
                ResourcePropertyImpl rp = new ResourcePropertyImpl(ep.getName(), ep.getValue());
                jr.addProperty(rp);
            }
        }
        return jr;
    }

    private void loadCustomResource(J2EEResourceCollection resources) throws ConfigException {
        com.sun.enterprise.config.serverbeans.CustomResource[] jBeanSet = this.rBean.getCustomResource();
        if (jBeanSet == null) {
            return;
        }
        for (int i = 0; i < jBeanSet.length; ++i) {
            com.sun.enterprise.config.serverbeans.CustomResource next = jBeanSet[i];
            if (!this.isReferenced(next.getJndiName())) {
                _logger.fine("Skipping Custom Resource:" + next.getJndiName() + ". It is not used by server: " + this.serverName);
                continue;
            }
            if (!next.isEnabled()) {
                this.logMessageIfNotEnabled(next.getJndiName(), CUSTOM_RES_TYPE);
                continue;
            }
            J2EEResource jr = IASJ2EEResourceFactoryImpl.toCustomJ2EEResource(next);
            resources.addResource(jr);
        }
    }

    public static J2EEResource toCustomJ2EEResource(com.sun.enterprise.config.serverbeans.CustomResource rbean) throws ConfigException {
        CustomResource jr = new CustomResource(rbean.getJndiName());
        jr.setEnabled(rbean.isEnabled());
        jr.setResType(rbean.getResType());
        jr.setFactoryClass(rbean.getFactoryClass());
        ElementProperty[] s = rbean.getElementProperty();
        if (s != null) {
            for (int j = 0; j < s.length; ++j) {
                ElementProperty next = s[j];
                ResourcePropertyImpl rp = new ResourcePropertyImpl(next.getName(), next.getValue());
                jr.addProperty(rp);
            }
        }
        return jr;
    }

    public static J2EEResource toExternalJndiJ2EEResource(com.sun.enterprise.config.serverbeans.ExternalJndiResource rbean) throws ConfigException {
        ExternalJndiResource jr = new ExternalJndiResource(rbean.getJndiName());
        jr.setEnabled(rbean.isEnabled());
        jr.setJndiLookupName(rbean.getJndiLookupName());
        jr.setResType(rbean.getResType());
        jr.setFactoryClass(rbean.getFactoryClass());
        ElementProperty[] s = rbean.getElementProperty();
        if (s != null) {
            for (int j = 0; j < s.length; ++j) {
                ElementProperty next = s[j];
                ResourcePropertyImpl rp = new ResourcePropertyImpl(next.getName(), next.getValue());
                jr.addProperty(rp);
            }
        }
        return jr;
    }

    private void loadExternalJndiResource(J2EEResourceCollection resources) throws ConfigException {
        com.sun.enterprise.config.serverbeans.ExternalJndiResource[] jBeanSet = this.rBean.getExternalJndiResource();
        if (jBeanSet == null) {
            return;
        }
        for (int i = 0; i < jBeanSet.length; ++i) {
            com.sun.enterprise.config.serverbeans.ExternalJndiResource next = jBeanSet[i];
            if (!this.isReferenced(next.getJndiName())) {
                _logger.fine("Skipping External JNDI Resource:" + next.getJndiName() + ". It is not used by server: " + this.serverName);
                continue;
            }
            if (!next.isEnabled()) {
                this.logMessageIfNotEnabled(next.getJndiName(), EXT_JNDI_RES_TYPE);
                continue;
            }
            J2EEResource jr = IASJ2EEResourceFactoryImpl.toExternalJndiJ2EEResource(next);
            resources.addResource(jr);
        }
    }

    private void loadPMFResource(J2EEResourceCollection resources) throws ConfigException {
        PersistenceManagerFactoryResource[] jBeanSet = this.rBean.getPersistenceManagerFactoryResource();
        if (jBeanSet == null) {
            return;
        }
        for (int i = 0; i < jBeanSet.length; ++i) {
            PersistenceManagerFactoryResource next = jBeanSet[i];
            if (!this.isReferenced(next.getJndiName())) {
                _logger.fine("Skipping PMF Resource:" + next.getJndiName() + ". It is not used by server: " + this.serverName);
                continue;
            }
            if (!next.isEnabled()) {
                this.logMessageIfNotEnabled(next.getJndiName(), PMF_RES_TYPE);
                continue;
            }
            resources.addResource(IASJ2EEResourceFactoryImpl.toPMFJ2EEResource(next));
        }
    }

    public static J2EEResource toPMFJ2EEResource(PersistenceManagerFactoryResource rbean) throws ConfigException {
        PMFResource jr = new PMFResource(rbean.getJndiName());
        jr.setEnabled(rbean.isEnabled());
        jr.setFactoryClass(rbean.getFactoryClass());
        jr.setJdbcResourceJndiName(rbean.getJdbcResourceJndiName());
        ElementProperty[] s = rbean.getElementProperty();
        if (s != null) {
            for (int j = 0; j < s.length; ++j) {
                ElementProperty next1 = s[j];
                ResourcePropertyImpl rp = new ResourcePropertyImpl(next1.getName(), next1.getValue());
                jr.addProperty(rp);
            }
        }
        return jr;
    }

    public static J2EEResource toMailJ2EEResource(com.sun.enterprise.config.serverbeans.MailResource rbean) throws ConfigException {
        MailResource jr = new MailResource(rbean.getJndiName());
        jr.setEnabled(rbean.isEnabled());
        jr.setStoreProtocol(rbean.getStoreProtocol());
        jr.setStoreProtocolClass(rbean.getStoreProtocolClass());
        jr.setTransportProtocol(rbean.getTransportProtocol());
        jr.setTransportProtocolClass(rbean.getTransportProtocolClass());
        jr.setMailHost(rbean.getHost());
        jr.setUsername(rbean.getUser());
        jr.setMailFrom(rbean.getFrom());
        jr.setDebug(rbean.isDebug());
        ElementProperty[] s = rbean.getElementProperty();
        if (s != null) {
            for (int j = 0; j < s.length; ++j) {
                ElementProperty next = s[j];
                ResourcePropertyImpl rp = new ResourcePropertyImpl(next.getName(), next.getValue());
                jr.addProperty(rp);
            }
        }
        return jr;
    }

    private void loadMailResource(J2EEResourceCollection resources) throws ConfigException {
        com.sun.enterprise.config.serverbeans.MailResource[] jBeanSet = this.rBean.getMailResource();
        if (jBeanSet == null) {
            return;
        }
        for (int i = 0; i < jBeanSet.length; ++i) {
            com.sun.enterprise.config.serverbeans.MailResource next = jBeanSet[i];
            if (!this.isReferenced(next.getJndiName())) {
                _logger.fine("Skipping Mail Resource:" + next.getJndiName() + ". It is not used by server: " + this.serverName);
                continue;
            }
            if (!next.isEnabled()) {
                this.logMessageIfNotEnabled(next.getJndiName(), MAIL_RES_TYPE);
                continue;
            }
            J2EEResource jr = IASJ2EEResourceFactoryImpl.toMailJ2EEResource(next);
            resources.addResource(jr);
        }
    }

    private void logMessageIfNotEnabled(String name, String type) {
        _logger.log(Level.INFO, "enterprise.resource_disabled", new Object[]{name, type});
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise");
        resources = null;
    }
}

