/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.PoolManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.logging.LogDomains;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ManagedConnection;

public class LocalTxConnectionEventListener
implements ConnectionEventListener {
    private PoolManager poolMgr;
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
    private IdentityHashMap associatedHandles;
    private ResourceHandle resource;

    public LocalTxConnectionEventListener(ResourceHandle resource) {
        this.resource = resource;
        this.associatedHandles = new IdentityHashMap(10);
        this.poolMgr = Switch.getSwitch().getPoolManager();
    }

    public void connectionClosed(ConnectionEvent evt) {
        Object connectionHandle = evt.getConnectionHandle();
        ResourceHandle handle = this.resource;
        if (this.associatedHandles.containsKey(connectionHandle)) {
            handle = (ResourceHandle)this.associatedHandles.get(connectionHandle);
        }
        this.poolMgr.resourceClosed(handle);
    }

    public void connectionErrorOccurred(ConnectionEvent evt) {
        this.resource.setConnectionErrorOccurred();
        ManagedConnection mc = (ManagedConnection)evt.getSource();
        mc.removeConnectionEventListener((ConnectionEventListener)this);
        this.poolMgr.resourceErrorOccurred(this.resource);
        try {
            mc.destroy();
        }
        catch (ResourceException resourceException) {
            // empty catch block
        }
    }

    public void localTransactionStarted(ConnectionEvent evt) {
    }

    public void localTransactionCommitted(ConnectionEvent evt) {
    }

    public void localTransactionRolledback(ConnectionEvent evt) {
    }

    public void associateHandle(Object c, ResourceHandle h) {
        this.associatedHandles.put(c, h);
    }

    public void removeAssociation(Object c) {
        this.associatedHandles.remove(c);
    }

    public Map getAssociatedHandles() {
        return this.associatedHandles;
    }
}

