/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.ManagementObjectManager;
import com.sun.enterprise.NamingManager;
import com.sun.enterprise.config.serverbeans.MailResource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.repository.IASJ2EEResourceFactoryImpl;
import com.sun.enterprise.repository.J2EEResource;
import com.sun.enterprise.resource.GlobalResourceDeployer;
import com.sun.enterprise.resource.ResourceInstaller;
import com.sun.enterprise.server.ResourceDeployer;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MailResourceDeployer
extends GlobalResourceDeployer
implements ResourceDeployer {
    private static final StringManager localStrings = StringManager.getManager("com.sun.enterprise.resource");
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core");

    public synchronized void deployResource(Object resource) throws Exception {
        MailResource mailRes = (MailResource)resource;
        if (mailRes == null) {
            _logger.log(Level.INFO, "core.resourcedeploy_error");
        } else if (mailRes.isEnabled()) {
            ManagementObjectManager mgr = this.getAppServerSwitchObject().getManagementObjectManager();
            mgr.registerJavaMailResource(mailRes.getJndiName());
            this.installResource(mailRes);
        } else {
            _logger.log(Level.INFO, "core.resource_disabled", new Object[]{mailRes.getJndiName(), "mail-resource"});
        }
    }

    void installResource(MailResource mailResource) throws Exception {
        J2EEResource j2eeRes = IASJ2EEResourceFactoryImpl.toMailJ2EEResource(mailResource);
        ResourceInstaller installer = this.getAppServerSwitchObject().getResourceInstaller();
        installer.installMailResource((com.sun.enterprise.repository.MailResource)j2eeRes);
        installer.addResource(j2eeRes);
    }

    public synchronized void undeployResource(Object resource) throws Exception {
        NamingManager namingMgr = this.getAppServerSwitchObject().getNamingManager();
        MailResource mailRes = (MailResource)resource;
        J2EEResource j2eeResource = IASJ2EEResourceFactoryImpl.toMailJ2EEResource(mailRes);
        namingMgr.unpublishObject(j2eeResource.getName());
        ResourceInstaller installer = this.getAppServerSwitchObject().getResourceInstaller();
        installer.removeResource(j2eeResource);
        ManagementObjectManager mgr = this.getAppServerSwitchObject().getManagementObjectManager();
        mgr.unregisterJavaMailResource(mailRes.getJndiName());
    }

    public synchronized void redeployResource(Object resource) throws Exception {
        this.undeployResource(resource);
        this.deployResource(resource);
    }

    public synchronized void enableResource(Object resource) throws Exception {
        this.deployResource(resource);
    }

    public synchronized void disableResource(Object resource) throws Exception {
        this.undeployResource(resource);
    }

    public Object getResource(String name, Resources rbeans) throws Exception {
        MailResource res = rbeans.getMailResourceByJndiName(name);
        if (res == null) {
            String msg = localStrings.getString("resource.no_resource", name);
            throw new Exception(msg);
        }
        return res;
    }
}

