/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.security.SSLUtils;
import com.sun.enterprise.server.pluggable.SecuritySupport;
import com.sun.logging.LogDomains;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.Provider;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SecuritySupportImpl
implements SecuritySupport {
    private static final String keyStoreProp = "javax.net.ssl.keyStore";
    private static final String trustStoreProp = "javax.net.ssl.trustStore";
    private static boolean isInit = false;
    protected static List keyStores = new ArrayList();
    protected static List trustStores = new ArrayList();
    protected static List keyStorePasswords = new ArrayList();
    protected static List tokenNames = new ArrayList();
    private static Logger _logger = null;

    public SecuritySupportImpl() {
        this(true);
    }

    protected SecuritySupportImpl(boolean initJKS) {
        if (initJKS && !isInit) {
            SecuritySupportImpl.loadStores(null, KeyStore.getDefaultType(), null, System.getProperty(keyStoreProp), SSLUtils.getKeyStorePass(), System.getProperty(trustStoreProp), SSLUtils.getTrustStorePass());
        }
        isInit = true;
    }

    protected static synchronized void loadStores(String tokenName, String storeType, Provider provider, String keyStoreFile, String keyStorePass, String trustStoreFile, String trustStorePass) {
        try {
            KeyStore keyStore = SecuritySupportImpl.loadKS(storeType, provider, keyStoreFile, keyStorePass);
            KeyStore trustStore = SecuritySupportImpl.loadKS(storeType, provider, trustStoreFile, trustStorePass);
            keyStores.add(keyStore);
            trustStores.add(trustStore);
            keyStorePasswords.add(keyStorePass);
            tokenNames.add(tokenName);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore loadKS(String keyStoreType, Provider provider, String keyStoreFile, String keyStorePass) throws Exception {
        KeyStore ks = null;
        ks = provider != null ? KeyStore.getInstance(keyStoreType, provider) : KeyStore.getInstance(keyStoreType);
        char[] passphrase = keyStorePass.toCharArray();
        FileInputStream istream = null;
        BufferedInputStream bstream = null;
        try {
            if (keyStoreFile != null) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Loading keystoreFile = " + keyStoreFile + ", keystorePass = " + keyStorePass);
                }
                istream = new FileInputStream(keyStoreFile);
                bstream = new BufferedInputStream(istream);
            }
            ks.load(bstream, passphrase);
        }
        finally {
            if (bstream != null) {
                bstream.close();
            }
            if (istream != null) {
                istream.close();
            }
        }
        return ks;
    }

    public KeyStore[] getKeyStores() {
        return keyStores.toArray(new KeyStore[keyStores.size()]);
    }

    public KeyStore[] getTrustStores() {
        return trustStores.toArray(new KeyStore[trustStores.size()]);
    }

    public String[] getKeyStorePasswords() {
        return keyStorePasswords.toArray(new String[keyStorePasswords.size()]);
    }

    public String[] getTokenNames() {
        return tokenNames.toArray(new String[tokenNames.size()]);
    }

    public void synchronizeKeyFile(ConfigContext configContext, String fileRealmName) throws Exception {
    }

    public KeyStore getKeyStore(String token) {
        int idx = this.getTokenIndex(token);
        if (idx < 0) {
            return null;
        }
        return (KeyStore)keyStores.get(idx);
    }

    public KeyStore getTrustStore(String token) {
        int idx = this.getTokenIndex(token);
        if (idx < 0) {
            return null;
        }
        return (KeyStore)trustStores.get(idx);
    }

    public String getKeyStorePassword(String token) {
        int idx = this.getTokenIndex(token);
        if (idx < 0) {
            return null;
        }
        return (String)keyStorePasswords.get(idx);
    }

    private int getTokenIndex(String token) {
        int idx = -1;
        if (token != null && (idx = tokenNames.indexOf(token)) < 0) {
            _logger.log(Level.WARNING, "token " + token + " is not found");
            if (tokenNames.size() > 0) {
                idx = 0;
            }
        }
        return idx;
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.system.core.security");
    }
}

