/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.sun.appserv.server.ServerLifecycle;
import com.sun.appserv.server.ServerLifecycleException;
import com.sun.enterprise.Switch;
import com.sun.enterprise.admin.alert.AlertConfigurator;
import com.sun.enterprise.admin.event.AdminEventListenerRegistry;
import com.sun.enterprise.admin.event.jms.JmsHostEvent;
import com.sun.enterprise.admin.event.jms.JmsServiceEvent;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.loader.ClassLoaderUtils;
import com.sun.enterprise.security.audit.AuditModuleEventListenerImpl;
import com.sun.enterprise.security.audit.SecurityServiceEventListenerImpl;
import com.sun.enterprise.security.auth.realm.AuthRealmEventListenerImpl;
import com.sun.enterprise.security.auth.realm.UserMgmtEventListenerImpl;
import com.sun.enterprise.server.J2EEServer;
import com.sun.enterprise.server.JmsHostEventListener;
import com.sun.enterprise.server.JmsServiceEventListener;
import com.sun.enterprise.server.PELaunch;
import com.sun.enterprise.server.ResourceManager;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.server.ServerContextImpl;
import com.sun.enterprise.server.logging.ServerLogManager;
import com.sun.enterprise.server.pluggable.InternalServicesList;
import com.sun.enterprise.util.ConnectorClassLoader;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ApplicationServer {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core");
    public static PrintStream ostream = System.out;
    public static PrintStream estream = System.err;
    private static final String USER_TX = "java:comp/UserTransaction";
    private static final String CODEBASE_PROP = "java.rmi.server.codebase";
    static String[][] servicesByName;
    private static ServerContext context;
    private ArrayList services = new ArrayList();
    private ClassLoader commonClassLoader;
    private ClassLoader connectorClassLoader;

    public void onInitialization(ServerContext context) throws ServerLifecycleException {
        ApplicationServer.context = context;
        ServerLogManager.reInitializeServerLoggers();
        this.printStartupInfo();
        ClassLoader parentOfCommonCL = this.getClass().getClassLoader();
        if (Boolean.getBoolean("com.sun.aas.useNewClassLoader")) {
            parentOfCommonCL = PELaunch.getSharedChain();
        }
        InstanceEnvironment env = ApplicationServer.context.getInstanceEnvironment();
        try {
            String dir = env.getLibClassesPath();
            String jarDir = env.getLibPath();
            this.commonClassLoader = ClassLoaderUtils.getClassLoader(new File[]{new File(dir)}, new File[]{new File(jarDir)}, parentOfCommonCL);
            if (this.commonClassLoader == null) {
                this.commonClassLoader = parentOfCommonCL;
            }
        }
        catch (IOException ioe) {
            _logger.log(Level.WARNING, "server.ioexception", ioe);
            this.commonClassLoader = parentOfCommonCL;
        }
        catch (Throwable th) {
            _logger.log(Level.WARNING, "server.exception", th);
            this.commonClassLoader = parentOfCommonCL;
        }
        this.connectorClassLoader = ConnectorClassLoader.getInstance(this.commonClassLoader);
        if (ApplicationServer.context instanceof ServerContextImpl) {
            ServerContextImpl contextImpl = (ServerContextImpl)ApplicationServer.context;
            contextImpl.setCommonClassLoader(this.commonClassLoader);
            contextImpl.setSharedClassLoader(this.connectorClassLoader);
            contextImpl.setLifecycleParentClassLoader(this.connectorClassLoader);
        }
        final ClassLoader commonCL = this.commonClassLoader;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(commonCL);
                return null;
            }
        });
        InternalServicesList servicesList = context.getPluggableFeatureFactory().getInternalServicesList();
        servicesByName = servicesList.getServicesByName();
        if (servicesByName == null) {
            _logger.log(Level.SEVERE, "services.null");
            throw new ServerLifecycleException();
        }
        this.services = this.instantiateRuntimeServices();
        for (int i = 0; i < this.services.size(); ++i) {
            Object service = this.services.get(i);
            if (!(service instanceof ServerLifecycle)) continue;
            try {
                ((ServerLifecycle)service).onInitialization(context);
                continue;
            }
            catch (ServerLifecycleException e) {
                _logger.log(Level.SEVERE, "service.notinit", new Object[]{service, e.toString()});
                throw e;
            }
        }
        AdminEventListenerRegistry.addAuditModuleEventListener(new AuditModuleEventListenerImpl());
        AdminEventListenerRegistry.addAuthRealmEventListener(new AuthRealmEventListenerImpl());
        AdminEventListenerRegistry.addSecurityServiceEventListener(new SecurityServiceEventListenerImpl());
        AdminEventListenerRegistry.addUserMgmtEventListener(new UserMgmtEventListenerImpl());
        try {
            J2EEServer.main(context);
        }
        catch (Exception e) {
            throw new ServerLifecycleException(e);
        }
        final ClassLoader connCL = this.connectorClassLoader;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(connCL);
                return null;
            }
        });
    }

    protected ArrayList instantiateRuntimeServices() throws ServerLifecycleException {
        ArrayList serviceList = new ArrayList();
        for (int i = 0; i < servicesByName.length; ++i) {
            try {
                String[] def = servicesByName[i];
                Class<?> c = Class.forName(def[1]);
                Object o = c.newInstance();
                serviceList.add(o);
                continue;
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "server.exception", ex);
                throw new ServerLifecycleException(ex.getMessage());
            }
        }
        return serviceList;
    }

    public void onStartup() throws ServerLifecycleException {
        for (int i = 0; i < this.services.size(); ++i) {
            Object service = this.services.get(i);
            if (!(service instanceof ServerLifecycle)) continue;
            try {
                ((ServerLifecycle)service).onStartup(context);
                continue;
            }
            catch (ServerLifecycleException e) {
                _logger.log(Level.SEVERE, "service.notstarted", new Object[]{service, e.toString()});
                throw e;
            }
        }
        AlertConfigurator.getAlertConfigurator().configure();
    }

    public void onReady() throws ServerLifecycleException {
        try {
            AdminEventListenerRegistry.addResourceDeployEventListener(new ResourceManager(context));
            AdminEventListenerRegistry.addEventListener(JmsServiceEvent.eventType, new JmsServiceEventListener());
            AdminEventListenerRegistry.addEventListener(JmsHostEvent.eventType, new JmsHostEventListener());
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Thread.currentThread().setContextClassLoader(ApplicationServer.this.commonClassLoader);
                    return null;
                }
            });
            String startupHook = null;
            startupHook = System.getProperty("com.sun.enterprise.server.startupHook");
            if (startupHook != null) {
                try {
                    Class<?> hookClass = Class.forName(startupHook);
                    Method hookMethod = hookClass.getMethod("main", ServerContext.class);
                    hookMethod.invoke(null, context);
                }
                catch (Exception ex) {
                    _logger.log(Level.FINE, "server.exception", ex);
                }
            }
        }
        catch (Exception ee) {
            throw new ServerLifecycleException(ee);
        }
        for (int i = 0; i < this.services.size(); ++i) {
            Object service = this.services.get(i);
            if (!(service instanceof ServerLifecycle)) continue;
            try {
                ((ServerLifecycle)service).onReady(context);
                continue;
            }
            catch (ServerLifecycleException e) {
                _logger.log(Level.SEVERE, "service.notready", new Object[]{service, e.toString()});
            }
        }
    }

    public void onShutdown() throws ServerLifecycleException {
        for (int i = this.services.size(); i > 0; --i) {
            Object service = this.services.get(i - 1);
            _logger.log(Level.FINE, "service.shutdown", this.services.get(i - 1));
            try {
                if (!(service instanceof ServerLifecycle)) continue;
                ((ServerLifecycle)service).onShutdown();
                continue;
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "server.exception", e);
            }
        }
    }

    public void onTermination() throws ServerLifecycleException {
        block6: {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Killing all pools in the appserver");
            }
            try {
                Switch.getSwitch().getPoolManager().killAllPools();
            }
            catch (Throwable t) {
                if (!_logger.isLoggable(Level.FINE)) break block6;
                _logger.log(Level.FINE, "exception : " + t);
            }
        }
        for (int i = this.services.size(); i > 0; --i) {
            Object service = this.services.get(i - 1);
            _logger.log(Level.FINE, "service.shutdown", this.services.get(i - 1));
            try {
                if (!(service instanceof ServerLifecycle)) continue;
                ((ServerLifecycle)service).onTermination();
                continue;
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "server.exception", e);
            }
        }
        this.services = null;
    }

    public static ServerContext getServerContext() {
        return context;
    }

    protected void setServerContext(ServerContext context) {
        ApplicationServer.context = context;
    }

    private void printStartupInfo() {
        _logger.log(Level.INFO, "j2eerunner.printstartinfo", new Object[]{System.getProperty("java.vm.name"), System.getProperty("java.version"), System.getProperty("java.vm.vendor")});
    }

    static {
        context = null;
    }
}

