/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.common.properties;

import com.sun.enterprise.tools.common.util.diagnostics.Reporter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class PrincipalTableModel
extends AbstractTableModel {
    Vector principals = null;
    private static ResourceBundle bundle = ResourceBundle.getBundle("com.sun.enterprise.tools.common.properties.Bundle");

    public PrincipalTableModel(Vector values) {
        this.principals = values == null ? new Vector() : (Vector)values.clone();
    }

    public Object getValueAt(int row, int column) {
        if (row < this.principals.size()) {
            return ((String[])this.principals.elementAt(row))[column];
        }
        return "";
    }

    public int getRowCount() {
        return this.principals.size() + 1;
    }

    public int getColumnCount() {
        return 2;
    }

    public Vector getPrincipals() {
        return this.principals;
    }

    public boolean isCellEditable(int row, int col) {
        return true;
    }

    public void setValueAt(Object val, int row, int col) {
        int pre = this.principals.size();
        if (row >= pre) {
            String[] newPrincipal = new String[2];
            this.principals.add(newPrincipal);
        }
        if (!(val instanceof String)) {
            throw new IllegalArgumentException();
        }
        String input = (String)val;
        if (col == 0 && (input == null || input.trim().length() == 0)) {
            Reporter.info("row has no value (" + input + ")");
            this.principals.removeElementAt(row);
        } else {
            Reporter.info("(" + input.trim() + ")");
            ((String[])this.principals.elementAt((int)row))[col] = input.trim();
        }
        if (this.principals.size() < pre) {
            this.fireTableStructureChanged();
        }
    }

    public String getColumnName(int col) {
        if (0 == col) {
            return bundle.getString("COL_HEADER_PRINCIPAL");
        }
        if (1 == col) {
            return bundle.getString("COL_HEADER_DESCRIPTION");
        }
        throw new RuntimeException(bundle.getString("COL_HEADER_ERR_ERR_ERR"));
    }

    public static void main(String[] args) {
        String[] principal = new String[]{"user-name", "description"};
        Vector<String[]> principals = new Vector<String[]>();
        principals.add(principal);
        JTable table = new JTable(new PrincipalTableModel(principals));
        JScrollPane sp = new JScrollPane(table);
        final JDialog d = new JDialog();
        d.setSize(200, 150);
        d.getContentPane().setLayout(new BorderLayout());
        d.getContentPane().add((Component)sp, "Center");
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                d.setVisible(false);
                d.dispose();
            }
        });
        JPanel buttonsPane = new JPanel();
        buttonsPane.add(okButton);
        d.getContentPane().add((Component)buttonsPane, "South");
        d.setVisible(true);
    }

    static class CloseTestWindow
    extends WindowAdapter {
        private Vector principals = null;

        public CloseTestWindow(Vector vec) {
            this.principals = vec;
        }

        public void windowClosing(WindowEvent e) {
            System.exit(0);
        }
    }
}

