/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.archivist.AppClientArchivist;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.deployment.archivist.ConnectorArchivist;
import com.sun.enterprise.deployment.archivist.EjbArchivist;
import com.sun.enterprise.deployment.archivist.PluggableArchivistsHelper;
import com.sun.enterprise.deployment.archivist.WebArchivist;
import com.sun.enterprise.deployment.backend.J2EEModuleExploder;
import com.sun.enterprise.deployment.backend.OptionalPkgDependency;
import com.sun.enterprise.deployment.deploy.shared.AbstractArchive;
import com.sun.enterprise.deployment.deploy.shared.FileArchiveFactory;
import com.sun.enterprise.deployment.util.ApplicationValidator;
import com.sun.enterprise.loader.EJBClassPathUtils;
import com.sun.enterprise.logging.LogDomains;
import com.sun.enterprise.server.PELaunch;
import com.sun.enterprise.tools.verifier.BaseVerifier;
import com.sun.enterprise.tools.verifier.FrameworkContext;
import com.sun.enterprise.tools.verifier.ResultManager;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.VerifierErrorHandler;
import com.sun.enterprise.tools.verifier.apiscan.stdapis.APIRepository;
import com.sun.enterprise.tools.verifier.app.ApplicationVerifier;
import com.sun.enterprise.tools.verifier.appclient.AppClientVerifier;
import com.sun.enterprise.tools.verifier.connector.ConnectorVerifier;
import com.sun.enterprise.tools.verifier.ejb.EjbVerifier;
import com.sun.enterprise.tools.verifier.web.WebVerifier;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.JarClassLoader;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerificationHandler {
    private final String TMPDIR = System.getProperty("java.io.tmpdir");
    private SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyyMMddhhmmss");
    private String explodeDir = this.TMPDIR + File.separator + "exploded" + this.dateFormatter.format(new Date());
    private LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
    private FrameworkContext frameworkContext = null;
    private Logger logger = LogDomains.getLogger("javax.enterprise.system.tools.avk.tools.verifier");
    private Application application = null;
    private ResultManager resultManager = null;
    private Archivist archivist = null;
    private boolean isBackend = false;
    private List<String> classPath = null;
    private final int MAX_WINDOWS_PATH_LIMIT = 248;

    public VerificationHandler(FrameworkContext frameworkContext) throws IOException {
        this.frameworkContext = frameworkContext;
        try {
            this.initStandalone();
        }
        catch (IOException ioe) {
            this.cleanup();
            throw ioe;
        }
        catch (RuntimeException re) {
            this.cleanup();
            throw re;
        }
    }

    public VerificationHandler(FrameworkContext frameworkContext, Application application, AbstractArchive abstractArchive, List<String> classPath) {
        this.frameworkContext = frameworkContext;
        this.init();
        this.application = application;
        this.frameworkContext.setClassPath(classPath);
        this.frameworkContext.setJarFileName(application.getRegistrationName());
        this.isBackend = true;
        this.frameworkContext.setApplication(application);
        this.frameworkContext.setAbstractArchive(abstractArchive);
    }

    public ResultManager verifyArchive() {
        if (!this.application.isVirtual()) {
            this.runVerifier(new ApplicationVerifier(this.frameworkContext, this.application));
        }
        for (EjbBundleDescriptor ejbd : this.application.getEjbBundleDescriptors()) {
            this.runVerifier(new EjbVerifier(this.frameworkContext, ejbd));
        }
        for (WebBundleDescriptor webd : this.application.getWebBundleDescriptors()) {
            this.runVerifier(new WebVerifier(this.frameworkContext, webd));
        }
        for (ApplicationClientDescriptor appClientDescriptor : this.application.getApplicationClientDescriptors()) {
            this.runVerifier(new AppClientVerifier(this.frameworkContext, appClientDescriptor));
        }
        for (ConnectorDescriptor cond : this.application.getRarDescriptors()) {
            this.runVerifier(new ConnectorVerifier(this.frameworkContext, cond));
        }
        return this.resultManager;
    }

    private void init() {
        this.resultManager = new ResultManager();
        this.frameworkContext.setResultManager(this.resultManager);
        try {
            APIRepository.Initialize(this.frameworkContext.getConfigDirStr() + File.separator + "standard-apis.xml");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void initStandalone() throws IOException {
        this.init();
        this.logger.log(Level.FINE, this.getClass().getName() + ".debug.startingLoadJar");
        if (!this.frameworkContext.isPortabilityMode()) {
            String as_config_dir = System.getProperty("com.sun.aas.installRoot") + File.separator + "config";
            this.classPath = PELaunch.getServerClassPath(as_config_dir, this.frameworkContext.getDomainDir());
        }
        this.initVerifierTmpDirs();
        String jarFile = this.frameworkContext.getJarFileName();
        OptionalPkgDependency.satisfyOptionalPackageDependencies();
        this.archivist = ArchivistFactory.getArchivistForArchive(new File(jarFile));
        if (this.archivist == null) {
            throw new RuntimeException(this.smh.getLocalString(this.getClass().getName() + ".notAJavaEEArchive", "[ {0} ] is not a valid Java EE archive", new Object[]{jarFile}));
        }
        this.explodeArchive(new File(jarFile));
        this.checkAndExplodeArchiveInWindowsPlatform(jarFile);
        Descriptor.setBoundsChecking(false);
        try {
            this.createApplicationDescriptor();
        }
        catch (IOException e) {
            this.log("Problem in creating application descriptor", e);
            throw e;
        }
        catch (SAXParseException se) {
            this.log("Problem in parsing the xml file. For " + se.getLocalizedMessage() + ", error at line " + se.getLineNumber() + ", column " + se.getColumnNumber(), se);
            IOException ioe = new IOException();
            ioe.initCause(se);
            throw ioe;
        }
        ((Descriptor)this.application).visit(new ApplicationValidator());
    }

    private void runVerifier(BaseVerifier baseVerifier) {
        try {
            baseVerifier.verify();
        }
        catch (Exception e) {
            this.log("Problem in running tests for :" + baseVerifier.getDescriptor().getName(), e);
        }
    }

    private void createApplicationDescriptor() throws IOException, SAXParseException {
        PluggableArchivistsHelper defaultArchivists = new PluggableArchivistsHelper();
        defaultArchivists.registerArchivist(new ApplicationArchivist());
        defaultArchivists.registerArchivist(new WebArchivist());
        defaultArchivists.registerArchivist(new EjbArchivist());
        defaultArchivists.registerArchivist(new ConnectorArchivist());
        defaultArchivists.registerArchivist(new AppClientArchivist());
        AbstractArchive abstractArchive = new FileArchiveFactory().openArchive(this.frameworkContext.getExplodedArchivePath());
        this.frameworkContext.setAbstractArchive(abstractArchive);
        this.archivist.setPluggableArchivists(defaultArchivists);
        this.archivist.setXMLValidationLevel("full");
        this.archivist.setRuntimeXMLValidation(true);
        this.archivist.setRuntimeXMLValidationLevel("full");
        this.archivist.setAnnotationProcessingRequested(true);
        this.archivist.setAnnotationErrorHandler(new VerifierErrorHandler(this.resultManager));
        String jarName = new File(abstractArchive.getArchiveUri()).getName();
        this.createApplicationDescriptor0(abstractArchive, jarName);
    }

    private void explodeArchive(File archiveFile) throws IOException {
        block5: {
            if (archiveFile.isDirectory()) {
                this.frameworkContext.setExplodedArchivePath(archiveFile.getAbsolutePath());
                return;
            }
            String appName = FileUtils.makeFriendlyFileNameNoExtension(archiveFile.getName());
            File appDir = new File(new File(this.explodeDir), appName);
            this.frameworkContext.setExplodedArchivePath(appDir.getAbsolutePath());
            try {
                ModuleType moduleType = this.archivist.getModuleType();
                if (ModuleType.EAR.equals(moduleType)) {
                    this.application = J2EEModuleExploder.explodeEar(archiveFile, appDir);
                    break block5;
                }
                if (ModuleType.EJB.equals(moduleType) || ModuleType.CAR.equals(moduleType) || ModuleType.RAR.equals(moduleType) || ModuleType.WAR.equals(moduleType)) {
                    J2EEModuleExploder.explodeJar(archiveFile, appDir);
                    break block5;
                }
                throw new FileNotFoundException("Deployment descriptor not found in " + archiveFile.getName());
            }
            catch (Exception e) {
                IOException ioe = new IOException(e.getMessage());
                ioe.initCause(e);
                throw ioe;
            }
        }
    }

    private void checkAndExplodeArchiveInWindowsPlatform(String jarFile) throws IOException {
        if (!System.getProperty("os.name").toLowerCase().startsWith("win")) {
            return;
        }
        if (!this.testFileLength(new File(this.explodeDir))) {
            File tempDir = new File(System.getProperty("home.drive"), "temp");
            if (!tempDir.exists()) {
                throw new IOException(this.smh.getLocalString(this.getClass().getName() + ".exception1", "Maximum Path Length exceeded. The application uses long file names which has exceeded maximum allowed path length in windows. Please shorten the file names and then continue. Not able to proceed further as [{0}] does not exist", new Object[]{tempDir.getAbsolutePath()}));
            }
            if (!FileUtil.deleteDir(new File(this.explodeDir))) {
                this.logger.log(Level.WARNING, this.getClass().getName() + ".explodedirdeleteerror", new Object[]{this.explodeDir});
            }
            this.explodeDir = tempDir.getAbsolutePath() + File.separator + "exploded" + this.dateFormatter.format(new Date());
            this.explodeArchive(new File(jarFile));
            if (!this.testFileLength(new File(this.explodeDir))) {
                throw new IOException(this.smh.getLocalString(this.getClass().getName() + ".exception", "Maximum Path Length exceeded. The application uses long file names which has exceeded maximum allowed path length in windows. Please shorten the file names and then continue."));
            }
        }
    }

    private boolean testFileLength(File file) throws IOException {
        if (file.getAbsolutePath().length() > 248) {
            this.logger.log(Level.WARNING, this.getClass().getName() + ".maxlength.exceeded", new Object[]{file.getAbsolutePath(), file.getAbsolutePath().length(), 248});
            return false;
        }
        if (file.getCanonicalPath().length() > 248) {
            this.logger.log(Level.WARNING, this.getClass().getName() + ".maxlength.exceeded", new Object[]{file.getCanonicalPath(), file.getCanonicalPath().length(), 248});
            return false;
        }
        if (!file.isDirectory()) {
            return true;
        }
        for (File file1 : file.listFiles()) {
            if (this.testFileLength(file1)) continue;
            return false;
        }
        return true;
    }

    private boolean initVerifierTmpDirs() throws IOException {
        File test = new File(this.explodeDir);
        if (!test.isDirectory() && !test.getAbsoluteFile().mkdirs()) {
            this.logger.log(Level.SEVERE, this.getClass().getName() + ".explodedircreateerror", test.getAbsolutePath());
            throw new IOException(this.smh.getLocalString(this.getClass().getName() + ".explodedircreateerror", test.getAbsolutePath()));
        }
        return true;
    }

    public void cleanup() {
        if (!this.isBackend && this.application != null) {
            ((JarClassLoader)this.application.getClassLoader()).done();
        }
        if (!this.isBackend && !new File(this.frameworkContext.getJarFileName()).isDirectory()) {
            FileUtil.deleteDir(new File(this.explodeDir));
        }
    }

    private void log(String message, Exception e) {
        if (message == null) {
            message = "";
        }
        LogRecord logRecord = new LogRecord(Level.SEVERE, message);
        logRecord.setThrown(e);
        this.frameworkContext.getResultManager().log(logRecord);
    }

    private ClassLoader getEarClassLoader(Application dummyApp) throws IOException {
        List classPath = EJBClassPathUtils.getApplicationClassPath(dummyApp, this.frameworkContext.getExplodedArchivePath());
        return this.createClassLoaderFromPath(classPath);
    }

    private ClassLoader getModuleClassLoader(ModuleType type) throws IOException {
        String moduleRoot = this.frameworkContext.getExplodedArchivePath();
        List classPath = EJBClassPathUtils.getModuleClassPath(type, moduleRoot, moduleRoot);
        return this.createClassLoaderFromPath(classPath);
    }

    private ClassLoader createClassLoaderFromPath(List<String> classPath) throws IOException {
        if (!this.frameworkContext.isPortabilityMode()) {
            classPath.addAll(0, this.classPath);
            this.frameworkContext.setClassPath(classPath);
        } else {
            String as_lib_root = System.getProperty("com.sun.aas.installRoot") + File.separator + "lib" + File.separator;
            classPath.add(as_lib_root + "javaee.jar");
        }
        JarClassLoader jcl = new JarClassLoader();
        for (String path : classPath) {
            jcl.appendURL(new File(path));
        }
        return jcl;
    }

    private void createApplicationDescriptor0(AbstractArchive abstractArchive, String jarName) throws IOException, SAXParseException {
        if (this.archivist.getModuleType() == ModuleType.EAR) {
            ClassLoader classLoader = this.getEarClassLoader(this.application);
            this.application.setClassLoader(classLoader);
            this.archivist.setClassLoader(classLoader);
            this.archivist.setHandleRuntimeInfo(!this.frameworkContext.isPortabilityMode());
            this.archivist.readPersistenceDeploymentDescriptors(abstractArchive, this.application);
            ((ApplicationArchivist)this.archivist).readModulesDescriptors(this.application, abstractArchive);
            if (!this.frameworkContext.isPortabilityMode()) {
                this.archivist.readRuntimeDeploymentDescriptor(abstractArchive, this.application);
            }
            this.application.setRegistrationName(jarName);
        } else {
            ClassLoader classLoader = this.getModuleClassLoader(this.archivist.getModuleType());
            this.archivist.setClassLoader(classLoader);
            this.application = ApplicationArchivist.openArchive(jarName, this.archivist, abstractArchive, !this.frameworkContext.isPortabilityMode());
            this.application.setClassLoader(classLoader);
        }
    }
}

