/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.deploy.shared.AbstractArchive;
import com.sun.enterprise.logging.LogDomains;
import com.sun.enterprise.tools.verifier.FrameworkContext;
import com.sun.enterprise.tools.verifier.Initializer;
import com.sun.enterprise.tools.verifier.ReportHandler;
import com.sun.enterprise.tools.verifier.ResultManager;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.VerificationHandler;
import com.sun.enterprise.tools.verifier.gui.MainFrame;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Verifier {
    private static boolean debug = false;
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.tools.avk.tools.verifier");
    private FrameworkContext frameworkContext = null;

    public Verifier(String[] args) {
        StringManagerHelper.setLocalStringsManager(this.getClass());
        this.frameworkContext = new Initializer(args).getFrameworkContext();
    }

    public Verifier() {
        StringManagerHelper.setLocalStringsManager(this.getClass());
        this.frameworkContext = new FrameworkContext();
        this.frameworkContext.setUseTimeStamp(true);
        this.frameworkContext.setOutputDirName(System.getProperty("com.sun.aas.instanceRoot") + File.separator + "logs" + File.separator + "verifier-results");
    }

    public static void main(String[] args) throws IOException {
        Verifier verifier = new Verifier(args);
        if (verifier.frameworkContext.isUsingGui()) {
            MainFrame mf = new MainFrame(verifier.frameworkContext.getJarFileName(), true, verifier);
            mf.setSize(800, 600);
            mf.setVisible(true);
        } else {
            LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
            try {
                verifier.verify();
            }
            catch (Exception e) {
                LogRecord logRecord = new LogRecord(Level.SEVERE, smh.getLocalString(verifier.getClass().getName() + ".verifyFailed", "Could not verify successfully."));
                logRecord.setThrown(e);
                verifier.frameworkContext.getResultManager().log(logRecord);
            }
            verifier.generateReports();
            int failedCount = verifier.frameworkContext.getResultManager().getFailedCount() + verifier.frameworkContext.getResultManager().getErrorCount();
            if (failedCount != 0) {
                System.exit(failedCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultManager verify() throws IOException {
        ResultManager resultManager;
        VerificationHandler verificationHandler = new VerificationHandler(this.frameworkContext);
        try {
            resultManager = verificationHandler.verifyArchive();
        }
        finally {
            verificationHandler.cleanup();
        }
        return resultManager;
    }

    public ResultManager verify(String jarFile) throws IOException {
        this.frameworkContext.setJarFileName(jarFile);
        return this.verify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int verify(Application application, AbstractArchive abstractArchive, List<String> classPath, File jspOutDir) throws IOException {
        boolean originalBoundsChecking = Descriptor.isBoundsChecking();
        Descriptor.setBoundsChecking(false);
        ResultManager rmanager = null;
        this.frameworkContext.setJspOutDir(jspOutDir);
        this.frameworkContext.setIsBackend(true);
        VerificationHandler verificationHandler = null;
        try {
            if (application == null) {
                this.frameworkContext.setJarFileName(abstractArchive.getArchiveUri());
                verificationHandler = new VerificationHandler(this.frameworkContext);
            } else {
                verificationHandler = new VerificationHandler(this.frameworkContext, application, abstractArchive, classPath);
            }
            rmanager = verificationHandler.verifyArchive();
        }
        catch (Exception e) {
            LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
            LogRecord logRecord = new LogRecord(Level.SEVERE, smh.getLocalString(this.getClass().getName() + ".verifyFailed", "Could not verify successfully."));
            logRecord.setThrown(e);
            this.frameworkContext.getResultManager().log(logRecord);
        }
        finally {
            Descriptor.setBoundsChecking(originalBoundsChecking);
            if (verificationHandler != null) {
                verificationHandler.cleanup();
            }
        }
        this.generateReports();
        return rmanager.getErrorCount() + rmanager.getFailedCount();
    }

    public void generateReports() throws IOException {
        new ReportHandler(this.frameworkContext).generateAllReports();
    }

    public static boolean isDebug() {
        return debug;
    }

    public static void debug(Throwable t) {
        logger.log(Level.FINEST, "Exception occurred", t);
    }
}

