/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.tools.verifier.tests.ejb.MethodUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.ejb.TimedObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerTransactionStyle3
extends EjbTest
implements EjbCheck {
    private Result result = null;
    private ComponentNameConstructor compName = null;
    private EjbDescriptor descriptor = null;
    private Method[] homeMethods = null;
    private Method[] localHomeMethods = null;
    private Method[] remoteMethods = null;
    private Method[] localMethods = null;
    private Method[] serviceMethods = null;

    @Override
    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        this.compName = this.getVerifierContext().getComponentNameConstructor();
        this.descriptor = descriptor;
        if (!(descriptor instanceof EjbSessionDescriptor) && !(descriptor instanceof EjbEntityDescriptor)) {
            this.result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.homeintf.HomeMethodTest.notApplicable1", "Test apply only to session or entity beans."));
            return this.result;
        }
        if (!descriptor.getMethodContainerTransactions().isEmpty()) {
            this.commonToAllInterfaces();
        }
        if (this.result.getStatus() != 1) {
            this.addGoodDetails(this.result, this.compName);
            this.result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "Valid container transaction methods."));
        }
        return this.result;
    }

    private void commonToAllInterfaces() {
        boolean isTimedObject = false;
        try {
            ClassLoader jcl = this.getVerifierContext().getClassLoader();
            Class<?> beanClass = Class.forName(this.descriptor.getEjbClassName(), false, jcl);
            isTimedObject = TimedObject.class.isAssignableFrom(beanClass);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        this.initializeMethods();
        Enumeration ee = this.descriptor.getMethodContainerTransactions().keys();
        while (ee.hasMoreElements()) {
            String ejbClassSymbol;
            Set<Method> methods;
            String[] params;
            MethodDescriptor methodDescriptor = (MethodDescriptor)ee.nextElement();
            if (methodDescriptor.getName().equals(MethodDescriptor.ALL_EJB_METHODS) || methodDescriptor.getParameterClassNames() == null || isTimedObject && MethodDescriptor.EJB_BEAN.equals(methodDescriptor.getEjbClassSymbol()) && methodDescriptor.getName().equals("ejbTimeout") && (params = methodDescriptor.getJavaParameterClassNames()).length == 1 && params[0].trim().equals("javax.ejb.Timer") || this.isMethodContained(methods = this.getAllInterfaceMethods(methodDescriptor), methodDescriptor)) continue;
            String intf = ejbClassSymbol = methodDescriptor.getEjbClassSymbol();
            if (ejbClassSymbol == null) {
                intf = smh.getLocalString(this.getClass().getName() + ".msg", "any of bean");
            } else if (ejbClassSymbol.equals(MethodDescriptor.EJB_REMOTE)) {
                intf = "Remote or RemoteBusiness";
            } else if (ejbClassSymbol.equals(MethodDescriptor.EJB_LOCAL)) {
                intf = "Local or LocalBusiness";
            }
            this.addErrorDetails(this.result, this.compName);
            this.result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: Container Transaction method name [ {0} ] not defined in [ {1} ] interface(s).", new Object[]{methodDescriptor.getName(), intf}));
        }
    }

    private void initializeMethods() {
        this.homeMethods = this.getMethods(this.descriptor.getHomeClassName());
        this.localHomeMethods = this.getMethods(this.descriptor.getLocalHomeClassName());
        this.remoteMethods = this.getMethods(this.descriptor.getRemoteClassName());
        this.remoteMethods = this.getBusinessMethods(this.descriptor.getRemoteBusinessClassNames(), this.remoteMethods);
        this.localMethods = this.getMethods(this.descriptor.getLocalClassName());
        this.localMethods = this.getBusinessMethods(this.descriptor.getLocalBusinessClassNames(), this.localMethods);
        this.serviceMethods = this.getMethods(this.descriptor.getWebServiceEndpointInterfaceName());
    }

    private Set<Method> getAllInterfaceMethods(MethodDescriptor methodDescriptor) {
        HashSet<Method> methods = new HashSet<Method>();
        String methodIntf = methodDescriptor.getEjbClassSymbol();
        if (methodIntf == null) {
            methods.addAll(Arrays.asList(this.homeMethods));
            methods.addAll(Arrays.asList(this.localHomeMethods));
            methods.addAll(Arrays.asList(this.remoteMethods));
            methods.addAll(Arrays.asList(this.localMethods));
            methods.addAll(Arrays.asList(this.serviceMethods));
        } else if (methodIntf.equals(MethodDescriptor.EJB_HOME)) {
            methods.addAll(Arrays.asList(this.homeMethods));
        } else if (methodIntf.equals(MethodDescriptor.EJB_LOCALHOME)) {
            methods.addAll(Arrays.asList(this.localHomeMethods));
        } else if (methodIntf.equals(MethodDescriptor.EJB_REMOTE)) {
            methods.addAll(Arrays.asList(this.remoteMethods));
        } else if (methodIntf.equals(MethodDescriptor.EJB_LOCAL)) {
            methods.addAll(Arrays.asList(this.localMethods));
        } else if (methodIntf.equals(MethodDescriptor.EJB_WEB_SERVICE)) {
            methods.addAll(Arrays.asList(this.serviceMethods));
        }
        return methods;
    }

    private Method[] getMethods(String clsName) {
        if (clsName == null) {
            return new Method[0];
        }
        ClassLoader jcl = this.getVerifierContext().getClassLoader();
        try {
            Class<?> cls = Class.forName(clsName, false, jcl);
            return cls.getMethods();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return new Method[0];
        }
    }

    private Method[] getBusinessMethods(Set<String> classNames, Method[] intfMethods) {
        if (!classNames.isEmpty()) {
            ArrayList<Method> methods = new ArrayList<Method>();
            for (String clsName : classNames) {
                Method[] methodArray = this.getMethods(clsName);
                if (methodArray == null) continue;
                methods.addAll(Arrays.asList(methodArray));
            }
            if (intfMethods != null) {
                methods.addAll(Arrays.asList(intfMethods));
            }
            return methods.toArray(new Method[0]);
        }
        return intfMethods;
    }

    private boolean isMethodContained(Set<Method> methods, MethodDescriptor methodDescriptor) {
        boolean foundIt = false;
        for (Method method : methods) {
            if (!method.getName().equals(methodDescriptor.getName()) || !MethodUtils.stringArrayEquals(methodDescriptor.getParameterClassNames(), new MethodDescriptor(method).getParameterClassNames())) continue;
            foundIt = true;
            break;
        }
        return foundIt;
    }
}

