/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.runtime.resource;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.ResourcePrincipal;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.runtime.resource.ASEjbResRef;
import java.util.Set;

public class ASEjbRRefDefResPrincipal
extends ASEjbResRef {
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        boolean oneFailed = false;
        try {
            Set<ResourceReferenceDescriptor> resRef = descriptor.getResourceReferenceDescriptors();
            if (!resRef.isEmpty()) {
                for (ResourceReferenceDescriptor resDesc : resRef) {
                    String refName = resDesc.getName();
                    String refJndiName = resDesc.getJndiName();
                    ResourcePrincipal resPrinci = resDesc.getResourcePrincipal();
                    if (resPrinci == null) {
                        try {
                            resDesc = descriptor.getResourceReferenceByName(refName);
                            String resAuth = resDesc.getAuthorization();
                            if (resAuth.equals(ResourceReferenceDescriptor.APPLICATION_AUTHORIZATION)) {
                                this.addErrorDetails(result, compName);
                                result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "FAILED [AS-EJB resource-ref] : res-auth for res-ref-name {0} is defined as Application.Therefore the default-resource-principal should be supplied with valid properties", new Object[]{refName}));
                                continue;
                            }
                            this.addNaDetails(result, compName);
                            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "NOT APPLICABLE [AS-EJB resource-ref] : default-resource-principal Element not defined"));
                        }
                        catch (IllegalArgumentException iaex) {
                            this.addErrorDetails(result, compName);
                            result.failed(smh.getLocalString(this.getClass().getName() + ".failed2", "FAILED [AS-EJB resource-ref] : res-ref-name {0} is not defined in the ejb-jar.xml", new Object[]{refName}));
                        }
                        continue;
                    }
                    String name = resPrinci.getName();
                    if (name == null || name.length() == 0) {
                        oneFailed = true;
                        this.addErrorDetails(result, compName);
                        result.failed(smh.getLocalString(this.getClass().getName() + ".failed3", "FAILED [AS-EJB default-resource-principal] :  name cannot be an empty string"));
                    } else {
                        this.addGoodDetails(result, compName);
                        result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "PASSED [AS-EJB default-resource-principal] : name is {0}", new Object[]{name}));
                    }
                    String password = resPrinci.getPassword();
                    if (password == null || password.length() == 0) {
                        this.addWarningDetails(result, compName);
                        result.warning(smh.getLocalString(this.getClass().getName() + ".warning1", "WARNING [AS-EJB default-resource-principal] : password is an empty string"));
                    } else {
                        this.addGoodDetails(result, compName);
                        result.passed(smh.getLocalString(this.getClass().getName() + ".passed1", "PASSED [AS-EJB default-resource-principal] : password is  {0}", new Object[]{password}));
                    }
                    if (!oneFailed) continue;
                    result.setStatus(1);
                }
            } else {
                this.addNaDetails(result, compName);
                result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "{0} Does not define any resource-ref Elements"));
            }
        }
        catch (Exception ex) {
            this.addErrorDetails(result, compName);
            result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".notRun", "NOT RUN [AS-EJB] : Could not create the descriptor object"));
        }
        return result;
    }
}

