/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.enterprise.corba.ee.internal.util.LogWrap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;

public class MonitorTask
extends TimerTask {
    private static boolean initialized = false;
    private static boolean needORBMonitoring = false;
    private static boolean needEJBMonitoring = false;
    private static boolean needJDBCMonitoring = false;
    private static ArrayList monitorableList = null;
    private static long schedPeriod = 180000L;
    private static Timer timer;

    private static synchronized boolean isMonitoring() {
        if (!initialized) {
            try {
                String str1 = System.getProperties().getProperty("MONITOR_ORB");
                String str2 = System.getProperties().getProperty("MONITOR_EJB");
                String str3 = System.getProperties().getProperty("MONITOR_JDBC");
                String strm = System.getProperties().getProperty("MONITOR_TIME_PERIOD_SECONDS");
                if (null != str1 && (str1.startsWith("true") || str1.startsWith("TRUE"))) {
                    needORBMonitoring = true;
                }
                if (null != str2 && (str2.startsWith("true") || str2.startsWith("TRUE"))) {
                    needEJBMonitoring = true;
                }
                if (null != str3 && (str3.startsWith("true") || str3.startsWith("TRUE"))) {
                    needJDBCMonitoring = true;
                }
                if ((needORBMonitoring || needEJBMonitoring || needJDBCMonitoring) && null != strm) {
                    schedPeriod = 1000L * Long.parseLong(strm);
                }
            }
            catch (Exception e) {
                LogWrap.logger.log(Level.FINE, "MINOR: Unable to start a performance monitoring task > " + e);
            }
            if (needORBMonitoring || needEJBMonitoring || needJDBCMonitoring) {
                monitorableList = new ArrayList();
                timer = new Timer();
                timer.schedule((TimerTask)new MonitorTask(), schedPeriod, schedPeriod);
                LogWrap.logger.log(Level.SEVERE, "Starting the MonitorTask every " + schedPeriod + " milliseconds.");
            }
            initialized = true;
        }
        return needORBMonitoring || needEJBMonitoring || needJDBCMonitoring;
    }

    public static void addORBMonitorable(Object monitorable) {
        if (MonitorTask.isMonitoring() && needORBMonitoring) {
            monitorableList.add(monitorable);
        }
    }

    public static void addEJBMonitorable(Object monitorable) {
        if (MonitorTask.isMonitoring() && needEJBMonitoring) {
            monitorableList.add(monitorable);
        }
    }

    public static void addJDBCMonitorable(Object monitorable) {
        if (MonitorTask.isMonitoring() && needJDBCMonitoring) {
            monitorableList.add(monitorable);
        }
    }

    public static ArrayList getMonitorableList() {
        return monitorableList;
    }

    public void run() {
        StringBuffer sb = new StringBuffer();
        try {
            boolean first = true;
            sb.append("MONITORING : ");
            Iterator iter = MonitorTask.getMonitorableList().iterator();
            while (iter.hasNext()) {
                if (!first) {
                    sb.append(", ");
                } else {
                    first = false;
                }
                sb.append(iter.next().toString());
            }
            LogWrap.logger.log(Level.SEVERE, sb.toString());
        }
        catch (Exception e) {
            LogWrap.logger.log(Level.FINE, "MonitorTask received an exception > " + e);
        }
    }

    protected Timer getTimer() {
        return timer;
    }
}

