/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.enterprise.util.UniqueValueBlock;
import com.sun.enterprise.util.UniqueValueGenerator;
import com.sun.enterprise.util.UniqueValueGeneratorBackend;
import com.sun.enterprise.util.UniqueValueGeneratorException;
import com.sun.logging.LogDomains;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;

class SimpleUniqueValueGenerator
implements UniqueValueGenerator {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.util");
    private static Hashtable contextBlocks_;
    private static UniqueValueGeneratorBackend generatorBackend_;
    private static String generatorBackendId_;
    private String context_;

    SimpleUniqueValueGenerator(String context) {
        this.context_ = context;
    }

    private static synchronized UniqueValueGeneratorBackend getBackendGenerator() throws Exception {
        if (generatorBackend_ == null) {
            InitialContext jndiContext = new InitialContext();
            generatorBackend_ = (UniqueValueGeneratorBackend)jndiContext.lookup("J2EE_UNIQUE_VALUE_GEN");
        }
        return generatorBackend_;
    }

    private static synchronized String getGeneratorBackendId() throws UniqueValueGeneratorException {
        if (generatorBackendId_ == null) {
            try {
                UniqueValueGeneratorBackend backend = SimpleUniqueValueGenerator.getBackendGenerator();
                generatorBackendId_ = backend.getGeneratorId();
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, "enterprise_util.excep_suidgen_getgenbackendid", e);
                throw new UniqueValueGeneratorException(e.getMessage());
            }
        }
        return generatorBackendId_;
    }

    private static synchronized long nextNumberInternal(String context) throws UniqueValueGeneratorException {
        UniqueValueBlock valueBlock = null;
        try {
            UniqueValueGeneratorBackend generatorBackend = SimpleUniqueValueGenerator.getBackendGenerator();
            valueBlock = (UniqueValueBlock)contextBlocks_.get(context);
            if (valueBlock == null || !valueBlock.hasNext()) {
                valueBlock = generatorBackend.getNextValueBlock(context);
                contextBlocks_.put(context, valueBlock);
            }
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "enterprise_util.excep_suidgen_nextnuminternal", e);
            throw new UniqueValueGeneratorException(e.getMessage());
        }
        return valueBlock.next();
    }

    public long nextNumber() throws UniqueValueGeneratorException {
        return SimpleUniqueValueGenerator.nextNumberInternal(this.getContext());
    }

    public String nextId() throws UniqueValueGeneratorException {
        return SimpleUniqueValueGenerator.getGeneratorBackendId() + "_" + this.nextNumber();
    }

    public String getContext() {
        return this.context_;
    }

    static {
        generatorBackendId_ = null;
        generatorBackend_ = null;
        contextBlocks_ = new Hashtable();
    }
}

