/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.scheduler;

import com.sun.enterprise.util.collection.DListNode;
import com.sun.enterprise.util.scheduler.PeriodicallyServicable;
import com.sun.enterprise.util.scheduler.TaskData;

public class TimedTaskList {
    private DListNode first = new DListNode(null);
    private DListNode last;
    private int size = 0;

    protected TimedTaskList() {
        this.first.next = this.last = new DListNode(null);
        this.last.prev = this.first;
        this.last.next = null;
        this.first.prev = null;
    }

    protected int size() {
        return this.size;
    }

    protected TaskData getFirstTask() {
        DListNode node = this.first;
        node = node.next;
        if (null != node.next) {
            node.delink();
            --this.size;
            return (TaskData)node.object;
        }
        return null;
    }

    protected boolean addTask(PeriodicallyServicable taskObj, int startingTime, long currentTime) {
        TaskData task = new TaskData();
        task.obj = taskObj;
        task.abs_execute_time = currentTime + (long)startingTime - taskObj.getFrequency();
        return this.insertTask(task);
    }

    protected boolean insertTask(TaskData task) {
        task.abs_execute_time += task.obj.getFrequency();
        DListNode addingNode = new DListNode(task);
        DListNode node = this.first;
        ++this.size;
        for (int i = 0; i < this.size - 1; ++i) {
            node = node.next;
            long nodeTime = ((TaskData)node.object).abs_execute_time;
            if (nodeTime <= task.abs_execute_time) continue;
            node.insertBefore(addingNode);
            return true;
        }
        node.insertAfter(addingNode);
        return true;
    }

    protected boolean removeTask(PeriodicallyServicable obj) {
        DListNode node = this.first;
        for (int i = 0; i < this.size; ++i) {
            node = node.next;
            PeriodicallyServicable nodeObj = ((TaskData)node.object).obj;
            if (!nodeObj.equals(obj)) continue;
            node.delink();
            --this.size;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append(" [TimedTaskList: ");
        sb.append(this.size + " elements: ");
        DListNode node = this.first;
        while (null != node.next && null != node.next.object) {
            node = node.next;
            sb.append((int)(((TaskData)node.object).abs_execute_time / 1000L));
            sb.append(",");
        }
        sb.append("] ");
        return sb.toString();
    }
}

