/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.Switch;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.J2eeApplication;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.WebModule;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.util.DOLLoadingContextFactory;
import com.sun.enterprise.instance.WebModulesManager;
import com.sun.enterprise.server.ApplicationRegistry;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.web.MimeMap;
import com.sun.enterprise.web.VirtualServerPipeline;
import com.sun.enterprise.web.WebModuleConfig;
import com.sun.enterprise.web.stats.PWCRequestStatsImpl;
import com.sun.logging.LogDomains;
import java.io.File;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.core.StandardHost;

public class VirtualServer
extends StandardHost {
    private String _id = null;
    protected static Logger _logger = null;
    protected static ResourceBundle _rb = null;
    protected boolean _debug = false;
    private static final String _info = "com.sun.enterprise.web.VirtualServer/1.0";
    private com.sun.enterprise.config.serverbeans.VirtualServer vsBean;
    private MimeMap mimeMap;
    private boolean allowLinking = true;
    private String defaultWebXmlLocation;
    private String[] cacheControls;
    private boolean isActive;
    private PWCRequestStatsImpl pwcRequestStatsImpl;

    public VirtualServer() {
        this.setPipeline(new VirtualServerPipeline(this));
        if (_logger == null) {
            _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
            _rb = _logger.getResourceBundle();
        }
        this._debug = _logger.isLoggable(Level.FINE);
    }

    public String getID() {
        return this._id;
    }

    public void setID(String id) {
        this._id = id;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setIsActive(boolean isActive) {
        this.isActive = isActive;
    }

    public String getDefaultWebXmlLocation() {
        return this.defaultWebXmlLocation;
    }

    public void setDefaultWebXmlLocation(String defaultWebXmlLocation) {
        this.defaultWebXmlLocation = defaultWebXmlLocation;
    }

    public boolean getAllowLinking() {
        return this.allowLinking;
    }

    public void setAllowLinking(boolean allowLinking) {
        this.allowLinking = allowLinking;
    }

    public com.sun.enterprise.config.serverbeans.VirtualServer getBean() {
        return this.vsBean;
    }

    public void setBean(com.sun.enterprise.config.serverbeans.VirtualServer vsBean) {
        this.vsBean = vsBean;
    }

    public MimeMap getMimeMap() {
        return this.mimeMap;
    }

    public void setMimeMap(MimeMap mimeMap) {
        this.mimeMap = mimeMap;
    }

    public String[] getCacheControls() {
        return this.cacheControls;
    }

    public void setCacheControls(String[] cacheControls) {
        this.cacheControls = cacheControls;
    }

    public String getInfo() {
        return _info;
    }

    public synchronized void stop() throws LifecycleException {
        Switch sw = Switch.getSwitch();
        Container[] children = this.findChildren();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                sw.removeDescriptorFor(children[i]);
            }
        }
        super.stop();
    }

    protected List getWebModules(Server serverBean, String modulesRoot) {
        WebModule[] wmBeans;
        Vector<WebModuleConfig> modules = new Vector<WebModuleConfig>();
        Applications appsBean = null;
        try {
            appsBean = ServerBeansFactory.getApplicationsBean(serverBean.getConfigContext());
        }
        catch (ConfigException e) {
            String msg = _rb.getString("vs.appsConfigError");
            Object[] params = new Object[]{this.getID()};
            msg = MessageFormat.format(msg, params);
            _logger.log(Level.SEVERE, msg, e);
        }
        if (appsBean != null && (wmBeans = appsBean.getWebModule()) != null && wmBeans.length > 0) {
            for (int i = 0; i < wmBeans.length; ++i) {
                WebModule wm = wmBeans[i];
                if (this.isActive(wm)) {
                    WebModuleConfig wmInfo;
                    ApplicationRef ref = serverBean.getApplicationRefByRef(wm.getName());
                    if (ref == null) continue;
                    String location = wm.getLocation();
                    File moduleBase = new File(location);
                    if (!moduleBase.isAbsolute()) {
                        location = modulesRoot + File.separator + location;
                        wm.setLocation(location);
                    }
                    if ((wmInfo = this.loadWebModuleConfig(wm)) == null) continue;
                    modules.add(wmInfo);
                    continue;
                }
                if (!this._debug) continue;
                _logger.finer("Web Module [" + wm.getName() + "] is not applicable for virtual " + " server [" + this.getID() + "]");
            }
        }
        return modules;
    }

    protected WebModuleConfig getUserDefaultWebModuleConfig(Server serverBean) {
        Object[] params;
        WebModuleConfig wmInfo = null;
        Applications appsBean = null;
        try {
            appsBean = ServerBeansFactory.getApplicationsBean(serverBean.getConfigContext());
        }
        catch (ConfigException e) {
            String msg = _rb.getString("vs.appsConfigError");
            params = new Object[]{this.getID()};
            msg = MessageFormat.format(msg, params);
            _logger.log(Level.SEVERE, msg, e);
        }
        String wmID = this.getDefaultWebModuleID();
        if (wmID != null) {
            WebModule wm;
            wmInfo = this.findWebModuleInJ2eeApp(appsBean, wmID);
            if (wmInfo == null) {
                wm = appsBean.getWebModuleByName(wmID);
                if (wm != null) {
                    if (this.isActive(wm, false)) {
                        WebModule wmCopy = new WebModule();
                        wmCopy.setName(wm.getName());
                        wmCopy.setLocation(wm.getLocation());
                        wmCopy.setEnabled(wm.isEnabled());
                        wmCopy.setContextRoot(wm.getContextRoot());
                        wmInfo = this.loadWebModuleConfig(wmCopy);
                        wmInfo.setVirtualServers(this._id);
                        wmCopy.setName("__default-" + wmCopy.getName());
                        wmCopy.setContextRoot("");
                        wmCopy.setObjectType(wm.getObjectType());
                    } else {
                        params = new Object[]{wmID, this.getID()};
                        _logger.log(Level.SEVERE, "vs.defaultWebModuleDisabled", params);
                        wm = null;
                    }
                }
            } else {
                wm = wmInfo.getBean();
                wmInfo.setVirtualServers(this._id);
                wm.setName("__default-" + wm.getName());
                wm.setContextRoot("");
            }
            if (wmInfo == null) {
                Object[] params2 = new Object[]{wmID, this.getID()};
                _logger.log(Level.SEVERE, "vs.defaultWebModuleNotFound", params2);
            }
        }
        return wmInfo;
    }

    protected WebModuleConfig createSystemDefaultWebModuleIfNecessary() {
        WebModuleConfig wmInfo = null;
        String docroot = this.getAppBase();
        if (this.findChild("") == null && docroot != null) {
            wmInfo = new WebModuleConfig();
            WebModule wm = new WebModule();
            wm.setName("__default-web-module");
            wm.setContextRoot("");
            wm.setLocation(docroot);
            wmInfo.setBean(wm);
            wmInfo.setDescriptor(DOLLoadingContextFactory.getDefaultWebBundleDescriptor());
            WebBundleDescriptor wbd = wmInfo.getDescriptor();
            if (wbd.getApplication() == null) {
                Application application = new Application();
                application.setVirtual(true);
                application.setName("__default-web-module");
                wbd.setApplication(application);
            }
        }
        return wmInfo;
    }

    protected WebModuleConfig loadWebModuleConfig(WebModule wm) {
        WebModuleConfig wmInfo = new WebModuleConfig();
        wmInfo.setBean(wm);
        String wmID = wm.getName();
        String location = wm.getLocation();
        try {
            WebModulesManager webModulesManager = new WebModulesManager(ApplicationServer.getServerContext().getInstanceEnvironment());
            Application app = webModulesManager.getDescriptor(wmID, location);
            WebBundleDescriptor wbd = (WebBundleDescriptor)app.getStandaloneBundleDescriptor();
            wmInfo.setDescriptor(wbd);
        }
        catch (ConfigException ce) {
            wmInfo = null;
            String msg = _rb.getString("vs.moduleConfigError");
            Object[] params = new Object[]{wmID, this.getID()};
            msg = MessageFormat.format(msg, params);
            _logger.log(Level.SEVERE, msg, ce);
        }
        return wmInfo;
    }

    private boolean isActive(WebModule wm) {
        return this.isActive(wm, true);
    }

    protected boolean isActive(WebModule wm, boolean matchVSID) {
        String vsID = this.getID();
        boolean active = vsID != null && vsID.length() > 0;
        if (active &= wm != null) {
            List vsList;
            active &= wm.isEnabled();
            String vsIDs = this.getVirtualServers(wm.getName());
            if (this.getID().equals("__asadmin") && matchVSID && (vsIDs == null || vsIDs.length() == 0)) {
                return false;
            }
            active = vsIDs != null && matchVSID ? ((vsList = StringUtils.parseStringList(vsIDs, " ,")) != null ? (active &= vsList.contains(vsID.trim())) : (active &= true)) : (active &= true);
        }
        return active;
    }

    protected String getDefaultWebModuleID() {
        String wmID = null;
        if (this.vsBean != null) {
            wmID = this.vsBean.getDefaultWebModule();
            if (wmID != null && this._debug) {
                Object[] params = new Object[]{wmID, this._id};
                _logger.log(Level.FINE, "vs.defaultWebModule", params);
            }
        } else {
            _logger.log(Level.SEVERE, "vs.configError", this._id);
        }
        return wmID;
    }

    protected WebModuleConfig findWebModuleInJ2eeApp(Applications appsBean, String id) {
        WebModuleConfig wmInfo = null;
        int length = id.length();
        int separatorIndex = id.indexOf(":");
        if (separatorIndex == -1) {
            separatorIndex = id.indexOf(35);
        }
        if (separatorIndex != -1) {
            String appID = id.substring(0, separatorIndex);
            String moduleID = id.substring(separatorIndex + 1);
            J2eeApplication j2eeApp = appsBean.getJ2eeApplicationByName(appID);
            if (j2eeApp != null && j2eeApp.isEnabled()) {
                Application appDesc;
                String location = j2eeApp.getLocation();
                String moduleDir = FileUtils.makeFriendlyFilename(moduleID);
                ApplicationRegistry registry = ApplicationRegistry.getInstance();
                ClassLoader appLoader = registry.getClassLoaderForApplication(appID);
                if (appLoader != null && (appDesc = registry.getApplication(appLoader)) != null) {
                    Set wbds = appDesc.getWebBundleDescriptors();
                    WebBundleDescriptor wbd2 = null;
                    for (WebBundleDescriptor wbd2 : wbds) {
                        String webUri = wbd2.getModuleDescriptor().getArchiveUri();
                        if (!moduleID.equals(webUri)) continue;
                        StringBuffer dir = new StringBuffer(location);
                        dir.append(File.separator);
                        dir.append(moduleDir);
                        WebModule wm = new WebModule();
                        wm.setName(moduleID);
                        wm.setContextRoot(wbd2.getContextRoot());
                        wm.setLocation(dir.toString());
                        wm.setEnabled(true);
                        String vsList = this.getVirtualServers(j2eeApp.getName());
                        wmInfo = new WebModuleConfig();
                        wmInfo.setBean(wm);
                        wmInfo.setDescriptor(wbd2);
                        wmInfo.setParentLoader(appLoader);
                        wmInfo.setVirtualServers(vsList);
                        break;
                    }
                }
            } else {
                Object[] params = new Object[]{id, this.getID()};
                _logger.log(Level.SEVERE, "vs.defaultWebModuleDisabled", params);
            }
        }
        return wmInfo;
    }

    private String getVirtualServers(String appName) {
        String ret = null;
        try {
            ConfigContext ctx = ApplicationServer.getServerContext().getConfigContext();
            ret = ServerBeansFactory.getVirtualServersByAppName(ctx, appName);
        }
        catch (ConfigException ce) {
            _logger.log(Level.FINE, "Cannot get virtual server for " + appName, ce);
        }
        return ret;
    }

    public void clearAliases() {
        this.aliases = new String[0];
    }

    void setIsDisabled(boolean isDisabled) {
        ((VirtualServerPipeline)this.getPipeline()).setIsDisabled(isDisabled);
    }

    void setIsOff(boolean isOff) {
        ((VirtualServerPipeline)this.getPipeline()).setIsOff(isOff);
    }

    void addRedirect(String from, String url, String urlPrefix, boolean escape) {
        ((VirtualServerPipeline)this.getPipeline()).addRedirect(from, url, urlPrefix, escape);
    }

    public void setPWCRequestStatsImpl(PWCRequestStatsImpl pwcRequestStatsImpl) {
        this.pwcRequestStatsImpl = pwcRequestStatsImpl;
    }

    public PWCRequestStatsImpl getPWCRequestStatsImpl() {
        return this.pwcRequestStatsImpl;
    }
}

