/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly;

import com.sun.enterprise.web.connector.grizzly.SelectorThread;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.logging.Level;

public class SelectorReadThread
extends SelectorThread {
    ArrayList<SocketChannel> channels = new ArrayList();
    public int countName;

    protected void initPipeline() {
        this.initKeepAlivePipeline();
        this.processorPipeline = this.newPipeline(this.maxProcessorWorkerThreads, this.minWorkerThreads, "http-SelectorRead-" + this.countName + "-", this.port, 10);
        this.processorPipeline.initPipeline();
        if (this.maxReadWorkerThreads > 0) {
            this.readPipeline = this.newPipeline(this.maxReadWorkerThreads, this.minWorkerThreads, "read", this.port, 5);
            this.readPipeline.initPipeline();
        } else {
            this.readPipeline = this.processorPipeline;
        }
    }

    public synchronized void addChannel(SocketChannel channel) throws IOException, ClosedChannelException {
        this.channels.add(channel);
        this.selector.wakeup();
    }

    private synchronized void registerNewChannels() throws IOException {
        int size = this.channels.size();
        for (int i = 0; i < size; ++i) {
            SocketChannel sc = this.channels.get(i);
            sc.configureBlocking(false);
            try {
                SelectionKey readKey = sc.register(this.selector, 1);
                this.setSocketOptions(((SocketChannel)readKey.channel()).socket());
                continue;
            }
            catch (ClosedChannelException cce) {
                // empty catch block
            }
        }
        this.channels.clear();
    }

    public void initEndpoint() throws IOException, InstantiationException {
        this.setName("SelectorReaderThread-" + this.port);
        this.initAlgorithm();
        this.initPipeline();
        this.initProcessorTask(this.maxProcessorWorkerThreads);
        this.initReadTask(this.minReadQueueLength);
    }

    public void startEndpoint() throws IOException, InstantiationException {
        this.running = true;
        if (this.readPipeline != null) {
            this.readPipeline.startPipeline();
        }
        while (this.running) {
            try {
                if (this.selector == null) {
                    this.selector = Selector.open();
                }
                this.registerNewChannels();
                this.doSelect();
            }
            catch (Throwable t) {
                logger.log(Level.FINE, "selectorThread.errorOnRequest", t);
            }
        }
    }

    public int getCurrentBusyProcessorThreads() {
        return this.processorPipeline.getCurrentThreadsBusy();
    }
}

