/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice;

import com.sun.ejb.Container;
import com.sun.ejb.Invocation;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.ServiceRefPortInfo;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.runtime.common.MessageSecurityBindingDescriptor;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.jauth.AuthException;
import com.sun.enterprise.security.jauth.BaseAuthConfig;
import com.sun.enterprise.security.jauth.ClientAuthConfig;
import com.sun.enterprise.security.jauth.ClientAuthContext;
import com.sun.enterprise.security.jauth.ServerAuthConfig;
import com.sun.enterprise.security.jauth.ServerAuthContext;
import com.sun.enterprise.security.wss.WebServiceSecurity;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.webservice.HandlerResolverImpl;
import com.sun.enterprise.webservice.WSSCallbackHandler;
import com.sun.enterprise.webservice.WsUtil;
import com.sun.enterprise.webservice.monitoring.JAXWSEndpointImpl;
import com.sun.logging.LogDomains;
import com.sun.xml.ws.handler.SHDSOAPMessageContext;
import com.sun.xml.ws.spi.runtime.Invoker;
import com.sun.xml.ws.spi.runtime.MessageContext;
import com.sun.xml.ws.spi.runtime.SOAPMessageContext;
import com.sun.xml.ws.spi.runtime.SystemHandlerDelegate;
import com.sun.xml.ws.spi.runtime.SystemHandlerDelegateFactory;
import java.lang.reflect.Method;
import java.rmi.UnmarshalException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.PortInfo;
import javax.xml.ws.handler.soap.SOAPHandler;

public class JAXWSSystemHandlerDelegateFactory
extends SystemHandlerDelegateFactory {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.security");
    static final String CLIENT_AUTH_CONTEXT = "com.sun.enterprise.security.jauth.ClientAuthContext";
    static final String SERVER_AUTH_CONTEXT = "com.sun.enterprise.security.jauth.ServerAuthContext";
    static final Object factory = SystemHandlerDelegateFactory.getFactory();
    static StringManager localStrings = StringManager.getManager(JAXWSSystemHandlerDelegateFactory.class);
    static Map<QName, ClientDelegate> serviceMap = new HashMap<QName, ClientDelegate>();
    private static ClientDelegateHelper helper = new ClientDelegateHelper();

    public SystemHandlerDelegate create() {
        return helper;
    }

    public boolean isEnabled(MessageContext context) {
        boolean rvalue;
        boolean bl = rvalue = factory != null;
        if (rvalue) {
            rvalue = ClientDelegateHelper.getClientDelegate(context) != null;
        }
        return rvalue;
    }

    private JAXWSSystemHandlerDelegateFactory() {
    }

    public static SystemHandlerDelegate getEjbDelegate(ServerAuthConfig authConfig, WebServiceEndpoint webServiceEndpoint, JAXWSEndpointImpl endpoint) throws RuntimeException {
        try {
            if (webServiceEndpoint != null && webServiceEndpoint.hasAuthMethod()) {
                authConfig = null;
            }
            if (authConfig != null) {
                return new EjbDelegate(authConfig, endpoint);
            }
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "ws.error_server_config", e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        return null;
    }

    public static SystemHandlerDelegate getEjbDelegate(WebServiceEndpoint webServiceEndpoint, JAXWSEndpointImpl endpoint) throws RuntimeException {
        MessageSecurityBindingDescriptor binding = null;
        if (webServiceEndpoint != null) {
            binding = webServiceEndpoint.getMessageSecurityBinding();
        }
        try {
            ServerAuthConfig authConfig = ServerAuthConfig.getConfig("SOAP", binding, WSSCallbackHandler.getInstance());
            return JAXWSSystemHandlerDelegateFactory.getEjbDelegate(authConfig, webServiceEndpoint, endpoint);
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "ws.error_server_config", e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public static SystemHandlerDelegate getServletDelegate(WebServiceEndpoint webServiceEndpoint) throws Exception {
        MessageSecurityBindingDescriptor binding = null;
        if (webServiceEndpoint != null) {
            binding = webServiceEndpoint.getMessageSecurityBinding();
        }
        try {
            ServerAuthConfig authConfig = webServiceEndpoint != null && webServiceEndpoint.hasAuthMethod() ? null : ServerAuthConfig.getConfig("SOAP", binding, WSSCallbackHandler.getInstance());
            if (authConfig != null) {
                return new ServletDelegate(authConfig);
            }
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "ws.error_server_config", e);
            throw e;
        }
        return null;
    }

    public static void configureClientDelegate(Service service, ServiceReferenceDescriptor desc) {
        boolean hasConfig = false;
        HashMap<QName, ClientAuthConfig> portMap = new HashMap<QName, ClientAuthConfig>();
        MessageSecurityBindingDescriptor binding = null;
        Iterator iter = desc.getPortsInfo().iterator();
        try {
            ClientAuthConfig authConfig;
            while (iter.hasNext()) {
                ServiceRefPortInfo portInfo = (ServiceRefPortInfo)iter.next();
                binding = portInfo.getMessageSecurityBinding();
                if (binding == null) continue;
                authConfig = ClientAuthConfig.getConfig("SOAP", binding, WSSCallbackHandler.getInstance());
                if (portInfo.hasWsdlPort()) {
                    portMap.put(portInfo.getWsdlPort(), authConfig);
                    continue;
                }
                throw new RuntimeException("Service: " + service.getServiceName() + " portName (i.e. wsdl-Port) not defined");
            }
            authConfig = ClientAuthConfig.getConfig("SOAP", null, WSSCallbackHandler.getInstance());
            if (!portMap.isEmpty() || authConfig != null) {
                portMap.put(null, authConfig);
            }
            serviceMap.put(service.getServiceName(), new ClientDelegate(portMap));
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "ws.error_client_config", e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public static void removeClientDelegate(QName serviceName) {
        serviceMap.remove(serviceName);
    }

    static boolean portNamesMatch(QName pN1, QName pN2) {
        boolean rvalue = false;
        if (pN1 == pN2) {
            rvalue = true;
        } else if (pN1 != null && pN2 != null && pN1.equals(pN2)) {
            rvalue = true;
        }
        return rvalue;
    }

    static SOAPHandler getClientHandler(ServiceReferenceDescriptor descriptor, QName portName) {
        ClientHandler rvalue = null;
        MessageSecurityBindingDescriptor binding = null;
        ClientAuthConfig authConfig = null;
        for (ServiceRefPortInfo portInfo : descriptor.getPortsInfo()) {
            QName pN = portInfo.getWsdlPort();
            if (pN == null || !JAXWSSystemHandlerDelegateFactory.portNamesMatch(portName, pN)) continue;
            binding = portInfo.getMessageSecurityBinding();
            break;
        }
        try {
            authConfig = ClientAuthConfig.getConfig("SOAP", binding, WSSCallbackHandler.getInstance());
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "ws.error_client_config", e);
            authConfig = null;
        }
        if (authConfig != null) {
            rvalue = new ClientHandler(authConfig);
        }
        return rvalue;
    }

    public static HandlerResolverImpl getHandlerResolverImpl(Service service, ServiceReferenceDescriptor descriptor) {
        if (factory != null && factory instanceof JAXWSSystemHandlerDelegateFactory) {
            JAXWSSystemHandlerDelegateFactory.configureClientDelegate(service, descriptor);
            return null;
        }
        return new WSSHandlerResolver(descriptor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class WSSHandlerResolver
    extends HandlerResolverImpl {
        private Map<PortInfo, List<Handler>> chainMap = new HashMap<PortInfo, List<Handler>>();
        ServiceReferenceDescriptor d;

        public WSSHandlerResolver(ServiceReferenceDescriptor descriptor) {
            this.d = descriptor;
        }

        @Override
        public List<Handler> getHandlerChain(PortInfo info) {
            ArrayList<Handler> chain = null;
            if (this.chainMap.containsKey(info)) {
                chain = this.chainMap.get(info);
            } else {
                chain = new ArrayList();
                this.setHandlerChain(info, chain);
            }
            return chain;
        }

        @Override
        public void setHandlerChain(PortInfo info, List<Handler> chain) {
            List<Handler> currentList = this.chainMap.get(info);
            if (currentList != null && !currentList.isEmpty()) {
                currentList.addAll(chain);
                return;
            }
            SOAPHandler secHandler = null;
            if (this.d != null) {
                secHandler = JAXWSSystemHandlerDelegateFactory.getClientHandler(this.d, info.getPortName());
            }
            if (chain == null) {
                chain = new ArrayList<Handler>();
            }
            if (secHandler != null) {
                chain.add((Handler)secHandler);
            }
            this.chainMap.put(info, chain);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ClientHandler
    implements SOAPHandler<javax.xml.ws.handler.soap.SOAPMessageContext> {
        ClientAuthConfig config;
        private boolean isAppclientContainer;

        ClientHandler(ClientAuthConfig config) {
            this.config = config;
            int containerType = Switch.getSwitch().getContainerType();
            this.isAppclientContainer = containerType == 1;
        }

        @PostConstruct
        public void initMe() {
        }

        @PreDestroy
        public void destroyMe() {
            this.config = null;
        }

        public void close(javax.xml.ws.handler.MessageContext context) {
        }

        public boolean handleFault(javax.xml.ws.handler.soap.SOAPMessageContext context) {
            return true;
        }

        public boolean handleMessage(javax.xml.ws.handler.soap.SOAPMessageContext context) {
            assert (context instanceof SOAPMessageContext);
            boolean rvalue = true;
            boolean msgOut = (Boolean)context.get((Object)"javax.xml.ws.handler.message.outbound");
            try {
                if (msgOut) {
                    ClientAuthContext cAC = this.config.getAuthContext(context);
                    if (cAC != null) {
                        WebServiceSecurity.secureRequest(context, cAC, this.isAppclientContainer);
                        context.put((Object)JAXWSSystemHandlerDelegateFactory.CLIENT_AUTH_CONTEXT, (Object)cAC);
                        context.setScope(JAXWSSystemHandlerDelegateFactory.CLIENT_AUTH_CONTEXT, MessageContext.Scope.HANDLER);
                    }
                } else {
                    ClientAuthContext cAC = (ClientAuthContext)context.get((Object)JAXWSSystemHandlerDelegateFactory.CLIENT_AUTH_CONTEXT);
                    if (cAC != null) {
                        rvalue = WebServiceSecurity.validateResponse(context, cAC);
                    }
                }
            }
            catch (Exception e) {
                Level level = e instanceof AuthException ? Level.INFO : Level.SEVERE;
                String msg = msgOut ? "wss.container_auth_exception" : "wss.validate_dispose_failed";
                _logger.log(level, msg, e);
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
            return rvalue;
        }

        public Set<QName> getHeaders() {
            HashSet<QName> headers = new HashSet<QName>();
            QName[] qNames = this.config.getMechanisms();
            for (int i = 0; i < qNames.length; ++i) {
                headers.add(qNames[i]);
            }
            return headers;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ClientDelegate
    implements SystemHandlerDelegate {
        private boolean isAppclientContainer;
        Map<QName, ClientAuthConfig> portMap;

        ClientDelegate(Map<QName, ClientAuthConfig> portMap) {
            this.portMap = portMap;
            int containerType = Switch.getSwitch().getContainerType();
            this.isAppclientContainer = containerType == 1;
        }

        ClientAuthConfig getAuthConfig(MessageContext context) {
            ClientAuthConfig rvalue = null;
            QName portName = (QName)context.get((Object)"javax.xml.ws.wsdl.port");
            if (portName != null) {
                if (this.portMap.containsKey(portName)) {
                    rvalue = this.portMap.get(portName);
                } else if (this.portMap.containsKey(null)) {
                    rvalue = this.portMap.get(null);
                }
            } else if (this.portMap.containsKey(null)) {
                rvalue = this.portMap.get(null);
            }
            return rvalue;
        }

        public boolean processRequest(MessageContext context) throws Exception {
            ClientAuthContext cAC;
            assert (context instanceof SOAPMessageContext);
            boolean status = true;
            SOAPMessageContext soapMC = (SOAPMessageContext)context;
            ClientAuthConfig config = this.getAuthConfig(context);
            ClientAuthContext clientAuthContext = cAC = config == null ? null : config.getAuthContext((javax.xml.ws.handler.soap.SOAPMessageContext)soapMC);
            if (cAC != null) {
                try {
                    status = false;
                    WebServiceSecurity.secureRequest((javax.xml.ws.handler.soap.SOAPMessageContext)soapMC, cAC, this.isAppclientContainer);
                    soapMC.put((Object)JAXWSSystemHandlerDelegateFactory.CLIENT_AUTH_CONTEXT, (Object)cAC);
                    soapMC.setScope(JAXWSSystemHandlerDelegateFactory.CLIENT_AUTH_CONTEXT, MessageContext.Scope.HANDLER);
                    status = true;
                }
                catch (Exception e) {
                    if (e instanceof AuthException) {
                        _logger.log(Level.INFO, "ws.error_secure_request", e);
                    } else {
                        _logger.log(Level.SEVERE, "ws.error_secure_request", e);
                    }
                    throw e;
                }
            }
            return status;
        }

        public void processResponse(MessageContext context) throws Exception {
            assert (context instanceof SOAPMessageContext);
            SOAPMessageContext soapMC = (SOAPMessageContext)context;
            ClientAuthContext cAC = (ClientAuthContext)soapMC.get((Object)JAXWSSystemHandlerDelegateFactory.CLIENT_AUTH_CONTEXT);
            if (cAC == null) {
                return;
            }
            try {
                boolean retValue = WebServiceSecurity.validateResponse((javax.xml.ws.handler.soap.SOAPMessageContext)soapMC, cAC);
            }
            catch (Exception e) {
                if (e instanceof AuthException) {
                    _logger.log(Level.INFO, "ws.error_validate_response", e);
                } else {
                    _logger.log(Level.SEVERE, "ws.error_validate_response", e);
                }
                throw e;
            }
        }

        public void preInvokeEndpointHook(MessageContext context) {
        }
    }

    static class ClientDelegateHelper
    implements SystemHandlerDelegate {
        ClientDelegateHelper() {
        }

        static ClientDelegate getClientDelegate(MessageContext context) {
            ClientDelegate rvalue = null;
            QName serviceName = (QName)context.get((Object)"javax.xml.ws.wsdl.service");
            if (serviceName != null) {
                rvalue = serviceMap.get(serviceName);
            }
            if (rvalue == null) {
                throw new RuntimeException(serviceName == null ? "no WSDL_SERVICE in MessageContext" : "no ClientDelegate for service" + serviceName);
            }
            return rvalue;
        }

        public boolean processRequest(MessageContext context) throws Exception {
            return ClientDelegateHelper.getClientDelegate(context).processRequest(context);
        }

        public void processResponse(MessageContext context) throws Exception {
            ClientDelegateHelper.getClientDelegate(context).processResponse(context);
        }

        public void preInvokeEndpointHook(MessageContext context) {
            try {
                ClientDelegateHelper.getClientDelegate(context).preInvokeEndpointHook(context);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static class EjbDelegate
    extends ServletDelegate {
        private static WsUtil wsUtil = new WsUtil();
        JAXWSEndpointImpl endpoint;

        EjbDelegate(BaseAuthConfig authConfig, JAXWSEndpointImpl endpoint) {
            super(authConfig);
            this.endpoint = endpoint;
        }

        public boolean processRequest(MessageContext context) throws Exception {
            assert (context instanceof SOAPMessageContext);
            SOAPMessageContext soapMC = (SOAPMessageContext)context;
            boolean status = true;
            ServerAuthContext sAC = this.authConfig == null ? null : ((ServerAuthConfig)this.authConfig).getAuthContext((javax.xml.ws.handler.soap.SOAPMessageContext)soapMC);
            try {
                if (sAC != null) {
                    status = false;
                    status = WebServiceSecurity.validateRequest((javax.xml.ws.handler.soap.SOAPMessageContext)soapMC, sAC);
                    if (status) {
                        soapMC.put((Object)JAXWSSystemHandlerDelegateFactory.SERVER_AUTH_CONTEXT, (Object)sAC);
                        soapMC.setScope(JAXWSSystemHandlerDelegateFactory.SERVER_AUTH_CONTEXT, MessageContext.Scope.HANDLER);
                    }
                }
            }
            catch (Exception e) {
                if (e instanceof AuthException) {
                    _logger.log(Level.INFO, "ws.error_validate_request", e);
                } else {
                    _logger.log(Level.SEVERE, "ws.error_validate_request", e);
                }
                throw e;
            }
            finally {
                WebServiceSecurity.auditInvocation((javax.xml.ws.handler.soap.SOAPMessageContext)soapMC, status);
            }
            if (status) {
                Exception ie;
                block18: {
                    Switch theSwitch = Switch.getSwitch();
                    InvocationManager invManager = theSwitch.getInvocationManager();
                    Invocation inv = (Invocation)invManager.getCurrentInvocation();
                    Method m = BaseAuthConfig.getMethod((javax.xml.ws.handler.soap.SOAPMessageContext)soapMC);
                    ie = null;
                    if (m != null) {
                        Container container = (Container)inv.container;
                        try {
                            inv.method = m;
                            if (!container.authorize(inv)) {
                                ie = new Exception("Client not authorized for invocation of " + inv.method);
                                break block18;
                            }
                            inv.setWebServiceMethod(inv.method);
                        }
                        catch (Exception e) {
                            String errorMsg = "Error unmarshalling method for ejb " + (this.endpoint != null ? this.endpoint.getDescriptor().getEjbComponentImpl().getName() : "unable to determine EjbComponentImp.name");
                            ie = new UnmarshalException(errorMsg);
                            ie.initCause(e);
                        }
                    } else {
                        inv.setWebServiceMethod(null);
                    }
                }
                if (ie != null) {
                    inv.exception = ie;
                    throw ie;
                }
            }
            return status;
        }

        public void preInvokeEndpointHook(MessageContext context) {
            assert (context instanceof SOAPMessageContext);
            SOAPMessageContext soapMC = (SOAPMessageContext)context;
            if (this.endpoint.getDescriptor().hasHandlerChain()) {
                Switch theSwitch = Switch.getSwitch();
                InvocationManager invManager = theSwitch.getInvocationManager();
                Invocation inv = (Invocation)invManager.getCurrentInvocation();
                Container container = (Container)inv.container;
                Method m = BaseAuthConfig.getMethod((javax.xml.ws.handler.soap.SOAPMessageContext)soapMC);
                if (m != null) {
                    try {
                        Method webServiceMethodInPreHandler = inv.getWebServiceMethod();
                        if (webServiceMethodInPreHandler != null && !webServiceMethodInPreHandler.equals(m)) {
                            inv.exception = new UnmarshalException("Original method " + webServiceMethodInPreHandler + " does not match post-handler method " + m);
                        }
                    }
                    catch (Exception e) {
                        String errorMsg = "Exception while getting method for " + (inv != null ? ((Container)inv.container).getEjbDescriptor().getName() : "");
                        inv.exception = new UnmarshalException(errorMsg);
                        inv.exception.initCause(e);
                    }
                    if (inv.exception != null) {
                        WsUtil.getDefaultLogger().log(Level.WARNING, "postEjbHandlerError", inv.exception);
                        wsUtil.throwSOAPFaultException(inv.exception.getMessage(), context);
                    }
                }
            }
        }
    }

    static class ServletDelegate
    implements SystemHandlerDelegate {
        BaseAuthConfig authConfig;

        ServletDelegate(BaseAuthConfig authConfig) {
            this.authConfig = authConfig;
        }

        public boolean processRequest(MessageContext context) throws Exception {
            assert (context instanceof SOAPMessageContext);
            final SOAPMessageContext soapMC = (SOAPMessageContext)context;
            boolean status = true;
            ServerAuthContext sAC = this.authConfig == null ? null : ((ServerAuthConfig)this.authConfig).getAuthContext((javax.xml.ws.handler.soap.SOAPMessageContext)soapMC);
            try {
                if (sAC != null) {
                    status = false;
                    status = WebServiceSecurity.validateRequest((javax.xml.ws.handler.soap.SOAPMessageContext)soapMC, sAC);
                    if (status) {
                        soapMC.put((Object)JAXWSSystemHandlerDelegateFactory.SERVER_AUTH_CONTEXT, (Object)sAC);
                        soapMC.setScope(JAXWSSystemHandlerDelegateFactory.SERVER_AUTH_CONTEXT, MessageContext.Scope.HANDLER);
                    }
                }
            }
            catch (Exception e) {
                if (e instanceof AuthException) {
                    _logger.log(Level.INFO, "ws.error_validate_request", e);
                } else {
                    _logger.log(Level.SEVERE, "ws.error_validate_request", e);
                }
                throw e;
            }
            finally {
                WebServiceSecurity.auditInvocation((javax.xml.ws.handler.soap.SOAPMessageContext)soapMC, status);
            }
            if (status && System.getSecurityManager() != null && soapMC instanceof SHDSOAPMessageContext) {
                status = false;
                try {
                    Subject.doAsPrivileged(SecurityContext.getCurrent().getSubject(), new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            Invoker invoker = ((SHDSOAPMessageContext)soapMC).getInvoker();
                            invoker.invoke();
                            ServletDelegate.this.processResponse((MessageContext)soapMC);
                            return null;
                        }
                    }, null);
                }
                catch (PrivilegedActionException pae) {
                    Throwable cause = pae.getCause();
                    if (cause instanceof AuthException) {
                        _logger.log(Level.SEVERE, "ws.error_secure_response", cause);
                    }
                    Exception e = null;
                    e = cause instanceof Exception ? (Exception)cause : new Exception(cause);
                    throw e;
                }
            }
            return status;
        }

        public void processResponse(MessageContext context) throws Exception {
            assert (context instanceof SOAPMessageContext);
            SOAPMessageContext soapMC = (SOAPMessageContext)context;
            ServerAuthContext sAC = (ServerAuthContext)soapMC.get((Object)JAXWSSystemHandlerDelegateFactory.SERVER_AUTH_CONTEXT);
            if (sAC == null) {
                return;
            }
            try {
                WebServiceSecurity.secureResponse((javax.xml.ws.handler.soap.SOAPMessageContext)soapMC, sAC);
            }
            catch (Exception e) {
                if (e instanceof AuthException) {
                    _logger.log(Level.INFO, "ws.error_secure_response", e);
                } else {
                    _logger.log(Level.SEVERE, "ws.error_secure_response", e);
                }
                throw e;
            }
        }

        public void preInvokeEndpointHook(MessageContext context) {
        }
    }
}

