/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.signature;

import com.sun.org.apache.xml.internal.security.algorithms.SignatureAlgorithm;
import com.sun.org.apache.xml.internal.security.c14n.CanonicalizationException;
import com.sun.org.apache.xml.internal.security.c14n.InvalidCanonicalizerException;
import com.sun.org.apache.xml.internal.security.exceptions.Base64DecodingException;
import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.KeyInfo;
import com.sun.org.apache.xml.internal.security.keys.content.X509Data;
import com.sun.org.apache.xml.internal.security.signature.ObjectContainer;
import com.sun.org.apache.xml.internal.security.signature.SignedInfo;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureException;
import com.sun.org.apache.xml.internal.security.transforms.Transforms;
import com.sun.org.apache.xml.internal.security.utils.Base64;
import com.sun.org.apache.xml.internal.security.utils.I18n;
import com.sun.org.apache.xml.internal.security.utils.IdResolver;
import com.sun.org.apache.xml.internal.security.utils.SignatureElementProxy;
import com.sun.org.apache.xml.internal.security.utils.SignerOutputStream;
import com.sun.org.apache.xml.internal.security.utils.UnsyncBufferedOutputStream;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolver;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverSpi;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public final class XMLSignature
extends SignatureElementProxy {
    static Logger log = Logger.getLogger((class$com$sun$org$apache$xml$internal$security$signature$XMLSignature == null ? (class$com$sun$org$apache$xml$internal$security$signature$XMLSignature = XMLSignature.class$("com.sun.org.apache.xml.internal.security.signature.XMLSignature")) : class$com$sun$org$apache$xml$internal$security$signature$XMLSignature).getName());
    public static final String ALGO_ID_MAC_HMAC_SHA1 = "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
    public static final String ALGO_ID_SIGNATURE_DSA = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
    public static final String ALGO_ID_SIGNATURE_RSA = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    public static final String ALGO_ID_SIGNATURE_RSA_SHA1 = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    public static final String ALGO_ID_SIGNATURE_NOT_RECOMMENDED_RSA_MD5 = "http://www.w3.org/2001/04/xmldsig-more#rsa-md5";
    public static final String ALGO_ID_SIGNATURE_RSA_RIPEMD160 = "http://www.w3.org/2001/04/xmldsig-more#rsa-ripemd160";
    public static final String ALGO_ID_SIGNATURE_RSA_SHA256 = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
    public static final String ALGO_ID_SIGNATURE_RSA_SHA384 = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384";
    public static final String ALGO_ID_SIGNATURE_RSA_SHA512 = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512";
    public static final String ALGO_ID_MAC_HMAC_NOT_RECOMMENDED_MD5 = "http://www.w3.org/2001/04/xmldsig-more#hmac-md5";
    public static final String ALGO_ID_MAC_HMAC_RIPEMD160 = "http://www.w3.org/2001/04/xmldsig-more#hmac-ripemd160";
    public static final String ALGO_ID_MAC_HMAC_SHA256 = "http://www.w3.org/2001/04/xmldsig-more#hmac-sha256";
    public static final String ALGO_ID_MAC_HMAC_SHA384 = "http://www.w3.org/2001/04/xmldsig-more#hmac-sha384";
    public static final String ALGO_ID_MAC_HMAC_SHA512 = "http://www.w3.org/2001/04/xmldsig-more#hmac-sha512";
    private SignedInfo _signedInfo = null;
    private KeyInfo _keyInfo = null;
    private boolean _followManifestsDuringValidation = false;
    static /* synthetic */ Class class$com$sun$org$apache$xml$internal$security$signature$XMLSignature;

    public XMLSignature(Document document, String string, String string2) throws XMLSecurityException {
        this(document, string, string2, 0, "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
    }

    public XMLSignature(Document document, String string, String string2, int n) throws XMLSecurityException {
        this(document, string, string2, n, "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
    }

    public XMLSignature(Document document, String string, String string2, String string3) throws XMLSecurityException {
        this(document, string, string2, 0, string3);
    }

    public XMLSignature(Document document, String string, String string2, int n, String string3) throws XMLSecurityException {
        super(document);
        XMLUtils.addReturnToElement(this._constructionElement);
        this._baseURI = string;
        this._signedInfo = new SignedInfo(this._doc, string2, n, string3);
        this._constructionElement.appendChild(this._signedInfo.getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
        Element element = XMLUtils.createElementInSignatureSpace(this._doc, "SignatureValue");
        this._constructionElement.appendChild(element);
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public XMLSignature(Document document, String string, Element element, Element element2) throws XMLSecurityException {
        super(document);
        XMLUtils.addReturnToElement(this._constructionElement);
        this._baseURI = string;
        this._signedInfo = new SignedInfo(this._doc, element, element2);
        this._constructionElement.appendChild(this._signedInfo.getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
        Element element3 = XMLUtils.createElementInSignatureSpace(this._doc, "SignatureValue");
        this._constructionElement.appendChild(element3);
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public XMLSignature(Element element, String string) throws XMLSignatureException, XMLSecurityException {
        super(element, string);
        Element element2 = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "SignedInfo", 0);
        if (element2 == null) {
            Object[] objectArray = new Object[]{"SignedInfo", "Signature"};
            throw new XMLSignatureException("xml.WrongContent", objectArray);
        }
        this._signedInfo = new SignedInfo(element2, string);
        Element element3 = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "SignatureValue", 0);
        if (element3 == null) {
            Object[] objectArray = new Object[]{"SignatureValue", "Signature"};
            throw new XMLSignatureException("xml.WrongContent", objectArray);
        }
        Element element4 = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "KeyInfo", 0);
        if (element4 != null) {
            this._keyInfo = new KeyInfo(element4, string);
        }
    }

    public void setId(String string) {
        if (this._state == 0 && string != null) {
            this._constructionElement.setAttributeNS(null, "Id", string);
            IdResolver.registerElementById(this._constructionElement, string);
        }
    }

    public String getId() {
        return this._constructionElement.getAttributeNS(null, "Id");
    }

    public SignedInfo getSignedInfo() {
        return this._signedInfo;
    }

    public byte[] getSignatureValue() throws XMLSignatureException {
        try {
            Element element = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "SignatureValue", 0);
            byte[] byArray = Base64.decode(element);
            return byArray;
        }
        catch (Base64DecodingException base64DecodingException) {
            throw new XMLSignatureException("empty", base64DecodingException);
        }
    }

    private void setSignatureValueElement(byte[] byArray) {
        if (this._state == 0) {
            Element element = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "SignatureValue", 0);
            while (element.hasChildNodes()) {
                element.removeChild(element.getFirstChild());
            }
            String string = Base64.encode(byArray);
            if (string.length() > 76) {
                string = "\n" + string + "\n";
            }
            Text text = this._doc.createTextNode(string);
            element.appendChild(text);
        }
    }

    public KeyInfo getKeyInfo() {
        if (this._state == 0 && this._keyInfo == null) {
            this._keyInfo = new KeyInfo(this._doc);
            Element element = this._keyInfo.getElement();
            Element element2 = null;
            Node node = this._constructionElement.getFirstChild();
            element2 = XMLUtils.selectDsNode(node, "Object", 0);
            if (element2 != null) {
                this._constructionElement.insertBefore(element, element2);
                this._constructionElement.insertBefore(this._doc.createTextNode("\n"), element2);
            } else {
                this._constructionElement.appendChild(element);
                XMLUtils.addReturnToElement(this._constructionElement);
            }
        }
        return this._keyInfo;
    }

    public void appendObject(ObjectContainer objectContainer) throws XMLSignatureException {
        try {
            if (this._state != 0) {
                throw new XMLSignatureException("signature.operationOnlyBeforeSign");
            }
            this._constructionElement.appendChild(objectContainer.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new XMLSignatureException("empty", xMLSecurityException);
        }
    }

    public ObjectContainer getObjectItem(int n) {
        Element element = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "Object", n);
        try {
            return new ObjectContainer(element, this._baseURI);
        }
        catch (XMLSecurityException xMLSecurityException) {
            return null;
        }
    }

    public int getObjectLength() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "Object");
    }

    public void sign(Key key) throws XMLSignatureException {
        block7: {
            if (key instanceof PublicKey) {
                throw new IllegalArgumentException(I18n.translate("algorithms.operationOnlyVerification"));
            }
            try {
                if (this._state != 0) break block7;
                Element element = this._signedInfo.getSignatureMethodElement();
                SignatureAlgorithm signatureAlgorithm = new SignatureAlgorithm(element, this.getBaseURI());
                signatureAlgorithm.initSign(key);
                SignedInfo signedInfo = this.getSignedInfo();
                signedInfo.generateDigestValues();
                UnsyncBufferedOutputStream unsyncBufferedOutputStream = new UnsyncBufferedOutputStream(new SignerOutputStream(signatureAlgorithm));
                try {
                    ((OutputStream)unsyncBufferedOutputStream).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                signedInfo.signInOctectStream(unsyncBufferedOutputStream);
                byte[] byArray = signatureAlgorithm.sign();
                this.setSignatureValueElement(byArray);
            }
            catch (CanonicalizationException canonicalizationException) {
                throw new XMLSignatureException("empty", canonicalizationException);
            }
            catch (InvalidCanonicalizerException invalidCanonicalizerException) {
                throw new XMLSignatureException("empty", invalidCanonicalizerException);
            }
            catch (XMLSecurityException xMLSecurityException) {
                throw new XMLSignatureException("empty", xMLSecurityException);
            }
        }
    }

    public void addResourceResolver(ResourceResolver resourceResolver) {
        this.getSignedInfo().addResourceResolver(resourceResolver);
    }

    public void addResourceResolver(ResourceResolverSpi resourceResolverSpi) {
        this.getSignedInfo().addResourceResolver(resourceResolverSpi);
    }

    public boolean checkSignatureValue(X509Certificate x509Certificate) throws XMLSignatureException {
        if (x509Certificate != null) {
            return this.checkSignatureValue(x509Certificate.getPublicKey());
        }
        Object[] objectArray = new Object[]{"Didn't get a certificate"};
        throw new XMLSignatureException("empty", objectArray);
    }

    public boolean checkSignatureValue(Key key) throws XMLSignatureException {
        if (key == null) {
            Object[] objectArray = new Object[]{"Didn't get a key"};
            throw new XMLSignatureException("empty", objectArray);
        }
        try {
            if (!this.getSignedInfo().verify(this._followManifestsDuringValidation)) {
                return false;
            }
            SignatureAlgorithm signatureAlgorithm = new SignatureAlgorithm(this.getSignedInfo().getSignatureMethodElement(), this.getBaseURI());
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "SignatureMethodURI = " + signatureAlgorithm.getAlgorithmURI());
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "jceSigAlgorithm    = " + signatureAlgorithm.getJCEAlgorithmString());
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "jceSigProvider     = " + signatureAlgorithm.getJCEProviderName());
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "PublicKey = " + key);
            }
            signatureAlgorithm.initVerify(key);
            SignerOutputStream signerOutputStream = new SignerOutputStream(signatureAlgorithm);
            UnsyncBufferedOutputStream unsyncBufferedOutputStream = new UnsyncBufferedOutputStream(signerOutputStream);
            this._signedInfo.signInOctectStream(unsyncBufferedOutputStream);
            try {
                ((OutputStream)unsyncBufferedOutputStream).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            byte[] byArray = this.getSignatureValue();
            boolean bl = signatureAlgorithm.verify(byArray);
            return bl;
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new XMLSignatureException("empty", xMLSecurityException);
        }
    }

    public void addDocument(String string, Transforms transforms, String string2, String string3, String string4) throws XMLSignatureException {
        this._signedInfo.addDocument(this._baseURI, string, transforms, string2, string3, string4);
    }

    public void addDocument(String string, Transforms transforms, String string2) throws XMLSignatureException {
        this._signedInfo.addDocument(this._baseURI, string, transforms, string2, null, null);
    }

    public void addDocument(String string, Transforms transforms) throws XMLSignatureException {
        this._signedInfo.addDocument(this._baseURI, string, transforms, "http://www.w3.org/2000/09/xmldsig#sha1", null, null);
    }

    public void addDocument(String string) throws XMLSignatureException {
        this._signedInfo.addDocument(this._baseURI, string, null, "http://www.w3.org/2000/09/xmldsig#sha1", null, null);
    }

    public void addKeyInfo(X509Certificate x509Certificate) throws XMLSecurityException {
        X509Data x509Data = new X509Data(this._doc);
        x509Data.addCertificate(x509Certificate);
        this.getKeyInfo().add(x509Data);
    }

    public void addKeyInfo(PublicKey publicKey) {
        this.getKeyInfo().add(publicKey);
    }

    public SecretKey createSecretKey(byte[] byArray) {
        return this.getSignedInfo().createSecretKey(byArray);
    }

    public void setFollowNestedManifests(boolean bl) {
        this._followManifestsDuringValidation = bl;
    }

    public String getBaseLocalName() {
        return "Signature";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

