/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.appclient.jws.boot;

import com.sun.enterprise.appclient.Main;
import com.sun.enterprise.appclient.jws.Util;
import com.sun.enterprise.appclient.jws.boot.ClassPathManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.Policy;
import java.security.Security;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JWSACCMain
implements Runnable {
    private static final String PERMISSIONS_TEMPLATE_NAME = "jwsclient.policy";
    private static final String GRANT_CLAUSES_PROPERTY_EXPR = "${grant.clauses}";
    private static final String lineSep = System.getProperty("line.separator");
    private static Main accMain = null;
    private static String jwsPolicyTemplateURL = null;
    private static final String JWSACC_ARGUMENT_PREFIX = "-jwsacc";
    private static final String JWSACC_EXIT_AFTER_RETURN = "ExitAfterReturn";
    private static final String GRANT_CLAUSE_TEMPLATE = "grant codeBase \"{0}\" '{'\n    permission java.security.AllPermission;\n'}';";
    private static boolean exitAfterReturn = false;
    private static ClassPathManager classPathManager = null;
    private static URL[] downloadedJarURLs;
    private String[] args;

    public JWSACCMain(String[] args) {
        this.args = args;
    }

    public static void main(String[] args) {
        try {
            classPathManager = JWSACCMain.getClassPathManager();
            args = JWSACCMain.prepareJWSArgs(args);
            downloadedJarURLs = classPathManager.locateDownloadedJars();
        }
        catch (Throwable thr) {
            System.err.println("Error locating downloaded jars");
            thr.printStackTrace();
            System.exit(1);
        }
        JWSACCMain.setPermissions();
        JWSACCMain jwsACCMain = new JWSACCMain(args);
        try {
            SwingUtilities.invokeAndWait(jwsACCMain);
        }
        catch (Throwable thr) {
            System.err.println("Error attempting to launch JWSACCMain.main");
            thr.printStackTrace(System.err);
            System.exit(1);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        int exitValue = 0;
        try {
            File downloadedAppclientJarFile = this.findAppClientFileForJWSLaunch(this.getClass().getClassLoader());
            ClassLoader loader = JWSACCMain.prepareClassLoader(downloadedAppclientJarFile);
            System.setProperty("com.sun.aas.downloaded.appclient.jar", downloadedAppclientJarFile.getAbsolutePath());
            Thread.currentThread().setContextClassLoader(loader);
            Method mainMethod = null;
            Class<?> mainClass = Class.forName("com.sun.enterprise.appclient.Main", false, loader);
            mainMethod = mainClass.getMethod("main", String[].class);
            Object[] params = new Object[]{this.args};
            mainMethod.invoke(null, params);
            if (!exitAfterReturn) return;
        }
        catch (Throwable thr) {
            try {
                exitValue = 1;
                throw new RuntimeException(thr);
            }
            catch (Throwable throwable) {
                if (!exitAfterReturn) throw throwable;
                SwingUtilities.invokeLater(new Runnable(){
                    private int statusValue;

                    public void run() {
                        System.out.printf("Exiting after return from client with status %1$d%n", this.statusValue);
                        System.exit(this.statusValue);
                    }

                    public Runnable init(int exitStatus) {
                        this.statusValue = exitStatus;
                        return this;
                    }
                }.init(exitValue));
                throw throwable;
            }
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */.init(exitValue));
        return;
    }

    private static String[] prepareJWSArgs(String[] args) {
        Vector<String> JWSACCArgs = new Vector<String>();
        Vector<String> nonJWSACCArgs = new Vector<String>();
        for (String arg : args) {
            if (arg.startsWith(JWSACC_ARGUMENT_PREFIX)) {
                JWSACCArgs.add(arg.substring(JWSACC_ARGUMENT_PREFIX.length()));
                continue;
            }
            nonJWSACCArgs.add(arg);
        }
        JWSACCMain.processJWSArgs(JWSACCArgs);
        return nonJWSACCArgs.toArray(new String[nonJWSACCArgs.size()]);
    }

    private static void processJWSArgs(Vector<String> args) {
        for (String arg : args) {
            if (!arg.equals(JWSACC_EXIT_AFTER_RETURN)) continue;
            exitAfterReturn = true;
        }
    }

    private static void setPermissions() {
        String JWSACCMainClassName = JWSACCMain.class.getName();
        try {
            String permissionsTemplate = Util.loadResource(JWSACCMain.class, (String)PERMISSIONS_TEMPLATE_NAME);
            StringBuilder grantClauses = new StringBuilder();
            for (URL url : downloadedJarURLs) {
                grantClauses.append(MessageFormat.format(GRANT_CLAUSE_TEMPLATE, url.toExternalForm()));
            }
            String substitutedPermissionsTemplate = permissionsTemplate.replace(GRANT_CLAUSES_PROPERTY_EXPR, grantClauses.toString());
            boolean retainTempFiles = Boolean.getBoolean("com.sun.aas.jws.retainTempFiles");
            File policyFile = JWSACCMain.writeTextToTempFile(substitutedPermissionsTemplate, "jwsacc", ".policy", retainTempFiles);
            JWSACCMain.refreshPolicy(policyFile);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error loading permissions template", ioe);
        }
    }

    public static int firstFreePolicyIndex() {
        String propValue;
        int i = 0;
        while ((propValue = Security.getProperty("policy.url." + String.valueOf(++i))) != null && !propValue.equals("")) {
        }
        return i;
    }

    public static void refreshPolicy(File policyFile) {
        int idx = JWSACCMain.firstFreePolicyIndex();
        URI policyFileURI = policyFile.toURI();
        Security.setProperty("policy.url." + idx, policyFileURI.toASCIIString());
        Policy p = Policy.getPolicy();
        p.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File writeTextToTempFile(String content, String prefix, String suffix, boolean retainTempFiles) throws IOException, FileNotFoundException {
        BufferedWriter wtr = null;
        try {
            File result = File.createTempFile(prefix, suffix);
            if (!retainTempFiles) {
                result.deleteOnExit();
            }
            FileOutputStream fos = new FileOutputStream(result);
            wtr = new BufferedWriter(new OutputStreamWriter(fos));
            wtr.write(content);
            wtr.close();
            File file = result;
            return file;
        }
        finally {
            if (wtr != null) {
                wtr.close();
            }
        }
    }

    private static ClassLoader prepareClassLoader(File downloadedAppclientJarFile) throws IOException, URISyntaxException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        URLClassLoader ldr = new URLClassLoader(downloadedJarURLs, classPathManager.getParentClassLoader());
        return ldr;
    }

    private static File findContainingJar(String target, ClassLoader loader) throws IllegalArgumentException, URISyntaxException, MalformedURLException, IllegalAccessException, InvocationTargetException {
        URL resourceURL = loader.getResource(target);
        return classPathManager.findContainingJar(resourceURL);
    }

    private File findAppClientFileForJWSLaunch(ClassLoader loader) throws URISyntaxException, MalformedURLException, IllegalAccessException, InvocationTargetException {
        File containingJar = JWSACCMain.findContainingJar("META-INF/application.xml", loader);
        if (containingJar == null) {
            containingJar = JWSACCMain.findContainingJar("META-INF/application-client.xml", loader);
        }
        if (containingJar == null) {
            throw new IllegalArgumentException("Could not locate META-INF/application.xml or META-INF/application-client.xml");
        }
        return containingJar;
    }

    public static ClassPathManager getClassPathManager() throws ClassNotFoundException, NoSuchMethodException {
        return ClassPathManager.getClassPathManager();
    }
}

