/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.converter;

import com.sun.web.ui.component.DateManager;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;

public class DateConverter
implements Converter,
Serializable {
    public String getAsString(FacesContext context, UIComponent component, Object o) throws ConverterException {
        try {
            return this.getDateFormat(component).format(o);
        }
        catch (Exception ex) {
            throw new ConverterException((Throwable)ex);
        }
    }

    public Object getAsObject(FacesContext context, UIComponent component, String s) throws ConverterException {
        if (s.length() == 0) {
            return null;
        }
        try {
            Date date = this.getDateFormat(component).parse(s);
            return date;
        }
        catch (Exception ex) {
            throw new ConverterException((Throwable)ex);
        }
    }

    private DateFormat getDateFormat(UIComponent component) {
        DateManager dateManager = null;
        if (component instanceof DateManager) {
            dateManager = (DateManager)component;
        } else if (component.getParent() instanceof DateManager) {
            dateManager = (DateManager)component.getParent();
        }
        if (dateManager == null) {
            throw new RuntimeException("The DateConverter can only be used with components which implement DateManager");
        }
        return dateManager.getDateFormat();
    }
}

