/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.theme;

import com.sun.web.ui.theme.Theme;
import com.sun.web.ui.theme.ThemeConfigurationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class ThemeManager {
    public static final String THEME_MANAGER = "com.sun.web.ui.ThemeManager";
    private static String defaultTheme = null;
    private Locale defaultLocale = null;
    private HashMap themes = new HashMap();
    private boolean populated = false;
    private ThemeManager themeManager = null;
    private static final boolean DEBUG = false;
    private String messageResource = null;

    protected ThemeManager() {
    }

    protected void addThemeMap(String name, Map themeMap) {
        this.themes.put(name, themeMap);
    }

    public Theme getTheme(String name, Locale locale) {
        Object mapObject = this.themes.get(name);
        if (mapObject == null) {
            if (this.themes.isEmpty()) {
                String message = "CONFIGURATION ERROR: no theme resources library available";
                throw new ThemeConfigurationException(message);
            }
            this.log("WARNING: theme " + name + " has not been initialized.");
            if (defaultTheme != null) {
                mapObject = this.themes.get(defaultTheme);
                if (mapObject != null) {
                    this.log("Using the default theme " + defaultTheme);
                }
            } else {
                this.log("WARNING: no default theme name available either, using any theme!");
            }
            if (mapObject == null) {
                mapObject = this.themes.values().iterator().next();
            }
        }
        Map themeMap = (Map)mapObject;
        Object theme = null;
        Object object = themeMap.get(locale);
        if (object == null) {
            this.log("No theme instance found for locale " + locale.getDisplayName());
            if (this.defaultLocale != null) {
                this.log("Trying to use the default locale " + this.defaultLocale.getDisplayName());
                object = themeMap.get(this.defaultLocale);
            }
            if (object == null && !themeMap.isEmpty()) {
                this.log("Trying to use any theme instance");
                object = themeMap.values().iterator().next();
            }
            if (object == null) {
                String message = "CONFIGURATION ERROR: no theme resources library available";
                throw new ThemeConfigurationException(message);
            }
        }
        return (Theme)object;
    }

    protected void setDefaultThemeName(String name) {
        if (name != null && name.length() > 0) {
            defaultTheme = name;
        }
        this.checkDefaultThemeName();
    }

    protected void setDefaultLocale(Locale defaultLocale) {
        this.defaultLocale = defaultLocale;
    }

    public String getDefaultThemeName() {
        return defaultTheme;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("ThemeManager for Sun Web Componenents.");
        buffer.append("\nDefault theme is ");
        buffer.append(defaultTheme);
        buffer.append(".\nAvailable themes: ");
        Iterator iterator = this.themes.keySet().iterator();
        while (iterator.hasNext()) {
            buffer.append(iterator.next());
            buffer.append(" ");
        }
        buffer.append(".\nAvailable locales: ");
        iterator = ((Map)this.themes.get(defaultTheme)).keySet().iterator();
        while (iterator.hasNext()) {
            buffer.append(iterator.next());
            buffer.append(" ");
        }
        return buffer.toString();
    }

    private void checkDefaultThemeName() {
        Iterator keys;
        boolean warn = false;
        if (defaultTheme != null) {
            if (this.themes.containsKey(defaultTheme)) {
                return;
            }
            warn = true;
            this.log("WARNING: default theme name " + defaultTheme + " is invalid");
        }
        if ((keys = this.themes.keySet().iterator()).hasNext()) {
            defaultTheme = keys.next().toString();
        }
        if (warn) {
            this.log("Using defaultTheme " + defaultTheme + "instead");
        }
    }

    private void log(String s) {
        System.out.println(this.getClass().getName() + "::" + s);
    }
}

