/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.persistence.spi.PersistenceUnitInfo;
import oracle.toplink.essentials.ejb.cmp3.persistence.PersistenceUnitProcessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataDescriptor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataLogger;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataPersistenceUnit;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataProject;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataValidator;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.ClassAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.objects.MetadataClass;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.XMLHelper;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.XMLLogger;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.XMLValidator;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.accessors.XMLClassAccessor;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataProcessor {
    protected ClassLoader m_loader;
    protected MetadataLogger m_logger;
    protected MetadataProject m_project;
    protected MetadataValidator m_validator;

    public MetadataProcessor(AbstractSession session, ClassLoader loader, boolean enableLazyForOneToOne) {
        this.m_loader = loader;
        this.m_project = new MetadataProject(session, enableLazyForOneToOne);
    }

    public MetadataProcessor(AbstractSession session, ClassLoader loader, Collection<Class> entities, boolean enableLazyForOneToOne) {
        this.m_loader = loader;
        this.m_project = new MetadataProject(session, enableLazyForOneToOne);
        for (Class entity : entities) {
            this.m_project.addDescriptor(new MetadataDescriptor(entity));
        }
    }

    public void addEntityListeners() {
        for (MetadataDescriptor descriptor : this.m_project.getDescriptors()) {
            ClassAccessor accessor = descriptor.getClassAccessor();
            accessor.setAnnotatedElement(descriptor.getJavaClass());
            accessor.clearMappedSuperclasses();
            accessor.processListeners(this.m_loader);
        }
    }

    public void addNamedQueries() {
        this.m_project.processNamedQueries(this.m_validator);
        this.m_project.processNamedNativeQueries(this.m_loader);
    }

    public static Set<String> buildClassSet(InputStream xmlDocumentInputStream, String fileName, ClassLoader loader) {
        XMLHelper helper = new XMLHelper(xmlDocumentInputStream, fileName, loader);
        String defaultPkg = helper.getNodeValue(new String[]{"entity-mappings", "package", "text()"});
        HashSet<String> classSet = new HashSet<String>();
        classSet.addAll(MetadataProcessor.buildClassSetForNodeList(helper, "entity", defaultPkg));
        return classSet;
    }

    protected static Set<String> buildClassSetForNodeList(XMLHelper helper, String xPath, String defaultPkg) {
        HashSet<String> classNames = new HashSet<String>();
        NodeList nodes = helper.getNodes("entity-mappings", xPath);
        int nodeCount = nodes.getLength();
        for (int i = 0; i < nodeCount; ++i) {
            classNames.add(XMLHelper.getFullyQualifiedClassName(helper.getNode(nodes.item(i), "@class").getNodeValue(), defaultPkg));
        }
        return classNames;
    }

    public MetadataLogger getLogger() {
        return this.m_logger;
    }

    public MetadataProject getProject() {
        return this.m_project;
    }

    public MetadataValidator getValidator() {
        return this.m_validator;
    }

    public AbstractSession processAnnotations() {
        this.m_validator = new MetadataValidator();
        this.m_logger = new MetadataLogger(this.m_project.getSession());
        for (MetadataDescriptor descriptor : this.m_project.getDescriptors().toArray(new MetadataDescriptor[0])) {
            ClassAccessor accessor = descriptor.getClassAccessor();
            if (accessor != null) continue;
            accessor = new ClassAccessor(new MetadataClass(descriptor.getJavaClass()), this, descriptor);
            descriptor.setClassAccessor(accessor);
            accessor.process();
        }
        return this.m_project.process();
    }

    public void processPersistenceUnitMetadata(AbstractSession session, PersistenceUnitInfo persistenceUnitInfo, Collection<String> mappingFileNames, Collection<Class> entities) {
        if (!mappingFileNames.isEmpty()) {
            Iterator<String> fileNames = mappingFileNames.iterator();
            for (String fileName : mappingFileNames) {
                InputStream inputStream = null;
                this.m_logger = new XMLLogger(session);
                try {
                    MetadataPersistenceUnit existingPersistenceUnit;
                    Class cls;
                    Node node;
                    int i;
                    inputStream = PersistenceUnitProcessor.createInputStreamForFileInPersistenceUnit(fileName, persistenceUnitInfo, this.m_loader);
                    if (inputStream == null) {
                        this.getLogger().logWarningMessage("orm_could_not_find_orm_xml_file", fileName);
                        continue;
                    }
                    XMLHelper helper = new XMLHelper(inputStream, fileNames.next(), this.m_loader);
                    NodeList nodes = helper.getNodes("entity-mappings", "mapped-superclass");
                    for (i = 0; i < nodes.getLength(); ++i) {
                        node = nodes.item(i);
                        cls = helper.getNodeValue(nodes.item(i), "@class", Void.TYPE);
                        this.m_project.addMappedSuperclass(cls, node, helper);
                    }
                    nodes = helper.getNodes("entity-mappings", "embeddable");
                    for (i = 0; i < nodes.getLength(); ++i) {
                        node = nodes.item(i);
                        cls = helper.getNodeValue(nodes.item(i), "@class", Void.TYPE);
                        this.m_project.addEmbeddable(cls, node, helper);
                    }
                    Node persistenceUnitMetadataNode = helper.getNode(new String[]{"entity-mappings", "persistence-unit-metadata"});
                    if (persistenceUnitMetadataNode == null) continue;
                    MetadataPersistenceUnit persistenceUnit = new MetadataPersistenceUnit();
                    persistenceUnit.setIsMetadataComplete(helper.getNode(persistenceUnitMetadataNode, "xml-mapping-metadata-complete") != null);
                    Node persistenceUnitDefaultsNode = helper.getNode(persistenceUnitMetadataNode, "persistence-unit-defaults");
                    if (persistenceUnitDefaultsNode != null) {
                        persistenceUnit.setAccess(helper.getNodeTextValue(persistenceUnitDefaultsNode, "access"));
                        persistenceUnit.setSchema(helper.getNodeTextValue(persistenceUnitDefaultsNode, "schema"));
                        persistenceUnit.setCatalog(helper.getNodeTextValue(persistenceUnitDefaultsNode, "catalog"));
                        persistenceUnit.setIsCascadePersist(helper.getNode(persistenceUnitDefaultsNode, "cascade-persist") != null);
                        NodeList listenerNodes = helper.getNodes(persistenceUnitDefaultsNode, "entity-listeners", "entity-listener");
                        if (listenerNodes != null) {
                            this.m_project.addDefaultListeners(listenerNodes, helper);
                        }
                    }
                    if ((existingPersistenceUnit = this.m_project.getPersistenceUnit()) != null) {
                        if (existingPersistenceUnit.equals(persistenceUnit)) continue;
                        new XMLValidator().throwPersistenceUnitMetadataConflict(existingPersistenceUnit.getConflict());
                        continue;
                    }
                    this.m_project.setPersistenceUnit(persistenceUnit);
                }
                catch (IOException exception) {
                    this.getLogger().logWarningMessage("orm_warning_exception_loading_orm_xml_file", fileName, exception);
                }
                catch (RuntimeException re) {
                    throw re;
                }
                finally {
                    if (inputStream == null) continue;
                    try {
                        inputStream.close();
                    }
                    catch (IOException exc) {}
                }
            }
        }
        if (!entities.isEmpty()) {
            for (Class entity : entities) {
                this.m_project.addDescriptor(new MetadataDescriptor(entity));
            }
        }
    }

    public void processXML(InputStream xmlDocumentStream, String fileName) {
        if (this.m_project.hasDescriptors()) {
            this.m_validator = new XMLValidator();
            this.m_logger = new XMLLogger(this.m_project.getSession());
            XMLHelper helper = new XMLHelper(xmlDocumentStream, fileName, this.m_loader);
            MetadataDescriptor desc = this.m_project.getDescriptors().iterator().next();
            XMLClassAccessor dummyAccessor = new XMLClassAccessor(new MetadataClass(desc.getJavaClass()), null, helper, this, desc);
            dummyAccessor.processEntityMappings();
            NodeList entityNodes = helper.getNodes("entity-mappings", "entity");
            if (entityNodes != null) {
                for (int i = 0; i < entityNodes.getLength(); ++i) {
                    Node entityNode = entityNodes.item(i);
                    Class entityClass = helper.getClassForNode(entityNode);
                    MetadataDescriptor descriptor = this.m_project.getDescriptor(entityClass);
                    ClassAccessor accessor = descriptor.getClassAccessor();
                    if (accessor != null) continue;
                    accessor = new XMLClassAccessor(new MetadataClass(descriptor.getJavaClass()), entityNode, helper, this, descriptor);
                    descriptor.setClassAccessor(accessor);
                    accessor.process();
                }
            }
        }
    }

    public void setClassLoader(ClassLoader loader) {
        this.m_loader = loader;
    }
}

