/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.queryframework;

import java.util.Vector;
import oracle.toplink.essentials.internal.localization.ExceptionLocalization;
import oracle.toplink.essentials.sessions.DatabaseRecord;

public class FieldResult {
    protected String attributeName;
    protected String[] multipleFieldIdentifiers;
    Vector fieldResults;
    protected String columnName;

    public FieldResult(String attributeName, String column) {
        this.columnName = column;
        if (attributeName == null || this.columnName == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("null_values_for_field_result"));
        }
        this.multipleFieldIdentifiers = attributeName.split("\\.", 0);
        this.attributeName = this.multipleFieldIdentifiers[0];
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public Object getValueFromRecord(DatabaseRecord record) {
        return record.get(this.columnName);
    }

    public Vector getFieldResults() {
        return this.fieldResults;
    }

    public String[] getMultipleFieldIdentifiers() {
        return this.multipleFieldIdentifiers;
    }

    public void add(FieldResult newFieldResult) {
        if (this.fieldResults == null) {
            this.fieldResults = new Vector();
            this.fieldResults.add(this);
        }
        this.fieldResults.add(newFieldResult);
    }
}

