/*
 * Decompiled with CFR 0.152.
 */
package samples.webapps.simple.beans.num;

import java.util.Random;

public class NumberGuessBean {
    int answer;
    boolean success;
    String hint;
    int numGuesses;

    public NumberGuessBean() {
        this.reset();
    }

    public void setGuess(String string) {
        int n;
        ++this.numGuesses;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = -1;
        }
        if (n == this.answer) {
            this.success = true;
        } else if (n == -1) {
            this.hint = "a number next time";
        } else if (n < this.answer) {
            this.hint = "higher";
        } else if (n > this.answer) {
            this.hint = "lower";
        }
    }

    public boolean getSuccess() {
        return this.success;
    }

    public String getHint() {
        return "" + this.hint;
    }

    public int getNumGuesses() {
        return this.numGuesses;
    }

    public void reset() {
        this.answer = Math.abs(new Random().nextInt() % 100) + 1;
        this.success = false;
        this.numGuesses = 0;
    }
}

