/*
 * Decompiled with CFR 0.152.
 */
package samples.webapps.simple.servlet.filters;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public final class RequestDumperFilter
implements Filter {
    private FilterConfig filterConfig = null;

    public void destroy() {
        this.filterConfig = null;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        int n;
        String[] stringArray;
        String string;
        Object object;
        if (this.filterConfig == null) {
            return;
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("Request Received at " + new Timestamp(System.currentTimeMillis()));
        printWriter.println(" characterEncoding=" + servletRequest.getCharacterEncoding());
        printWriter.println("     contentLength=" + servletRequest.getContentLength());
        printWriter.println("       contentType=" + servletRequest.getContentType());
        printWriter.println("            locale=" + servletRequest.getLocale());
        printWriter.print("           locales=");
        Enumeration enumeration = servletRequest.getLocales();
        boolean bl = true;
        while (enumeration.hasMoreElements()) {
            object = (Locale)enumeration.nextElement();
            if (bl) {
                bl = false;
            } else {
                printWriter.print(", ");
            }
            printWriter.print(((Locale)object).toString());
        }
        printWriter.println();
        object = servletRequest.getParameterNames();
        while (object.hasMoreElements()) {
            string = (String)object.nextElement();
            printWriter.print("         parameter=" + string + "=");
            stringArray = servletRequest.getParameterValues(string);
            for (n = 0; n < stringArray.length; ++n) {
                if (n > 0) {
                    printWriter.print(", ");
                }
                printWriter.print(stringArray[n]);
            }
            printWriter.println();
        }
        printWriter.println("          protocol=" + servletRequest.getProtocol());
        printWriter.println("        remoteAddr=" + servletRequest.getRemoteAddr());
        printWriter.println("        remoteHost=" + servletRequest.getRemoteHost());
        printWriter.println("            scheme=" + servletRequest.getScheme());
        printWriter.println("        serverName=" + servletRequest.getServerName());
        printWriter.println("        serverPort=" + servletRequest.getServerPort());
        printWriter.println("          isSecure=" + servletRequest.isSecure());
        if (servletRequest instanceof HttpServletRequest) {
            printWriter.println("---------------------------------------------");
            string = (HttpServletRequest)servletRequest;
            printWriter.println("       contextPath=" + string.getContextPath());
            stringArray = string.getCookies();
            if (stringArray == null) {
                stringArray = new Cookie[]{};
            }
            for (n = 0; n < stringArray.length; ++n) {
                printWriter.println("            cookie=" + stringArray[n].getName() + "=" + stringArray[n].getValue());
            }
            object = string.getHeaderNames();
            while (object.hasMoreElements()) {
                String string2 = (String)object.nextElement();
                String string3 = string.getHeader(string2);
                printWriter.println("            header=" + string2 + "=" + string3);
            }
            printWriter.println("            method=" + string.getMethod());
            printWriter.println("          pathInfo=" + string.getPathInfo());
            printWriter.println("       queryString=" + string.getQueryString());
            printWriter.println("        remoteUser=" + string.getRemoteUser());
            printWriter.println("requestedSessionId=" + string.getRequestedSessionId());
            printWriter.println("        requestURI=" + string.getRequestURI());
            printWriter.println("       servletPath=" + string.getServletPath());
        }
        printWriter.println("=============================================");
        printWriter.flush();
        this.filterConfig.getServletContext().log(stringWriter.getBuffer().toString());
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
    }

    public String toString() {
        if (this.filterConfig == null) {
            return "RequestDumperFilter()";
        }
        StringBuffer stringBuffer = new StringBuffer("RequestDumperFilter(");
        stringBuffer.append(this.filterConfig);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

