/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.handlers;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBase;
import com.sun.enterprise.tools.admingui.util.MBeanUtil;
import com.sun.enterprise.tools.admingui.util.Util;
import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.view.DescriptorContainerView;
import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import com.sun.enterprise.tools.guiframework.view.ViewDescriptorManager;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;

public class MBeanHandlers {
    public static final String IN = "in";
    public static final String OUT = "out";
    public static final String KEY = "key";
    public static final String VALUE = "value";
    public static final String OBJECT_NAME = "objectName";
    public static final String DISPLAY_NAMES = "displayNames";
    public static final String ATTRIBUTE_NAMES = "attributeNames";
    public static final String PROPERTY_NAMES = "propertyNames";
    public static final String ATTRIBUTE_NAME = "attributeName";
    public static final String ATTRIBUTE_VALUES = "attributeValues";
    public static final String DATA_CONVERSION_TYPE = "dataConversionType";
    public static final String VIEW_DESCRIPTOR_NAME = "viewDescriptorName";

    public void getAttributeListFromMBean(RequestContext reqCtx, HandlerContext handlerCtx) {
        ArrayList attributeNames = (ArrayList)handlerCtx.getInputValue(ATTRIBUTE_NAMES);
        if (attributeNames == null) {
            throw new IllegalArgumentException("The parameter map did not contain attributeNames");
        }
        Object objectName = handlerCtx.getInputValue(OBJECT_NAME);
        if (objectName == null) {
            throw new IllegalArgumentException("The parameter map did not contain objectName");
        }
        AttributeList values = null;
        try {
            values = MBeanUtil.getAttributes(objectName.toString(), attributeNames.toArray(new String[attributeNames.size()]));
        }
        catch (Exception ex) {
            if (ex.getCause() instanceof InstanceNotFoundException) {
                if (Util.isLoggableFINE()) {
                    Util.logFINE("caught: InstanceNotFoundException");
                }
            }
            throw new FrameworkException("Unable to get MBean attributes for object name: '" + objectName + "'.", (Throwable)ex, null, null);
        }
        handlerCtx.setOutputValue(VALUE, (Object)values);
    }

    public void getAttributeValueFromMBean(RequestContext reqCtx, HandlerContext handlerCtx) {
        String attributeName = (String)handlerCtx.getInputValue(ATTRIBUTE_NAME);
        if (attributeName == null) {
            throw new IllegalArgumentException("The parameter map did not contain attributeName");
        }
        Object objectName = handlerCtx.getInputValue(OBJECT_NAME);
        if (objectName == null) {
            throw new IllegalArgumentException("The parameter map did not contain objectName");
        }
        try {
            handlerCtx.setOutputValue(VALUE, MBeanUtil.getAttribute(objectName.toString(), attributeName));
        }
        catch (Exception ex) {
            if (ex.getCause() instanceof InstanceNotFoundException) {
                if (Util.isLoggableFINE()) {
                    Util.logFINE("caught: InstanceNotFoundException");
                }
            }
            throw new FrameworkException("Unable to get MBean attribute for object name: '" + objectName + "'.", (Throwable)ex, null, null);
        }
    }

    public void setAttributeListToMBean(RequestContext reqCtx, HandlerContext handlerCtx) {
        AttributeList value = (AttributeList)handlerCtx.getInputValue(VALUE);
        Object objectName = handlerCtx.getInputValue(OBJECT_NAME);
        if (objectName == null) {
            throw new IllegalArgumentException("The parameter map did not contain objectName");
        }
        try {
            MBeanUtil.setAttributes(objectName.toString(), value);
        }
        catch (Exception ex) {
            throw new FrameworkException("Error while setting attributes on MBean '" + objectName + "'!", (Throwable)ex, handlerCtx.getViewDescriptor(), handlerCtx.getView());
        }
    }

    public void setAttributeToMBean(RequestContext reqCtx, HandlerContext handlerCtx) {
        Object value = handlerCtx.getInputValue(VALUE);
        String name = (String)handlerCtx.getInputValue(KEY);
        String val = null;
        val = value instanceof Object[] ? this.convertToCommaSeperatedList((Object[])value) : (String)value;
        Attribute attr = new Attribute(name, val);
        Object objectName = handlerCtx.getInputValue(OBJECT_NAME);
        if (objectName == null) {
            throw new IllegalArgumentException("The parameter map did not contain objectName");
        }
        if (name == null) {
            throw new IllegalArgumentException("The parameter map did not contain AttributeName");
        }
        try {
            MBeanUtil.setAttribute(objectName.toString(), attr);
        }
        catch (Exception ex) {
            throw new FrameworkException("Error while setting attributes on MBean '" + objectName + "'!", (Throwable)ex, handlerCtx.getViewDescriptor(), handlerCtx.getView());
        }
    }

    private String convertToCommaSeperatedList(Object[] values) {
        String allValues = null;
        if (values != null) {
            int len = values.length;
            for (int count = 0; count < len; ++count) {
                String val = (String)values[count];
                if (val == null || val.toString().trim().length() == 0) continue;
                allValues = allValues == null ? val : allValues + "," + val;
            }
        }
        return allValues;
    }

    private Attribute split(Attribute attr, String splitChar) {
        if (attr == null || attr.getValue() == null) {
            return attr;
        }
        String newline = System.getProperty("line.separator");
        String strValue = attr.getValue().toString();
        boolean changed = false;
        if (strValue.indexOf(splitChar) > -1) {
            strValue = strValue.replaceAll(splitChar, newline);
            changed = true;
        }
        if (strValue.indexOf("${path.separator}") > -1) {
            strValue = strValue.replaceAll("\\$\\{path.separator\\}", newline);
            changed = true;
        }
        return changed ? new Attribute(attr.getName(), strValue) : attr;
    }

    private Attribute unsplit(Attribute attr, String splitChar) {
        if (attr == null || attr.getValue() == null) {
            return attr;
        }
        String strValue = attr.getValue().toString();
        String result = "";
        StringTokenizer st = new StringTokenizer(strValue, "\n\r");
        while (st.hasMoreTokens()) {
            if (!result.equals("")) {
                result = result + "${path.separator}";
            }
            result = result + st.nextToken();
        }
        return new Attribute(attr.getName(), result);
    }

    public void split(RequestContext reqCtx, HandlerContext handlerCtx) {
        AttributeList value = null;
        Object inputList = handlerCtx.getInputValue(IN);
        String splitChar = System.getProperty("path.separator");
        if (!splitChar.equals("") && inputList instanceof AttributeList) {
            AttributeList list = (AttributeList)inputList;
            AttributeList newList = new AttributeList();
            for (int i = 0; i < list.size(); ++i) {
                newList.add(i, this.split((Attribute)list.get(i), splitChar));
            }
            value = newList;
        }
        handlerCtx.setOutputValue(OUT, value);
    }

    public void unsplit(RequestContext reqCtx, HandlerContext handlerCtx) {
        Object value = handlerCtx.getInputValue(IN);
        String splitChar = System.getProperty("path.separator");
        if (!splitChar.equals("") && value instanceof AttributeList) {
            AttributeList list = (AttributeList)value;
            AttributeList newList = new AttributeList();
            for (int i = 0; i < list.size(); ++i) {
                newList.add(i, this.unsplit((Attribute)list.get(i), splitChar));
            }
            value = newList;
        }
        handlerCtx.setOutputValue(OUT, value);
    }

    public void getAttributeListFromDisplayFields(RequestContext reqCtx, HandlerContext handlerCtx) {
        ArrayList attributeNames = (ArrayList)handlerCtx.getInputValue(ATTRIBUTE_NAMES);
        if (attributeNames == null) {
            throw new IllegalArgumentException("The parameter map did not contain attributeNames");
        }
        ArrayList displayNames = (ArrayList)handlerCtx.getInputValue(DISPLAY_NAMES);
        if (displayNames == null) {
            throw new IllegalArgumentException("The parameter map did not contain displayNames");
        }
        if (displayNames.size() != attributeNames.size()) {
            throw new IllegalArgumentException("displayNames and attributeNames should have same number of entries!");
        }
        ContainerView view = MBeanHandlers.getView(reqCtx, handlerCtx);
        AttributeList attrList = new AttributeList();
        for (int i = 0; i < attributeNames.size(); ++i) {
            Object fieldValue = view.getDisplayFieldValue((String)displayNames.get(i));
            if (fieldValue == null) continue;
            attrList.add(new Attribute((String)attributeNames.get(i), fieldValue));
        }
        handlerCtx.setOutputValue(VALUE, (Object)attrList);
    }

    public void getPropertiesListFromDisplayFields(RequestContext reqCtx, HandlerContext handlerCtx) {
        ArrayList propertyNames = (ArrayList)handlerCtx.getInputValue(PROPERTY_NAMES);
        if (propertyNames == null) {
            throw new IllegalArgumentException("The parameter map did not contain propertyNames");
        }
        ArrayList displayNames = (ArrayList)handlerCtx.getInputValue(DISPLAY_NAMES);
        if (displayNames == null) {
            throw new IllegalArgumentException("The parameter map did not contain displayNames");
        }
        if (displayNames.size() != propertyNames.size()) {
            throw new IllegalArgumentException("displayNames and attributeNames should have same number of entries!");
        }
        ContainerView view = MBeanHandlers.getView(reqCtx, handlerCtx);
        Properties props = new Properties();
        for (int i = 0; i < propertyNames.size(); ++i) {
            String fieldValue = (String)view.getDisplayFieldValue((String)displayNames.get(i));
            if (fieldValue == null || fieldValue == "") continue;
            props.put((String)propertyNames.get(i), fieldValue);
        }
        handlerCtx.setOutputValue(VALUE, (Object)props);
    }

    public void getAttributeListFromNameValues(RequestContext reqCtx, HandlerContext handlerCtx) {
        ArrayList attributeNames = (ArrayList)handlerCtx.getInputValue(ATTRIBUTE_NAMES);
        ArrayList attributeValues = (ArrayList)handlerCtx.getInputValue(ATTRIBUTE_VALUES);
        if (attributeNames == null || attributeValues == null) {
            throw new IllegalArgumentException("The parameter map must contain attributeNames and attributeValues");
        }
        if (attributeValues.size() != attributeNames.size()) {
            throw new IllegalArgumentException("attributeNamesand attributeValues should have same number of entries!");
        }
        AttributeList attrList = new AttributeList();
        for (int i = 0; i < attributeNames.size(); ++i) {
            attrList.add(new Attribute((String)attributeNames.get(i), attributeValues.get(i)));
        }
        handlerCtx.setOutputValue(VALUE, (Object)attrList);
    }

    public void getArrayListFromDisplayFields(RequestContext reqCtx, HandlerContext handlerCtx) {
        ArrayList displayNames = (ArrayList)handlerCtx.getInputValue(DISPLAY_NAMES);
        if (displayNames == null) {
            throw new IllegalArgumentException("The parameter map did not contain displayNames");
        }
        ContainerView view = MBeanHandlers.getView(reqCtx, handlerCtx);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < displayNames.size(); ++i) {
            Object fieldValue = view.getDisplayFieldValue((String)displayNames.get(i));
            if (fieldValue instanceof String && ((String)fieldValue).length() == 0) {
                fieldValue = null;
            }
            arrayList.add(fieldValue);
        }
        handlerCtx.setOutputValue(VALUE, arrayList);
    }

    public void getMapFromDisplayFields(RequestContext reqCtx, HandlerContext handlerCtx) {
        ArrayList displayNames = (ArrayList)handlerCtx.getInputValue(DISPLAY_NAMES);
        ArrayList keyNames = (ArrayList)handlerCtx.getInputValue(ATTRIBUTE_NAMES);
        if (displayNames == null) {
            throw new IllegalArgumentException("The parameter map did not contain displayNames");
        }
        ContainerView view = MBeanHandlers.getView(reqCtx, handlerCtx);
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < displayNames.size(); ++i) {
            Object fieldValue = view.getDisplayFieldValue((String)displayNames.get(i));
            if (fieldValue instanceof String && ((String)fieldValue).length() == 0) {
                fieldValue = null;
            }
            map.put((String)keyNames.get(i), fieldValue);
        }
        handlerCtx.setOutputValue(VALUE, map);
    }

    public void setDisplayFieldsFromAttributeList(RequestContext reqCtx, HandlerContext handlerCtx) {
        Object value = handlerCtx.getInputValue(VALUE);
        if (value == null) {
            return;
        }
        ArrayList attributeNames = (ArrayList)handlerCtx.getInputValue(ATTRIBUTE_NAMES);
        if (attributeNames == null) {
            throw new IllegalArgumentException("The parameter map did not contain attributeNames");
        }
        ArrayList displayNames = (ArrayList)handlerCtx.getInputValue(DISPLAY_NAMES);
        if (displayNames == null) {
            throw new IllegalArgumentException("The parameter map did not contain displayNames");
        }
        if (displayNames.size() != attributeNames.size()) {
            throw new IllegalArgumentException("displayNames and attributeNames should have same number of entries!");
        }
        ContainerView view = MBeanHandlers.getView(reqCtx, handlerCtx);
        AttributeList attrList = (AttributeList)value;
        for (int i = 0; i < displayNames.size(); ++i) {
            int j;
            String attrName = (String)attributeNames.get(i);
            for (j = 0; j < attrList.size() && !((Attribute)attrList.get(j)).getName().equals(attrName); ++j) {
            }
            if (j >= attrList.size()) continue;
            Object attrValue = ((Attribute)attrList.get(j)).getValue();
            view.setDisplayFieldValue((String)displayNames.get(i), attrValue);
        }
    }

    public void setDisplayFieldsFromPropertiesList(RequestContext reqCtx, HandlerContext handlerCtx) {
        Object value = handlerCtx.getInputValue(VALUE);
        if (value == null) {
            return;
        }
        ArrayList propertyNames = (ArrayList)handlerCtx.getInputValue(PROPERTY_NAMES);
        if (propertyNames == null) {
            throw new IllegalArgumentException("The parameter map did not contain propertyNames");
        }
        ArrayList displayNames = (ArrayList)handlerCtx.getInputValue(DISPLAY_NAMES);
        if (displayNames == null) {
            throw new IllegalArgumentException("The parameter map did not contain displayNames");
        }
        if (displayNames.size() != propertyNames.size()) {
            throw new IllegalArgumentException("displayNames and attributeNames should have same number of entries!");
        }
        ContainerView view = MBeanHandlers.getView(reqCtx, handlerCtx);
        Properties props = (Properties)value;
        for (int i = 0; i < displayNames.size(); ++i) {
            String propertyValue = props.getProperty(propertyNames.get(i).toString());
            view.setDisplayFieldValue((String)displayNames.get(i), (Object)propertyValue);
        }
    }

    public void setDisplayFieldsFromList(RequestContext reqCtx, HandlerContext handlerCtx) {
        ArrayList valueList = (ArrayList)handlerCtx.getInputValue("valueList");
        if (valueList == null) {
            throw new IllegalArgumentException("The parameter map did not contain valueList");
        }
        ArrayList displayNames = (ArrayList)handlerCtx.getInputValue(DISPLAY_NAMES);
        if (displayNames == null) {
            throw new IllegalArgumentException("The parameter map did not contain displayNames");
        }
        if (displayNames.size() != valueList.size()) {
            throw new IllegalArgumentException("displayNames and valueList should have same number of entries!");
        }
        ContainerView view = MBeanHandlers.getView(reqCtx, handlerCtx);
        for (int i = 0; i < valueList.size(); ++i) {
            view.setDisplayFieldValue((String)displayNames.get(i), (Object)((String)valueList.get(i)));
        }
    }

    public static ContainerView getView(RequestContext reqCtx, HandlerContext handlerCtx) {
        ViewDescriptor viewDesc = null;
        Object value = handlerCtx.getInputValue(VIEW_DESCRIPTOR_NAME);
        if (value == null) {
            viewDesc = handlerCtx.getViewDescriptor();
        } else {
            ViewDescriptorManager mgr = ViewDescriptorManager.getInstance();
            if (value instanceof List) {
                Iterator it = ((List)value).iterator();
                String key = it.next().toString();
                viewDesc = mgr.getViewDescriptor(key);
                if (viewDesc == null) {
                    throw new IllegalArgumentException("Top-level ViewDescriptor '" + key + "' not found!");
                }
                while (it.hasNext()) {
                    key = it.next().toString();
                    if ((viewDesc = viewDesc.getChildDescriptor(key)) != null) continue;
                    throw new IllegalArgumentException("Child ViewDescriptor '" + key + "' not found!");
                }
            } else {
                if (value instanceof String) {
                    View view = handlerCtx.getView();
                    DescriptorContainerView descView = (DescriptorContainerView)((ViewBase)view).getParentViewBean();
                    return (ContainerView)descView.getChild((String)value);
                }
                throw new IllegalArgumentException("Unknown type for viewDescriptorName. (" + value.toString() + ")");
            }
        }
        View view = viewDesc.getView(reqCtx);
        while (!(view instanceof ContainerView)) {
            view = view.getParent();
        }
        return (ContainerView)view;
    }

    public void getJMXAttributeValue(RequestContext reqCtx, HandlerContext handlerCtx) {
        Object val = handlerCtx.getInputValue("JMXAttribute");
        if (val == null) {
            throw new FrameworkException("The input value for 'JMXAttribute' was not specified.", null, null);
        }
        Attribute att = null;
        if (val instanceof AttributeList) {
            AttributeList list = (AttributeList)val;
            if (list.size() > 0) {
                att = (Attribute)list.get(0);
            }
        } else {
            att = (Attribute)val;
        }
        handlerCtx.setOutputValue(VALUE, att != null ? att.getValue() : null);
    }

    public void restoreDefaultValues(RequestContext reqCtx, HandlerContext handlerCtx) {
        ContainerView view = MBeanHandlers.getView(reqCtx, handlerCtx);
        ArrayList displayNames = (ArrayList)handlerCtx.getInputValue(DISPLAY_NAMES);
        ArrayList modelNames = (ArrayList)handlerCtx.getInputValue(ATTRIBUTE_NAMES);
        String objectName = (String)handlerCtx.getInputValue(OBJECT_NAME);
        Object[] params = new String[1];
        String[] types = new String[]{"java.lang.String"};
        for (int i = 0; i < modelNames.size(); ++i) {
            params[0] = (String)modelNames.get(i);
            String displayName = (String)displayNames.get(i);
            if (view.getDisplayFieldValue(displayName) == null) {
                view.setDisplayFieldValue(displayName, MBeanUtil.getAttribute(objectName, params[0]));
                continue;
            }
            view.setDisplayFieldValue(displayName, MBeanUtil.invoke(objectName, "getDefaultAttributeValue", params, types));
        }
    }
}

