/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.handlers;

import com.iplanet.jato.ModelManager;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.Model;
import com.iplanet.jato.model.ModelControlException;
import com.sun.enterprise.tools.admingui.util.MBeanUtil;
import com.sun.enterprise.tools.admingui.util.Util;
import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.view.DescriptorContainerView;
import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.model.CCActionTableModelInterface;
import java.util.ArrayList;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class WizardHandlers {
    public static final String MODEL_NAMES = "clearModels.modelNames";
    public static final String PROPERTY_NAME = "propertyName";
    public static final String PROPERTY_VALUE = "propertyValue";
    public static final String PROPS_OBJECT_NAME = "resourceName";
    public static final String TABLE_LOAD = "wizard.loadTable";
    public static final String PROP_MODEL = "property.model";
    public static final String PROP_CHILD = "property.child";

    public void create(RequestContext ctx, HandlerContext handlerCtx) {
        DescriptorContainerView descView = (DescriptorContainerView)ctx.getRequest().getAttribute("wizardView");
        ArrayList displayNames = (ArrayList)ctx.getRequest().getAttribute("displayNames");
        ArrayList modelNames = (ArrayList)ctx.getRequest().getAttribute("modelNames");
        String objectName = (String)ctx.getRequest().getAttribute("objectName");
        String methodName = (String)ctx.getRequest().getAttribute("methodName");
        AttributeList attrList = new AttributeList();
        for (int i = 0; i < displayNames.size(); ++i) {
            Attribute attr = new Attribute((String)modelNames.get(i), (String)descView.getDisplayFieldValue((String)displayNames.get(i)));
            attrList.add(attr);
        }
        Object[] params = new Object[]{attrList};
        String[] types = new String[]{"javax.management.AttributeList"};
        try {
            Object obj = MBeanUtil.invoke(objectName, methodName, params, types);
            ObjectName objName = (ObjectName)obj;
            if (Util.isLoggableFINEST()) {
                Util.logFINEST("In create object name is: " + objName.toString());
            }
            ctx.getRequest().setAttribute(PROPS_OBJECT_NAME, (Object)objName.toString());
        }
        catch (Exception ex) {
            throw new FrameworkException((Throwable)ex, descView.getViewDescriptor(), handlerCtx.getView());
        }
    }

    public void saveProperties(RequestContext ctx, HandlerContext handlerCtx) throws ModelControlException {
        DescriptorContainerView descView = (DescriptorContainerView)ctx.getRequest().getAttribute("wizardView");
        CCActionTableModelInterface model = (CCActionTableModelInterface)ctx.getRequest().getAttribute("wizardTableModel");
        String objectName = (String)ctx.getRequest().getAttribute(PROPS_OBJECT_NAME);
        if (Util.isLoggableFINEST()) {
            Util.logFINEST("In save object name is: " + objectName);
        }
        model.setRowSelectionType("multiple");
        model.beforeFirst();
        AttributeList attrs = new AttributeList();
        String[] type = new String[]{"javax.management.Attribute"};
        try {
            while (model.next()) {
                String name = (String)model.getValue(PROPERTY_NAME);
                String value = (String)model.getValue(PROPERTY_VALUE);
                if (name == null || name.trim().equals("")) continue;
                Object[] params = new Object[]{new Attribute(name, value)};
                MBeanUtil.invoke(objectName, "setProperty", params, type);
            }
        }
        catch (Exception ex) {
            throw new FrameworkException((Throwable)ex, descView.getViewDescriptor(), handlerCtx.getView());
        }
    }

    public void isTableLoaded(RequestContext ctx, HandlerContext handlerCtx) {
        boolean tL = false;
        if (ctx.getRequest().getAttribute(TABLE_LOAD) != null) {
            tL = new Boolean("" + ctx.getRequest().getAttribute(TABLE_LOAD));
        }
        if (tL) {
            ctx.getRequest().setAttribute(TABLE_LOAD, (Object)"true");
        } else {
            ctx.getRequest().setAttribute(TABLE_LOAD, (Object)"false");
        }
    }

    public void addProperty(RequestContext ctx, HandlerContext handlerCtx) {
        HttpServletRequest req = ctx.getRequest();
        DescriptorContainerView descView = (DescriptorContainerView)req.getAttribute(PROP_CHILD);
        if (descView == null) {
            throw new FrameworkException("addPropertyTest: 'child' attributes were null!", null, handlerCtx.getView());
        }
        CCActionTableModelInterface model = (CCActionTableModelInterface)req.getAttribute(PROP_MODEL);
        if (Util.isLoggableFINEST()) {
            Util.logFINEST("**MODEL IS: " + model);
        }
        try {
            if (model != null && model instanceof DefaultModel) {
                model.last();
                if (Util.isLoggableFINEST()) {
                    StringBuffer buf = new StringBuffer();
                    buf.append("MODEL IS NOT NULL:\n");
                    buf.append("**Number of rows: " + model.getNumRows() + "***");
                    buf.append("**Last row index: " + ((CCActionTableModel)model).getLastRowIndex() + "***");
                    Util.logFINEST(buf.toString());
                }
                model.appendRow();
                ((CCActionTableModel)model).sort();
                model.setValue(PROPERTY_NAME, (Object)"");
                model.setValue(PROPERTY_VALUE, (Object)"");
                if (Util.isLoggableFINEST()) {
                    Util.logFINEST("***Number of rows: " + model.getNumRows() + "***");
                }
                model.beforeFirst();
            } else if (Util.isLoggableFINEST()) {
                Util.logFINEST("MODEL IS NULL");
            }
        }
        catch (Exception ex) {
            throw new FrameworkException((Throwable)ex, descView.getViewDescriptor(), handlerCtx.getView());
        }
        descView.forwardTo(ctx);
    }

    public void deleteProperties(RequestContext ctx, HandlerContext handlerCtx) {
        HttpServletRequest req = ctx.getRequest();
        DescriptorContainerView descView = (DescriptorContainerView)req.getAttribute(PROP_CHILD);
        CCActionTableModelInterface model = (CCActionTableModelInterface)req.getAttribute(PROP_MODEL);
        if (Util.isLoggableFINEST()) {
            Util.logFINEST("Model name is: " + model);
        }
        model.setRowSelectionType("multiple");
        try {
            model.beforeFirst();
            AttributeList attrs = new AttributeList();
            while (model.next()) {
                if (model.isRowSelected()) continue;
                String name = (String)model.getValue(PROPERTY_NAME);
                String value = (String)model.getValue(PROPERTY_VALUE);
                if (Util.isLoggableFINEST()) {
                    Util.logFINEST("Property '" + name + "' with value '" + value + "' not selected.");
                }
                if (name == null || name.trim().equals("")) continue;
                attrs.add(new Attribute(name, value));
            }
            ((DefaultModel)model).clear();
            if (attrs != null) {
                for (int props = 0; props < attrs.size(); ++props) {
                    Attribute attr = (Attribute)attrs.get(props);
                    Object attrValue = attr.getValue();
                    String attrName = attr.getName();
                    model.appendRow();
                    ((CCActionTableModel)model).sort();
                    model.setValue(PROPERTY_NAME, (Object)attr.getName());
                    model.setValue(PROPERTY_VALUE, attr.getValue());
                    model.setRowSelected(false);
                }
            }
        }
        catch (Exception ex) {
            throw new FrameworkException((Throwable)ex, descView.getViewDescriptor(), handlerCtx.getView());
        }
    }

    public void clearModels(RequestContext ctx, HandlerContext handlerCtx) {
        HttpServletRequest req = ctx.getRequest();
        Object obj = req.getAttribute(MODEL_NAMES);
        if (obj == null) {
            throw new FrameworkException("You must specifiy 'clearModels.modelNames' to remove from Session.");
        }
        if (obj instanceof String) {
            ArrayList list = new ArrayList();
            list.add(obj);
            obj = list;
        }
        if (!(obj instanceof List)) {
            throw new FrameworkException("'clearModels.modelNames' must be a java.util.List!");
        }
        String[] names = ((List)obj).toArray(new String[((List)obj).size()]);
        HttpSession session = req.getSession();
        ModelManager modelMgr = ctx.getModelManager();
        Model model = null;
        for (int count = 0; count < names.length; ++count) {
            obj = session.getAttribute(names[count]);
            if (obj == null) continue;
            model = (Model)obj;
            if (model instanceof DefaultModel) {
                ((DefaultModel)model).clear();
            }
            modelMgr.removeFromSession(model);
        }
    }
}

