/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.jsfext.layout.xml;

import com.sun.enterprise.tools.jsfext.event.handlers.Handler;
import com.sun.enterprise.tools.jsfext.event.handlers.HandlerDefinition;
import com.sun.enterprise.tools.jsfext.event.handlers.IODescriptor;
import com.sun.enterprise.tools.jsfext.layout.descriptor.ComponentType;
import com.sun.enterprise.tools.jsfext.layout.descriptor.LayoutAttribute;
import com.sun.enterprise.tools.jsfext.layout.descriptor.LayoutComponent;
import com.sun.enterprise.tools.jsfext.layout.descriptor.LayoutDefinition;
import com.sun.enterprise.tools.jsfext.layout.descriptor.LayoutElement;
import com.sun.enterprise.tools.jsfext.layout.descriptor.LayoutElementBase;
import com.sun.enterprise.tools.jsfext.layout.descriptor.LayoutFacet;
import com.sun.enterprise.tools.jsfext.layout.descriptor.LayoutForEach;
import com.sun.enterprise.tools.jsfext.layout.descriptor.LayoutIf;
import com.sun.enterprise.tools.jsfext.layout.descriptor.LayoutMarkup;
import com.sun.enterprise.tools.jsfext.layout.descriptor.LayoutStaticText;
import com.sun.enterprise.tools.jsfext.layout.descriptor.LayoutWhile;
import com.sun.enterprise.tools.jsfext.layout.descriptor.Resource;
import com.sun.enterprise.tools.jsfext.util.IncludeInputStream;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class XMLLayoutDefinitionReader {
    public static final String ATTRIBUTE_ELEMENT = "attribute";
    public static final String COMPONENT_ELEMENT = "component";
    public static final String COMPONENT_TYPE_ELEMENT = "componenttype";
    public static final String EDIT_ELEMENT = "edit";
    public static final String EVENT_ELEMENT = "event";
    public static final String FACET_ELEMENT = "facet";
    public static final String FOREACH_ELEMENT = "foreach";
    public static final String HANDLER_ELEMENT = "handler";
    public static final String HANDLERS_ELEMENT = "handlers";
    public static final String HANDLER_DEFINITION_ELEMENT = "handlerdefinition";
    public static final String IF_ELEMENT = "if";
    public static final String INPUT_DEF_ELEMENT = "inputdef";
    public static final String INPUT_ELEMENT = "input";
    public static final String LAYOUT_DEFINITION_ELEMENT = "layoutdefinition";
    public static final String LAYOUT_ELEMENT = "layout";
    public static final String LIST_ELEMENT = "list";
    public static final String MARKUP_ELEMENT = "markup";
    public static final String OPTION_ELEMENT = "option";
    public static final String OUTPUT_DEF_ELEMENT = "outputdef";
    public static final String OUTPUT_MAPPING_ELEMENT = "outputmapping";
    public static final String STATIC_TEXT_ELEMENT = "statictext";
    public static final String TYPES_ELEMENT = "types";
    public static final String RESOURCES_ELEMENT = "resources";
    public static final String RESOURCE_ELEMENT = "resource";
    public static final String WHILE_ELEMENT = "while";
    public static final String CLASS_NAME_ATTRIBUTE = "classname";
    public static final String CONDITION_ATTRIBUTE = "condition";
    public static final String DEFAULT_ATTRIBUTE = "default";
    public static final String DESCRIPTION_ATTRIBUTE = "description";
    public static final String EXTRA_INFO_ATTRIBUTE = "extrainfo";
    public static final String FACTORY_CLASS_ATTRIBUTE = "factoryclass";
    public static final String ID_ATTRIBUTE = "id";
    public static final String KEY_ATTRIBUTE = "key";
    public static final String LIST_ATTRIBUTE = "list";
    public static final String METHOD_NAME_ATTRIBUTE = "methodname";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String OUTPUT_NAME_ATTRIBUTE = "outputname";
    public static final String OVERWRITE_ATTRIBUTE = "overwrite";
    public static final String PROPERTY_ATTRIBUTE = "property";
    public static final String RENDERED_ATTRIBUTE = "rendered";
    public static final String REQUIRED_ATTRIBUTE = "required";
    public static final String TAG_ATTRIBUTE = "tag";
    public static final String TARGET_KEY_ATTRIBUTE = "targetkey";
    public static final String TARGET_TYPE_ATTRIBUTE = "targettype";
    public static final String TYPE_ATTRIBUTE = "type";
    public static final String VALUE_ATTRIBUTE = "value";
    public static final String AUTO_RENDERED = "auto";
    public static final String EDITABLE = "editableContent";
    public static final String EDIT_MENU = "editMenu";
    public static final String EDIT_AREA_TYPE = "editArea";
    public static final String POPUP_MENU_TYPE = "popupMenu";
    public static final String EDIT_AREA_TYPE_CLASS = "com.sun.enterprise.tools.jsfext.component.factory.basic.EditAreaFactory";
    public static final String MARKUP_FACTORY_CLASS = "com.sun.enterprise.tools.jsfext.component.factory.basic.MarkupFactory";
    public static final String POPUP_MENU_TYPE_CLASS = "com.sun.enterprise.tools.jsfext.component.factory.basic.PopupMenuFactory";
    private URL _url = null;
    private EntityResolver _entityResolver = null;
    private ErrorHandler _errorHandler = null;
    private String _baseURI = null;
    private Map _handlerDefs = new HashMap();
    private int _markupCount = 1;

    public XMLLayoutDefinitionReader(URL url, EntityResolver entityResolver, ErrorHandler errorHandler, String baseURI) {
        this._url = url;
        this._entityResolver = entityResolver;
        this._errorHandler = errorHandler;
        this._baseURI = baseURI;
    }

    public URL getURL() {
        return this._url;
    }

    public EntityResolver getEntityResolver() {
        return this._entityResolver;
    }

    public ErrorHandler getErrorHandler() {
        return this._errorHandler;
    }

    public String getBaseURI() {
        return this._baseURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LayoutDefinition read() throws IOException {
        IncludeInputStream inputStream = new IncludeInputStream(new BufferedInputStream(this.getURL().openStream()));
        Document doc = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setValidating(true);
            dbf.setIgnoringComments(true);
            dbf.setIgnoringElementContentWhitespace(false);
            dbf.setCoalescing(false);
            dbf.setExpandEntityReferences(true);
            DocumentBuilder db = null;
            try {
                db = dbf.newDocumentBuilder();
            }
            catch (ParserConfigurationException ex) {
                throw new RuntimeException(ex);
            }
            if (this.getEntityResolver() != null) {
                db.setEntityResolver(this.getEntityResolver());
            }
            if (this.getErrorHandler() != null) {
                db.setErrorHandler(this.getErrorHandler());
            }
            try {
                doc = db.parse(inputStream, this.getBaseURI());
            }
            catch (SAXException ex) {
                throw new RuntimeException(ex);
            }
        }
        finally {
            try {
                ((InputStream)inputStream).close();
            }
            catch (Exception exception) {}
        }
        return this.createLayoutDefinition(doc);
    }

    private LayoutDefinition createLayoutDefinition(Document doc) {
        Element node = doc.getDocumentElement();
        if (!node.getNodeName().equalsIgnoreCase(LAYOUT_DEFINITION_ELEMENT)) {
            throw new RuntimeException("Document Element must be 'layoutdefinition'");
        }
        LayoutDefinition ld = new LayoutDefinition("");
        List childElements = this.getChildElements(node, RESOURCES_ELEMENT);
        Iterator it = childElements.iterator();
        if (it.hasNext()) {
            this.addResources(ld, (Node)it.next());
        }
        if ((it = (childElements = this.getChildElements(node, TYPES_ELEMENT)).iterator()).hasNext()) {
            this.addTypes(ld, (Node)it.next());
        }
        if ((it = (childElements = this.getChildElements(node, HANDLERS_ELEMENT)).iterator()).hasNext()) {
            this.cacheHandlerDefs((Node)it.next());
        }
        if ((it = (childElements = this.getChildElements(node, EVENT_ELEMENT)).iterator()).hasNext()) {
            Node eventNode = (Node)it.next();
            String type = (String)this.getAttributes(eventNode).get(TYPE_ATTRIBUTE);
            List handlers = ld.getHandlers(type);
            ld.setHandlers(type, this.getHandlers(eventNode, handlers));
        }
        if (!(it = (childElements = this.getChildElements(node, LAYOUT_ELEMENT)).iterator()).hasNext()) {
            throw new RuntimeException("A 'layout' element is required in the XML document!");
        }
        this.addChildLayoutElements(ld, (Node)it.next());
        return ld;
    }

    private void addResources(LayoutDefinition ld, Node node) {
        Iterator it = this.getChildElements(node, RESOURCE_ELEMENT).iterator();
        while (it.hasNext()) {
            ld.addResource(this.createResource((Node)it.next()));
        }
    }

    private Resource createResource(Node node) {
        Map attributes = this.getAttributes(node);
        String id = (String)attributes.get(ID_ATTRIBUTE);
        String extraInfo = (String)attributes.get(EXTRA_INFO_ATTRIBUTE);
        String factoryClass = (String)attributes.get(FACTORY_CLASS_ATTRIBUTE);
        if (factoryClass == null || id == null || extraInfo == null || factoryClass.trim().equals("") || id.trim().equals("") || extraInfo.trim().equals("")) {
            throw new RuntimeException("'id', 'extrainfo', and 'factoryclass' are required attributes of 'resource' Element!");
        }
        return new Resource(id, extraInfo, factoryClass);
    }

    private void addTypes(LayoutDefinition ld, Node node) {
        Iterator it = this.getChildElements(node, COMPONENT_TYPE_ELEMENT).iterator();
        while (it.hasNext()) {
            ld.addComponentType(this.createComponentType((Node)it.next()));
        }
    }

    private ComponentType createComponentType(Node node) {
        Map attributes = this.getAttributes(node);
        String id = (String)attributes.get(ID_ATTRIBUTE);
        String factoryClass = (String)attributes.get(FACTORY_CLASS_ATTRIBUTE);
        if (factoryClass == null || id == null || factoryClass.trim().equals("") || id.trim().equals("")) {
            throw new RuntimeException("Both 'id' and 'factoryclass' are required attributes of 'componenttype' Element!");
        }
        return new ComponentType(id, factoryClass);
    }

    private void cacheHandlerDefs(Node node) {
        HandlerDefinition def = null;
        Iterator it = this.getChildElements(node, HANDLER_DEFINITION_ELEMENT).iterator();
        while (it.hasNext()) {
            def = this.createHandlerDefinition((Node)it.next());
            this._handlerDefs.put(def.getId(), def);
        }
    }

    public HandlerDefinition createHandlerDefinition(Node node) {
        Map attributes = this.getAttributes(node);
        String value = (String)attributes.get(ID_ATTRIBUTE);
        HandlerDefinition hd = new HandlerDefinition(value);
        value = (String)attributes.get(CLASS_NAME_ATTRIBUTE);
        if (value != null && !value.equals("")) {
            String tmpStr = (String)attributes.get(METHOD_NAME_ATTRIBUTE);
            if (tmpStr == null || tmpStr.equals("")) {
                throw new IllegalArgumentException("You must provide a 'methodname' attribute on the 'handlerdefinition' element with classname atttribute equal to '" + value + "'.");
            }
            hd.setHandlerMethod(value, tmpStr);
        }
        List handlers = hd.getChildHandlers();
        hd.setChildHandlers(this.getHandlers(node, handlers));
        this.addInputDefs(hd, node);
        this.addOutputDefs(hd, node);
        return hd;
    }

    private List getHandlers(Node node, List handlers) {
        Iterator it = this.getChildElements(node, HANDLER_ELEMENT).iterator();
        if (handlers == null) {
            handlers = new ArrayList<Handler>();
        }
        while (it.hasNext()) {
            handlers.add(this.createHandler((Node)it.next()));
        }
        return handlers;
    }

    private Handler createHandler(Node handlerNode) {
        String id = (String)this.getAttributes(handlerNode).get(ID_ATTRIBUTE);
        if (id == null || id.trim().equals("")) {
            throw new RuntimeException("'id' attribute not found on 'handler' Element!");
        }
        HandlerDefinition handlerDef = (HandlerDefinition)this._handlerDefs.get(id);
        if (handlerDef == null) {
            throw new IllegalArgumentException("handler elements id attribute must match the id attribute of a handlerdefinition.  A HANDLER_ELEMENT with '" + id + "' was specified, however there is no cooresponding " + HANDLER_DEFINITION_ELEMENT + " with a matching " + ID_ATTRIBUTE + " attribute.");
        }
        Handler handler = new Handler(handlerDef);
        Map attributes = null;
        Node inputNode2 = null;
        for (Node inputNode2 : this.getChildElements(handlerNode, INPUT_ELEMENT)) {
            attributes = this.getAttributes(inputNode2);
            handler.setInputValue((String)attributes.get(NAME_ATTRIBUTE), this.getValueFromNode(inputNode2, attributes));
        }
        Iterator it = this.getChildElements(handlerNode, OUTPUT_MAPPING_ELEMENT).iterator();
        while (it.hasNext()) {
            attributes = this.getAttributes((Node)it.next());
            handler.setOutputMapping((String)attributes.get(OUTPUT_NAME_ATTRIBUTE), (String)attributes.get(TARGET_KEY_ATTRIBUTE), (String)attributes.get(TARGET_TYPE_ATTRIBUTE));
        }
        return handler;
    }

    private void addInputDefs(HandlerDefinition hd, Node hdNode) {
        Iterator it = this.getChildElements(hdNode, INPUT_DEF_ELEMENT).iterator();
        while (it.hasNext()) {
            hd.addInputDef(this.createIODescriptor((Node)it.next()));
        }
    }

    private void addOutputDefs(HandlerDefinition hd, Node hdNode) {
        Iterator it = this.getChildElements(hdNode, OUTPUT_DEF_ELEMENT).iterator();
        while (it.hasNext()) {
            hd.addOutputDef(this.createIODescriptor((Node)it.next()));
        }
    }

    private IODescriptor createIODescriptor(Node node) {
        Map attributes = this.getAttributes(node);
        String name = (String)attributes.get(NAME_ATTRIBUTE);
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("Name must be provided!");
        }
        String type = (String)attributes.get(TYPE_ATTRIBUTE);
        if (type == null || type.equals("")) {
            throw new IllegalArgumentException("Type must be provided!");
        }
        Object def = attributes.get(DEFAULT_ATTRIBUTE);
        String req = (String)attributes.get(REQUIRED_ATTRIBUTE);
        IODescriptor ioDesc = new IODescriptor(name, type);
        ioDesc.setDefault(def);
        if (req != null) {
            ioDesc.setRequired(Boolean.valueOf(req));
        }
        return ioDesc;
    }

    private void addChildLayoutElements(LayoutElement layElt, Node node) {
        Iterator it = this.getChildElements(node).iterator();
        Node childNode = null;
        String name = null;
        while (it.hasNext()) {
            childNode = (Node)it.next();
            name = childNode.getNodeName();
            if (name.equalsIgnoreCase(IF_ELEMENT)) {
                layElt.addChildLayoutElement(this.createLayoutIf(layElt, childNode));
                continue;
            }
            if (name.equalsIgnoreCase(ATTRIBUTE_ELEMENT)) {
                LayoutElement childElt = this.createLayoutAttribute(layElt, childNode);
                if (childElt == null) continue;
                layElt.addChildLayoutElement(childElt);
                continue;
            }
            if (name.equalsIgnoreCase(MARKUP_ELEMENT)) {
                layElt.addChildLayoutElement(this.createLayoutMarkup(layElt, childNode));
                continue;
            }
            if (name.equalsIgnoreCase(FACET_ELEMENT)) {
                layElt.addChildLayoutElement(this.createLayoutFacet(layElt, childNode));
                continue;
            }
            if (name.equalsIgnoreCase(STATIC_TEXT_ELEMENT)) {
                layElt.addChildLayoutElement(this.createLayoutStaticText(layElt, childNode));
                continue;
            }
            if (name.equalsIgnoreCase(COMPONENT_ELEMENT)) {
                layElt.addChildLayoutElement(this.createLayoutComponent(layElt, childNode));
                continue;
            }
            if (name.equalsIgnoreCase(EVENT_ELEMENT)) {
                name = (String)this.getAttributes(childNode).get(TYPE_ATTRIBUTE);
                List handlers = layElt.getHandlers(name);
                layElt.setHandlers(name, this.getHandlers(childNode, handlers));
                continue;
            }
            if (name.equalsIgnoreCase(FOREACH_ELEMENT)) {
                layElt.addChildLayoutElement(this.createLayoutForEach(layElt, childNode));
                continue;
            }
            if (name.equalsIgnoreCase(WHILE_ELEMENT)) {
                layElt.addChildLayoutElement(this.createLayoutWhile(layElt, childNode));
                continue;
            }
            if (name.equalsIgnoreCase(EDIT_ELEMENT)) {
                layElt.addChildLayoutElement(this.createEditLayoutComponent(layElt, childNode));
                continue;
            }
            throw new RuntimeException("Unknown Element Found: '" + childNode.getNodeName() + "' under '" + node.getNodeName() + "'.");
        }
    }

    private LayoutElement createLayoutIf(LayoutElement parent, Node node) {
        String condition = (String)this.getAttributes(node).get(CONDITION_ATTRIBUTE);
        if (condition == null || condition.trim().equals("")) {
            throw new RuntimeException("'condition' attribute not found on 'if' Element!");
        }
        LayoutIf ifElt = new LayoutIf(parent, condition);
        this.addChildLayoutElements(ifElt, node);
        return ifElt;
    }

    private LayoutElement createLayoutForEach(LayoutElement parent, Node node) {
        String list = (String)this.getAttributes(node).get("list");
        if (list == null || list.trim().equals("")) {
            throw new RuntimeException("'list' attribute not found on 'foreach' Element!");
        }
        String key = (String)this.getAttributes(node).get(KEY_ATTRIBUTE);
        if (key == null || key.trim().equals("")) {
            throw new RuntimeException("'key' attribute not found on 'foreach' Element!");
        }
        LayoutForEach forEachElt = new LayoutForEach(parent, list, key);
        this.addChildLayoutElements(forEachElt, node);
        return forEachElt;
    }

    private LayoutElement createLayoutWhile(LayoutElement parent, Node node) {
        String condition = (String)this.getAttributes(node).get(CONDITION_ATTRIBUTE);
        if (condition == null || condition.trim().equals("")) {
            throw new RuntimeException("'condition' attribute not found on 'while' Element!");
        }
        LayoutWhile whileElt = new LayoutWhile(parent, condition);
        this.addChildLayoutElements(whileElt, node);
        return whileElt;
    }

    private LayoutElement createLayoutAttribute(LayoutElement parent, Node node) {
        Map attributes = this.getAttributes(node);
        String name = (String)attributes.get(NAME_ATTRIBUTE);
        if (name == null || name.trim().equals("")) {
            throw new RuntimeException("'name' attribute not found on 'attribute' Element!");
        }
        LayoutAttribute attributeElt = null;
        LayoutComponent comp = null;
        comp = parent instanceof LayoutComponent ? (LayoutComponent)parent : XMLLayoutDefinitionReader.getParentLayoutComponent(parent);
        if (comp != null) {
            this.addOption(comp, node);
        } else {
            String value = (String)attributes.get(VALUE_ATTRIBUTE);
            String property = (String)attributes.get(PROPERTY_ATTRIBUTE);
            attributeElt = new LayoutAttribute(parent, name, value, property);
            this.addChildLayoutElements(attributeElt, node);
        }
        return attributeElt;
    }

    private LayoutElement createLayoutMarkup(LayoutElement parent, Node node) {
        Map attributes = this.getAttributes(node);
        String tag = (String)attributes.get(TAG_ATTRIBUTE);
        if (tag == null || tag.trim().equals("")) {
            throw new RuntimeException("'tag' attribute not found on 'markup' Element!");
        }
        LayoutElementBase markupElt = null;
        if (parent instanceof LayoutComponent || XMLLayoutDefinitionReader.isNestedLayoutComponent(parent)) {
            ComponentType type = this.ensureMarkupType(parent);
            markupElt = new LayoutComponent(parent, MARKUP_ELEMENT + this._markupCount++, type);
            LayoutComponent markupComp = (LayoutComponent)markupElt;
            markupComp.addOption(TAG_ATTRIBUTE, tag);
            markupComp.setNested(true);
            markupComp.setFacetChild(false);
            this.addChildLayoutComponentChildren(markupComp, node);
        } else {
            String type = (String)attributes.get(TYPE_ATTRIBUTE);
            markupElt = new LayoutMarkup(parent, tag, type);
            this.addChildLayoutElements(markupElt, node);
        }
        return markupElt;
    }

    private LayoutElement createLayoutFacet(LayoutElement parent, Node node) {
        String id = (String)this.getAttributes(node).get(ID_ATTRIBUTE);
        if (id == null || id.trim().equals("")) {
            throw new RuntimeException("'id' attribute not found on 'facet' Element!");
        }
        LayoutFacet facetElt = new LayoutFacet(parent, id);
        String rendered = (String)this.getAttributes(node).get(RENDERED_ATTRIBUTE);
        boolean isRendered = true;
        isRendered = rendered == null || rendered.trim().equals("") || rendered.equals(AUTO_RENDERED) ? !XMLLayoutDefinitionReader.isNestedLayoutComponent(facetElt) : Boolean.getBoolean(rendered);
        facetElt.setRendered(isRendered);
        this.addChildLayoutElements(facetElt, node);
        return facetElt;
    }

    private static boolean isLayoutComponentChild(LayoutElement elt) {
        for (elt = elt.getParent(); elt != null; elt = elt.getParent()) {
            if (elt instanceof LayoutComponent) {
                return true;
            }
            if (!(elt instanceof LayoutFacet)) continue;
            return false;
        }
        return false;
    }

    public static boolean isNestedLayoutComponent(LayoutElement elt) {
        return XMLLayoutDefinitionReader.getParentLayoutComponent(elt) != null;
    }

    private LayoutElement createLayoutComponent(LayoutElement parent, Node node) {
        Map attributes = this.getAttributes(node);
        String id = (String)attributes.get(ID_ATTRIBUTE);
        String type = (String)attributes.get(TYPE_ATTRIBUTE);
        if (type == null || type.trim().equals("")) {
            throw new RuntimeException("'type' attribute not found on 'component' Element!");
        }
        LayoutComponent component = new LayoutComponent(parent, id, this.getComponentType(parent, type));
        String overwrite = (String)attributes.get(OVERWRITE_ATTRIBUTE);
        if (overwrite != null && overwrite.length() > 0) {
            component.setOverwrite(Boolean.valueOf(overwrite));
        }
        component.setNested(XMLLayoutDefinitionReader.isNestedLayoutComponent(component));
        if (XMLLayoutDefinitionReader.isLayoutComponentChild(component)) {
            component.setFacetChild(false);
        } else {
            while (parent != null) {
                if (parent instanceof LayoutFacet) {
                    if (!XMLLayoutDefinitionReader.isLayoutComponentChild(parent)) break;
                    id = parent.getUnevaluatedId();
                    break;
                }
                parent = parent.getParent();
            }
            component.addOption("_facetName", id);
        }
        this.addChildLayoutComponentChildren(component, node);
        return component;
    }

    private void addChildLayoutComponentChildren(LayoutComponent component, Node node) {
        Iterator it = this.getChildElements(node).iterator();
        Node childNode = null;
        String name = null;
        while (it.hasNext()) {
            childNode = (Node)it.next();
            name = childNode.getNodeName();
            if (name.equalsIgnoreCase(COMPONENT_ELEMENT)) {
                component.addChildLayoutElement(this.createLayoutComponent(component, childNode));
                continue;
            }
            if (name.equalsIgnoreCase(FACET_ELEMENT)) {
                component.addChildLayoutElement(this.createLayoutFacet(component, childNode));
                continue;
            }
            if (name.equalsIgnoreCase(OPTION_ELEMENT)) {
                this.addOption(component, childNode);
                continue;
            }
            if (name.equalsIgnoreCase(EVENT_ELEMENT)) {
                name = (String)this.getAttributes(childNode).get(TYPE_ATTRIBUTE);
                List handlers = component.getHandlers(name);
                component.setHandlers(name, this.getHandlers(childNode, handlers));
                continue;
            }
            if (name.equalsIgnoreCase(EDIT_ELEMENT)) {
                component.addChildLayoutElement(this.createEditLayoutComponent(component, childNode));
                continue;
            }
            if (name.equalsIgnoreCase(MARKUP_ELEMENT)) {
                component.addChildLayoutElement(this.createLayoutMarkup(component, childNode));
                continue;
            }
            if (name.equalsIgnoreCase(ATTRIBUTE_ELEMENT)) {
                this.createLayoutAttribute(component, childNode);
                continue;
            }
            throw new RuntimeException("Unknown Element Found: '" + childNode.getNodeName() + "' under '" + COMPONENT_ELEMENT + "'.");
        }
    }

    private LayoutElement createEditLayoutComponent(LayoutElement parent, Node node) {
        parent = this.createEditPopupMenuLayoutComponent(parent, node);
        Map attributes = this.getAttributes(node);
        String id = (String)attributes.get(ID_ATTRIBUTE);
        ComponentType type = this.ensureEditAreaType(parent);
        LayoutComponent component = new LayoutComponent(parent, EDITABLE + id, type);
        parent.addChildLayoutElement(component);
        component.setNested(XMLLayoutDefinitionReader.isNestedLayoutComponent(component));
        component.setFacetChild(false);
        component.addOption(EDITABLE, Boolean.TRUE);
        this.addChildLayoutComponentChildren(component, node);
        return parent;
    }

    private LayoutElement createEditPopupMenuLayoutComponent(LayoutElement parent, Node node) {
        Map attributes = this.getAttributes(node);
        String id = (String)attributes.get(ID_ATTRIBUTE);
        ComponentType type = this.ensurePopupMenuType(parent);
        LayoutComponent popupMenu = new LayoutComponent(parent, EDIT_MENU + id, type);
        popupMenu.setNested(XMLLayoutDefinitionReader.isNestedLayoutComponent(popupMenu));
        popupMenu.setFacetChild(false);
        return popupMenu;
    }

    private ComponentType ensurePopupMenuType(LayoutElement elt) {
        LayoutDefinition ld = elt.getLayoutDefinition();
        ComponentType type = ld.getComponentType(POPUP_MENU_TYPE);
        if (type == null) {
            type = new ComponentType(POPUP_MENU_TYPE, POPUP_MENU_TYPE_CLASS);
            ld.addComponentType(type);
        }
        return type;
    }

    private ComponentType ensureEditAreaType(LayoutElement elt) {
        LayoutDefinition ld = elt.getLayoutDefinition();
        ComponentType type = ld.getComponentType(EDIT_AREA_TYPE);
        if (type == null) {
            type = new ComponentType(EDIT_AREA_TYPE, EDIT_AREA_TYPE_CLASS);
            ld.addComponentType(type);
        }
        return type;
    }

    private ComponentType ensureMarkupType(LayoutElement elt) {
        LayoutDefinition ld = elt.getLayoutDefinition();
        ComponentType type = ld.getComponentType(MARKUP_ELEMENT);
        if (type == null) {
            type = new ComponentType(MARKUP_ELEMENT, MARKUP_FACTORY_CLASS);
            ld.addComponentType(type);
        }
        return type;
    }

    private void addOption(LayoutComponent component, Node node) {
        Map attributes = this.getAttributes(node);
        String name = (String)attributes.get(NAME_ATTRIBUTE);
        if (name == null || name.trim().equals("")) {
            throw new RuntimeException("'name' attribute not found on 'option' Element!");
        }
        name = name.trim();
        Object value = this.getValueFromNode(node, attributes);
        component.addOption(name, value);
    }

    private Object getValueFromNode(Node node, Map attributes) {
        Object value = attributes.get(VALUE_ATTRIBUTE);
        if (value == null) {
            ArrayList list = new ArrayList();
            Iterator it = this.getChildElements(node, "list").iterator();
            while (it.hasNext()) {
                list.add(this.getAttributes((Node)it.next()).get(VALUE_ATTRIBUTE));
            }
            if (list.size() > 0) {
                value = list;
            }
        }
        return value;
    }

    private LayoutElement createLayoutStaticText(LayoutElement parent, Node node) {
        LayoutStaticText text = new LayoutStaticText(parent, "", this.getTextNodesAsString(node));
        return text;
    }

    public List getChildElements(Node node) {
        return this.getChildElements(node, null);
    }

    public List getChildElements(Node node, String name) {
        NodeList nodes = node.getChildNodes();
        if (nodes == null) {
            return new ArrayList(0);
        }
        ArrayList<Node> list = new ArrayList<Node>();
        Node childNode = null;
        for (int idx = 0; idx < nodes.getLength(); ++idx) {
            childNode = nodes.item(idx);
            if (childNode.getNodeType() != 1 || name != null && !childNode.getNodeName().equalsIgnoreCase(name)) continue;
            list.add(childNode);
        }
        return list;
    }

    public String getTextNodesAsString(Node node) {
        NodeList nodes = node.getChildNodes();
        if (nodes == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer("");
        Node childNode = null;
        for (int idx = 0; idx < nodes.getLength(); ++idx) {
            childNode = nodes.item(idx);
            if (childNode.getNodeType() != 3 && childNode.getNodeType() != 4) continue;
            buf.append(childNode.getNodeValue());
        }
        return buf.toString();
    }

    public Map getAttributes(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes == null || attributes.getLength() == 0) {
            return new HashMap(0);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Node attNode = null;
        for (int idx = 0; idx < attributes.getLength(); ++idx) {
            attNode = attributes.item(idx);
            map.put(attNode.getNodeName().toLowerCase(), attNode.getNodeValue());
        }
        return map;
    }

    public ComponentType getComponentType(LayoutElement elt, String type) {
        ComponentType componentType = elt.getLayoutDefinition().getComponentType(type);
        if (componentType == null) {
            throw new IllegalArgumentException("ComponentType '" + type + "' not defined!");
        }
        return componentType;
    }

    public static LayoutComponent getParentLayoutComponent(LayoutElement elt) {
        for (elt = elt.getParent(); elt != null; elt = elt.getParent()) {
            if (!(elt instanceof LayoutComponent)) continue;
            return (LayoutComponent)elt;
        }
        return null;
    }
}

