/*
 * Decompiled with CFR 0.152.
 */
package com.sun.genericra.inbound;

import com.sun.genericra.inbound.InboundJmsResourcePool;
import com.sun.genericra.util.ExceptionUtils;
import com.sun.genericra.util.LogUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;

public class DeadMessageProducer {
    private Session session;
    private String destinationType;
    private MessageProducer producer;
    private static Logger logger = LogUtils.getLogger();

    public DeadMessageProducer(Connection con, InboundJmsResourcePool pool, Destination dest) throws JMSException {
        this.destinationType = pool.getConsumer().getSpec().getDeadMessageDestinationType();
        logger.log(Level.FINE, "DeadMessageDestinationType is obtained for message sender : " + this.destinationType);
        this.createSession(con);
        this.createProducer(dest);
    }

    private void createSession(Connection con) throws JMSException {
        this.session = this.destinationType.equals("javax.jms.Queue") ? ((QueueConnection)con).createQueueSession(false, 1) : (this.destinationType.equals("javax.jms.Topic") ? ((TopicConnection)con).createTopicSession(false, 1) : con.createSession(false, 1));
    }

    private void createProducer(Destination dest) throws JMSException {
        this.producer = this.destinationType.equals("javax.jms.Queue") ? ((QueueSession)this.session).createSender((Queue)dest) : (this.destinationType.equals("javax.jms.Topic") ? ((TopicSession)this.session).createPublisher((Topic)dest) : this.session.createProducer(dest));
    }

    public void send(Message msg) throws JMSException {
        try {
            if (this.destinationType.equals("javax.jms.Queue")) {
                ((QueueSender)this.producer).send(msg);
            } else if (this.destinationType.equals("javax.jms.Topic")) {
                ((TopicPublisher)this.producer).publish(msg);
            } else {
                this.producer.send(msg);
            }
        }
        catch (Exception e) {
            throw ExceptionUtils.newJMSException(e);
        }
    }

    public void close() throws JMSException {
        try {
            if (this.producer != null) {
                this.producer.close();
            }
        }
        catch (Exception e) {
            logger.log(Level.FINE, e.getMessage(), e);
        }
        try {
            this.session.close();
        }
        catch (Exception e) {
            logger.log(Level.FINE, e.getMessage(), e);
        }
    }
}

