/*
 * Decompiled with CFR 0.152.
 */
package com.sun.genericra.outbound;

import com.sun.genericra.outbound.AbstractManagedConnectionFactory;
import com.sun.genericra.outbound.ManagedConnection;
import com.sun.genericra.outbound.SessionAdapter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;

public class ConnectionHandle
implements Connection,
TopicConnection,
QueueConnection {
    private ManagedConnection mc;
    private Connection physicalJMSCon;
    private boolean isClosed = false;
    private ArrayList sessions = new ArrayList();
    private ArrayList tempDestinations = new ArrayList();
    private boolean valid = true;

    public ConnectionHandle(ManagedConnection connection) {
        this.mc = connection;
        this.physicalJMSCon = this.mc.getPhysicalConnection();
    }

    private boolean inACC() {
        return ((AbstractManagedConnectionFactory)this.mc.getManagedConnectionFactory()).isInAppClientContainer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        int i;
        if (this.isClosed()) {
            return;
        }
        this.physicalJMSCon.stop();
        ArrayList arrayList = this.sessions;
        synchronized (arrayList) {
            Object[] sessionObjects = this.sessions.toArray();
            for (i = 0; i < sessionObjects.length; ++i) {
                SessionAdapter sa = (SessionAdapter)sessionObjects[i];
                sa.close();
            }
        }
        arrayList = this.tempDestinations;
        synchronized (arrayList) {
            Object[] dests = this.tempDestinations.toArray();
            for (i = 0; i < dests.length; ++i) {
                if (dests[i] instanceof TemporaryQueue) {
                    ((TemporaryQueue)dests[i]).delete();
                }
                if (!(dests[i] instanceof TemporaryTopic)) continue;
                ((TemporaryTopic)dests[i]).delete();
            }
        }
        this.isClosed = true;
        this.mc.sendConnectionClosedEvent(this);
        if (!this.mc.isTransactionInProgress()) {
            this.mc.sendConnectionErrorEvent(this);
        }
    }

    public void start() throws JMSException {
        this.checkIfClosed();
        this.physicalJMSCon.start();
    }

    public void stop() throws JMSException {
        if (!this.inACC()) {
            throw new JMSException("Conncetion.stop() cannot be called on non-ACC clients");
        }
        this.checkIfClosed();
        this.physicalJMSCon.stop();
    }

    public String getClientID() throws JMSException {
        this.checkIfClosed();
        if (!this.inACC()) {
            throw new JMSException("Client ID cannot be set in non-ACC clients");
        }
        return this.physicalJMSCon.getClientID();
    }

    public void setClientID(String clientID) throws JMSException {
        this.checkIfClosed();
        if (!this.inACC()) {
            throw new JMSException("Client ID cannot be set in non-ACC clients");
        }
        this.physicalJMSCon.setClientID(clientID);
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        this.checkIfClosed();
        return this.physicalJMSCon.getMetaData();
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        if (!this.inACC()) {
            throw new JMSException("Conncetion.getExceptionListener() cannot be called on non-ACC clients");
        }
        this.checkIfClosed();
        return this.physicalJMSCon.getExceptionListener();
    }

    public void setExceptionListener(ExceptionListener excptLstnr) throws JMSException {
        if (!this.inACC()) {
            throw new JMSException("Conncetion.setExceptionListener() cannot be called on non-ACC clients");
        }
        this.checkIfClosed();
        this.physicalJMSCon.setExceptionListener(excptLstnr);
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return this.createSession(transacted, acknowledgeMode, 0);
    }

    private boolean checkIfSessionsCanBeCreated() throws JMSException {
        this.checkIfClosed();
        if (this.mc.isTransactionInProgress()) {
            if (this.mc.canSessionsBeCreated()) {
                return true;
            }
            throw new JMSException("More than one sessions cannot be created within a transaction");
        }
        return true;
    }

    public ConnectionConsumer createConnectionConsumer(Destination dest, String msgSel, ServerSessionPool ssp, int maxMsgs) throws JMSException {
        this.checkIfClosed();
        return this.physicalJMSCon.createConnectionConsumer(dest, msgSel, ssp, maxMsgs);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subName, String msgSel, ServerSessionPool ssp, int maxMsgs) throws JMSException {
        this.checkIfClosed();
        return this.physicalJMSCon.createDurableConnectionConsumer(topic, subName, msgSel, ssp, maxMsgs);
    }

    public TopicSession createTopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return (TopicSession)this.createSession(transacted, acknowledgeMode, 1);
    }

    private Session createSession(boolean transacted, int acknowledgeMode, int type) throws JMSException {
        this.checkIfSessionsCanBeCreated();
        Session s = this.mc.getPhysicalJMSSession(transacted, acknowledgeMode, type);
        SessionAdapter sa = new SessionAdapter(s, this);
        this.sessions.add(sa);
        return sa;
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String subName, ServerSessionPool ssp, int maxMsgs) throws JMSException {
        this.checkIfClosed();
        return this.physicalJMSCon.createConnectionConsumer((Destination)topic, subName, ssp, maxMsgs);
    }

    private boolean isXA() {
        return ((AbstractManagedConnectionFactory)this.mc.getManagedConnectionFactory()).getSupportsXA();
    }

    public QueueSession createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return (QueueSession)this.createSession(transacted, acknowledgeMode, 2);
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String subName, ServerSessionPool ssp, int maxMsgs) throws JMSException {
        this.checkIfClosed();
        return this.physicalJMSCon.createConnectionConsumer((Destination)queue, subName, ssp, maxMsgs);
    }

    public void cleanup() throws JMSException {
        Iterator iter = this.sessions.iterator();
        while (iter.hasNext()) {
            SessionAdapter sa = (SessionAdapter)iter.next();
            sa.setInvalid();
            iter.remove();
        }
    }

    public ManagedConnection getManagedConnection() {
        return this.mc;
    }

    public void associateConnection(ManagedConnection mc) {
        this.mc = mc;
        this.physicalJMSCon = mc.getPhysicalConnection();
    }

    private void checkIfClosed() throws JMSException {
        if (this.isClosed) {
            throw new IllegalStateException("Connection is closed");
        }
        if (!this.valid) {
            throw new IllegalStateException("Invalid connection");
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void removeSessionAdapter(SessionAdapter sessionToBeRemoved) {
        this.sessions.remove(sessionToBeRemoved);
    }

    public List getSessions() {
        return this.sessions;
    }

    public void setInvalid() {
        this.valid = false;
    }

    void _addTemporaryDest(Destination dest) {
        this.tempDestinations.add(dest);
    }
}

