/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.generic;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import javax.management.remote.generic.ObjectWrapping;

public class ObjectWrappingImpl
implements ObjectWrapping {
    public Object wrap(Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        return byteArrayOutputStream.toByteArray();
    }

    public Object unwrap(Object object, ClassLoader classLoader) throws IOException, ClassNotFoundException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
        ObjectInputStreamWithLoader objectInputStreamWithLoader = new ObjectInputStreamWithLoader(byteArrayInputStream);
        return objectInputStreamWithLoader.readObject(classLoader);
    }

    private static class ObjectInputStreamWithLoader
    extends ObjectInputStream {
        private ClassLoader cloader;

        public ObjectInputStreamWithLoader(InputStream inputStream) throws IOException {
            super(inputStream);
        }

        public Object readObject(ClassLoader classLoader) throws IOException, ClassNotFoundException {
            this.cloader = classLoader;
            return this.readObject();
        }

        protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
            return this.cloader == null ? super.resolveClass(objectStreamClass) : Class.forName(objectStreamClass.getName(), false, this.cloader);
        }
    }
}

