/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote.generic;

import com.sun.jmx.remote.generic.ServerSynchroMessageConnection;
import com.sun.jmx.remote.generic.SynchroCallback;
import com.sun.jmx.remote.opt.internal.ServerCommunicatorAdmin;
import com.sun.jmx.remote.opt.internal.ServerNotifForwarder;
import com.sun.jmx.remote.opt.security.JMXSubjectDomainCombiner;
import com.sun.jmx.remote.opt.security.SubjectDelegator;
import com.sun.jmx.remote.opt.util.ClassLoaderWithRepository;
import com.sun.jmx.remote.opt.util.ClassLogger;
import com.sun.jmx.remote.opt.util.EnvHelp;
import com.sun.jmx.remote.opt.util.OrderClassLoaders;
import java.io.EOFException;
import java.io.IOException;
import java.io.NotSerializableException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.loading.ClassLoaderRepository;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXServerErrorException;
import javax.management.remote.NotificationResult;
import javax.management.remote.TargetedNotification;
import javax.management.remote.generic.ConnectionClosedException;
import javax.management.remote.generic.GenericConnectorServer;
import javax.management.remote.generic.ObjectWrapping;
import javax.management.remote.message.CloseMessage;
import javax.management.remote.message.MBeanServerRequestMessage;
import javax.management.remote.message.MBeanServerResponseMessage;
import javax.management.remote.message.Message;
import javax.management.remote.message.NotificationRequestMessage;
import javax.management.remote.message.NotificationResponseMessage;
import javax.security.auth.Subject;

class ServerIntermediary {
    private static final Long ONE_LONG = new Long(1L);
    private final MBeanServer mbeanServer;
    private final GenericConnectorServer myServer;
    private final ServerSynchroMessageConnection connection;
    private final String clientId;
    private final RequestHandler requestHandler = new RequestHandler();
    private final ObjectWrapping serialization;
    private final AccessControlContext acc;
    private final Subject subject;
    private final SubjectDelegator subjectDelegator;
    private final ClassLoader defaultClassLoader;
    private final ClassLoaderWithRepository clr;
    private ServerNotifForwarder serverNotifForwarder;
    private Map env;
    private GenericServerCommunicatorAdmin serverCommunicatorAdmin;
    private static final ClassLogger logger = new ClassLogger("javax.management.remote.generic", "ServerIntermediary");
    private static final int RUNNING = 0;
    private static final int FAILED = 1;
    private static final int TERMINATED = 2;
    private int state = 0;
    private final int[] stateLock = new int[0];
    private final boolean isRI10;

    public ServerIntermediary(MBeanServer mBeanServer, GenericConnectorServer genericConnectorServer, ServerSynchroMessageConnection serverSynchroMessageConnection, ObjectWrapping objectWrapping, Subject subject, ClassLoader classLoader, Map map) {
        if (logger.traceOn()) {
            logger.trace("constructor", "Create a ServerIntermediary object.");
        }
        if (mBeanServer == null) {
            throw new NullPointerException("Null mbean server.");
        }
        if (serverSynchroMessageConnection == null) {
            throw new NullPointerException("Null connection.");
        }
        this.mbeanServer = mBeanServer;
        this.myServer = genericConnectorServer;
        this.connection = serverSynchroMessageConnection;
        this.clientId = serverSynchroMessageConnection.getConnectionId();
        this.serialization = objectWrapping;
        this.subjectDelegator = new SubjectDelegator();
        this.subject = subject;
        this.acc = subject == null ? null : new AccessControlContext(AccessController.getContext(), new JMXSubjectDomainCombiner(subject));
        this.defaultClassLoader = classLoader;
        final ClassLoader classLoader2 = classLoader;
        this.clr = (ClassLoaderWithRepository)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new ClassLoaderWithRepository(ServerIntermediary.this.getClassLoaderRepository(), classLoader2);
            }
        });
        this.env = map;
        long l = EnvHelp.getServerConnectionTimeout(this.env);
        String string = (String)this.env.get("com.sun.jmx.remote.bug.compatible");
        if (string == null) {
            string = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("com.sun.jmx.remote.bug.compatible");
                }
            });
        }
        this.isRI10 = "RI1.0.0".equals(string);
        this.serverCommunicatorAdmin = new GenericServerCommunicatorAdmin(l);
    }

    private synchronized ServerNotifForwarder getServerNotifFwd() {
        if (this.serverNotifForwarder == null) {
            this.serverNotifForwarder = new ServerNotifForwarder(this.mbeanServer, this.env, this.myServer.getNotifBuffer());
        }
        return this.serverNotifForwarder;
    }

    public Object handleRequest(MBeanServerRequestMessage mBeanServerRequestMessage) throws Exception {
        if (logger.traceOn()) {
            logger.trace("handleRequest", "Handle a request: " + mBeanServerRequestMessage);
        }
        if (mBeanServerRequestMessage == null) {
            return null;
        }
        Object[] objectArray = mBeanServerRequestMessage.getParams();
        switch (mBeanServerRequestMessage.getMethodId()) {
            case 3: {
                if (logger.traceOn()) {
                    logger.trace("handleRequest", "Handle a CREATE_MBEAN request.");
                }
                return this.mbeanServer.createMBean((String)objectArray[0], (ObjectName)objectArray[1]);
            }
            case 5: {
                if (logger.traceOn()) {
                    logger.trace("handleRequest", "Handle a CREATE_MBEAN_LOADER request.");
                }
                return this.mbeanServer.createMBean((String)objectArray[0], (ObjectName)objectArray[1], (ObjectName)objectArray[2]);
            }
            case 4: {
                if (logger.traceOn()) {
                    logger.trace("handleRequest", "Handle a CREATE_MBEAN_PARAMS request.");
                }
                return this.mbeanServer.createMBean((String)objectArray[0], (ObjectName)objectArray[1], (Object[])this.serialization.unwrap(objectArray[2], this.clr), (String[])objectArray[3]);
            }
            case 6: {
                if (logger.traceOn()) {
                    logger.trace("handleRequest", "Handle a CREATE_MBEAN_LOADER_PARAMS request.");
                }
                return this.mbeanServer.createMBean((String)objectArray[0], (ObjectName)objectArray[1], (ObjectName)objectArray[2], (Object[])this.unwrapWithDefault(objectArray[3], this.getClassLoader((ObjectName)objectArray[2])), (String[])objectArray[4]);
            }
            case 7: {
                if (logger.traceOn()) {
                    logger.trace("handleRequest", "Handle a GET_ATTRIBUTE request.");
                }
                return this.mbeanServer.getAttribute((ObjectName)objectArray[0], (String)objectArray[1]);
            }
            case 8: {
                if (logger.traceOn()) {
                    logger.trace("handleRequest", "Handle a GET_ATTRIBUTES request.");
                }
                return this.mbeanServer.getAttributes((ObjectName)objectArray[0], (String[])objectArray[1]);
            }
            case 9: {
                if (logger.traceOn()) {
                    logger.trace("handleRequest", "Handle a GET_DEFAULT_DOMAIN request.");
                }
                return this.mbeanServer.getDefaultDomain();
            }
            case 10: {
                if (logger.traceOn()) {
                    logger.trace("handleRequest", "Handle a GET_DOMAINS request.");
                }
                return this.mbeanServer.getDomains();
            }
            case 11: {
                if (logger.traceOn()) {
                    logger.trace("handleRequest", "Handle a GET_MBEAN_COUNT request.");
                }
                return this.mbeanServer.getMBeanCount();
            }
            case 12: {
                if (logger.traceOn()) {
                    logger.trace("handleRequest", "Handle a GET_MBEAN_INFO request.");
                }
                return this.mbeanServer.getMBeanInfo((ObjectName)objectArray[0]);
            }
            case 13: {
                if (logger.traceOn()) {
                    logger.trace("handleRequest", "Handle a GET_OBJECT_INSTANCE request.");
                }
                return this.mbeanServer.getObjectInstance((ObjectName)objectArray[0]);
            }
            case 14: {
                if (logger.traceOn()) {
                    logger.trace("handleRequest", "Handle a INVOKE request.");
                }
                return this.mbeanServer.invoke((ObjectName)objectArray[0], (String)objectArray[1], (Object[])this.unwrapWithDefault(objectArray[2], this.getClassLoaderFor((ObjectName)objectArray[0])), (String[])objectArray[3]);
            }
            case 15: {
                if (logger.traceOn()) {
                    logger.trace("handleRequest", "Handle a IS_INSTANCE_OF request.");
                }
                return this.mbeanServer.isInstanceOf((ObjectName)objectArray[0], (String)objectArray[1]) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 16: {
                if (logger.traceOn()) {
                    logger.trace("handleRequest", "Handle a IS_REGISTERED request.");
                }
                return this.mbeanServer.isRegistered((ObjectName)objectArray[0]) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 17: {
                if (logger.traceOn()) {
                    logger.trace("handleRequest", "Handle a QUERY_MBEANS request.");
                }
                return this.mbeanServer.queryMBeans((ObjectName)objectArray[0], (QueryExp)this.serialization.unwrap(objectArray[1], this.defaultClassLoader));
            }
            case 18: {
                if (logger.traceOn()) {
                    logger.trace("handleRequest", "Handle a QUERY_NAMES request.");
                }
                return this.mbeanServer.queryNames((ObjectName)objectArray[0], (QueryExp)this.serialization.unwrap(objectArray[1], this.defaultClassLoader));
            }
            case 23: {
                if (logger.traceOn()) {
                    logger.trace("handleRequest", "Handle a SET_ATTRIBUTE request.");
                }
                this.mbeanServer.setAttribute((ObjectName)objectArray[0], (Attribute)this.unwrapWithDefault(objectArray[1], this.getClassLoaderFor((ObjectName)objectArray[0])));
                return null;
            }
            case 24: {
                if (logger.traceOn()) {
                    logger.trace("handleRequest", "Handle a SET_ATTRIBUTES request.");
                }
                return this.mbeanServer.setAttributes((ObjectName)objectArray[0], (AttributeList)this.unwrapWithDefault(objectArray[1], this.getClassLoaderFor((ObjectName)objectArray[0])));
            }
            case 25: {
                if (logger.traceOn()) {
                    logger.trace("handleRequest", "Handle a UNREGISTER_MBEAN request.");
                }
                this.mbeanServer.unregisterMBean((ObjectName)objectArray[0]);
                return null;
            }
            case 2: {
                if (logger.traceOn()) {
                    logger.trace("handleRequest", "Handle a ADD_NOTIFICATION_LISTENER_OBJECTNAME request.");
                }
                ClassLoader classLoader = this.getClassLoaderFor((ObjectName)objectArray[0]);
                this.mbeanServer.addNotificationListener((ObjectName)objectArray[0], (ObjectName)objectArray[1], (NotificationFilter)this.unwrapWithDefault(objectArray[2], classLoader), this.unwrapWithDefault(objectArray[3], classLoader));
                return null;
            }
            case 21: {
                if (logger.traceOn()) {
                    logger.trace("handleRequest", "Handle a REMOVE_NOTIFICATION_LISTENER_OBJECTNAME request.");
                }
                this.mbeanServer.removeNotificationListener((ObjectName)objectArray[0], (ObjectName)objectArray[1]);
                return null;
            }
            case 22: {
                if (logger.traceOn()) {
                    logger.trace("handleRequest", "Handle a REMOVE_NOTIFICATION_LISTENER_OBJECTNAME_FILTER_HANDBACK request.");
                }
                ClassLoader classLoader = this.getClassLoaderFor((ObjectName)objectArray[0]);
                this.mbeanServer.removeNotificationListener((ObjectName)objectArray[0], (ObjectName)objectArray[1], (NotificationFilter)this.unwrapWithDefault(objectArray[2], classLoader), this.unwrapWithDefault(objectArray[3], classLoader));
                return null;
            }
            case 1: {
                int n;
                if (logger.traceOn()) {
                    logger.trace("handleRequest", "Handle a ADD_NOTIFICATION_LISTENERS request.");
                }
                if (this.isRI10) {
                    ObjectName objectName = ((ObjectName[])objectArray[0])[0];
                    ClassLoader classLoader = this.getClassLoaderFor(objectName);
                    Object object = ((Object[])objectArray[1])[0];
                    return this.getServerNotifFwd().addNotificationListener(objectName, (NotificationFilter)this.unwrapWithDefault(object, classLoader));
                }
                if (objectArray[0] == null || objectArray[1] == null) {
                    throw new IllegalArgumentException("Got null arguments.");
                }
                ObjectName[] objectNameArray = (ObjectName[])objectArray[0];
                Object[] objectArray2 = (Object[])objectArray[1];
                if (objectNameArray.length != objectArray2.length) {
                    throw new IllegalArgumentException("The value lengths of 2 parameters are not same.");
                }
                for (n = 0; n < objectNameArray.length; ++n) {
                    if (objectNameArray[n] != null) continue;
                    throw new IllegalArgumentException("Null Object name.");
                }
                Integer[] integerArray = new Integer[objectNameArray.length];
                boolean bl = logger.debugOn();
                try {
                    for (n = 0; n < objectNameArray.length; ++n) {
                        ClassLoader classLoader = this.getClassLoaderFor(objectNameArray[n]);
                        if (bl) {
                            logger.debug("addNotificationListener(ObjectName,NotificationFilter)", "connectionId=" + this.clientId + " unwrapping filter with target extended ClassLoader.");
                        }
                        NotificationFilter notificationFilter = (NotificationFilter)this.unwrapWithDefault(objectArray2[n], classLoader);
                        if (bl) {
                            logger.debug("addNotificationListener(ObjectName,NotificationFilter)", "connectionId=" + this.clientId + ", name=" + objectNameArray[n] + ", filter=" + notificationFilter);
                        }
                        integerArray[n] = this.getServerNotifFwd().addNotificationListener(objectNameArray[n], notificationFilter);
                    }
                    return integerArray;
                }
                catch (Exception exception) {
                    Exception exception2;
                    for (int i = 0; i < n; ++i) {
                        try {
                            this.getServerNotifFwd().removeNotificationListener(objectNameArray[i], integerArray[i]);
                            continue;
                        }
                        catch (Exception exception3) {
                            logger.warning("handleRequest-addNotificationListener", "Failed to remove a listener from the MBean " + objectNameArray[i] + ". " + exception3.toString());
                        }
                    }
                    if (exception instanceof PrivilegedActionException) {
                        exception2 = this.extractException(exception);
                    }
                    throw exception2;
                }
            }
            case 20: {
                if (logger.traceOn()) {
                    logger.trace("handleRequest", "Handle a REMOVE_NOTIFICATION_LISTENER_FILTER_HANDBACK request.");
                }
                this.getServerNotifFwd().removeNotificationListener((ObjectName)objectArray[0], new Integer[]{(Integer)objectArray[1]});
                return null;
            }
            case 19: {
                if (logger.traceOn()) {
                    logger.trace("handleRequest", "Handle a REMOVE_NOTIFICATION_LISTENER request.");
                }
                this.getServerNotifFwd().removeNotificationListener((ObjectName)objectArray[0], (Integer[])objectArray[1]);
                return null;
            }
        }
        logger.info("handleRequest", "Unknown request id: " + mBeanServerRequestMessage.getMethodId());
        throw new IllegalArgumentException("The specified method is not found [MethodId=" + mBeanServerRequestMessage.getMethodId() + "]");
    }

    public void terminate() {
        this.terminate(false, "The server is stopped.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate(boolean bl, String string) {
        if (logger.traceOn()) {
            logger.trace("terminate", "Terminating....");
        }
        Object object = this.stateLock;
        synchronized (this.stateLock) {
            if (this.state == 2) {
                // ** MonitorExit[var3_3 /* !! */ ] (shouldn't be in output)
                return;
            }
            this.state = 2;
            // ** MonitorExit[var3_3 /* !! */ ] (shouldn't be in output)
            if (!bl) {
                if (logger.traceOn()) {
                    logger.trace("terminate", "Send a CloseMessage to the client.");
                }
                try {
                    ServerSynchroMessageConnection serverSynchroMessageConnection = this.connection;
                    object = serverSynchroMessageConnection;
                    synchronized (serverSynchroMessageConnection) {
                        this.connection.sendOneWay(new CloseMessage(string));
                        // ** MonitorExit[var3_3 /* !! */ ] (shouldn't be in output)
                    }
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    if (logger.traceOn()) {
                        logger.trace("terminate", "The transport level does not support the method sendOneWay: " + unsupportedOperationException);
                    }
                }
                catch (IOException iOException) {
                    logger.warning("terminate", "Failed to inform the client: " + iOException);
                    logger.debug("terminate", iOException);
                }
            }
            {
                if (this.serverNotifForwarder != null) {
                    this.serverNotifForwarder.terminate();
                }
                try {
                    this.connection.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.serverCommunicatorAdmin != null) {
                    this.serverCommunicatorAdmin.terminate();
                }
                this.myServer.clientClosing(this, this.clientId, "The method terminate is called.", null);
                if (logger.traceOn()) {
                    logger.trace("terminate", "Terminated.");
                }
                return;
            }
        }
    }

    ServerSynchroMessageConnection getTransport() {
        return this.connection;
    }

    private NotificationResult purgeUnserializable(NotificationResult notificationResult) {
        ArrayList<TargetedNotification> arrayList = new ArrayList<TargetedNotification>();
        TargetedNotification[] targetedNotificationArray = notificationResult.getTargetedNotifications();
        for (int i = 0; i < targetedNotificationArray.length; ++i) {
            TargetedNotification targetedNotification = targetedNotificationArray[i];
            NotificationResult notificationResult2 = new NotificationResult(0L, 0L, new TargetedNotification[]{targetedNotification});
            try {
                this.serialization.wrap(notificationResult2);
                arrayList.add(targetedNotification);
                continue;
            }
            catch (IOException iOException) {
                logger.warning("purgeUnserializable", "cannot serialize notif: " + targetedNotification);
                logger.fine("purgeUnserializable", iOException);
                Integer n = targetedNotification.getListenerID();
                Notification notification = targetedNotification.getNotification();
                String string = "Not serializable: " + notification;
                JMXConnectionNotification jMXConnectionNotification = new JMXConnectionNotification("jmx.remote.connection.notifs.lost", notification.getSource(), this.clientId, notification.getSequenceNumber(), string, ONE_LONG);
                targetedNotification = new TargetedNotification(jMXConnectionNotification, n);
                notificationResult2 = new NotificationResult(0L, 0L, new TargetedNotification[]{targetedNotification});
                try {
                    this.serialization.wrap(notificationResult2);
                    arrayList.add(targetedNotification);
                    continue;
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
        }
        targetedNotificationArray = arrayList.toArray(new TargetedNotification[0]);
        return new NotificationResult(notificationResult.getEarliestSequenceNumber(), notificationResult.getNextSequenceNumber(), targetedNotificationArray);
    }

    void start() {
        this.connection.setCallback(this.requestHandler);
    }

    private ClassLoaderRepository getClassLoaderRepository() {
        return (ClassLoaderRepository)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ServerIntermediary.this.mbeanServer.getClassLoaderRepository();
            }
        });
    }

    private ClassLoader getClassLoader(final ObjectName objectName) throws InstanceNotFoundException {
        try {
            return (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws InstanceNotFoundException {
                    return ServerIntermediary.this.mbeanServer.getClassLoader(objectName);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (InstanceNotFoundException)this.extractException(privilegedActionException);
        }
    }

    private ClassLoader getClassLoaderFor(final ObjectName objectName) throws InstanceNotFoundException {
        try {
            return (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws InstanceNotFoundException {
                    return ServerIntermediary.this.mbeanServer.getClassLoaderFor(objectName);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (InstanceNotFoundException)this.extractException(privilegedActionException);
        }
    }

    private Exception extractException(Exception exception) {
        while (exception instanceof PrivilegedActionException) {
            exception = ((PrivilegedActionException)exception).getException();
        }
        return exception;
    }

    private Object unwrapWithDefault(final Object object, final ClassLoader classLoader) throws IOException, ClassNotFoundException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException, ClassNotFoundException {
                    return ServerIntermediary.this.serialization.unwrap(object, new OrderClassLoaders(classLoader, ServerIntermediary.this.defaultClassLoader));
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = this.extractException(privilegedActionException);
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)exception;
            }
            return null;
        }
    }

    private class PrivilegedRequestJob
    implements PrivilegedExceptionAction {
        private MBeanServerRequestMessage request;

        public PrivilegedRequestJob(MBeanServerRequestMessage mBeanServerRequestMessage) {
            this.request = mBeanServerRequestMessage;
        }

        public Object run() throws Exception {
            return ServerIntermediary.this.serialization.wrap(ServerIntermediary.this.handleRequest(this.request));
        }
    }

    private class GenericServerCommunicatorAdmin
    extends ServerCommunicatorAdmin {
        public GenericServerCommunicatorAdmin(long l) {
            super(l);
        }

        protected void doStop() {
            ServerIntermediary.this.terminate();
        }
    }

    private class RequestHandler
    implements SynchroCallback {
        private RequestHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Message execute(Message message) {
            boolean bl = ServerIntermediary.this.serverCommunicatorAdmin.reqIncoming();
            try {
                if (bl) {
                    throw new ConnectionClosedException("The connection is being terminated by the server");
                }
                if (logger.traceOn()) {
                    logger.trace("RequestHandler-execute", "Execute the request: " + message);
                }
                if (message instanceof CloseMessage) {
                    Message message2 = this.handleCloseMessage((CloseMessage)message);
                    return message2;
                }
                if (message instanceof NotificationRequestMessage) {
                    Message message3 = this.handleNotifReqMessage((NotificationRequestMessage)message);
                    return message3;
                }
                if (message instanceof MBeanServerRequestMessage) {
                    Message message4 = this.handleMBSReqMessage((MBeanServerRequestMessage)message);
                    return message4;
                }
                logger.warning("RequestHandler-execute", "Got unknown message: " + message);
                ServerIntermediary.this.myServer.failedConnectionNotif(ServerIntermediary.this.clientId, "Got unknown message: " + message, message);
                ServerIntermediary.this.terminate(false, "Got unknown message: " + message);
            }
            catch (IOException iOException) {
                logger.trace("RequestHandler.execute", iOException);
            }
            finally {
                ServerIntermediary.this.serverCommunicatorAdmin.rspOutgoing();
            }
            return null;
        }

        private Message handleCloseMessage(CloseMessage closeMessage) {
            if (logger.traceOn()) {
                logger.trace("RequestHandler-execute", "Receive a CloseMessage.");
            }
            ServerIntermediary.this.terminate(true, null);
            return null;
        }

        private Message handleNotifReqMessage(NotificationRequestMessage notificationRequestMessage) throws IOException {
            Object object;
            if (logger.traceOn()) {
                logger.trace("RequestHandler-execute", "Receive a NotificationRequestMessage.");
            }
            long l = notificationRequestMessage.getClientSequenceNumber();
            long l2 = notificationRequestMessage.getTimeout();
            int n = notificationRequestMessage.getMaxNotifications();
            NotificationResult notificationResult = ServerIntermediary.this.getServerNotifFwd().fetchNotifs(l, l2, n);
            try {
                object = ServerIntermediary.this.serialization.wrap(notificationResult);
            }
            catch (NotSerializableException notSerializableException) {
                notificationResult = ServerIntermediary.this.purgeUnserializable(notificationResult);
                object = ServerIntermediary.this.serialization.wrap(notificationResult);
            }
            return new NotificationResponseMessage(object);
        }

        private Message handleMBSReqMessage(MBeanServerRequestMessage mBeanServerRequestMessage) throws IOException {
            if (logger.traceOn()) {
                logger.trace("RequestHandler-execute", "Receive a MBeanServerRequestMessage.");
            }
            try {
                AccessControlContext accessControlContext;
                Subject subject = mBeanServerRequestMessage.getDelegationSubject();
                if (subject == null) {
                    accessControlContext = ServerIntermediary.this.acc;
                } else {
                    if (ServerIntermediary.this.subject == null) {
                        throw new SecurityException("Subject delegation cannot be enabled unless an authenticated subject is put in place");
                    }
                    accessControlContext = ServerIntermediary.this.subjectDelegator.delegatedContext(ServerIntermediary.this.acc, subject);
                }
                Object t = AccessController.doPrivileged(new PrivilegedRequestJob(mBeanServerRequestMessage), accessControlContext);
                return new MBeanServerResponseMessage(mBeanServerRequestMessage.getMessageId(), t, false);
            }
            catch (Exception exception) {
                Exception exception2 = ServerIntermediary.this.extractException(exception);
                if (logger.traceOn()) {
                    logger.trace("RequestHandler-execute", "Got an exception: " + exception2, exception2);
                }
                return new MBeanServerResponseMessage(mBeanServerRequestMessage.getMessageId(), this.wrapException(exception2), true);
            }
            catch (Error error) {
                if (logger.traceOn()) {
                    logger.trace("RequestHandler-execute", "Got an error: " + error, error);
                }
                JMXServerErrorException jMXServerErrorException = new JMXServerErrorException(error.toString(), error);
                return new MBeanServerResponseMessage(mBeanServerRequestMessage.getMessageId(), this.wrapException(jMXServerErrorException), true);
            }
        }

        private Object wrapException(Exception exception) throws IOException {
            try {
                return ServerIntermediary.this.serialization.wrap(exception);
            }
            catch (NotSerializableException notSerializableException) {
                return ServerIntermediary.this.serialization.wrap(notSerializableException);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connectionException(Exception exception) {
            Object object = ServerIntermediary.this.stateLock;
            synchronized (object) {
                if (ServerIntermediary.this.state != 0) {
                    return;
                }
                ServerIntermediary.this.state = 1;
            }
            if (exception instanceof EOFException) {
                logger.warning("RequestHandler-connectionException", "JMX connector client exited without closing connection");
            } else {
                logger.warning("RequestHandler-connectionException", "JMX connector transport got exception when reading input message: " + exception);
            }
            logger.finer("RequestHandler-connectionException", exception);
            object = null;
            object = exception instanceof ClassNotFoundException ? (Object)("The client " + ServerIntermediary.this.clientId + "got an unknown message: " + exception) : (Object)("The client " + ServerIntermediary.this.clientId + " has failed: " + exception);
            ServerIntermediary.this.myServer.failedConnectionNotif(ServerIntermediary.this.clientId, (String)object, exception);
            ServerIntermediary.this.terminate(true, null);
        }
    }
}

