/*
 * Decompiled with CFR 0.152.
 */
package samples.webapps.simple.servlet.compressionFilters;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import samples.webapps.simple.servlet.compressionFilters.CompressionServletResponseWrapper;

public class CompressionFilter
implements Filter {
    private FilterConfig config = null;
    private int minThreshold = 128;
    protected int compressionThreshold;
    private int debug = 0;

    public void init(FilterConfig filterConfig) {
        this.config = filterConfig;
        if (filterConfig != null) {
            String string = filterConfig.getInitParameter("debug");
            this.debug = string != null ? Integer.parseInt(string) : 0;
            String string2 = filterConfig.getInitParameter("compressionThreshold");
            if (string2 != null) {
                this.compressionThreshold = Integer.parseInt(string2);
                if (this.compressionThreshold != 0 && this.compressionThreshold < this.minThreshold) {
                    if (this.debug > 0) {
                        System.out.println("compressionThreshold should be either 0 - no compression or >= " + this.minThreshold);
                        System.out.println("compressionThreshold set to " + this.minThreshold);
                    }
                    this.compressionThreshold = this.minThreshold;
                }
            } else {
                this.compressionThreshold = 0;
            }
        } else {
            this.compressionThreshold = 0;
        }
    }

    public void destroy() {
        this.config = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        String string;
        if (this.debug > 0) {
            System.out.println("@doFilter");
        }
        if (this.compressionThreshold == 0) {
            if (this.debug > 0) {
                System.out.println("doFilter gets called, but compressionTreshold is set to 0 - no compression");
            }
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        boolean bl = false;
        if (servletRequest instanceof HttpServletRequest) {
            if (this.debug > 1) {
                System.out.println("requestURI = " + ((HttpServletRequest)servletRequest).getRequestURI());
            }
            if ("false".equals(string = ((HttpServletRequest)servletRequest).getParameter("gzip"))) {
                if (this.debug > 0) {
                    System.out.println("got parameter gzip=false --> don't compress, just chain filter");
                }
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
            Enumeration enumeration = ((HttpServletRequest)servletRequest).getHeaders("Accept-Encoding");
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (string2.indexOf("gzip") != -1) {
                    if (this.debug > 0) {
                        System.out.println("supports compression");
                    }
                    bl = true;
                    continue;
                }
                if (this.debug <= 0) continue;
                System.out.println("no support for compresion");
            }
        }
        if (!bl) {
            if (this.debug > 0) {
                System.out.println("doFilter gets called wo compression");
            }
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        if (servletResponse instanceof HttpServletResponse) {
            string = new CompressionServletResponseWrapper((HttpServletResponse)servletResponse);
            string.setDebugLevel(this.debug);
            string.setCompressionThreshold(this.compressionThreshold);
            if (this.debug > 0) {
                System.out.println("doFilter gets called with compression");
            }
            try {
                filterChain.doFilter(servletRequest, (ServletResponse)string);
            }
            finally {
                string.finishResponse();
            }
            return;
        }
    }

    public void setFilterConfig(FilterConfig filterConfig) {
        this.init(filterConfig);
    }

    public FilterConfig getFilterConfig() {
        return this.config;
    }
}

