/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.model;

import com.iplanet.jato.model.DefaultModel;
import com.sun.web.ui.model.CCFileChooserModelInterface;
import com.sun.web.ui.model.CCFileChooserTimeInterface;
import java.io.File;
import java.io.FileFilter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;

public class CCFileChooserModel
extends DefaultModel
implements CCFileChooserModelInterface,
CCFileChooserTimeInterface {
    private String type = null;
    private Boolean multipleSelect;
    private int fileListBoxHeight = 10;
    private FileChooserFilter fileFilter = null;
    private String filterString = null;
    private String currentFilter;
    private String storedDirectory;
    private String homeDir = "/";
    private String currentDir;
    private Vector selectedFiles = new Vector();
    private String serverName = null;
    private String sortField = "alpha";
    private Locale locale = null;
    private static String DEFAULT_DATEFORMAT = "MM/dd/yy";
    private static String DEFAULT_TIMEFORMAT = "HH:mm";
    private String dateFormat = null;
    private String timeFormat = null;
    private boolean popupMode = false;
    private String alertChild;
    private String productNameAlt = null;
    private String productNameHeight = null;
    private String productNameSrc = null;
    private String productNameWidth = null;

    public void setType(String type) {
        this.type = !type.equals("file") && !type.equals("folder") ? "file" : type;
    }

    public String getType() {
        return this.type;
    }

    public void setMultipleSelect(boolean multipleSelect) {
        this.multipleSelect = new Boolean(multipleSelect);
    }

    public boolean multipleSelect() {
        boolean result = false;
        if (this.multipleSelect != null) {
            result = this.multipleSelect;
        }
        return result;
    }

    public boolean isMultipleSelectSet() {
        return this.multipleSelect != null;
    }

    public void setPopupMode(boolean result) {
        this.popupMode = result;
    }

    public boolean isPopupMode() {
        return this.popupMode;
    }

    public String getProductNameAlt() {
        return this.productNameAlt;
    }

    public void setProductNameAlt(String value) {
        this.productNameAlt = value;
    }

    public String getProductNameHeight() {
        return this.productNameHeight;
    }

    public void setProductNameHeight(String value) {
        this.productNameHeight = value;
    }

    public String getProductNameSrc() {
        return this.productNameSrc;
    }

    public void setProductNameSrc(String value) {
        this.productNameSrc = value;
    }

    public String getProductNameWidth() {
        return this.productNameWidth;
    }

    public void setProductNameWidth(String value) {
        this.productNameWidth = value;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        if (locale != null) {
            this.locale = locale;
        }
    }

    public String[] getSelectedFiles() {
        if (this.selectedFiles.isEmpty()) {
            return null;
        }
        Object[] list = this.selectedFiles.toArray();
        String[] strList = new String[list.length];
        for (int i = 0; i < list.length; ++i) {
            strList[i] = (String)list[i];
        }
        return strList;
    }

    public void addSelectedFile(String file) {
        if (file != null) {
            this.selectedFiles.add(file);
        }
    }

    public void clearFiles() {
        this.selectedFiles.clear();
    }

    public String getCurrentDirectory() {
        return this.currentDir;
    }

    public void setCurrentDirectory(String dir) {
        this.currentDir = dir;
    }

    public FileFilter instantiateFilter(String filterString) {
        this.fileFilter = new FileChooserFilter(filterString);
        return this.fileFilter;
    }

    public FileFilter getFileFilter() {
        if (this.fileFilter == null) {
            this.fileFilter = this.filterString == null ? new FileChooserFilter() : new FileChooserFilter(this.filterString);
        }
        return this.fileFilter;
    }

    public String getFilterString() {
        return this.filterString;
    }

    public void setFilterString(String filterString) {
        if (filterString != null) {
            this.filterString = filterString;
        }
    }

    public int getFileListBoxHeight() {
        return this.fileListBoxHeight;
    }

    public void setFileListBoxHeight(int height) {
        if (height > 0) {
            this.fileListBoxHeight = height;
        }
    }

    public String getDateFormat() {
        if (this.dateFormat == null) {
            return DEFAULT_DATEFORMAT;
        }
        return this.dateFormat;
    }

    public void setDateFormat(String format) {
        this.dateFormat = format == null ? DEFAULT_DATEFORMAT : format;
    }

    public String getTimeFormat() {
        if (this.timeFormat == null) {
            return DEFAULT_TIMEFORMAT;
        }
        return this.timeFormat;
    }

    public void setTimeFormat(String format) {
        this.timeFormat = format == null ? DEFAULT_TIMEFORMAT : format;
    }

    public String getServerName() {
        return this.serverName != null ? this.serverName : this.getLocalHostName();
    }

    public void setServerName(String serverName) {
        this.serverName = serverName != null ? serverName : this.getLocalHostName();
    }

    private String getLocalHostName() {
        String hostName;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ukhe) {
            hostName = "localhost";
        }
        return hostName;
    }

    public String getHomeDirectory() {
        return this.homeDir;
    }

    public void setHomeDirectory(String homeDir) {
        if (homeDir != null) {
            this.homeDir = homeDir;
        }
    }

    public boolean canRead(String directory) throws Exception {
        if (directory == null) {
            throw new Exception("filechooser.dir_is_null");
        }
        File file = new File(directory);
        if (!file.exists()) {
            throw new Exception("filechooser.file_does_not_exist");
        }
        return file.canRead();
    }

    public File[] getFiles(String directory) {
        int i;
        File file;
        if (directory == null) {
            directory = this.homeDir;
        }
        if (!(file = new File(directory)).exists()) {
            return null;
        }
        if (file.isFile()) {
            return null;
        }
        File[] files = file.listFiles();
        if (files == null || files.length == 0) {
            return null;
        }
        ArrayList<File> justFiles = new ArrayList<File>();
        ArrayList<File> justDirs = new ArrayList<File>();
        for (int i2 = 0; i2 < files.length; ++i2) {
            if (files[i2].isDirectory()) {
                justDirs.add(files[i2]);
                continue;
            }
            justFiles.add(files[i2]);
        }
        File[] fileArray = new File[justFiles.size()];
        for (int i3 = 0; i3 < justFiles.size(); ++i3) {
            fileArray[i3] = (File)justFiles.get(i3);
        }
        File[] dirArray = new File[justDirs.size()];
        for (i = 0; i < justDirs.size(); ++i) {
            dirArray[i] = (File)justDirs.get(i);
        }
        this.sort(fileArray);
        this.sort(dirArray);
        for (i = 0; i < justDirs.size(); ++i) {
            files[i] = dirArray[i];
        }
        for (int j = 0; j < justFiles.size(); ++j) {
            files[i + j] = fileArray[j];
        }
        return files;
    }

    public void sort(File[] fileList) {
        if (fileList == null || fileList.length == 0) {
            return;
        }
        if (fileList.length == 1) {
            return;
        }
        String sortField = this.getSortField();
        for (int i = fileList.length - 1; i >= 0; --i) {
            for (int j = 0; j < i; ++j) {
                boolean flag = false;
                if (sortField.equals("alpha")) {
                    flag = this.inAlphabeticOrderAsc(fileList[j], fileList[j + 1]);
                } else if (sortField.equals("alphd")) {
                    flag = this.inAlphabeticOrderDsc(fileList[j], fileList[j + 1]);
                } else if (sortField.equals("sza")) {
                    flag = this.isSortedBySizeAsc(fileList[j], fileList[j + 1]);
                } else if (sortField.equals("szd")) {
                    flag = this.isSortedBySizeDsc(fileList[j], fileList[j + 1]);
                } else if (sortField.equals("lma")) {
                    flag = this.isSortedByTimeAsc(fileList[j], fileList[j + 1]);
                } else if (sortField.equals("lmd")) {
                    flag = this.isSortedByTimeDsc(fileList[j], fileList[j + 1]);
                }
                if (!flag) continue;
                File tmp = fileList[j];
                fileList[j] = fileList[j + 1];
                fileList[j + 1] = tmp;
            }
        }
    }

    private boolean inAlphabeticOrderAsc(File file1, File file2) {
        return file1.getName().compareToIgnoreCase(file2.getName()) >= 0;
    }

    private boolean inAlphabeticOrderDsc(File file1, File file2) {
        return file2.getName().compareToIgnoreCase(file1.getName()) >= 0;
    }

    private boolean isSortedBySizeAsc(File file1, File file2) {
        if (file1.length() == file2.length()) {
            return file1.getName().compareToIgnoreCase(file2.getName()) >= 0;
        }
        return file1.length() > file2.length();
    }

    private boolean isSortedBySizeDsc(File file1, File file2) {
        if (file1.length() == file2.length()) {
            return file1.getName().compareToIgnoreCase(file2.getName()) >= 0;
        }
        return file1.length() < file2.length();
    }

    private boolean isSortedByTimeAsc(File file1, File file2) {
        if (file1.lastModified() == file2.lastModified()) {
            return file1.getName().compareToIgnoreCase(file2.getName()) >= 0;
        }
        return file1.lastModified() > file2.lastModified();
    }

    private boolean isSortedByTimeDsc(File file1, File file2) {
        if (file1.lastModified() == file2.lastModified()) {
            return file1.getName().compareToIgnoreCase(file2.getName()) >= 0;
        }
        return file1.lastModified() < file2.lastModified();
    }

    public String getSortField() {
        if (this.sortField == null) {
            return "alpha";
        }
        return this.sortField;
    }

    public void setSortField(String field) {
        this.sortField = field == null || !field.equals("alpha") && !field.equals("alphd") && !field.equals("sza") && !field.equals("szd") && !field.equals("lma") && !field.equals("lmd") ? "alpha" : field;
    }

    public void setAlertChildView(String childView) {
        if (childView != null) {
            this.alertChild = childView;
        }
    }

    public String getAlertChildView() {
        return this.alertChild;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.type == "file") {
            buffer.append("Selected File(s): \n");
        } else {
            buffer.append("Selected Folder(s): \n");
        }
        String dir = this.getCurrentDirectory();
        String[] fileList = this.getSelectedFiles();
        for (int i = 0; i < fileList.length; ++i) {
            buffer.append(dir).append(File.separator).append(fileList[i]).append("\n");
        }
        return buffer.toString();
    }

    private static class FileChooserFilter
    implements FileFilter {
        private String filterString = null;
        private String extPattern = null;
        private String namePattern = null;

        public FileChooserFilter() {
        }

        public FileChooserFilter(String filterString) {
            if (filterString != null) {
                this.filterString = filterString;
                this.filterString.trim();
                int index = filterString.indexOf(46);
                if (index == -1) {
                    this.namePattern = filterString;
                } else if (index == 0) {
                    if (filterString.length() > 1) {
                        this.extPattern = filterString.substring(1);
                    }
                } else if (index == filterString.length() - 1) {
                    this.namePattern = filterString.substring(0, index - 1);
                } else {
                    this.namePattern = filterString.substring(0, index);
                    this.extPattern = filterString.substring(index + 1);
                }
            }
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            if (this.filterString == null) {
                return true;
            }
            if (this.filterString.length() == 0) {
                return true;
            }
            if (this.filterString.equals("*")) {
                return true;
            }
            String fileName = f.getName();
            if (this.filterString.equals(fileName)) {
                return true;
            }
            String extension = this.getExtension(fileName);
            String name = this.getName(fileName);
            if (this.filterString.indexOf(46) == -1) {
                return this.check(fileName, this.filterString);
            }
            if (this.filterString.indexOf(46) != -1 && fileName.indexOf(46) == -1) {
                return false;
            }
            boolean nameFlag = this.check(name, this.namePattern);
            boolean extFlag = this.check(extension, this.extPattern);
            return nameFlag && extFlag;
        }

        private boolean check(String value, String pattern) {
            boolean flag = false;
            if (value == null && pattern == null) {
                flag = true;
            } else if (value == null && pattern != null) {
                if (pattern.equals("*")) {
                    flag = true;
                }
            } else if (value != null && pattern != null) {
                if (pattern.equals("*")) {
                    flag = true;
                } else if (pattern.equals(value)) {
                    flag = true;
                } else {
                    StringTokenizer st = new StringTokenizer(pattern, "*");
                    if (st.countTokens() == 1) {
                        if (pattern.endsWith("*") && pattern.startsWith("*")) {
                            flag = this.checkPattern(st, value);
                        } else if (pattern.endsWith("*")) {
                            String prefix = pattern.substring(0, pattern.length() - 1);
                            flag = value.startsWith(prefix);
                        } else if (pattern.startsWith("*")) {
                            String suffix = pattern.substring(1, pattern.length());
                            flag = value.endsWith(suffix);
                        }
                    } else {
                        flag = this.checkPattern(st, value);
                    }
                }
            }
            return flag;
        }

        private boolean checkPattern(StringTokenizer token, String name) {
            int position = 0;
            boolean flag = true;
            while (token.hasMoreTokens()) {
                String subset = token.nextToken();
                int index = name.indexOf(subset, position);
                if (index == -1) {
                    flag = false;
                    break;
                }
                position = index + subset.length();
            }
            return flag;
        }

        private String getExtension(String name) {
            String ext = null;
            if (name != null) {
                int i = name.indexOf(46);
                if (i == -1) {
                    return null;
                }
                if (i == 0) {
                    ext = name.substring(1);
                } else if (i < name.length() - 1) {
                    ext = name.substring(i + 1).toLowerCase();
                }
            }
            return ext;
        }

        private String getName(String name) {
            String fileName = null;
            int length = name.length();
            if (name != null) {
                int i = name.indexOf(46);
                if (i == -1) {
                    fileName = name;
                } else if (i == 0) {
                    fileName = null;
                } else if (i <= length - 1) {
                    fileName = name.substring(0, i);
                }
            }
            return fileName;
        }
    }
}

