/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.taglib.html;

import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.html.HtmlDisplayField;
import com.iplanet.jato.view.html.Option;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.taglib.html.CCSelectTag;
import com.sun.web.ui.view.html.CCOption;
import com.sun.web.ui.view.html.CCOptionSeparator;
import com.sun.web.ui.view.html.CCSelectableList;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;

public class CCSelectableListTag
extends CCSelectTag {
    protected static final String ATTRIB_MONOSPACE = "monospace";
    protected static final String ATTRIB_MULTIPLE = "multiple";
    protected static final String ATTRIB_SIZE = "size";
    protected static final String ATTRIB_DISABLESTYLEONLY = "disableStyleOnly";

    protected String getHTMLStringInternal(Tag parent, PageContext pageContext, View view) throws JspException {
        super.getHTMLStringInternal(parent, pageContext, view);
        NonSyncStringBuffer buffer = new NonSyncStringBuffer(8192);
        if (this.isNav4() && this.isTrue(this.getMonospace())) {
            buffer.append("<div style=\"font-family:monospace\"").append(">\n");
        }
        buffer.append("<select");
        CCSelectableListTag.appendAttribute(buffer, "name", this.field.getQualifiedName());
        CCSelectableListTag.appendAttribute(buffer, "id", this.getElementId());
        CCSelectableListTag.appendAttribute(buffer, "class", this.getSelectClassName());
        CCSelectableListTag.appendAttribute(buffer, ATTRIB_SIZE, this.getSize());
        if (this.isTrue(this.getMultiple())) {
            CCSelectableListTag.appendAttribute(buffer, ATTRIB_MULTIPLE, ATTRIB_MULTIPLE);
        }
        CCSelectableListTag.appendAttribute(buffer, "title", this.isTrue(this.getDisabled()) && this.getTitleDisabled() != null ? this.getMessage(this.getTitleDisabled()) : this.getMessage(this.getTitle()));
        this.appendCommonHtmlAttributes(buffer);
        this.appendJavaScriptAttributes(buffer);
        if (this.field instanceof HtmlDisplayField) {
            this.appendExtraHtml((HtmlDisplayField)this.field, buffer);
        }
        buffer.append(">");
        NonSyncStringBuffer buffer2 = new NonSyncStringBuffer();
        this.appendOptions(buffer2, this.field.getOptions().toOptionArray());
        this.appendNoneSelectedOption(buffer);
        buffer.append(buffer2.toString()).append("</select>");
        if (this.isNav4() && this.isTrue(this.getMonospace())) {
            buffer.append("</div>");
        }
        if (this.isTrue(this.getDynamic())) {
            this.appendHiddenFields(buffer);
            this.includeDynamicJS();
        }
        return buffer.toString();
    }

    protected String getSelectClassName() {
        String result = null;
        result = this.isTrue(this.getDisabled()) ? (this.isTrue(this.getMonospace()) ? "LstMnoDis" : "LstDis") : (this.isTrue(this.getMonospace()) ? "LstMno" : "Lst");
        return result;
    }

    protected String getOptionGroupClassName() {
        return "LstOptGrp";
    }

    protected String getOptionClassName(Option option) {
        String className = "LstOpt";
        if (option instanceof CCOption) {
            if (((CCOption)option).isDisabled()) {
                className = "LstOptDis";
                if (this.isTrue(this.getDisableStyleOnly())) {
                    ((CCOption)option).setDisabled(false);
                }
            }
        } else if (option instanceof CCOptionSeparator) {
            className = "LstOptSep";
        }
        return className;
    }

    protected String getNoneSelectedOptionClassName() {
        return "LstOptSel";
    }

    protected void setAttributes() throws JspException {
        super.setAttributes();
        if (this.field instanceof CCSelectableList) {
            CCSelectableList child = (CCSelectableList)this.field;
            if (child.getMonospace() != null) {
                this.setMonospace(child.getMonospace().toString());
            }
            if (child.getMultiple() != null) {
                this.setMultiple(child.getMultiple().toString());
            }
            if (child.getSize() != null) {
                this.setSize(child.getSize().toString());
            }
        }
    }

    public String getMonospace() {
        return (String)this.getValue(ATTRIB_MONOSPACE);
    }

    public void setMonospace(String value) {
        if (value != null && !value.toLowerCase().equals("true") && !value.toLowerCase().equals("false")) {
            CCDebug.trace1("Invalid parameter: " + value);
            return;
        }
        this.setValue(ATTRIB_MONOSPACE, value);
    }

    public String getMultiple() {
        return (String)this.getValue(ATTRIB_MULTIPLE);
    }

    public void setMultiple(String value) {
        if (value != null && !value.toLowerCase().equals("true") && !value.toLowerCase().equals("false")) {
            CCDebug.trace1("Invalid parameter: " + value);
            return;
        }
        this.setValue(ATTRIB_MULTIPLE, value);
    }

    public String getSize() {
        return (String)this.getValue(ATTRIB_SIZE);
    }

    public void setSize(String value) {
        String svalue = "2";
        if (value != null) {
            try {
                int i = Integer.parseInt(value);
                if (i > 2) {
                    svalue = value;
                }
            }
            catch (NumberFormatException nfe) {
                CCDebug.trace1("Invalid parameter: " + value);
            }
        }
        this.setValue(ATTRIB_SIZE, svalue);
    }

    public String getDisableStyleOnly() {
        return (String)this.getValue(ATTRIB_DISABLESTYLEONLY);
    }

    public void setDisableStyleOnly(String value) {
        if (value != null && !value.toLowerCase().equals("true") && !value.toLowerCase().equals("false")) {
            CCDebug.trace1("Invalid parameter: " + value);
            return;
        }
        this.setValue(ATTRIB_DISABLESTYLEONLY, value);
    }
}

