/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.taglib.propertysheet;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.HtmlUtil;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.JspDisplayEvent;
import com.iplanet.jato.view.html.Option;
import com.iplanet.jato.view.html.OptionList;
import com.iplanet.jato.view.html.SelectableGroup;
import com.sun.web.ui.common.CCBodyContentImpl;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.common.CCImage;
import com.sun.web.ui.common.CCJspWriterImpl;
import com.sun.web.ui.model.CCPropertySheetModelInterface;
import com.sun.web.ui.taglib.common.CCDescriptorTagBase;
import com.sun.web.ui.taglib.common.CCTagBase;
import com.sun.web.ui.taglib.help.CCHelpInlineTag;
import com.sun.web.ui.taglib.html.CCCheckBoxTag;
import com.sun.web.ui.taglib.html.CCHrefTag;
import com.sun.web.ui.taglib.html.CCLabelTag;
import com.sun.web.ui.taglib.html.CCRadioButtonTag;
import com.sun.web.ui.taglib.legend.CCLegendTag;
import com.sun.web.ui.taglib.spacer.CCSpacerTag;
import com.sun.web.ui.view.html.CCHref;
import com.sun.web.ui.view.html.CCLabel;
import com.sun.web.ui.view.propertysheet.CCPropertySheet;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTag;
import javax.servlet.jsp.tagext.Tag;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CCPropertySheetTag
extends CCDescriptorTagBase {
    private static final String ATTRIB_SHOW_JUMP_LINKS = "CCPropertySheetTag.jumpLinks";
    private static final String ATTRIB_ADD_JAVASCRIPT = "CCPropertySheetTag.addJavaScript";
    private static final int DEFAULT_LABEL_WIDTH = 0;
    protected int numberOfSections;
    private ArrayList visibleSectionIndexes;
    protected int labelIdCount = 0;
    protected int labelWidth = 0;
    protected CCLabel labelChild = null;
    protected CCHref hrefChild = null;
    protected ContainerView containerView = null;
    protected ArrayList requiredFieldIDs = new ArrayList();
    protected ArrayList requiredFieldMessages = new ArrayList();
    protected ArrayList requiredFieldFunctions = new ArrayList();

    public void reset() {
        super.reset();
        this.containerView = null;
        this.numberOfSections = 0;
        this.visibleSectionIndexes = null;
        this.labelIdCount = 0;
        this.labelChild = null;
        this.hrefChild = null;
        this.labelWidth = 0;
        this.requiredFieldIDs.clear();
        this.requiredFieldMessages.clear();
        this.requiredFieldFunctions.clear();
    }

    protected String getHTMLStringInternal(Tag parent, PageContext pageContext, View view) throws JspException {
        if (parent == null) {
            throw new IllegalArgumentException("parent cannot be null.");
        }
        if (pageContext == null) {
            throw new IllegalArgumentException("pageContext cannot be null.");
        }
        if (view == null) {
            throw new IllegalArgumentException("view cannot be null.");
        }
        super.getHTMLStringInternal(parent, pageContext, view);
        this.checkChildType(view, CCPropertySheet.class);
        CCPropertySheet field = (CCPropertySheet)view;
        this.containerView = field.getContainerView() != null ? field.getContainerView() : (ContainerView)field.getParent();
        CCPropertySheetModelInterface model = field.getModel();
        if (model == null) {
            throw new IllegalArgumentException("PropertySheet model cannot be null");
        }
        if (model.getDocument() == null) {
            throw new RuntimeException("The property sheet model getDocument() returned null.\nBe sure a valid XML file was supplied to the property sheet model.");
        }
        this.setParent(parent);
        this.setPageContext(pageContext);
        if (field.getShowJumpLinks() != null) {
            this.setShowJumpLinks(field.getShowJumpLinks().toString());
        }
        NonSyncStringBuffer buffer = new NonSyncStringBuffer(8192);
        try {
            field.beginDisplay((DisplayEvent)new JspDisplayEvent((Tag)this, pageContext));
        }
        catch (ModelControlException e) {
            throw new JspException(e.getRootCause());
        }
        NodeList sections = this.getSections(model);
        this.numberOfSections = sections.getLength();
        this.visibleSectionIndexes = new ArrayList(this.numberOfSections);
        for (int i = 0; i < this.numberOfSections; ++i) {
            if (!this.isVisible(sections.item(i), model)) continue;
            this.visibleSectionIndexes.add(new Integer(i));
        }
        this.appendSections(buffer, sections, model);
        this.appendJavaScript(buffer);
        return buffer.toString();
    }

    protected void appendSections(NonSyncStringBuffer buffer, NodeList sections, CCPropertySheetModelInterface model) throws JspException {
        if (this.visibleSectionIndexes.size() == 0) {
            return;
        }
        this.appendJumpLinks(buffer, sections, model);
        boolean added = false;
        for (int i = 0; i < this.numberOfSections; ++i) {
            Node section = sections.item(i);
            if (!this.isVisible(section, model)) continue;
            if (added) {
                this.appendSeparator(buffer);
            }
            this.appendSection(buffer, section, model);
            if (this.hasJumpLinks()) {
                this.appendBackToTop(buffer);
            } else {
                buffer.append(this.getSpacerHTMLString("10", "1"));
            }
            added = true;
        }
    }

    protected void appendJumpLinks(NonSyncStringBuffer buffer, NodeList sections, CCPropertySheetModelInterface model) throws JspException {
        if (this.hasJumpLinks()) {
            this.appendJumpLinks(buffer, sections);
            if (this.hasRequiredProperties(model)) {
                this.appendRequiredFieldLegend(buffer);
            } else {
                buffer.append(this.getSpacerHTMLString("10", "1"));
            }
            this.appendSeparator(buffer);
        } else if (this.hasRequiredProperties(model)) {
            this.appendRequiredFieldLegend(buffer);
        } else {
            buffer.append(this.getSpacerHTMLString("15", "1"));
        }
    }

    protected void appendSection(NonSyncStringBuffer buffer, Node section, CCPropertySheetModelInterface model) throws JspException {
        String name;
        Node child;
        int i;
        int maxLength = 0;
        NodeList children = section.getChildNodes();
        int length = children.getLength();
        if (length == 0) {
            return;
        }
        this.appendSectionHead(buffer, section);
        boolean processingProps = false;
        boolean propsAvailable = false;
        String labelWidth = this.getLabelWidth(section, "labelWidth");
        if (labelWidth.equals("true")) {
            for (i = 0; i < length; ++i) {
                child = children.item(i);
                name = child.getNodeName();
                if (!name.equalsIgnoreCase("property")) continue;
                propsAvailable = true;
                NodeList propChild = child.getChildNodes();
                int len = propChild.getLength();
                if (len == 0) continue;
                for (int k = 0; k < len; ++k) {
                    int tempLength;
                    Node attri = propChild.item(k);
                    String attriName = attri.getNodeName();
                    if (!attriName.equals("label") || (tempLength = this.getNameHTML(attri).length()) <= maxLength) continue;
                    maxLength = tempLength;
                }
            }
            if (!propsAvailable) {
                maxLength = -1;
            }
        }
        for (i = 0; i < length; ++i) {
            child = children.item(i);
            if (!this.isVisible(child, model)) continue;
            name = child.getNodeName();
            if (name.equalsIgnoreCase("property")) {
                if (!processingProps) {
                    this.appendPropertyListStart(buffer);
                    processingProps = true;
                }
                this.appendProperty(buffer, child, model, 1, maxLength);
                continue;
            }
            if (!name.equalsIgnoreCase("subsection")) continue;
            if (processingProps) {
                this.appendPropertyListEnd(buffer);
                processingProps = false;
            }
            this.appendSubsection(buffer, child, model, 1, maxLength);
        }
        if (processingProps) {
            this.appendPropertyListEnd(buffer);
        }
        this.appendEndSectionHead(buffer);
    }

    protected void appendSubsection(NonSyncStringBuffer buffer, Node subsection, CCPropertySheetModelInterface model, int level, int labelWidth) throws JspException {
        this.labelWidth = labelWidth;
        this.appendSubsection(buffer, subsection, model, level);
    }

    protected void appendSubsection(NonSyncStringBuffer buffer, Node subsection, CCPropertySheetModelInterface model, int level) throws JspException {
        int maxLength = 0;
        NodeList properties = this.getProperties(subsection);
        if (properties.getLength() == 0) {
            return;
        }
        this.appendSubsectionHead(buffer, subsection);
        this.appendPropertyListStart(buffer);
        String lwidth = this.getLabelWidth(subsection, "labelWidth");
        if (lwidth.equals("true") || (this.labelWidth == -1 || this.labelWidth > 0) && !lwidth.equals("false")) {
            for (int l = 0; l < properties.getLength(); ++l) {
                NodeList propChild = properties.item(l).getChildNodes();
                int len = propChild.getLength();
                for (int k = 0; k < len; ++k) {
                    int tempLength;
                    Node attri = propChild.item(k);
                    String attriName = attri.getNodeName();
                    if (!attriName.equals("label") || (tempLength = this.getNameHTML(attri).length()) <= maxLength) continue;
                    maxLength = tempLength;
                }
            }
        } else {
            maxLength = !lwidth.equals("false") ? this.labelWidth : 0;
        }
        this.appendProperties(buffer, properties, model, level, maxLength);
        this.appendPropertyListEnd(buffer);
        this.appendEndSubsectionHead(buffer);
        this.labelWidth = 0;
    }

    protected void appendValueSet(NonSyncStringBuffer buffer, Node valueSet, CCPropertySheetModelInterface model, int level) throws JspException {
        NodeList properties = this.getProperties(valueSet);
        if (properties.getLength() == 0) {
            return;
        }
        this.appendPropertyListStart(buffer);
        this.appendProperties(buffer, properties, model, level, 0);
        this.appendPropertyListEnd(buffer);
    }

    protected void appendProperties(NonSyncStringBuffer buffer, NodeList properties, CCPropertySheetModelInterface model, int level, int labelWidth) throws JspException {
        this.labelWidth = labelWidth;
        this.appendProperties(buffer, properties, model, level);
    }

    protected void appendProperties(NonSyncStringBuffer buffer, NodeList properties, CCPropertySheetModelInterface model, int level) throws JspException {
        int length = properties.getLength();
        for (int i = 0; i < length; ++i) {
            Node property = properties.item(i);
            if (!this.isVisible(property, model)) continue;
            this.appendProperty(buffer, property, model, level, this.labelWidth);
        }
        this.labelWidth = 0;
    }

    protected void appendProperty(NonSyncStringBuffer buffer, Node property, CCPropertySheetModelInterface model, int level, int labelWidth) throws JspException {
        this.labelWidth = labelWidth;
        this.appendProperty(buffer, property, model, level);
    }

    protected void appendProperty(NonSyncStringBuffer buffer, Node property, CCPropertySheetModelInterface model, int level) throws JspException {
        boolean colspan;
        buffer.append("<tr>\n");
        String labelId = null;
        boolean hasNoValueElement = this.hasNoValueElement(property);
        boolean bl = colspan = this.isSpan(property) || hasNoValueElement;
        if (!colspan) {
            labelId = this.appendLabel(buffer, property, model, level, this.labelWidth);
        }
        if (colspan) {
            buffer.append("<td valign=\"top\" colspan=\"2\"><div class=\"");
        } else {
            buffer.append("<td valign=\"top\"><div class=\"");
        }
        buffer.append(this.getDivClass(colspan, level)).append("\">");
        NodeList subNodes = property.getChildNodes();
        for (int i = 0; i < subNodes.getLength(); ++i) {
            Node subNode = subNodes.item(i);
            String nodeName = subNode.getNodeName();
            if (nodeName.equalsIgnoreCase("cc")) {
                boolean isTableTag;
                if (i != 0) {
                    buffer.append("\n");
                }
                if (isTableTag = this.isTableTag(subNode, colspan, level)) {
                    this.preTableFormat(buffer);
                }
                labelId = this.appendValue(buffer, subNode, labelId, level > 1 || !colspan);
                if (!isTableTag) continue;
                this.postTableFormat(buffer, colspan, level);
                continue;
            }
            if (nodeName.equalsIgnoreCase("fieldhelp")) {
                this.appendFieldHelp(buffer, this.getNameHTML(subNode));
                continue;
            }
            if (nodeName.equalsIgnoreCase("ccgroup")) {
                this.appendValueSet(buffer, subNode, model, level + 1);
                continue;
            }
            if (nodeName.equalsIgnoreCase("label")) {
                if (!hasNoValueElement) continue;
                String labelHTML = this.getNameHTML(subNode);
                String style = level > 1 ? "LblLev3Txt" : "LblLev2Txt";
                buffer.append(this.getLabelHTMLString(style, null, null, this.isError(property, model), this.isRequired(property), labelHTML));
                continue;
            }
            String html = subNode.getNodeValue();
            if (html == null) continue;
            buffer.append(html.trim());
        }
        buffer.append("</div></td></tr>\n");
        this.labelWidth = 0;
    }

    protected String appendValue(NonSyncStringBuffer buff, Node valueNode, String labelId, boolean level3Style) throws JspException {
        String returnId = labelId;
        if (this.isIDforTagNeeded(valueNode)) {
            returnId = null;
        } else {
            labelId = null;
        }
        String html = this.getValueHTML(valueNode, labelId, level3Style);
        if (html == null) {
            return returnId;
        }
        if (labelId != null && html.indexOf(60) < 0) {
            buff.append("<span id=\"").append(labelId).append("\" class=\"ConDefTxt\">").append(html).append("</span>");
        } else {
            buff.append(html);
        }
        return returnId;
    }

    protected String appendLabel(NonSyncStringBuffer buff, Node property, CCPropertySheetModelInterface model, int level, int labelWidth) throws JspException {
        this.labelWidth = labelWidth;
        return this.appendLabel(buff, property, model, level);
    }

    protected String appendLabel(NonSyncStringBuffer buff, Node property, CCPropertySheetModelInterface model, int level) throws JspException {
        String labelForId = null;
        String style = level > 1 ? "LblLev3Txt" : "LblLev2Txt";
        String labelHTML = null;
        Node labelNode = this.getPropertySubElement(property, "label");
        if (labelNode != null) {
            labelHTML = this.getNameHTML(labelNode);
        }
        if (labelHTML == null) {
            buff.append("<td><div class=\"").append(this.getDivClass(true, level)).append("\"><span class=\"").append(style).append("\">&nbsp;</span></div></td>\n");
            return labelForId;
        }
        labelHTML.trim();
        buff.append("<td valign=\"top\"");
        String align = this.getAlignLabel(labelNode);
        if (align != null) {
            buff.append(" align=\"").append(align).append("\"");
        }
        if (this.getWrapLabel(labelNode)) {
            buff.append(">\n");
        } else {
            buff.append(" nowrap=\"nowrap\">\n");
        }
        buff.append("<div class=\"").append(this.getDivClass(true, level)).append("\">");
        if (this.labelWidth > 0) {
            buff.append(CCPropertySheetTag.getImageHTMLString(CCImage.DOT, 1, this.labelWidth * 16));
            buff.append("<br>");
        }
        if (this.isLabelForNeeded(property)) {
            labelForId = this.getAttributeValue(labelNode, "Id", null);
            if (labelForId == null) {
                labelForId = this.getNextLabelId();
            } else if (labelForId.equals("null")) {
                labelForId = null;
            }
        }
        String labelForElement = this.getAttributeValue(labelNode, "labelFor", null);
        if (this.addJavaScript() && labelForId != null) {
            this.setJavaScriptArrays(property, labelForId, labelHTML);
        }
        String addColon = this.getAttributeValue(labelNode, "addColon", "true");
        if (!labelHTML.endsWith(":") && addColon.equalsIgnoreCase("true")) {
            labelHTML = labelHTML + ":";
        }
        buff.append(this.getLabelHTMLString(style, labelForId, labelForElement, this.isError(property, model), this.isRequired(property), labelHTML));
        buff.append("</div></td>\n");
        this.labelWidth = 0;
        return labelForElement == null ? labelForId : null;
    }

    protected void appendFieldHelp(NonSyncStringBuffer buffer, String helpText) throws JspException {
        if (helpText == null || helpText.trim().length() == 0) {
            return;
        }
        helpText = HtmlUtil.escape((String)helpText);
        CCBodyContentImpl bodyContent = new CCBodyContentImpl(new CCJspWriterImpl(null, 100, false));
        try {
            bodyContent.print(helpText);
        }
        catch (IOException e) {
            CCDebug.trace3(e.getMessage());
        }
        CCHelpInlineTag helpTag = new CCHelpInlineTag();
        helpTag.setBodyContent(bodyContent);
        helpTag.setType("field");
        helpTag.setTabIndex(this.getTabIndex());
        helpTag.setName("propertySheetInLineHelp");
        String help = null;
        if (this.fireBeginDisplayEvent(this.containerView, helpTag) && (help = helpTag.getHTMLString(this.getParent(), this.pageContext, null)) != null && help.trim().length() > 0) {
            help = "<br />" + help;
        }
        if ((help = this.fireEndDisplayEvent(this.containerView, helpTag, help)) != null && help.trim().length() > 0) {
            buffer.append(help);
        }
    }

    protected String getDivClass(boolean firstColumn, int level) {
        if (firstColumn && level == 1) {
            return "ConTblCl1Div";
        }
        if (!firstColumn && level == 1) {
            return "ConTblCl2Div";
        }
        if (firstColumn && level > 1) {
            return "ConEmbTblCl1Div";
        }
        if (!firstColumn && level > 1) {
            return "ConEmbTblCl2Div";
        }
        return null;
    }

    protected boolean isIDforTagNeeded(Node valueNode) {
        String tagClass = this.getAttributeValue(valueNode, "tagclass", null);
        if (tagClass == null) {
            return false;
        }
        if (tagClass.equals("com.sun.web.ui.taglib.html.CCCheckBoxTag")) {
            return false;
        }
        if (tagClass.equals("com.sun.web.ui.taglib.html.CCRadioButtonTag")) {
            return false;
        }
        if (tagClass.equals("com.sun.web.ui.taglib.datetime.CCDateTimeTag")) {
            return false;
        }
        if (tagClass.equals("com.sun.web.ui.taglib.addremove.CCAddRemoveTag")) {
            return false;
        }
        if (tagClass.equals("com.sun.web.ui.taglib.table.CCActionTableTag")) {
            return false;
        }
        if (tagClass.equals("com.sun.web.ui.taglib.html.CCHrefTag")) {
            return false;
        }
        if (tagClass.equals("com.sun.web.ui.taglib.html.CCButtonTag")) {
            return false;
        }
        if (tagClass.equals("com.sun.web.ui.taglib.wizard.CCWizardWindowTag")) {
            return false;
        }
        if (tagClass.equals("com.sun.web.ui.taglib.spacer.CCSpacerTag")) {
            return false;
        }
        if (tagClass.equals("com.sun.web.ui.taglib.filechooser.CCFileChooserTag")) {
            return false;
        }
        return !tagClass.equals("com.sun.web.ui.taglib.filechooser.CCFileChooserWindowTag");
    }

    protected String getHrefHTMLString(String anchor, String type, String title, String content) throws JspException {
        CCHrefTag href = new CCHrefTag();
        href.setAnchor(anchor);
        href.setType(type);
        href.setTitle(title);
        href.setTabIndex(this.getTabIndex());
        href.setName("propertySheetJumpLink");
        try {
            CCBodyContentImpl bodyContent = new CCBodyContentImpl(new CCJspWriterImpl(null, 100, false));
            bodyContent.print(HtmlUtil.escape((String)this.getMessage(content)));
            href.setBodyContent(bodyContent);
        }
        catch (IOException e) {
            CCDebug.trace1(e.getMessage());
        }
        if (this.hrefChild == null) {
            this.hrefChild = new CCHref(this.containerView, "_PropertySheetJumpLink", null);
        }
        String html = "";
        if (this.fireBeginDisplayEvent(this.containerView, href)) {
            html = href.getHTMLString(this.getParent(), this.pageContext, (View)this.hrefChild);
        }
        return this.fireEndDisplayEvent(this.containerView, href, html);
    }

    protected String getLabelHTMLString(String style, String labelId, String elementName, boolean isError, boolean isRequired, String content) throws JspException {
        CCLabelTag labelTag = new CCLabelTag();
        labelTag.setStyleClass(style);
        labelTag.setElementId(labelId);
        labelTag.setShowError(new Boolean(isError).toString());
        labelTag.setShowRequired(new Boolean(isRequired).toString());
        labelTag.setName("propertySheetLabel");
        if (elementName != null && labelId != null) {
            labelTag.setElementName(elementName);
        }
        if (this.labelChild == null) {
            this.labelChild = new CCLabel(this.containerView, "_PropertySheetLabel", content);
        }
        this.labelChild.setValue(content);
        String html = "";
        if (this.fireBeginDisplayEvent(this.containerView, labelTag)) {
            html = labelTag.getHTMLString(this.getParent(), this.pageContext, (View)this.labelChild);
        }
        return this.fireEndDisplayEvent(this.containerView, labelTag, html);
    }

    protected String getSpacerHTMLString(String height, String width) throws JspException {
        CCSpacerTag spacerTag = new CCSpacerTag();
        spacerTag.setNewline("true");
        spacerTag.setHeight(height);
        spacerTag.setWidth(width);
        return spacerTag.getHTMLString(this.getParent(), this.pageContext, null);
    }

    protected String getLegendHTMLString(String align, String top, String right, String bottom, String left) throws JspException {
        CCLegendTag legendTag = new CCLegendTag();
        legendTag.setAlign(align);
        legendTag.setMarginTop(top);
        legendTag.setMarginRight(right);
        legendTag.setMarginBottom(bottom);
        legendTag.setMarginLeft(left);
        return legendTag.getHTMLString(this.getParent(), this.pageContext, null);
    }

    protected String getNextLabelId() {
        ++this.labelIdCount;
        return "psLbl" + this.labelIdCount;
    }

    protected NodeList getSections(CCPropertySheetModelInterface model) {
        return model.getDocument().getElementsByTagName("section");
    }

    protected NodeList getProperties(Node node) {
        return node.getChildNodes();
    }

    protected boolean hasRequiredProperties(CCPropertySheetModelInterface model) {
        NodeList sections = this.getSections(model);
        int nSections = sections.getLength();
        for (int index = 0; index < nSections; ++index) {
            if (!this.hasRequiredProperties(model, (Element)sections.item(index))) continue;
            return true;
        }
        return false;
    }

    private boolean hasRequiredProperties(CCPropertySheetModelInterface model, Element elt) {
        String tagClass;
        if (!this.isVisible(elt, model)) {
            return false;
        }
        if (this.isRequired(elt)) {
            return true;
        }
        if (elt.getNodeName().equals("cc") && (tagClass = this.getAttributeValue(elt, "tagclass", null)) != null && tagClass.equals("com.sun.web.ui.taglib.datetime.CCDateTimeTag")) {
            return true;
        }
        NodeList children = elt.getChildNodes();
        if (children == null) {
            return false;
        }
        Node child = null;
        int nChildren = children.getLength();
        for (int index = 0; index < nChildren; ++index) {
            child = children.item(index);
            if (child.getNodeType() != 1 || !this.hasRequiredProperties(model, (Element)child)) continue;
            return true;
        }
        return false;
    }

    protected String getAnchor(Node sectionNode) {
        return this.getAttributeValue(sectionNode, "name", "");
    }

    protected String getAttributeValue(Node node, String attrName, String defaultValue) {
        NamedNodeMap nodeAttrs;
        Node nameNode;
        if (node == null) {
            return defaultValue;
        }
        String value = null;
        if (node.hasAttributes() && (nameNode = (nodeAttrs = node.getAttributes()).getNamedItem(attrName)) != null) {
            value = nameNode.getNodeValue();
        }
        return value == null ? defaultValue : value;
    }

    protected boolean getWrapLabel(Node labelNode) throws JspException {
        String value = this.getAttributeValue(labelNode, "wrap", "true");
        return new Boolean(value);
    }

    protected String getAlignLabel(Node labelNode) throws JspException {
        String value = this.getAttributeValue(labelNode, "align", null);
        return value;
    }

    protected String getLabelWidth(Node node, String type) throws JspException {
        String value = this.getAttributeValue(node, type, null);
        if (value == null) {
            value = "null";
        }
        return value;
    }

    protected boolean isRequired(Node propertyNode) {
        String value = this.getAttributeValue(propertyNode, "required", "false");
        return new Boolean(value);
    }

    protected String getRequiredMsg(Node propertyNode, String label) {
        String value = this.getAttributeValue(propertyNode, "alertMsg", null);
        if (value == null) {
            return label;
        }
        Object[] args = new String[]{label};
        return this.getMessage(value, args);
    }

    protected void setJavaScriptArrays(Node property, String labelForId, String labelHTML) {
        String functionName = this.getAttributeValue(property, "checkFunction", null);
        if (functionName == null) {
            if (this.isRequired(property)) {
                functionName = "ps_checkForValue";
            } else {
                return;
            }
        }
        this.requiredFieldIDs.add(labelForId);
        this.requiredFieldMessages.add(this.getRequiredMsg(property, labelHTML));
        this.requiredFieldFunctions.add(functionName);
    }

    protected boolean isSpan(Node propertyNode) throws JspException {
        Node labelNode = this.getPropertySubElement(propertyNode, "label");
        if (labelNode != null) {
            return false;
        }
        String value = this.getAttributeValue(propertyNode, "span", "false");
        return new Boolean(value);
    }

    protected boolean isTableTag(Node valueNode, boolean span, int level) {
        String tagClass = this.getAttributeValue(valueNode, "tagclass", null);
        return tagClass.equals("com.sun.web.ui.taglib.table.CCActionTableTag") && span && level == 1;
    }

    protected Node getPropertySubElement(Node propertyNode, String elementName) throws JspException {
        for (Node labelNode = propertyNode.getFirstChild(); labelNode != null; labelNode = labelNode.getNextSibling()) {
            if (!labelNode.getNodeName().equalsIgnoreCase(elementName)) {
                continue;
            }
            return labelNode;
        }
        return null;
    }

    protected String getDefaultValue(Node node) throws JspException {
        String html = this.getAttributeValue(node, "defaultValue", null);
        if (html != null) {
            return this.getMessage(html);
        }
        return "";
    }

    protected boolean isLabelForNeeded(Node propertyNode) {
        NodeList subNodes = propertyNode.getChildNodes();
        for (int i = 0; i < subNodes.getLength(); ++i) {
            Node valueNode = subNodes.item(i);
            String nodeName = valueNode.getNodeName();
            if (nodeName == null || !nodeName.equalsIgnoreCase("cc") || !this.isIDforTagNeeded(valueNode)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasNoValueElement(Node propertyNode) {
        NodeList subNodes = propertyNode.getChildNodes();
        for (int i = 0; i < subNodes.getLength(); ++i) {
            Node valueNode = subNodes.item(i);
            String nodeName = valueNode.getNodeName();
            if (nodeName == null || !nodeName.equalsIgnoreCase("cc")) continue;
            return false;
        }
        return true;
    }

    protected boolean isVisible(Node node, CCPropertySheetModelInterface model) {
        String name = this.getAttributeValue(node, "name", null);
        if (name != null) {
            return model.isVisible(name);
        }
        return true;
    }

    protected boolean isError(Node propertyNode, CCPropertySheetModelInterface model) throws JspException {
        String value = this.getAttributeValue(propertyNode, "error", null);
        if (value != null) {
            return new Boolean(value);
        }
        String name = this.getAttributeValue(propertyNode, "name", null);
        if (name != null) {
            return model.isErrorProperty(name);
        }
        Node labelNode = this.getPropertySubElement(propertyNode, "label");
        if (labelNode != null && (name = this.getAttributeValue(labelNode, "name", null)) != null) {
            return model.isErrorProperty(name);
        }
        return false;
    }

    protected String getNameHTML(Node node) throws JspException {
        if (!node.hasAttributes()) {
            CCDebug.trace1("Node missing the name attribute.");
            return "";
        }
        String viewName = this.getAttributeValue(node, "name", null);
        if (viewName == null) {
            return this.getDefaultValue(node);
        }
        View child = this.containerView.getChild(viewName);
        CCTagBase tag = this.getCCTag("com.sun.web.ui.taglib.html.CCStaticTextFieldTag");
        tag.setName(viewName);
        if (tag.getBundleID() == null) {
            tag.setBundleID(this.getBundleID());
        }
        tag.setTabIndex(this.getTabIndex());
        String html = "";
        if (this.fireBeginDisplayEvent(this.containerView, tag) && ((html = tag.getHTMLString(this.getParent(), this.pageContext, child)) == null || html.equals(""))) {
            html = this.getDefaultValue(node);
        }
        return this.fireEndDisplayEvent(this.containerView, tag, html);
    }

    protected String getValueHTML(Node valueNode, String labelId, boolean levelThree) throws JspException, IllegalArgumentException {
        if (valueNode == null) {
            CCDebug.trace1("Property node missing value element");
            return null;
        }
        String viewName = this.getAttributeValue(valueNode, "name", "");
        String tagclassName = this.getAttributeValue(valueNode, "tagclass", "com.sun.web.ui.taglib.html.CCStaticTextFieldTag");
        View child = null;
        if (!tagclassName.equals("com.sun.web.ui.taglib.spacer.CCSpacerTag")) {
            child = this.containerView.getChild(viewName);
        }
        CCTagBase tag = this.getCCTag(tagclassName);
        tag.setName(viewName);
        if (labelId != null) {
            tag.setElementId(labelId);
        }
        if (tagclassName.equals("com.sun.web.ui.taglib.html.CCCheckBoxTag")) {
            CCCheckBoxTag cb = (CCCheckBoxTag)tag;
            cb.setStyleLevel(levelThree ? "3" : "2");
            cb.setElementId(this.getNextLabelId());
        } else if (tagclassName.equals("com.sun.web.ui.taglib.html.CCRadioButtonTag")) {
            CCRadioButtonTag rb = (CCRadioButtonTag)tag;
            rb.setStyleLevel(levelThree ? "3" : "2");
            rb.setElementId(this.getNextLabelId());
        }
        if (valueNode.hasChildNodes()) {
            NodeList childNodeList = valueNode.getChildNodes();
            CCBodyContentImpl bodyContent = null;
            if (tag instanceof BodyTag) {
                bodyContent = new CCBodyContentImpl(new CCJspWriterImpl(null, 100, false));
            }
            OptionList options = null;
            if (child != null && child instanceof SelectableGroup) {
                options = new OptionList();
            }
            for (int i = 0; i < childNodeList.getLength(); ++i) {
                this.parseValueChildNode(childNodeList.item(i), tag, bodyContent, options);
            }
            if (bodyContent != null) {
                ((BodyTag)tag).setBodyContent((BodyContent)bodyContent);
            }
            if (options != null && options.size() > 0) {
                ((SelectableGroup)child).setOptions(options);
            }
        }
        if (tag.getBundleID() == null) {
            tag.setBundleID(this.getBundleID());
        }
        tag.setTabIndex(this.getTabIndex());
        String html = null;
        if (this.fireBeginDisplayEvent(this.containerView, tag)) {
            html = tag.getHTMLString(this.getParent(), this.pageContext, child);
        }
        return this.fireEndDisplayEvent(this.containerView, tag, html);
    }

    protected void parseValueChildNode(Node node, CCTagBase tag, BodyContent bodyContent, OptionList options) throws JspException {
        String nodeName = node.getNodeName();
        if (nodeName == null) {
            CCDebug.trace1("Unable to obtain child node");
            return;
        }
        if (nodeName.equals("attribute")) {
            this.parseAttributeElement(node, tag);
        } else if (nodeName.equals("option") || nodeName.equals("optionGroup") || nodeName.equals("optionSeparator")) {
            if (options == null) {
                throw new IllegalArgumentException("The content of element named ccis invalid, " + ((Object)((Object)tag)).getClass().getName() + " does not implement SelectableGroup");
            }
            Option option = null;
            if (nodeName.equals("option")) {
                option = this.parseOptionElement(node);
            } else if (nodeName.equals("optionGroup")) {
                option = this.parseOptionGroupElement(node);
            } else if (nodeName.equals("optionSeparator")) {
                option = this.parseOptionSeparatorElement(node);
            }
            if (option != null) {
                options.add(option);
            }
        } else if (nodeName.equals("cc")) {
            if (bodyContent == null) {
                throw new IllegalArgumentException("The content of element named ccis invalid, " + ((Object)((Object)tag)).getClass().getName() + " does not implement BodyTag");
            }
            try {
                String html = this.getValueHTML(node, null, true);
                bodyContent.print(html != null && html.trim().length() > 0 ? html : "");
            }
            catch (IOException e) {
                CCDebug.trace3(e.getMessage());
            }
        } else {
            if (bodyContent == null) {
                return;
            }
            try {
                bodyContent.print(node.getNodeValue() != null ? node.getNodeValue().trim() : "");
            }
            catch (IOException e) {
                CCDebug.trace3(e.getMessage());
            }
        }
    }

    protected void setTagAttributes(View child, CCTagBase tag, String element) throws JspException {
    }

    protected void appendJavaScriptFunctions(NonSyncStringBuffer buff) {
        buff.append("\nfunction ps_CheckRequiredFields() {\n    var i;\n    for (i = 0; i < reqFieldIDs.length; i++) {\n\tvar field = document.getElementById(reqFieldIDs[i]);\n\tif (field != null) {\n\t    if (reqFieldFunctions[i] != null && reqFieldFunctions[i](field) == false) {\n\t\talert(reqFieldMessages[i]);\n\t\tfield.focus();\n\t\treturn false;\n\t    }\n\t}\n    }\n    return true;\n}\n");
        if (this.requiredFieldFunctions.contains("ps_checkForSelection")) {
            buff.append("\nfunction ps_checkForSelection(formField) {\n    return (formField.selectedIndex != 0);\n}\n");
        }
        boolean addSupportFunction = false;
        if (this.requiredFieldFunctions.contains("ps_checkForValue")) {
            buff.append("\nfunction ps_checkForValue(formField) {\n    var result = (formField.value != '') && (ps_isInCharSet(formField.value, \" \\t\\n\\r\") == false);\n    if (result == false) formField.select();\n    return result;\n}\n");
            addSupportFunction = true;
        }
        if (this.requiredFieldFunctions.contains("ps_checkForNumericValue")) {
            buff.append("\nfunction ps_checkForNumericValue(formField) {\n    var result = (formField.value != '') && ps_isInCharSet(formField.value, \"0123456789.\");\n    if (result == false) formField.select();\n    return result;\n}\n");
            addSupportFunction = true;
        }
        if (addSupportFunction) {
            buff.append("\nfunction ps_isInCharSet(str, charSet) {\n    var i;\n    for (i = 0; i < str.length; i++) {\n\tvar c = str.charAt(i);\n\tif (charSet.indexOf(c) < 0) {\n\t    return false;\n\t}\n    }\n    return true;\n}\n");
        }
    }

    protected void appendJavaScript(NonSyncStringBuffer buff) {
        if (!this.addJavaScript()) {
            return;
        }
        buff.append("\n<script language=\"JavaScript\">\n// <!--\n");
        if (this.requiredFieldIDs.size() == 0) {
            buff.append("\nfunction ps_CheckRequiredFields() {\n    return true;\n}\n");
        } else {
            int i;
            if (this.requiredFieldFunctions.size() > 0) {
                this.appendJavaScriptFunctions(buff);
                buff.append("\nvar reqFieldFunctions = new Object();\n");
                for (i = 0; i < this.requiredFieldFunctions.size(); ++i) {
                    buff.append("reqFieldFunctions[").append(i).append("] = ").append((String)this.requiredFieldFunctions.get(i)).append(";\n");
                }
            }
            buff.append("\nvar reqFieldIDs = new Array();\n");
            for (i = 0; i < this.requiredFieldIDs.size(); ++i) {
                buff.append("reqFieldIDs[").append(i).append("] = \"").append((String)this.requiredFieldIDs.get(i)).append("\";\n");
            }
            buff.append("\nvar reqFieldMessages = new Array();\n");
            for (i = 0; i < this.requiredFieldMessages.size(); ++i) {
                buff.append("reqFieldMessages[").append(i).append("] = \"").append((String)this.requiredFieldMessages.get(i)).append("\";\n");
            }
        }
        buff.append("// -->\n</script>\n\n");
    }

    protected void appendSeparator(NonSyncStringBuffer buff) {
        buff.append("\n<table width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" title=\"\"><tr><td>\n").append(CCPropertySheetTag.getImageHTMLString(CCImage.DOT, "1", "10")).append("</td><td class=\"ConLin\" width=\"100%\">").append(CCPropertySheetTag.getImageHTMLString(CCImage.DOT, "1", "1")).append("</td></tr></table>\n\n");
    }

    protected void appendRequiredFieldLegend(NonSyncStringBuffer buff) throws JspException {
        buff.append(this.getLegendHTMLString("right", "5", "10", "5", "0"));
    }

    protected void appendSectionHead(NonSyncStringBuffer buff, Node sectionNode) throws JspException {
        String sectionName = this.getNameHTML(sectionNode);
        String anchor = this.getAnchor(sectionNode);
        if (anchor.equals("")) {
            anchor = sectionName;
        }
        if (this.hasJumpLinks()) {
            buff.append("<a name=\"").append(anchor).append("\" id=\"").append(anchor).append("\"></a>\n");
        }
        if (this.isIe()) {
            buff.append("<fieldset class=\"ConFldSet\">");
            if (!sectionName.equals("")) {
                buff.append("<legend class=\"ConFldSetLgd\">");
                buff.append(sectionName);
                buff.append("</legend>\n");
            }
        } else {
            buff.append("<div class=\"ConFldSetDiv\">");
            if (!sectionName.equals("")) {
                buff.append("<div class=\"ConFldSetLgdDiv\">");
                buff.append(sectionName);
                buff.append("</div>\n");
            }
        }
    }

    protected void appendEndSectionHead(NonSyncStringBuffer buff) {
        if (this.isIe()) {
            buff.append("</fieldset>\n");
        } else {
            buff.append("</div>\n");
        }
    }

    protected void appendSubsectionHead(NonSyncStringBuffer buff, Node sectionNode) throws JspException {
        buff.append("<div class=\"ConSubSecDiv\"><div class=\"ConSubSecTtlTxt\">");
        buff.append(this.getNameHTML(sectionNode));
        buff.append("</div>\n");
    }

    protected void appendEndSubsectionHead(NonSyncStringBuffer buff) {
        buff.append("</div>\n");
    }

    protected void appendPropertyListStart(NonSyncStringBuffer buff) {
        buff.append("\n<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" title=\"\">\n");
    }

    protected void appendPropertyListEnd(NonSyncStringBuffer buff) {
        buff.append("</table>\n");
    }

    protected void appendRequiredFieldIndicator(NonSyncStringBuffer buff) {
        buff.append("<img src=\"" + CCImage.REQUIRED + "\" alt=\"").append(this.getTagMessage("propertysheet.required")).append("\" width=\"7\" height=\"14\" /> ");
    }

    protected void appendErrorFieldIndicator(NonSyncStringBuffer buff) {
        buff.append("<img src=\"" + CCImage.ALERT_ERROR_SMALL + "\" alt=\"").append(this.getTagMessage("propertysheet.error")).append("\" width=\"11\" height=\"14\" style=\"margin-top:3px\"/> ");
    }

    protected void preTableFormat(NonSyncStringBuffer buff) {
        buff.append("</div></td></tr></table>");
    }

    protected void postTableFormat(NonSyncStringBuffer buff, boolean colspan, int level) {
        buff.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" title=\"\">\n<tr><td valign=\"top\" colspan=\"2\"><div class=\"").append(this.getDivClass(colspan, level)).append("\">");
    }

    protected void appendJumpLinks(NonSyncStringBuffer buff, NodeList sections) throws JspException {
        int nVisibleSections = this.visibleSectionIndexes.size();
        if (nVisibleSections == 0) {
            return;
        }
        String[] names = new String[nVisibleSections];
        String[] anchors = new String[nVisibleSections];
        Node sectionNode = null;
        int sectionIndex = 0;
        for (int i = 0; i < nVisibleSections; ++i) {
            sectionIndex = (Integer)this.visibleSectionIndexes.get(i);
            sectionNode = sections.item(sectionIndex);
            names[i] = this.getNameHTML(sectionNode);
            anchors[i] = this.getAnchor(sectionNode);
        }
        buff.append("<div class=\"ConJmpScnDiv\">\n<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr>\n");
        if (nVisibleSections < 5) {
            this.appendJumpLinks(buff, names, anchors, nVisibleSections, 2);
        } else if (nVisibleSections < 10) {
            this.appendJumpLinks(buff, names, anchors, nVisibleSections, 3);
        } else {
            this.appendJumpLinks(buff, names, anchors, nVisibleSections, 4);
        }
        buff.append("</tr></table></div>\n");
    }

    protected void appendJumpLinks(NonSyncStringBuffer buff, String[] names, String[] anchors, int count, int linksPerRow) throws JspException {
        int numRows = (count + linksPerRow - 1) / linksPerRow;
        for (int k = 0; k < numRows; ++k) {
            if (k != 0) {
                buff.append("</tr><tr>");
            }
            for (int i = k; i < k + linksPerRow * numRows && i < count; i += numRows) {
                this.appendJumpLink(buff, names[i], anchors[i]);
            }
        }
    }

    protected void appendJumpLink(NonSyncStringBuffer buff, String name, String anchor) throws JspException {
        String title = this.getTagMessage("propertysheet.jumpTo") + " " + name;
        if (name.indexOf(this.getTagMessage("propertysheet.section")) < 0) {
            title = title + " " + this.getTagMessage("propertysheet.section");
        }
        buff.append("<td><div class=\"ConJmpLnkDiv\">").append(this.getHrefHTMLString(anchor, "jump", title, name)).append("</div></td>\n");
    }

    protected void appendBackToTop(NonSyncStringBuffer buff) throws JspException {
        buff.append("<div class=\"ConJmpTopDiv\">").append(this.getHrefHTMLString("", "jumpTop", this.getTagMessage("propertysheet.jumpToTopOfPage"), this.getTagMessage("propertysheet.backToTop"))).append("</div>\n");
    }

    public void setShowJumpLinks(String value) {
        if (value != null && !value.toLowerCase().equals("true") && !value.toLowerCase().equals("false")) {
            CCDebug.trace1("Invalid parameter: " + value);
            return;
        }
        this.setValue(ATTRIB_SHOW_JUMP_LINKS, value);
    }

    public String getShowJumpLinks() {
        String value = (String)this.getValue(ATTRIB_SHOW_JUMP_LINKS);
        return value;
    }

    protected boolean hasJumpLinks() {
        if (this.visibleSectionIndexes.size() > 1) {
            return new Boolean(this.getShowJumpLinks());
        }
        return false;
    }

    public void setAddJavaScript(String value) {
        if (value != null && !value.toLowerCase().equals("true") && !value.toLowerCase().equals("false")) {
            CCDebug.trace1("Invalid parameter: " + value);
            return;
        }
        this.setValue(ATTRIB_ADD_JAVASCRIPT, value);
    }

    public String getAddJavaScript() {
        String value = (String)this.getValue(ATTRIB_ADD_JAVASCRIPT);
        return value;
    }

    protected boolean addJavaScript() {
        return new Boolean(this.getAddJavaScript());
    }
}

