/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.view.wizard;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.Model;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.RequestHandlingViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBeanBase;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.JspDisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.model.CCWizardModelInterface;
import com.sun.web.ui.model.CCWizardWindowModelInterface;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCHref;
import com.sun.web.ui.view.html.CCImageField;
import com.sun.web.ui.view.html.CCStaticTextField;
import com.sun.web.ui.view.tabs.CCNodeEventHandlerInterface;
import com.sun.web.ui.view.tabs.CCTabs;
import com.sun.web.ui.view.wizard.CCWizardPage;
import com.sun.web.ui.view.wizard.CCWizardTabs;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.servlet.ServletException;

public class CCWizard
extends RequestHandlingViewBase
implements CCNodeEventHandlerInterface {
    public static final String CHILD_WIZARD_TITLE = "wizardTitle";
    public static final String CHILD_PREVIOUS_BUTTON = "previousButton";
    public static final String CHILD_NEXT_BUTTON = "nextButton";
    public static final String CHILD_FINISH_BUTTON = "finishButton";
    public static final String CHILD_CANCEL_BUTTON = "cancelButton";
    public static final String CHILD_CLOSE_BUTTON = "closeButton";
    public static final String CHILD_PAGING_HREF = "pagingHref";
    public static final String CHILD_ERROR_PROMPT = "errorPrompt";
    public static final String CHILD_CANCEL_PROMPT = "cancelPrompt";
    public static final String CHILD_TABS = "tabs";
    public static final String CHILD_IMAGE = "wizardImage";
    public static final String CHILD_VISITED_STEPS = "visitedSteps";
    public static final String CHILD_VISITED_PAGES = "visitedPages";
    public static final String CHILD_CURRENT_STEP = "currentStep";
    public static final String CHILD_FUTURE_STEPS = "futureSteps";
    public static final String CHILD_STEP_HELP = "stepHelp";
    public static final String CHILD_STEP_TITLE = "stepTitle";
    public static final String CHILD_STEP_INSTRUCTION = "stepInstruction";
    public static final String WIZARD_PAGE = "wizardPage";
    private boolean closeWizard = false;
    private boolean isResultsPage = false;
    private static final String CHILD_WIZARD_NAME = "wizName";
    protected final String DEFAULT_WIZARD_TITLE_VALUE = "wizard.title";
    protected final String DEFAULT_PREVIOUS_BUTTON_VALUE = "wizard.button.previous";
    protected final String DEFAULT_NEXT_BUTTON_VALUE = "wizard.button.next";
    protected final String DEFAULT_CANCEL_BUTTON_VALUE = "wizard.button.cancel";
    protected final String DEFAULT_FINISH_BUTTON_VALUE = "wizard.button.finish";
    protected final String DEFAULT_CLOSE_BUTTON_VALUE = "wizard.button.close";
    protected final String[] DEFAULT_VISITED_STEPS_VALUE = null;
    protected final String[] DEFAULT_VISITED_PAGES_VALUE = null;
    protected final String DEFAULT_CURRENT_STEP_VALUE;
    protected final String[] DEFAULT_FUTURE_STEPS_VALUE = null;
    protected final String[] DEFAULT_STEP_HELP_VALUE = null;
    protected final String DEFAULT_STEP_INSTRUCTION_VALUE;
    protected final String DEFAULT_STEP_TITLE_VALUE;
    private CCWizardModelInterface wizardModel;
    private CCWizardWindowModelInterface wizardWindowModel;
    private ViewBeanBase parentView = null;

    public CCWizard(View view, String name) {
        this(view, null, name, null);
    }

    public CCWizard(View view, Model model, String name, CCWizardWindowModelInterface wizardWindowModel) {
        super(view, name);
        this.DEFAULT_CURRENT_STEP_VALUE = null;
        this.DEFAULT_STEP_INSTRUCTION_VALUE = null;
        this.DEFAULT_STEP_TITLE_VALUE = null;
        this.wizardWindowModel = wizardWindowModel;
        this.parentView = (ViewBeanBase)view;
        this.wizardModel = (CCWizardModelInterface)model;
        if (model == null) {
            this.getWizardModel(this.getRequestContext());
        } else if (model instanceof CCWizardModelInterface) {
            this.wizardModel = (CCWizardModelInterface)model;
        } else {
            throw new IllegalArgumentException(CCDebug.getClassMethod(0) + " : model is not a CCWizardModelInterface.");
        }
        this.registerChildren();
    }

    private void getWizardModel(RequestContext requestContext) {
        throw new IllegalArgumentException(CCDebug.getClassMethod(0) + " : model is not a CCWizardModelInterface.");
    }

    protected void registerChildren() {
        this.registerChild(CHILD_WIZARD_TITLE, CCStaticTextField.class);
        this.registerChild(CHILD_PREVIOUS_BUTTON, CCButton.class);
        this.registerChild(CHILD_CANCEL_BUTTON, CCButton.class);
        this.registerChild(CHILD_NEXT_BUTTON, CCButton.class);
        this.registerChild(CHILD_FINISH_BUTTON, CCButton.class);
        this.registerChild(CHILD_CLOSE_BUTTON, CCButton.class);
        this.registerChild(CHILD_PAGING_HREF, CCHref.class);
        this.registerChild(CHILD_ERROR_PROMPT, CCStaticTextField.class);
        this.registerChild(CHILD_CANCEL_PROMPT, CCStaticTextField.class);
        this.registerChild(CHILD_IMAGE, CCImageField.class);
        this.registerChild(CHILD_TABS, CCWizardTabs.class);
        this.registerChild(CHILD_VISITED_STEPS, CCStaticTextField.class);
        this.registerChild(CHILD_VISITED_PAGES, CCStaticTextField.class);
        this.registerChild(CHILD_CURRENT_STEP, CCStaticTextField.class);
        this.registerChild(CHILD_FUTURE_STEPS, CCStaticTextField.class);
        this.registerChild(CHILD_STEP_HELP, CCStaticTextField.class);
        this.registerChild(CHILD_STEP_TITLE, CCStaticTextField.class);
        this.registerChild(CHILD_STEP_INSTRUCTION, CCStaticTextField.class);
        Class c = this.wizardModel.getCurrentPageClass();
        this.registerChild(WIZARD_PAGE, c);
    }

    protected View createChild(String name) {
        try {
            if (name.equals(CHILD_WIZARD_TITLE)) {
                CCStaticTextField child = new CCStaticTextField((View)this, this.wizardModel, CHILD_WIZARD_TITLE, CHILD_WIZARD_TITLE, "wizard.title");
                return child;
            }
            if (name.equals(CHILD_TABS)) {
                CCWizardTabs child = new CCWizardTabs((View)this, null, name);
                return child;
            }
            if (name.equals(CHILD_CANCEL_BUTTON)) {
                CCButton child = new CCButton((ContainerView)this, CHILD_CANCEL_BUTTON, CHILD_CANCEL_BUTTON, (Object)"wizard.button.cancel");
                child.setType("secondary");
                child.setDisabled(false);
                return child;
            }
            if (name.equals(CHILD_PREVIOUS_BUTTON)) {
                CCButton child = new CCButton((ContainerView)this, CHILD_PREVIOUS_BUTTON, CHILD_PREVIOUS_BUTTON, (Object)"wizard.button.previous");
                child.setType("secondary");
                return child;
            }
            if (name.equals(CHILD_NEXT_BUTTON)) {
                CCButton child = new CCButton((ContainerView)this, CHILD_NEXT_BUTTON, CHILD_NEXT_BUTTON, (Object)"wizard.button.next");
                child.setType("primary");
                child.setDisabled(false);
                return child;
            }
            if (name.equals(CHILD_FINISH_BUTTON)) {
                CCButton child = new CCButton((ContainerView)this, CHILD_FINISH_BUTTON, CHILD_FINISH_BUTTON, (Object)"wizard.button.finish");
                child.setType("primary");
                child.setDisabled(false);
                return child;
            }
            if (name.equals(CHILD_CLOSE_BUTTON)) {
                CCButton child = new CCButton((ContainerView)this, CHILD_CLOSE_BUTTON, CHILD_CLOSE_BUTTON, (Object)"wizard.button.close");
                child.setType("primary");
                child.setDisabled(false);
                return child;
            }
            if (name.equals(CHILD_PAGING_HREF)) {
                CCHref child = new CCHref((ContainerView)this, this.wizardModel, CHILD_PAGING_HREF, CHILD_PAGING_HREF, null, null);
                return child;
            }
            if (name.equals(CHILD_ERROR_PROMPT)) {
                CCStaticTextField child = new CCStaticTextField((View)this, this.wizardModel, CHILD_ERROR_PROMPT, CHILD_ERROR_PROMPT, null);
                return child;
            }
            if (name.equals(CHILD_CANCEL_PROMPT)) {
                CCStaticTextField child = new CCStaticTextField((View)this, this.wizardModel, CHILD_CANCEL_PROMPT, CHILD_CANCEL_PROMPT, null);
                return child;
            }
            if (name.equals(CHILD_VISITED_STEPS)) {
                CCStaticTextField child = new CCStaticTextField((View)this, this.wizardModel, CHILD_VISITED_STEPS, CHILD_VISITED_STEPS, this.DEFAULT_VISITED_STEPS_VALUE);
                return child;
            }
            if (name.equals(CHILD_VISITED_PAGES)) {
                CCStaticTextField child = new CCStaticTextField((View)this, this.wizardModel, CHILD_VISITED_PAGES, CHILD_VISITED_PAGES, this.DEFAULT_VISITED_PAGES_VALUE);
                return child;
            }
            if (name.equals(CHILD_CURRENT_STEP)) {
                CCStaticTextField child = new CCStaticTextField((View)this, this.wizardModel, CHILD_CURRENT_STEP, CHILD_CURRENT_STEP, this.DEFAULT_CURRENT_STEP_VALUE);
                return child;
            }
            if (name.equals(CHILD_FUTURE_STEPS)) {
                CCStaticTextField child = new CCStaticTextField((View)this, this.wizardModel, CHILD_FUTURE_STEPS, CHILD_FUTURE_STEPS, this.DEFAULT_FUTURE_STEPS_VALUE);
                return child;
            }
            if (name.equals(CHILD_STEP_HELP)) {
                CCStaticTextField child = new CCStaticTextField((View)this, this.wizardModel, CHILD_STEP_HELP, CHILD_STEP_HELP, this.DEFAULT_STEP_HELP_VALUE);
                return child;
            }
            if (name.equals(CHILD_STEP_TITLE)) {
                CCStaticTextField child = new CCStaticTextField((View)this, this.wizardModel, CHILD_STEP_TITLE, CHILD_STEP_TITLE, this.DEFAULT_STEP_TITLE_VALUE);
                return child;
            }
            if (name.equals(CHILD_STEP_INSTRUCTION)) {
                CCStaticTextField child = new CCStaticTextField((View)this, this.wizardModel, CHILD_STEP_INSTRUCTION, CHILD_STEP_INSTRUCTION, this.DEFAULT_STEP_INSTRUCTION_VALUE);
                return child;
            }
            if (name.equals(CHILD_WIZARD_NAME)) {
                return new CCStaticTextField((View)this, this.wizardModel, name, CHILD_WIZARD_NAME, null, null);
            }
            if (name.equals(WIZARD_PAGE)) {
                Class pageClass = this.getChildType(name);
                return this.newWizardPage(pageClass);
            }
            if (name.equals(CHILD_IMAGE)) {
                CCImageField child = new CCImageField((ContainerView)this, CHILD_IMAGE, null);
                return child;
            }
            throw new NoSuchChildException(name);
        }
        catch (NoSuchChildException nsce) {
            throw new IllegalArgumentException(CCDebug.getClassMethod(0) + " : " + nsce.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException(CCDebug.getClassMethod(0) + " : " + e.getMessage());
        }
    }

    public String getWizardResourceBundle() {
        return this.wizardModel.getResourceBundle();
    }

    public boolean isFinishPage() {
        return this.wizardModel.isFinishPage();
    }

    public boolean closeWizard() {
        return this.closeWizard;
    }

    public boolean isResultsPage() {
        return this.isResultsPage;
    }

    public boolean showCancelAlert() {
        String cancelPrompt = this.wizardModel.getCancelPrompt();
        return cancelPrompt != null && cancelPrompt.length() > 0 && this.wizardModel.firstPageSeen();
    }

    public boolean isSubstep(String pageId) {
        return this.wizardModel.isSubstep(pageId);
    }

    public String getCurrentPageId() {
        return this.wizardModel.getCurrentPageId();
    }

    public String[] getFuturePages() {
        return this.wizardModel.getFuturePages();
    }

    public String getStepTitle(String pageId) {
        return this.wizardModel.getStepTitle(pageId);
    }

    public String getPlaceholderText(String pageId) {
        return this.wizardModel.getPlaceholderText(pageId);
    }

    public String getRefreshForm() {
        return (String)this.wizardWindowModel.getValue("wizBtnForm");
    }

    public String getRefreshCmdChild() {
        return (String)this.wizardWindowModel.getValue("wizRefreshCmdChild");
    }

    public boolean canBeStepLink(String pageId) {
        return this.wizardModel.canBeStepLink(pageId);
    }

    public final void handleNextButtonRequest(RequestInvocationEvent event) throws ServletException, IOException {
        if (!this.wizardModel.nextRequest(this.getChild(WIZARD_PAGE))) {
            this.parentView.forwardTo(this.getRequestContext());
            return;
        }
        this.unregisterChild(WIZARD_PAGE);
        Class c = this.wizardModel.getCurrentPageClass();
        this.registerChild(WIZARD_PAGE, c);
        this.parentView.forwardTo(this.getRequestContext());
    }

    public final void handlePreviousButtonRequest(RequestInvocationEvent event) throws ServletException, IOException {
        if (!this.wizardModel.previousRequest(this.getChild(WIZARD_PAGE))) {
            this.parentView.forwardTo(this.getRequestContext());
            return;
        }
        this.unregisterChild(WIZARD_PAGE);
        Class c = this.wizardModel.getCurrentPageClass();
        this.registerChild(WIZARD_PAGE, c);
        this.parentView.forwardTo(this.getRequestContext());
    }

    public final void handleCancelButtonRequest(RequestInvocationEvent event) throws ServletException, IOException {
        this.closeWizard = true;
        this.wizardModel.cancelRequest(this.getChild(WIZARD_PAGE));
        this.parentView.forwardTo(this.getRequestContext());
    }

    public final void handleFinishButtonRequest(RequestInvocationEvent event) throws ServletException, IOException {
        boolean result = this.wizardModel.finishRequest(this.getChild(WIZARD_PAGE));
        if (!result) {
            this.parentView.forwardTo(this.getRequestContext());
            return;
        }
        this.unregisterChild(WIZARD_PAGE);
        Class c = this.wizardModel.getCurrentPageClass();
        boolean bl = this.isResultsPage = c != null;
        if (this.isResultsPage) {
            this.registerChild(WIZARD_PAGE, c);
        }
        this.closeWizard = !this.isResultsPage;
        this.parentView.forwardTo(this.getRequestContext());
    }

    public final void handleCloseButtonRequest(RequestInvocationEvent event) throws ServletException, IOException {
        this.wizardModel.closeRequest(this.getChild(WIZARD_PAGE));
        this.closeWizard = true;
        this.parentView.forwardTo(this.getRequestContext());
    }

    public final void handlePagingHrefRequest(RequestInvocationEvent event) throws ServletException, IOException {
        if (!this.wizardModel.gotoRequest(this.getChild(WIZARD_PAGE))) {
            this.parentView.forwardTo(this.getRequestContext());
            return;
        }
        this.unregisterChild(WIZARD_PAGE);
        Class c = this.wizardModel.getCurrentPageClass();
        this.registerChild(WIZARD_PAGE, c);
        this.parentView.forwardTo(this.getRequestContext());
    }

    public void nodeClicked(RequestInvocationEvent event, int id) {
        CCWizardTabs tabChild = (CCWizardTabs)this.getChild(CHILD_TABS);
        boolean success = false;
        if (id == 0) {
            this.wizardModel.stepRequest(this.getChild(WIZARD_PAGE));
        } else {
            this.wizardModel.helpRequest(this.getChild(WIZARD_PAGE));
        }
        this.isResultsPage = this.wizardModel.isResultsPage();
        this.parentView.forwardTo(this.getRequestContext());
    }

    public void beginDisplay(JspDisplayEvent event) throws ModelControlException {
        if (!this.closeWizard) {
            CCTabs tabChild = (CCTabs)this.getChild(CHILD_TABS);
            ((CCWizardTabs)tabChild).setActiveTab(this.wizardModel.getActiveTab());
            ((CCButton)this.getChild(CHILD_PREVIOUS_BUTTON)).setDisabled(!this.wizardModel.hasPreviousPage());
        }
        super.beginDisplay((DisplayEvent)event);
    }

    private View newWizardPage(Class pageClass) {
        CCWizardPage wizardPage = null;
        if (pageClass != null) {
            try {
                Constructor newPage = pageClass.getConstructor(View.class, Model.class);
                Object[] args = new Object[]{this, this.wizardModel.getCurrentPageModel()};
                wizardPage = (CCWizardPage)newPage.newInstance(args);
            }
            catch (InstantiationException instExc) {
                System.out.println(instExc.getMessage());
                instExc.printStackTrace();
            }
            catch (IllegalAccessException illaccessExc) {
                System.out.println(illaccessExc.getMessage());
                illaccessExc.printStackTrace();
            }
            catch (IllegalArgumentException illargExc) {
                System.out.println(illargExc.getMessage());
                illargExc.printStackTrace();
            }
            catch (InvocationTargetException invocExc) {
                Throwable e = invocExc.getCause();
                System.out.println(e.getMessage());
                e.printStackTrace();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                e.printStackTrace();
            }
        } else {
            System.out.println("Null pageClass.");
        }
        return (View)wizardPage;
    }

    class NoSuchChildException
    extends Exception {
        NoSuchChildException(String name) {
            super("Invalid child name [" + name + "]");
        }
    }
}

