/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.model;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;

public class Markup {
    private static String[] ISO8859_1_Entities = new String[]{"nbsp", "iexcl", "cent", "pound", "curren", "yen", "brvbar", "sect", "uml", "copy", "ordf", "laquo", "not", "shy", "reg", "macr", "deg", "plusmn", "sup2", "sup3", "acute", "micro", "para", "middot", "cedil", "sup1", "ordm", "raquo", "frac14", "frac12", "frac34", "iquest", "Agrave", "Aacute", "Acirc", "Atilde", "Auml", "Aring", "AElig", "Ccedil", "Egrave", "Eacute", "Ecirc", "Euml", "Igrave", "Iacute", "Icirc", "Iuml", "ETH", "Ntilde", "Ograve", "Oacute", "Ocirc", "Otilde", "Ouml", "times", "Oslash", "Ugrave", "Uacute", "Ucirc", "Uuml", "Yacute", "THORN", "szlig", "agrave", "aacute", "acirc", "atilde", "auml", "aring", "aelig", "ccedil", "egrave", "eacute", "ecirc", "euml", "igrave", "iacute", "icirc", "iuml", "eth", "ntilde", "ograve", "oacute", "ocirc", "otilde", "ouml", "divide", "oslash", "ugrave", "uacute", "ucirc", "uuml", "yacute", "thorn", "yuml"};
    private StringBuffer buffer = new StringBuffer();
    private String encoding = "ISO-8859-1";
    private boolean open = false;

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getMarkup() {
        this.close();
        return this.buffer.toString();
    }

    public void clear() {
        this.buffer.setLength(0);
        this.open = false;
    }

    public String toString() {
        return this.getMarkup();
    }

    public void startElement(String name, UIComponent component) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.close();
        this.buffer.append('<');
        this.buffer.append(name);
        this.open = true;
    }

    public void endElement(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (this.open) {
            this.buffer.append('/');
            this.close();
        } else {
            this.buffer.append("</");
            this.buffer.append(name);
            this.buffer.append('>');
        }
    }

    public void writeAttribute(String name, Object value, String property) {
        if (name == null || value == null) {
            throw new NullPointerException();
        }
        if (!this.open) {
            throw new IllegalStateException("No element is currently open");
        }
        Class<?> clazz = value.getClass();
        if (clazz == Boolean.class) {
            if (Boolean.TRUE.equals(value)) {
                this.buffer.append(' ');
                this.buffer.append(name);
                this.buffer.append("=\"");
                this.buffer.append(name);
                this.buffer.append('\"');
            }
            return;
        }
        this.buffer.append(' ');
        this.buffer.append(name);
        this.buffer.append("=\"");
        String text = value.toString();
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char ch = text.charAt(i);
            if (ch < '\u00a0') {
                if (ch >= '?') {
                    this.buffer.append(ch);
                    continue;
                }
                if (ch >= '\'') {
                    if (ch < '<') {
                        this.buffer.append(ch);
                        continue;
                    }
                    if (ch == '>') {
                        this.buffer.append("&gt;");
                        continue;
                    }
                    this.buffer.append(ch);
                    continue;
                }
                if (ch == '&') {
                    if (i + 1 < length && text.charAt(i + 1) == '{') {
                        this.buffer.append(ch);
                        continue;
                    }
                    this.buffer.append("&amp;");
                    continue;
                }
                if (ch == '\"') {
                    this.buffer.append("&quot;");
                    continue;
                }
                this.buffer.append(ch);
                continue;
            }
            if (ch <= '\u00ff') {
                this.buffer.append('&');
                this.buffer.append(ISO8859_1_Entities[ch - 160]);
                this.buffer.append(';');
                continue;
            }
            this.numeric(ch);
        }
        this.buffer.append('\"');
    }

    public void writeURIAttribute(String name, Object value, String property) {
        if (name == null || value == null) {
            throw new NullPointerException();
        }
        if (!this.open) {
            throw new IllegalStateException("No element is currently open");
        }
        String text = value.toString();
        if (text.startsWith("javascript:")) {
            this.writeAttribute(name, value, property);
            return;
        }
        this.buffer.append(' ');
        this.buffer.append(name);
        this.buffer.append("=\"");
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char ch = text.charAt(i);
            if (ch < '!' || ch > '~') {
                if (ch == ' ') {
                    this.buffer.append('+');
                    continue;
                }
                this.hexadecimals(ch);
                continue;
            }
            if (ch == '\"') {
                this.buffer.append("%22");
                continue;
            }
            if (ch == '?') {
                this.buffer.append('?');
                try {
                    this.buffer.append(URLEncoder.encode(text.substring(i + 1), this.encoding));
                    break;
                }
                catch (UnsupportedEncodingException e) {
                    throw new FacesException((Throwable)e);
                }
            }
            this.buffer.append(ch);
        }
        this.buffer.append('\"');
    }

    public void writeComment(Object comment) {
        if (comment == null) {
            throw new NullPointerException();
        }
        this.close();
        this.buffer.append("<!-- ");
        this.buffer.append(comment);
        this.buffer.append(" -->");
    }

    public void writeRaw(Object raw, String property) {
        if (raw == null) {
            throw new NullPointerException();
        }
        this.close();
        this.buffer.append(raw.toString());
    }

    public void writeText(Object text, String property) {
        if (text == null) {
            throw new NullPointerException();
        }
        this.close();
        String stext = text.toString();
        int length = stext.length();
        for (int i = 0; i < length; ++i) {
            char ch = stext.charAt(i);
            if (ch < '\u00a0') {
                if (ch >= '?') {
                    this.buffer.append(ch);
                    continue;
                }
                if (ch >= '\'') {
                    if (ch < '<') {
                        this.buffer.append(ch);
                        continue;
                    }
                    if (ch == '<') {
                        this.buffer.append("&lt;");
                        continue;
                    }
                    if (ch == '>') {
                        this.buffer.append("&gt;");
                        continue;
                    }
                    this.buffer.append(ch);
                    continue;
                }
                if (ch == '&') {
                    this.buffer.append("&amp;");
                    continue;
                }
                this.buffer.append(ch);
                continue;
            }
            if (ch <= '\u00ff') {
                this.buffer.append('&');
                this.buffer.append(ISO8859_1_Entities[ch - 160]);
                this.buffer.append(';');
                continue;
            }
            this.numeric(ch);
        }
    }

    protected void close() {
        if (this.open) {
            this.buffer.append('>');
            this.open = false;
        }
    }

    protected void hexadecimal(int i) {
        if (i < 10) {
            this.buffer.append((char)(48 + i));
        } else {
            this.buffer.append((char)(65 + (i - 10)));
        }
    }

    protected void hexadecimals(char ch) {
        this.buffer.append('%');
        this.hexadecimal((ch >> 4) % 16);
        this.hexadecimal(ch % 16);
    }

    protected void numeric(char ch) {
        if (ch == 8364) {
            this.buffer.append("&euro;");
            return;
        }
        int i = ch;
        if (i > 10000) {
            this.buffer.append(48 + i / 10000);
            this.buffer.append(48 + (i %= 10000) / 1000);
            this.buffer.append(48 + (i %= 1000) / 100);
            this.buffer.append(48 + (i %= 100) / 10);
            this.buffer.append(48 + (i %= 10));
        } else if (i > 1000) {
            this.buffer.append(48 + i / 1000);
            this.buffer.append(48 + (i %= 1000) / 100);
            this.buffer.append(48 + (i %= 100) / 10);
            this.buffer.append(48 + (i %= 10));
        } else {
            this.buffer.append(48 + i / 100);
            this.buffer.append(48 + (i %= 100) / 10);
            this.buffer.append(48 + (i %= 10));
        }
        this.buffer.append(';');
    }
}

