/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.renderer;

import com.sun.web.ui.component.Alarm;
import com.sun.web.ui.renderer.ImageRenderer;
import com.sun.web.ui.theme.Theme;
import com.sun.web.ui.util.ThemeUtilities;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class AlarmRenderer
extends ImageRenderer {
    private static final String LABEL_LEFT = "left";
    private static final String LABEL_RIGHT = "right";
    private static final String WHITE_SPACE = "&nbsp;";

    protected void renderStart(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        boolean showImage;
        if (context == null || component == null) {
            throw new NullPointerException("FacesContext or UIComponent is null");
        }
        Alarm alarm = (Alarm)component;
        String label = alarm.getText();
        String severity = this.getSeverity(alarm);
        boolean severityOk = this.isSeverityOk(severity);
        boolean bl = showImage = !severityOk || alarm.getUrl() != null;
        if (showImage) {
            Theme theme = ThemeUtilities.getTheme(context);
            if (label == null) {
                this.renderImage(context, alarm, writer);
            } else if (LABEL_LEFT.equalsIgnoreCase(alarm.getTextPosition())) {
                this.renderLabel(context, alarm, label, true, true, writer);
                this.renderImage(context, alarm, writer);
            } else {
                this.renderImage(context, alarm, writer);
                this.renderLabel(context, alarm, label, false, true, writer);
            }
        } else if (label != null) {
            this.renderLabel(context, alarm, label, false, false, writer);
        }
    }

    private void renderLabel(FacesContext context, Alarm alarm, String label, boolean labelLeft, boolean addSpace, ResponseWriter writer) throws IOException {
        if (labelLeft) {
            writer.writeText((Object)label, null);
            if (addSpace) {
                writer.write(WHITE_SPACE);
            }
        } else {
            if (addSpace) {
                writer.write(WHITE_SPACE);
            }
            writer.writeText((Object)label, null);
        }
    }

    private void renderImage(FacesContext context, Alarm alarm, ResponseWriter writer) throws IOException {
        super.renderStart(context, (UIComponent)alarm, writer);
        super.renderAttributes(context, (UIComponent)alarm, writer);
    }

    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        String severity = this.getSeverity((Alarm)component);
        boolean severityOk = this.isSeverityOk(severity);
        if (!severityOk || ((Alarm)component).getUrl() != null) {
            super.renderEnd(context, component, writer);
        }
    }

    protected void renderAttributes(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
    }

    private String getSeverity(Alarm alarm) {
        String severity = alarm.getSeverity();
        if (severity == null || severity.trim().length() == 0) {
            severity = "ok";
        }
        return severity.toLowerCase();
    }

    private boolean isSeverityOk(String severity) {
        return "ok".equalsIgnoreCase(severity);
    }
}

