/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.renderer;

import com.sun.web.ui.component.AlarmStatus;
import com.sun.web.ui.component.ImageComponent;
import com.sun.web.ui.renderer.HyperlinkRenderer;
import com.sun.web.ui.theme.Theme;
import com.sun.web.ui.util.RenderingUtilities;
import com.sun.web.ui.util.ThemeUtilities;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class AlarmStatusRenderer
extends HyperlinkRenderer {
    protected void renderAlarmLabel(FacesContext context, AlarmStatus alarmStatus, ResponseWriter writer, Theme theme) throws IOException {
        writer.startElement("span", (UIComponent)alarmStatus);
        this.addCoreAttributes(context, (UIComponent)alarmStatus, writer, theme.getStyleClass("MASTHEAD_TEXT"));
        String text = alarmStatus.getText() != null ? alarmStatus.getText() : theme.getMessage("masthead.currentAlarms");
        writer.write(text);
        writer.write("&nbsp;");
        writer.endElement("span");
    }

    protected void renderStart(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        AlarmStatus alarmStatus = (AlarmStatus)component;
        Theme theme = ThemeUtilities.getTheme(context);
        UIComponent facet = alarmStatus.getFacet("alarmLabel");
        if (facet != null) {
            RenderingUtilities.renderComponent(facet, context);
        } else {
            this.renderAlarmLabel(context, alarmStatus, writer, theme);
        }
        int numAlarms = 0;
        String icon = null;
        String themeIcon = null;
        String alt = null;
        facet = alarmStatus.getFacet("downAlarms");
        if (facet != null) {
            RenderingUtilities.renderComponent(facet, context);
        } else if (alarmStatus.isDownAlarms()) {
            numAlarms = alarmStatus.getNumDownAlarms();
            themeIcon = numAlarms != 0 ? "ALARM_MASTHEAD_DOWN_MEDIUM" : "ALARM_MASTHEAD_DOWN_DIMMED";
            icon = alarmStatus.getDownIcon() != null ? alarmStatus.getDownIcon() : themeIcon;
            alt = theme.getMessage("Alarm.downImageAltText");
            this.renderAlarmCount(context, writer, alarmStatus, icon, theme.getStyleClass("MASTHEAD_ALARM_LINK"), numAlarms, alt);
        }
        facet = alarmStatus.getFacet("criticalAlarms");
        if (facet != null) {
            RenderingUtilities.renderComponent(facet, context);
        } else if (alarmStatus.isCriticalAlarms()) {
            numAlarms = alarmStatus.getNumCriticalAlarms();
            themeIcon = numAlarms != 0 ? "ALARM_MASTHEAD_CRITICAL_MEDIUM" : "ALARM_MASTHEAD_CRITICAL_DIMMED";
            icon = alarmStatus.getCriticalIcon() != null ? alarmStatus.getCriticalIcon() : themeIcon;
            alt = theme.getMessage("Alarm.criticalImageAltText");
            this.renderAlarmCount(context, writer, alarmStatus, icon, theme.getStyleClass("MASTHEAD_ALARM_LINK"), numAlarms, alt);
        }
        facet = alarmStatus.getFacet("majorAlarms");
        if (facet != null) {
            RenderingUtilities.renderComponent(facet, context);
        } else if (alarmStatus.isMajorAlarms()) {
            numAlarms = alarmStatus.getNumMajorAlarms();
            themeIcon = numAlarms != 0 ? "ALARM_MASTHEAD_MAJOR_MEDIUM" : "ALARM_MASTHEAD_MAJOR_DIMMED";
            icon = alarmStatus.getMajorIcon() != null ? alarmStatus.getMajorIcon() : themeIcon;
            alt = theme.getMessage("Alarm.majorImageAltText");
            this.renderAlarmCount(context, writer, alarmStatus, icon, theme.getStyleClass("MASTHEAD_ALARM_LINK"), numAlarms, alt);
        }
        facet = alarmStatus.getFacet("minorAlarms");
        if (facet != null) {
            RenderingUtilities.renderComponent(facet, context);
        } else if (alarmStatus.isMinorAlarms()) {
            numAlarms = alarmStatus.getNumMinorAlarms();
            themeIcon = numAlarms != 0 ? "ALARM_MASTHEAD_MINOR_MEDIUM" : "ALARM_MASTHEAD_MINOR_DIMMED";
            icon = alarmStatus.getMinorIcon() != null ? alarmStatus.getMinorIcon() : themeIcon;
            alt = theme.getMessage("Alarm.minorImageAltText");
            this.renderAlarmCount(context, writer, alarmStatus, icon, theme.getStyleClass("MASTHEAD_ALARM_LINK"), numAlarms, alt);
        }
    }

    protected void renderAlarmCount(FacesContext context, ResponseWriter writer, AlarmStatus alarmStatus, String icon, String styleClass, int numAlarms, String alt) throws IOException {
        String realText = alarmStatus.getText();
        String realIcon = alarmStatus.getIcon();
        String realStyleClass = alarmStatus.getStyleClass();
        boolean reallyDisabled = alarmStatus.isDisabled();
        String realAlt = alarmStatus.getAlt();
        alarmStatus.setIcon(icon);
        alarmStatus.setText("&nbsp;" + numAlarms);
        alarmStatus.setStyleClass(styleClass);
        alarmStatus.setAlt(alt);
        if (numAlarms == 0) {
            alarmStatus.setDisabled(true);
        }
        this.renderLink(context, (UIComponent)alarmStatus, writer);
        writer.write("&nbsp;&nbsp;&nbsp;");
        alarmStatus.setText(realText);
        alarmStatus.setIcon(realIcon);
        alarmStatus.setStyleClass(realStyleClass);
        alarmStatus.setDisabled(reallyDisabled);
        alarmStatus.setAlt(alt);
    }

    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
    }

    protected void finishRenderAttributes(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        AlarmStatus alarmStatus = (AlarmStatus)component;
        ImageComponent image = alarmStatus.getImageFacet();
        String label = alarmStatus.getText();
        if (image != null) {
            RenderingUtilities.renderComponent((UIComponent)image, context);
        }
        if (label != null) {
            writer.write(label);
        }
    }

    protected void renderAlarmImage(FacesContext context, AlarmStatus alarmStatus, ResponseWriter writer, Theme theme, String alarmSrc) throws IOException {
        ImageComponent image = new ImageComponent();
        image.setIcon(alarmSrc);
        RenderingUtilities.renderComponent((UIComponent)image, context);
    }
}

