/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.handlers;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBase;
import com.iplanet.jato.view.event.ChildContentDisplayEvent;
import com.iplanet.jato.view.html.HREF;
import com.iplanet.jato.view.html.OptionList;
import com.iplanet.jato.view.html.StaticTextField;
import com.sun.enterprise.admin.common.Status;
import com.sun.enterprise.admin.servermgmt.RuntimeStatus;
import com.sun.enterprise.admin.servermgmt.RuntimeStatusList;
import com.sun.enterprise.tools.admingui.ConfigProperties;
import com.sun.enterprise.tools.admingui.util.MBeanUtil;
import com.sun.enterprise.tools.admingui.util.Util;
import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.view.DescriptorContainerView;
import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import com.sun.enterprise.tools.guiframework.view.descriptors.CCActionTableDescriptor;
import com.sun.enterprise.tools.guiframework.view.descriptors.CCAddRemoveDescriptor;
import com.sun.enterprise.tools.guiframework.view.descriptors.CCPropertySheetDescriptor;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;
import com.sun.enterprise.tools.guiframework.view.event.BeforeCreateEvent;
import com.sun.web.ui.model.CCActionTableModelInterface;
import com.sun.web.ui.model.CCAddRemoveModelInterface;
import com.sun.web.ui.model.CCPropertySheetModelInterface;
import com.sun.web.ui.view.addremove.CCAddRemove;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class TargetHandlers {
    private static final String blankGif = "/com_sun_web_ui/images/other/dot.gif\" width=\"11\" height=\"11";

    public void setupTargetsSection(RequestContext ctx, HandlerContext handlerCtx) {
        ViewDescriptor vd = handlerCtx.getEvent() instanceof BeforeCreateEvent ? ((BeforeCreateEvent)handlerCtx.getEvent()).getViewDescriptor() : handlerCtx.getViewDescriptor();
        if (vd instanceof CCPropertySheetDescriptor) {
            CCPropertySheetModelInterface model = ((CCPropertySheetDescriptor)vd).getModel();
            String targetsSectionName = (String)handlerCtx.getInputValue("targetsSectionName");
            Boolean hasTargets = ConfigProperties.getInstance().getTargetSupported();
            if (targetsSectionName != null) {
                model.setVisible(targetsSectionName, hasTargets.booleanValue());
                handlerCtx.setOutputValue("hasTargets", (Object)hasTargets);
            } else {
                handlerCtx.setOutputValue("hasTargets", (Object)new Boolean(false));
            }
        } else {
            throw new RuntimeException("ViewDesc should be of type property sheet.");
        }
    }

    public void setAvailableList(RequestContext ctx, HandlerContext handlerCtx) {
        CCAddRemoveModelInterface model;
        String[] names;
        ViewDescriptor vd = handlerCtx.getEvent() instanceof BeforeCreateEvent ? ((BeforeCreateEvent)handlerCtx.getEvent()).getViewDescriptor() : handlerCtx.getViewDescriptor();
        if (vd instanceof CCAddRemoveDescriptor) {
            ObjectName[] clusters = (ObjectName[])handlerCtx.getInputValue("clusters");
            ObjectName[] instances = (ObjectName[])handlerCtx.getInputValue("instances");
            names = this.getAllTargets(clusters, instances);
            model = ((CCAddRemoveDescriptor)vd).getModel();
            CCAddRemoveDescriptor addRemoveDesc = (CCAddRemoveDescriptor)vd;
            String defaultInstance = (String)handlerCtx.getInputValue("defaultInstance");
            String defaultCluster = (String)handlerCtx.getInputValue("defaultCluster");
            String defaultTarget = null;
            Vector<String> vv = new Vector<String>(Arrays.asList(names));
            if (!Util.isEmpty(defaultInstance)) {
                vv.remove(defaultInstance);
                defaultTarget = defaultInstance;
            }
            if (!Util.isEmpty(defaultCluster)) {
                vv.remove(defaultCluster);
                defaultTarget = defaultCluster;
            }
            if (defaultTarget != null) {
                names = new String[vv.size()];
                for (int i = 0; i < vv.size(); ++i) {
                    names[i] = vv.elementAt(i);
                }
                model.setSelectedOptionList(new OptionList(new String[]{defaultTarget}, new String[]{defaultTarget}));
            }
        } else {
            throw new RuntimeException("Not an AddRemoveComponent!");
        }
        model.setAvailableOptionList(new OptionList(names, names));
    }

    public void setAllTargets(RequestContext ctx, HandlerContext handlerCtx) {
        ObjectName[] clusters = (ObjectName[])handlerCtx.getInputValue("clusters");
        ObjectName[] instances = (ObjectName[])handlerCtx.getInputValue("instances");
        String[] allTargets = this.getAllTargets(clusters, instances);
        handlerCtx.setOutputValue("allTargets", (Object)allTargets);
    }

    private String[] getAllTargets(ObjectName[] clusters, ObjectName[] instances) {
        int i;
        int clusterCount = clusters == null ? 0 : clusters.length;
        int instanceCount = instances == null ? 0 : instances.length;
        String[] allTargets = new String[clusterCount + instanceCount];
        for (i = 0; i < clusterCount; ++i) {
            allTargets[i] = (String)MBeanUtil.getAttribute(clusters[i], "name");
        }
        for (i = 0; i < instanceCount; ++i) {
            allTargets[i + clusterCount] = (String)MBeanUtil.getAttribute(instances[i], "name");
        }
        return allTargets;
    }

    public void setSelectedTargets(RequestContext ctx, HandlerContext handlerCtx) {
        String[] associatedTargets;
        String[] targets;
        ViewDescriptor vd = handlerCtx.getEvent() instanceof BeforeCreateEvent ? ((BeforeCreateEvent)handlerCtx.getEvent()).getViewDescriptor() : handlerCtx.getViewDescriptor();
        if (vd instanceof CCAddRemoveDescriptor) {
            targets = (String[])handlerCtx.getInputValue("targets");
            String objectName = (String)handlerCtx.getInputValue("objectName");
            String[] refName = handlerCtx.getInputValue("referedTargets");
            String key = (String)handlerCtx.getInputValue("key");
            if (key == null) {
                key = "name";
            }
            if (targets == null) {
                targets = new String[]{};
            }
            associatedTargets = null;
            if (refName == null) {
                refName = new String[]{};
            }
            if (refName instanceof ObjectName[]) {
                associatedTargets = this.getAssociatedTargets((ObjectName[])refName, key);
            } else if (refName instanceof String[]) {
                associatedTargets = refName;
            }
        } else {
            throw new RuntimeException("Not an AddRemoveComponent!");
        }
        targets = this.getAvailableVirtualServers(targets, associatedTargets);
        CCAddRemoveDescriptor addRemoveDesc = (CCAddRemoveDescriptor)vd;
        CCAddRemoveModelInterface model = addRemoveDesc.getModel();
        model.setAvailableOptionList(new OptionList(targets, targets));
        model.setSelectedOptionList(new OptionList(associatedTargets, associatedTargets));
    }

    private String[] getAssociatedTargets(ObjectName[] refName, String key) {
        String[] associatedTargets = refName != null ? new String[refName.length] : new String[]{};
        for (int i = 0; refName != null && i < refName.length; ++i) {
            associatedTargets[i] = refName[i].getKeyProperty(key);
        }
        return associatedTargets;
    }

    public void setAvailableVirtualServers(RequestContext ctx, HandlerContext handlerCtx) {
        String[] selectedVS;
        CCAddRemoveModelInterface model;
        String[] availableVS;
        ViewDescriptor vd = handlerCtx.getEvent() instanceof BeforeCreateEvent ? ((BeforeCreateEvent)handlerCtx.getEvent()).getViewDescriptor() : handlerCtx.getViewDescriptor();
        if (vd instanceof CCAddRemoveDescriptor) {
            ObjectName[] virtualServers = (ObjectName[])handlerCtx.getInputValue("virtualServers");
            String objectName = (String)handlerCtx.getInputValue("objectName");
            int vsCount = virtualServers == null ? 0 : virtualServers.length;
            availableVS = new String[vsCount];
            for (int i = 0; i < vsCount; ++i) {
                availableVS[i] = (String)MBeanUtil.getAttribute(virtualServers[i], "id");
            }
            CCAddRemoveDescriptor addRemoveDesc = (CCAddRemoveDescriptor)vd;
            model = addRemoveDesc.getModel();
            selectedVS = this.getAssociatedVirtualServers(objectName);
            if (selectedVS == null || selectedVS.length == 0) {
                selectedVS = availableVS;
                availableVS = new String[]{};
            } else {
                availableVS = this.getAvailableVirtualServers(availableVS, selectedVS);
            }
        } else {
            throw new RuntimeException("Not an AddRemoveComponent!");
        }
        model.setAvailableOptionList(new OptionList(availableVS, availableVS));
        model.setSelectedOptionList(new OptionList(selectedVS, selectedVS));
    }

    private String[] getAvailableVirtualServers(String[] availableVS, String[] selectedVS) {
        Vector<String> availableVector = new Vector<String>();
        boolean selected = false;
        for (int i = 0; i < availableVS.length; ++i) {
            for (int j = 0; j < selectedVS.length; ++j) {
                if (!availableVS[i].equals(selectedVS[j])) continue;
                selected = true;
                break;
            }
            if (!selected) {
                availableVector.add(availableVS[i]);
            }
            selected = false;
        }
        availableVS = availableVector.toArray(new String[availableVector.size()]);
        return availableVS;
    }

    private String[] getAssociatedVirtualServers(String objectName) {
        String str = (String)MBeanUtil.getAttribute(objectName, "virtual-servers");
        String[] vs = Util.stringToArray(str, ",");
        return vs;
    }

    public void setVirtualServerAttribute(RequestContext ctx, HandlerContext handlerCtx) {
        String objectName = (String)handlerCtx.getInputValue("objectName");
        String[] targets = (String[])handlerCtx.getInputValue("targets");
        String virtualServers = Util.concatDelimiter(targets, ",");
        Attribute attr = new Attribute("virtual-servers", virtualServers);
        MBeanUtil.setAttribute(objectName, attr);
    }

    public void getSelectedTargets(RequestContext ctx, HandlerContext handlerCtx) {
        String childName = (String)handlerCtx.getInputValue("targetsChildName");
        if (childName == null || childName.length() == 0) {
            return;
        }
        View view = handlerCtx.getView();
        DescriptorContainerView descView = (DescriptorContainerView)((ViewBase)view).getParentViewBean();
        ViewDescriptor vd = descView.getViewDescriptor();
        ViewDescriptor desc = vd.getChildDescriptor(childName);
        if (!(desc instanceof CCAddRemoveDescriptor)) {
            throw new FrameworkException("addRemoveDescriptor is of wrong type", desc, view);
        }
        CCAddRemoveDescriptor addRemoveDesc = (CCAddRemoveDescriptor)desc;
        CCAddRemoveModelInterface model = addRemoveDesc.getModel();
        CCAddRemove addRemoveChild = (CCAddRemove)addRemoveDesc.getView(ctx);
        OptionList selectedOptions = model.getSelectedOptionList(addRemoveChild);
        OptionList availableOptions = model.getAvailableOptionList(addRemoveChild);
        if (selectedOptions == null) {
            selectedOptions = model.getSelectedOptionList();
        }
        if (availableOptions == null) {
            availableOptions = model.getAvailableOptionList();
        }
        String[] targets = null;
        if (selectedOptions != null) {
            targets = new String[selectedOptions.size()];
            for (int i = 0; i < targets.length; ++i) {
                targets[i] = selectedOptions.getValue(i);
            }
        }
        String[] availableTargets = null;
        if (availableOptions != null) {
            availableTargets = new String[availableOptions.size()];
            for (int i = 0; i < availableTargets.length; ++i) {
                availableTargets[i] = availableOptions.getValue(i);
            }
        }
        handlerCtx.setOutputValue("targets", (Object)targets);
        handlerCtx.setOutputValue("availableTargets", (Object)availableTargets);
    }

    public void createReferences(RequestContext ctx, HandlerContext handlerCtx) {
        String objectName = (String)handlerCtx.getInputValue("objectName");
        String methodName = (String)handlerCtx.getInputValue("methodName");
        String key = (String)handlerCtx.getInputValue("key");
        String[] targets = (String[])handlerCtx.getInputValue("targets");
        String[] types = new String[]{"java.lang.String", "boolean", "java.lang.String"};
        if (targets != null) {
            for (int i = 0; i < targets.length; ++i) {
                Object[] params = new Object[]{targets[i], new Boolean(true), key};
                MBeanUtil.invoke(objectName, methodName, params, types);
            }
        }
    }

    public void createMBeanWithReferences(RequestContext ctx, HandlerContext handlerCtx) {
        String enabled;
        String objectName = (String)handlerCtx.getInputValue("objectName");
        String methodName = (String)handlerCtx.getInputValue("methodName");
        ArrayList typesList = (ArrayList)handlerCtx.getInputValue("types");
        ArrayList paramsList = (ArrayList)handlerCtx.getInputValue("params");
        String[] targets = (String[])handlerCtx.getInputValue("targets");
        String[] types = typesList.toArray(new String[typesList.size()]);
        Boolean isTargetSupported = ConfigProperties.getInstance().getTargetSupported();
        if (targets == null || targets.length == 0) {
            targets = new String[]{"server"};
        }
        Map attrsMap = (Map)paramsList.get(0);
        if (isTargetSupported.booleanValue()) {
            enabled = (String)attrsMap.get("EEenabled");
            if (Util.isEmpty(enabled)) {
                enabled = "true";
            }
            attrsMap.put("enabled", enabled);
        } else {
            enabled = (String)attrsMap.get("PEenabled");
            if (Util.isEmpty(enabled)) {
                enabled = "true";
            }
            attrsMap.put("enabled", enabled);
        }
        attrsMap.remove("PEenabled");
        attrsMap.remove("EEenabled");
        for (int i = 0; i < targets.length; ++i) {
            paramsList.add(0, targets[i]);
            Object[] params = paramsList.toArray();
            MBeanUtil.invoke(objectName, methodName, params, types);
            paramsList.remove(0);
            String objName = "com.sun.appserv:type=application-ref,category=config,ref=" + attrsMap.get("name") + ",server=" + targets[i];
            Attribute attr = new Attribute("enabled", attrsMap.get("enabled"));
            MBeanUtil.setAttribute(objName, attr);
        }
        if (!Util.isEmpty((String)attrsMap.get("description"))) {
            Attribute desc = new Attribute("description", attrsMap.get("description"));
            MBeanUtil.setAttribute("com.sun.appserv:type=mbean,category=config,name=" + attrsMap.get("name"), desc);
        }
    }

    public void deleteReferences(RequestContext ctx, HandlerContext handlerCtx) {
        String objectName = (String)handlerCtx.getInputValue("objectName");
        String methodName = (String)handlerCtx.getInputValue("methodName");
        String key = (String)handlerCtx.getInputValue("key");
        String[] targets = (String[])handlerCtx.getInputValue("availableTargets");
        String[] types = new String[]{"java.lang.String", "java.lang.String"};
        if (targets != null) {
            for (int i = 0; i < targets.length; ++i) {
                Object[] params = new Object[]{targets[i], key};
                MBeanUtil.invoke(objectName, methodName, params, types);
            }
        }
    }

    public void deleteLBReferences(RequestContext ctx, HandlerContext handlerCtx) {
        String objectName = (String)handlerCtx.getInputValue("objectName");
        String methodName = (String)handlerCtx.getInputValue("methodName");
        String key = (String)handlerCtx.getInputValue("key");
        String[] deleteTargets = (String[])handlerCtx.getInputValue("availableTargets");
        String[] types = new String[]{"java.lang.String"};
        if (deleteTargets != null) {
            for (int i = 0; i < deleteTargets.length; ++i) {
                Object[] params = new Object[]{deleteTargets[i]};
                MBeanUtil.invoke(objectName, methodName, params, types);
            }
        }
    }

    public void createLBReferences(RequestContext ctx, HandlerContext handlerCtx) {
        String objectName = (String)handlerCtx.getInputValue("objectName");
        String methodName = (String)handlerCtx.getInputValue("methodName");
        String key = (String)handlerCtx.getInputValue("key");
        String[] targets = (String[])handlerCtx.getInputValue("targets");
        Object objName = null;
        if (targets != null) {
            for (int i = 0; i < targets.length; ++i) {
                String[] types2 = new String[]{"java.lang.String"};
                Object[] params2 = new Object[]{targets[i]};
                try {
                    objName = MBeanUtil.invoke(objectName, "getClusterRefByRef", params2, types2);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (objName != null) continue;
                String[] types = new String[]{"javax.management.AttributeList"};
                AttributeList attrList = new AttributeList();
                attrList.add(new Attribute("ref", targets[i]));
                Object[] params = new Object[]{attrList};
                MBeanUtil.invoke(objectName, methodName, params, types);
            }
        }
    }

    public void getRequiredTargets(RequestContext ctx, HandlerContext handlerCtx) {
        Object objectName = handlerCtx.getInputValue("ObjectName");
        String[] targets = (String[])handlerCtx.getInputValue("availableTargets");
        String[] allTargets = (String[])handlerCtx.getInputValue("targetList");
        String key = (String)handlerCtx.getInputValue("key");
        HashMap availableTargetsList = Util.stringArrayToHashMap(targets);
        Vector<String> deleteTargets = new Vector<String>();
        Vector<String> createTargets = new Vector<String>();
        if (key == null) {
            key = "name";
        }
        String[] instanceName = null;
        if (objectName instanceof ObjectName[]) {
            instanceName = this.getAssociatedTargets((ObjectName[])objectName, key);
        } else if (objectName instanceof String[]) {
            instanceName = (String[])objectName;
        }
        HashMap instancesList = Util.stringArrayToHashMap(instanceName);
        for (int i = 0; allTargets != null && i < allTargets.length; ++i) {
            if (availableTargetsList.containsKey(allTargets[i]) && instancesList.containsKey(allTargets[i])) {
                deleteTargets.add(allTargets[i]);
            }
            if (availableTargetsList.containsKey(allTargets[i]) || instancesList.containsKey(allTargets[i])) continue;
            createTargets.add(allTargets[i]);
        }
        handlerCtx.setOutputValue("deleteTargets", (Object)deleteTargets.toArray(new String[deleteTargets.size()]));
        handlerCtx.setOutputValue("createTargets", (Object)createTargets.toArray(new String[createTargets.size()]));
    }

    public void beginDisplayTargetPlaceHolder(RequestContext ctx, HandlerContext handlerCtx) {
        StaticTextField field = (StaticTextField)handlerCtx.getView();
        field.setValue((Object)".TARGETVALUE.");
    }

    public void beginDisplayTargetsInTable(RequestContext ctx, HandlerContext handlerCtx) {
        HREF href = (HREF)handlerCtx.getView();
        href.setValue((Object)".TARGETVALUE.");
    }

    public String endDisplayTargetsInTable(RequestContext ctx, HandlerContext handlerCtx) {
        if (!(handlerCtx.getEvent() instanceof ChildContentDisplayEvent)) {
            return null;
        }
        ChildContentDisplayEvent dispEvent = (ChildContentDisplayEvent)handlerCtx.getEvent();
        String content = dispEvent.getContent();
        ObjectName[] targets = (ObjectName[])handlerCtx.getInputValue("targets");
        String key = (String)handlerCtx.getInputValue("key");
        if (key == null) {
            key = "name";
        }
        String hrefs = "";
        if (targets != null) {
            for (int i = 0; i < targets.length; ++i) {
                String objectType;
                if (i > 0) {
                    hrefs = hrefs + "<br />";
                }
                String isCluster = (objectType = targets[i].getKeyProperty("type")).equalsIgnoreCase("cluster") ? "true" : "false";
                String statusIcon = TargetHandlers.getStatusIconHtml(targets[i]);
                String tmp = content.replaceFirst(".TARGETVALUE.", (String)MBeanUtil.getAttribute(targets[i], key) + "&isCluster=" + isCluster);
                hrefs = hrefs + statusIcon + tmp.replaceAll(".TARGETVALUE.", (String)MBeanUtil.getAttribute(targets[i], key));
            }
        }
        return hrefs;
    }

    public String endDisplayLBsInTable(RequestContext ctx, HandlerContext handlerCtx) {
        if (!(handlerCtx.getEvent() instanceof ChildContentDisplayEvent)) {
            return null;
        }
        ChildContentDisplayEvent dispEvent = (ChildContentDisplayEvent)handlerCtx.getEvent();
        String content = dispEvent.getContent();
        String[] targets = (String[])handlerCtx.getInputValue("targets");
        ObjectName[] lbs = (ObjectName[])handlerCtx.getInputValue("lbs");
        String key = (String)handlerCtx.getInputValue("key");
        if (key == null) {
            key = "name";
        }
        String hrefs = "";
        if (targets != null && lbs != null) {
            for (int i = 0; i < targets.length; ++i) {
                String lbConfig = "";
                String name = "";
                if (i > 0) {
                    hrefs = hrefs + "<br />";
                }
                for (int j = 0; j < lbs.length; ++j) {
                    lbConfig = (String)MBeanUtil.getAttribute(lbs[j].toString(), "lb-config-name");
                    if (!targets[i].equals(lbConfig)) continue;
                    name = lbs[j].getKeyProperty("name");
                }
                String tmp = content.replaceFirst(".TARGETVALUE.", name);
                hrefs = hrefs + tmp.replaceAll(".TARGETVALUE.", name);
            }
        }
        return hrefs;
    }

    public void getStatusCounts(RequestContext ctx, HandlerContext handlerCtx) {
        ObjectName[] instances = (ObjectName[])handlerCtx.getInputValue("instances");
        int running = 0;
        int restart = 0;
        int stopped = 0;
        if (instances != null) {
            block6: for (int i = 0; i < instances.length; ++i) {
                Object sts = null;
                try {
                    sts = MBeanUtil.invoke(instances[i], "getRuntimeStatus", null, null);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (sts == null || !(sts instanceof RuntimeStatus)) continue;
                boolean restartNeeded = ((RuntimeStatus)sts).isRestartNeeded();
                Status s = ((RuntimeStatus)sts).getStatus();
                switch (s.getStatusCode()) {
                    case 0: 
                    case 1: {
                        ++running;
                        if (!restartNeeded) continue block6;
                        ++restart;
                        continue block6;
                    }
                    case 2: 
                    case 3: {
                        ++stopped;
                    }
                }
            }
        }
        handlerCtx.setOutputValue("running", (Object)new Integer(running));
        handlerCtx.setOutputValue("restart", (Object)new Integer(restart));
        handlerCtx.setOutputValue("stopped", (Object)new Integer(stopped));
    }

    public static String getStatusIconHtml(ObjectName obj) {
        if (obj == null) {
            return "";
        }
        Object sts = null;
        try {
            sts = MBeanUtil.invoke(obj, "getRuntimeStatus", null, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return TargetHandlers.getStatusIconHtml(sts);
    }

    public static String getStatusHtml(Object sts) {
        if (sts == null) {
            return TargetHandlers.getStatusIconHtml(-1, false, null) + Util.getMessage("serverinst.unknown");
        }
        if (sts instanceof RuntimeStatus) {
            boolean restartNeeded = ((RuntimeStatus)sts).isRestartNeeded();
            Status s = ((RuntimeStatus)sts).getStatus();
            int statusCode = s.getStatusCode();
            String statusString = "";
            switch (statusCode) {
                case 0: 
                case 1: {
                    if (restartNeeded) {
                        statusString = Util.getMessage("serverinst.restart");
                        break;
                    }
                    statusString = Util.getMessage("serverinst.running");
                    break;
                }
                case 2: 
                case 3: {
                    statusString = Util.getMessage("serverinst.notRunning");
                }
            }
            return TargetHandlers.getStatusIconHtml(statusCode, restartNeeded, null) + statusString;
        }
        if (sts instanceof RuntimeStatusList) {
            RuntimeStatusList stsList = (RuntimeStatusList)sts;
            if (stsList.anyRunning()) {
                return TargetHandlers.getStatusIconHtml(0, false, stsList.toString()) + stsList.toString();
            }
            return TargetHandlers.getStatusIconHtml(3, false, stsList.toString()) + stsList.toString();
        }
        return "";
    }

    public static String getStatusIconHtml(Object sts) {
        if (sts == null) {
            return TargetHandlers.getStatusIconHtml(-1, false, null);
        }
        if (sts instanceof RuntimeStatus) {
            boolean restartNeeded = ((RuntimeStatus)sts).isRestartNeeded();
            Status s = ((RuntimeStatus)sts).getStatus();
            int statusCode = s.getStatusCode();
            return TargetHandlers.getStatusIconHtml(statusCode, restartNeeded, null);
        }
        if (sts instanceof RuntimeStatusList) {
            RuntimeStatusList stsList = (RuntimeStatusList)sts;
            if (stsList.anyRunning()) {
                return TargetHandlers.getStatusIconHtml(0, false, stsList.toString());
            }
            return TargetHandlers.getStatusIconHtml(3, false, stsList.toString());
        }
        return "<img src=\"/com_sun_web_ui/images/other/dot.gif\" width=\"11\" height=\"11\" border=\"0\" alt=\"\"/>&nbsp;";
    }

    public static String getStatusIconHtml(int statusCode, boolean restartNeeded, String altMessage) {
        if (altMessage != null && altMessage.length() == 0) {
            altMessage = null;
        }
        switch (statusCode) {
            case 0: 
            case 1: {
                if (restartNeeded) {
                    String restartGif = Util.getMessage("serverinst.restartGif");
                    return "<img src=\"" + (restartGif == null || restartGif.length() == 0 ? blankGif : restartGif) + "\" border=\"0\" alt=\"" + (altMessage == null ? Util.getMessage("serverinst.restart") : altMessage) + "\" />&nbsp;";
                }
                String runningGif = Util.getMessage("serverinst.runningGif");
                return "<img src=\"" + (runningGif == null || runningGif.length() == 0 ? blankGif : runningGif) + "\" border=\"0\" alt=\"" + (altMessage == null ? Util.getMessage("serverinst.running") : altMessage) + "\" />&nbsp;";
            }
            case 2: 
            case 3: {
                String stoppedGif = Util.getMessage("serverinst.stoppedGif");
                return "<img src=\"" + (stoppedGif == null || stoppedGif.length() == 0 ? blankGif : stoppedGif) + "\" border=\"0\" alt=\"" + (altMessage == null ? Util.getMessage("serverinst.notRunning") : altMessage) + "\" />&nbsp;";
            }
            case -1: {
                String unknownGif = Util.getMessage("serverinst.unknownGif");
                return "<img src=\"" + (unknownGif == null || unknownGif.length() == 0 ? blankGif : unknownGif) + "\" border=\"0\" alt=\"" + (altMessage == null ? Util.getMessage("serverinst.unknown") : altMessage) + "\" />&nbsp;";
            }
        }
        return "<img src=\"/com_sun_web_ui/images/other/dot.gif\" width=\"11\" height=\"11\" border=\"0\" alt=\"\"/>&nbsp;";
    }

    public void disableButtons(RequestContext ctx, HandlerContext handlerCtx) {
        Integer rCount = (Integer)handlerCtx.getInputValue("RunningCount");
        Integer sCount = (Integer)handlerCtx.getInputValue("StoppedCount");
        if (rCount == null || sCount == null) {
            throw new IllegalArgumentException("The parameter map did not contain 'StatusCount'!");
        }
        int r = rCount;
        int s = sCount;
        if (r == 0) {
            handlerCtx.setOutputValue("runngingStatus", (Object)"true");
        } else {
            handlerCtx.setOutputValue("runngingStatus", (Object)"false");
        }
        if (s == 0) {
            handlerCtx.setOutputValue("stoppedStatus", (Object)"true");
        } else {
            handlerCtx.setOutputValue("stoppedStatus", (Object)"false");
        }
    }

    public String formatStatusCount(RequestContext ctx, HandlerContext handlerCtx) {
        Object obj = handlerCtx.getInputValue("count");
        if (obj == null) {
            throw new RuntimeException("null count in formatStatusCount!");
        }
        String count = obj.toString();
        if (count.trim().equals("0")) {
            if (blankGif == null || blankGif.length() == 0) {
                return "&nbsp;&nbsp;--";
            }
            return "<img src=\"/com_sun_web_ui/images/other/dot.gif\" width=\"11\" height=\"11\" border=\"0\" alt=\"\" />--";
        }
        String icon = (String)handlerCtx.getInputValue("icon");
        if (icon == null) {
            throw new RuntimeException("ICON is null in formatStatusCount!");
        }
        String s = "";
        if (icon.equals("stopped")) {
            s = TargetHandlers.getStatusIconHtml(2, false, null) + "&nbsp;" + count;
        } else if (icon.equals("restart")) {
            s = TargetHandlers.getStatusIconHtml(0, true, null) + "&nbsp;" + count;
        } else if (icon.equals("running")) {
            s = TargetHandlers.getStatusIconHtml(0, false, null) + "&nbsp;" + count;
        }
        return s;
    }

    public String getObjectStatus(RequestContext ctx, HandlerContext handlerCtx) {
        int i;
        Object sts = null;
        String objectName = (String)handlerCtx.getInputValue("objectName");
        try {
            String[] types;
            Object[] params;
            String result;
            String objectType = new ObjectName(objectName).getKeyProperty("type");
            if (objectType.equals("node-agent") && (result = (String)MBeanUtil.invoke(objectName, "getPropertyValue", params = new Object[]{"rendezvousOccurred"}, types = new String[]{"java.lang.String"})).equalsIgnoreCase("false")) {
                String status = Util.getMessage("nodeAgent.awaitingInitialSync");
                String stoppedGif = Util.getMessage("serverinst.stoppedGif");
                if (stoppedGif != null && stoppedGif.length() != 0) {
                    status = "<img src=\"" + stoppedGif + "\" border=\"0\" alt=\"" + status + "\" />&nbsp;" + status;
                }
                handlerCtx.setOutputValue("status", (Object)status);
                return status;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            sts = MBeanUtil.invoke(objectName, "getRuntimeStatus", null, null);
        }
        catch (Exception ex) {
            // empty catch block
        }
        String status = TargetHandlers.getStatusHtml(sts);
        if (status.indexOf("dot.gif") > 0 && (i = status.indexOf(";")) > 0) {
            status = status.substring(i + 1);
        }
        handlerCtx.setOutputValue("status", (Object)status);
        return status;
    }

    public String isRunning(RequestContext ctx, HandlerContext handlerCtx) {
        String status = "false";
        String objectName = (String)handlerCtx.getInputValue("objectName");
        try {
            Object sts = MBeanUtil.invoke(objectName, "getRuntimeStatus", null, null);
            if (sts != null && sts instanceof RuntimeStatus) {
                Status s = ((RuntimeStatus)sts).getStatus();
                int statusCode = s.getStatusCode();
                switch (statusCode) {
                    case 0: 
                    case 1: {
                        status = "true";
                        break;
                    }
                    default: {
                        status = "false";
                    }
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        handlerCtx.setOutputValue("status", (Object)status);
        return status;
    }

    public String getClusterStatus(RequestContext ctx, HandlerContext handlerCtx) {
        int restart = 0;
        int running = 0;
        int stopped = 0;
        int unknown = 0;
        String status = Util.getMessage("serverinst.noInstances");
        String clusterObjectName = (String)handlerCtx.getInputValue("clusterObjectName");
        Object objs = MBeanUtil.invoke(clusterObjectName, "listServerInstances", null, null);
        if (objs != null && objs instanceof ObjectName[]) {
            ObjectName[] instances = (ObjectName[])objs;
            for (int i = 0; i < instances.length; ++i) {
                Object sts = null;
                try {
                    sts = MBeanUtil.invoke(instances[i], "getRuntimeStatus", null, null);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (sts != null && sts instanceof RuntimeStatus) {
                    boolean restartNeeded = ((RuntimeStatus)sts).isRestartNeeded();
                    Status s = ((RuntimeStatus)sts).getStatus();
                    int statusCode = s.getStatusCode();
                    switch (statusCode) {
                        case 0: 
                        case 1: {
                            ++running;
                            if (!restartNeeded) break;
                            ++restart;
                            break;
                        }
                        case 2: 
                        case 3: {
                            ++stopped;
                        }
                    }
                    continue;
                }
                ++unknown;
            }
            if (instances.length > 0) {
                status = "" + running + Util.getMessage("serverinst.runningInstances");
                if (stopped > 0) {
                    status = status + "<br />" + stopped + Util.getMessage("serverinst.stoppedInstances");
                }
                if (restart > 0) {
                    status = status + "<br />" + restart + Util.getMessage("serverinst.restartInstances");
                }
                if (unknown > 0) {
                    status = status + "<br />" + unknown + Util.getMessage("serverinst.unknown");
                }
            }
        }
        handlerCtx.setOutputValue("status", (Object)status);
        return status;
    }

    public boolean isTargetSupported(RequestContext ctx, HandlerContext handlerCtx) {
        Boolean isTargetSupported = ConfigProperties.getInstance().getTargetSupported();
        handlerCtx.setOutputValue("isTargetSupported", (Object)isTargetSupported);
        return isTargetSupported;
    }

    public String endDisplayInstanceStatus(RequestContext ctx, HandlerContext handlerCtx) {
        ObjectName[] instances = (ObjectName[])handlerCtx.getInputValue("instances");
        String method = (String)handlerCtx.getInputValue("methodName");
        String result = "";
        if (instances != null) {
            for (int i = 0; i < instances.length; ++i) {
                Object value;
                if (i > 0) {
                    result = result + "<br />";
                }
                if ((value = MBeanUtil.invoke(instances[i], method, null, null)) == null) continue;
                result = value instanceof RuntimeStatus ? result + ((RuntimeStatus)value).toShortString().replaceAll(" ", "&nbsp;") : result + value.toString().replaceAll(" ", "&nbsp;");
            }
        }
        return result;
    }

    public void resourceRefAction(RequestContext ctx, HandlerContext handlerCtx) {
        String tableChildName;
        View view = handlerCtx.getView();
        DescriptorContainerView descView = (DescriptorContainerView)((ViewBase)view).getParentViewBean();
        ViewDescriptor vd = descView.getViewDescriptor();
        ViewDescriptor tableDescriptor = vd.getChildDescriptor(tableChildName = (String)handlerCtx.getInputValue("tableChildName"));
        if (tableDescriptor == null) {
            throw new FrameworkException("tableDescriptor is null", vd, view);
        }
        if (!(tableDescriptor instanceof CCActionTableDescriptor)) {
            throw new FrameworkException("tableDescriptor is of wrong type", tableDescriptor, view);
        }
        CCActionTableModelInterface model = (CCActionTableModelInterface)handlerCtx.getInputValue("propertiesModel");
        if (model == null) {
            throw new FrameworkException("PropertiesHandler.getModel: Parameter 'propertiesModel' not specified");
        }
        String editKeyValue = (String)handlerCtx.getInputValue("editKeyValue");
        String action = (String)handlerCtx.getInputValue("action");
        String methodName = (String)handlerCtx.getInputValue("methodName");
        model.setRowSelectionType("multiple");
        try {
            model.beforeFirst();
            while (model.next()) {
                if (!model.isRowSelected()) continue;
                String objectName = (String)model.getValue("objectName");
                ObjectName resRefObjectName = (ObjectName)MBeanUtil.invoke(objectName, methodName, new Object[]{editKeyValue}, new String[]{"java.lang.String"});
                TargetHandlers.changeEnableStatus(resRefObjectName, action);
                model.setRowSelected(false);
            }
        }
        catch (Exception ex) {
            throw new FrameworkException("Error while enabling: '" + vd.getName() + "'", (Throwable)ex, vd, null);
        }
        ContainerViewBase containerView = (ContainerViewBase)tableDescriptor.getView(ctx).getParent();
        containerView.removeChild(tableDescriptor.getName());
        ((DefaultModel)model).clear();
    }

    public static void changeEnableStatus(ObjectName resRefObjectName, String action) {
        Attribute attr = new Attribute("enabled", action);
        MBeanUtil.setAttribute(resRefObjectName, attr);
        if (action.equals("true")) {
            String editKeyValue = resRefObjectName.getKeyProperty("ref");
            TargetHandlers.changeResourceAttribute(editKeyValue, attr);
        }
    }

    private static void changeResourceAttribute(String resName, Attribute attr) {
        try {
            String resType = (String)MBeanUtil.invoke("com.sun.com.sun.appserv:type=resources,category=config", "getResourceType", (Object[])new String[]{resName}, new String[]{"java.lang.String"});
            ObjectName obj = new ObjectName("com.sun.com.sun.appserv:category=config,type=" + resType + ",jndi-name=" + resName);
            MBeanUtil.setAttribute(obj, attr);
        }
        catch (MalformedObjectNameException ex) {
            throw new FrameworkException("error in TargetHandlers changeEnableStatus :", (Throwable)ex);
        }
    }

    public void changeResourceStatusAll(RequestContext ctx, HandlerContext handlerCtx) {
        View view = handlerCtx.getView();
        DescriptorContainerView descView = (DescriptorContainerView)((ViewBase)view).getParentViewBean();
        ViewDescriptor vd = descView.getViewDescriptor();
        String childName = (String)vd.getParameter("tableChildName");
        if (childName == null) {
            throw new FrameworkException("childName not specified", vd, view);
        }
        ViewDescriptor tableDescriptor = vd.getChildDescriptor(childName);
        if (tableDescriptor == null) {
            throw new FrameworkException("tableDescriptor is null", vd, view);
        }
        if (!(tableDescriptor instanceof CCActionTableDescriptor)) {
            throw new FrameworkException("tableDescriptor is of wrong type", tableDescriptor, view);
        }
        String newStatus = (String)handlerCtx.getInputValue("new-status");
        String key = (String)handlerCtx.getInputValue("key");
        TargetHandlers.doAction(((CCActionTableDescriptor)tableDescriptor).getModel(), tableDescriptor, key, newStatus);
    }

    private static void doAction(CCActionTableModelInterface model, ViewDescriptor vd, String key, String newStatus) {
        RequestContext ctx = RequestManager.getRequestContext();
        Attribute attr = new Attribute("enabled", newStatus);
        try {
            model.setRowSelectionType("multiple");
            model.beforeFirst();
            while (model.next()) {
                if (!model.isRowSelected()) continue;
                String resName = (String)model.getValue(key);
                if (newStatus.equals("true")) {
                    MBeanUtil.setAttribute((String)model.getValue("objectName"), attr);
                }
                Object[] params = new String[]{resName};
                String[] types = new String[]{"java.lang.String"};
                boolean isTargetSupported = ConfigProperties.getInstance().getTargetSupported();
                if (!isTargetSupported) {
                    MBeanUtil.setAttribute("com.sun.appserv:type=resource-ref,server=server,category=config,ref=" + resName, attr);
                } else {
                    ObjectName[] targets = (ObjectName[])MBeanUtil.invoke("com.sun.appserv:type=resources,category=config", "listReferencees", params, types);
                    if (targets == null) continue;
                    for (int i = 0; i < targets.length; ++i) {
                        ObjectName resRef = (ObjectName)MBeanUtil.invoke(targets[i], "getResourceRefByRef", params, types);
                        MBeanUtil.setAttribute(resRef, attr);
                    }
                }
                model.setRowSelected(false);
            }
        }
        catch (Exception ex) {
            throw new FrameworkException("error in changeResourceStatus ", (Throwable)ex);
        }
        View view = vd.getView(ctx).getParent();
        ContainerViewBase descView = (ContainerViewBase)view;
        descView.removeChild(vd.getName());
        ((DefaultModel)model).clear();
    }

    public void getDefaultTarget(RequestContext ctx, HandlerContext handlerCtx) {
        handlerCtx.setOutputValue("defaultTarget", (Object)ConfigProperties.getInstance().getDefaultTarget());
    }

    public void beginResourceEditTabsDisplay(RequestContext ctx, HandlerContext handlerCtx) {
        HREF href = (HREF)handlerCtx.getView();
        href.setValue((Object)(href.getValue() + ".RESOURCENAME."));
    }

    public String endResourceEditTabsDisplay(RequestContext ctx, HandlerContext handlerCtx) {
        if (!(handlerCtx.getEvent() instanceof ChildContentDisplayEvent)) {
            return null;
        }
        ChildContentDisplayEvent dispEvent = (ChildContentDisplayEvent)handlerCtx.getEvent();
        String content = dispEvent.getContent();
        content = content.replaceAll(".RESOURCENAME.", "&name=" + ctx.getRequest().getAttribute("editKeyValue"));
        return content;
    }

    public void beginEditTabsDisplay(RequestContext ctx, HandlerContext handlerCtx) {
        HREF href = (HREF)handlerCtx.getView();
        href.setValue((Object)(href.getValue() + ".PLACEHOLDER."));
    }

    public String endEditTabsDisplay(RequestContext ctx, HandlerContext handlerCtx) {
        if (!(handlerCtx.getEvent() instanceof ChildContentDisplayEvent)) {
            return null;
        }
        ChildContentDisplayEvent dispEvent = (ChildContentDisplayEvent)handlerCtx.getEvent();
        String content = dispEvent.getContent();
        String key = (String)handlerCtx.getInputValue("key");
        if (key == null) {
            key = "name";
        }
        content = content.replaceAll(".PLACEHOLDER.", "&" + key + "=" + ctx.getRequest().getAttribute(key));
        return content;
    }

    public String endClusteredInstanceTabsDisplay(RequestContext ctx, HandlerContext handlerCtx) {
        if (!(handlerCtx.getEvent() instanceof ChildContentDisplayEvent)) {
            return null;
        }
        ChildContentDisplayEvent dispEvent = (ChildContentDisplayEvent)handlerCtx.getEvent();
        String content = dispEvent.getContent();
        String key = (String)handlerCtx.getInputValue("key");
        if (key == null) {
            key = "name";
        }
        content = content.replaceAll(".PLACEHOLDER.", "&" + key + "=" + ctx.getRequest().getAttribute(key) + "&isCluster=true");
        return content;
    }
}

