/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.servlet;

import com.sun.appserv.management.ext.wsmgmt.WebServiceMgr;
import com.sun.appserv.management.util.misc.ExceptionUtil;
import com.sun.enterprise.tools.admingui.ConfigProperties;
import com.sun.enterprise.tools.admingui.handlers.DeploymentHandler;
import com.sun.enterprise.tools.admingui.handlers.WebServiceHandler;
import com.sun.enterprise.tools.admingui.servlet.MultipartHandler;
import com.sun.enterprise.tools.admingui.util.AMXUtil;
import com.sun.enterprise.tools.admingui.util.FileUtil;
import com.sun.enterprise.tools.admingui.util.MBeanUtil;
import com.sun.enterprise.tools.admingui.util.Util;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class UploadServlet
extends HttpServlet {
    private static final String CFG_MAX_UPLOAD_SIZE = "maxUploadSize";
    private static final int MAX_UPLOAD_SIZE = 0xA00000;
    private static final String CURRENT = "current";
    private static final String NEXT = "next";
    int maxUploadSize = 0xA00000;
    ServletContext ctxt = null;
    String mesg = null;
    String bundle = "com.sun.enterprise.tools.admingui.resources.Resources";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.ctxt = this.getServletContext();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String uploadType = req.getParameter("uploadType");
        String appType = req.getParameter("appType");
        String which = req.getParameter("which");
        String cancelPage = req.getParameter("cancelPage");
        res.setContentType("text/html; charset=UTF-8");
        PrintWriter out = res.getWriter();
        String contentType = req.getContentType();
        String uploadDir = null;
        String uploadDirErrMsg = "";
        String dispatchRequest = null;
        if (!"mbean".equals(appType) || which.equals("client")) {
            try {
                uploadDir = FileUtil.getUploadDir();
            }
            catch (SecurityException se) {
                uploadDirErrMsg = Util.getMessage("upload.permission");
                se.printStackTrace();
            }
            catch (Exception e) {
                if (uploadType == null) {
                    uploadDirErrMsg = Util.getMessage("upload.UploadTypeNotSpecified");
                }
                e.printStackTrace();
            }
        }
        if (contentType.toLowerCase().startsWith("multipart/form-data")) {
            if (uploadDir == null && Util.isLoggableCONFIG()) {
                Util.logCONFIG("UploadServlet.doPost: uploadDir is null. " + uploadDirErrMsg);
            }
            if (uploadDir == null) {
                if (Util.isLoggableWARNING()) {
                    Util.logWARNING(Util.getMessage("upload.ErrorUploadingFile") + Util.getMessage("upload.nullDir") + Util.getMessage(uploadDirErrMsg));
                }
                req.setAttribute("ALERT_TYPE", (Object)"error");
                req.setAttribute("ALERT_SUMMARY", (Object)"upload.nullDir");
                req.setAttribute("MBEAN_MESSAGE", (Object)uploadDirErrMsg);
                req.setAttribute("HAS_MBEAN_MESSAGE", (Object)"true");
                req.setAttribute("HAS_ERROR_MESSAGE", (Object)"true");
                if (cancelPage != null && !cancelPage.equals("")) {
                    req.setAttribute("cancelPage", (Object)cancelPage);
                }
                dispatchRequest = this.getDispatchRequest(uploadType, appType, CURRENT);
            } else {
                MultipartHandler multiReq = new MultipartHandler(req, uploadDir, this.maxUploadSize);
                multiReq.parseMultipartUpload();
                Enumeration fileEnum = multiReq.getFileNames();
                String name = (String)fileEnum.nextElement();
                File appFile = multiReq.getFile(name);
                String appFileName = appFile.getAbsolutePath();
                long len = appFile.length();
                if (len > 0L) {
                    dispatchRequest = this.getDispatchRequest(uploadType, appType, NEXT);
                    String filePath = appFile.getAbsolutePath();
                    String fileName = this.getFileName(filePath);
                    if (dispatchRequest != null) {
                        if (uploadType.equals("deploy")) {
                            String listPage = multiReq.getParameter("upload.listPage");
                            req.setAttribute("filePath", (Object)filePath);
                            req.setAttribute("fileName", (Object)this.getFileName(filePath));
                            req.setAttribute("uploadedFileName", (Object)appFile.getName());
                            req.setAttribute("ctxtRoot", (Object)("/" + fileName));
                            if (cancelPage != null && !cancelPage.equals("")) {
                                req.setAttribute("cancelPage", (Object)cancelPage);
                            }
                            if (listPage != null && !listPage.equals("")) {
                                req.setAttribute("listPage", (Object)listPage);
                            }
                            if ("mbean".equals(appType) && !this.testMbeanExist(req, filePath)) {
                                dispatchRequest = this.getDispatchRequest("deploy", appType, CURRENT);
                            }
                        } else if (uploadType.equals("redeploy")) {
                            if (!this.redeploy(req, true, filePath)) {
                                dispatchRequest = this.getDispatchRequest("redeploy", appType, CURRENT);
                            }
                        } else if (uploadType.equals("transformationRule") && !this.addTransformationRule(req, filePath)) {
                            dispatchRequest = this.getDispatchRequest("transformationRule", appType, CURRENT);
                        }
                    }
                } else {
                    req.setAttribute("AppType", (Object)appType);
                    req.setAttribute("ALERT_TYPE", (Object)"error");
                    req.setAttribute("ALERT_SUMMARY", (Object)"upload.ErrorUploadingFile");
                    req.setAttribute("MBEAN_MESSAGE", (Object)"upload.FileToUploadDoesNotExist");
                    req.setAttribute("HAS_MBEAN_MESSAGE", (Object)"true");
                    req.setAttribute("HAS_ERROR_MESSAGE", (Object)"true");
                    if (cancelPage != null && !cancelPage.equals("")) {
                        req.setAttribute("cancelPage", (Object)cancelPage);
                    }
                    dispatchRequest = this.getDispatchRequest(uploadType, appType, CURRENT);
                }
            }
        } else if (contentType.toLowerCase().startsWith("application/x-www-form-urlencoded")) {
            dispatchRequest = this.getDispatchRequest(uploadType, appType, NEXT);
            if (uploadType.equals("redeploy")) {
                if (!this.redeploy(req, false, null)) {
                    dispatchRequest = this.getDispatchRequest("redeploy", appType, CURRENT);
                }
            } else if ("mbean".equals(appType) && !this.testMbeanExist(req, null)) {
                dispatchRequest = this.getDispatchRequest("deploy", appType, CURRENT);
            }
        } else {
            dispatchRequest = this.getDispatchRequest(uploadType, appType, NEXT);
        }
        try {
            req.getRequestDispatcher(dispatchRequest).forward((ServletRequest)req, (ServletResponse)res);
        }
        catch (Exception e) {
            this.ctxt.log(e.getMessage() + " " + e.getClass());
        }
    }

    private String getDispatchRequest(String uploadType, String appType, String page) {
        String dispatchRequest = null;
        if (page.equals(CURRENT)) {
            if (uploadType.equals("deploy")) {
                dispatchRequest = "../admingui/upload";
            } else if (uploadType.equals("redeploy")) {
                dispatchRequest = "../admingui/redeploy";
            } else if (uploadType.equals("transformationRule")) {
                dispatchRequest = "../admingui/webServiceTransformationAdd";
            }
        } else if (page.equals(NEXT)) {
            boolean isEAR = false;
            boolean isWAR = false;
            boolean isEJB = false;
            boolean isRAR = false;
            boolean isAC = false;
            boolean isMBean = false;
            if (appType != null) {
                if (appType.equals("ear")) {
                    isEAR = true;
                } else if (appType.equals("war")) {
                    isWAR = true;
                } else if (appType.equals("jar")) {
                    isEJB = true;
                } else if (appType.equals("rar")) {
                    isRAR = true;
                } else if (appType.equals("all")) {
                    isAC = true;
                } else if (appType.equals("mbean")) {
                    isMBean = true;
                }
            }
            if (uploadType.equals("deploy")) {
                if (isWAR) {
                    dispatchRequest = "../admingui/deployWebModule";
                } else if (isEAR) {
                    dispatchRequest = "../admingui/deployJ2EEApplication";
                } else if (isEJB) {
                    dispatchRequest = "../admingui/deployEJBJarModule";
                } else if (isRAR) {
                    dispatchRequest = "../admingui/deployConnectorModule";
                } else if (isAC) {
                    dispatchRequest = "../admingui/deployAppclientModule";
                } else if (isMBean) {
                    dispatchRequest = "../admingui/createCustomMBean";
                }
            } else if (uploadType.equals("redeploy")) {
                Boolean isTargetSupported = ConfigProperties.getInstance().getTargetSupported();
                if (isWAR) {
                    dispatchRequest = isTargetSupported.booleanValue() ? "../admingui/eeWebApplications" : "../admingui/webApplications";
                } else if (isEAR) {
                    dispatchRequest = isTargetSupported.booleanValue() ? "../admingui/eeEnterpriseApplications" : "../admingui/enterpriseApplications";
                } else if (isEJB) {
                    dispatchRequest = isTargetSupported.booleanValue() ? "../admingui/eeEjbModules" : "../admingui/ejbModules";
                } else if (isRAR) {
                    dispatchRequest = isTargetSupported.booleanValue() ? "../admingui/eeConnectorModules" : "../admingui/connectorModules";
                } else if (isAC) {
                    dispatchRequest = isTargetSupported.booleanValue() ? "../admingui/eeAppclientModules" : "../admingui/appclientModules";
                }
            } else if (uploadType.equals("transformationRule")) {
                dispatchRequest = "../admingui/webServiceTransformation";
            }
        }
        return dispatchRequest;
    }

    private boolean redeploy(HttpServletRequest req, boolean isUpload, String uploadFile) {
        boolean isRedeploySuccessful = false;
        String location = req.getParameter("AppFile");
        String type = req.getParameter("appType");
        String contextRoot = req.getParameter("contextRoot");
        location = isUpload ? uploadFile : req.getParameter("DirectoryDeployField");
        String n = req.getParameter("name");
        Properties props = new Properties();
        props.setProperty("archiveName", location);
        props.setProperty("name", n);
        props.setProperty("force", "true");
        props.setProperty("contextRoot", contextRoot);
        String errMsg = null;
        req.setAttribute("AppType", (Object)type);
        req.setAttribute("HAS_MBEAN_MESSAGE", (Object)"true");
        try {
            DeploymentHandler.invokeDeploymentFacility(null, props, location);
            isRedeploySuccessful = true;
            req.setAttribute("ALERT_TYPE", (Object)"info");
            req.setAttribute("ALERT_SUMMARY", (Object)"redeploy.successful");
            req.setAttribute("MBEAN_MESSAGE", (Object)"");
            req.setAttribute("infoAlert", (Object)"true");
        }
        catch (Exception e) {
            isRedeploySuccessful = false;
            errMsg = e.getMessage();
            if (errMsg == null) {
                errMsg = Util.getMessage(this.bundle, "alert.SeeServerLog", null);
            }
            req.setAttribute("ALERT_TYPE", (Object)"error");
            req.setAttribute("ALERT_SUMMARY", (Object)"alert.Summary");
            req.setAttribute("MBEAN_MESSAGE", (Object)errMsg);
            req.setAttribute("HAS_ERROR_MESSAGE", (Object)"true");
        }
        return isRedeploySuccessful;
    }

    private boolean addTransformationRule(HttpServletRequest req, String uploadDir) {
        boolean isAddRuleSuccessful = false;
        String clientLocation = req.getParameter("RuleFile");
        File f = new File(clientLocation);
        String errMsg = null;
        String ruleName = req.getParameter("ruleName");
        String webServiceKey = req.getParameter("webServiceKey");
        webServiceKey = webServiceKey.replaceAll("[@]", "#");
        String applyTo = req.getParameter("applyTo");
        boolean enabled = Boolean.valueOf(req.getParameter("enabled"));
        try {
            WebServiceMgr wsm = AMXUtil.getDomainRoot().getWebServiceMgr();
            WebServiceHandler.createTransformationRuleConfig(webServiceKey, ruleName, enabled, applyTo, uploadDir, null);
            isAddRuleSuccessful = true;
        }
        catch (Exception e) {
            isAddRuleSuccessful = false;
            Throwable t = ExceptionUtil.getRootCause((Throwable)e);
            if (t != null && (errMsg = t.getLocalizedMessage()) == null) {
                errMsg = t.getMessage();
            }
            if (errMsg == null) {
                errMsg = Util.getMessage(this.bundle, "alert.SeeServerLog", null);
            }
            req.setAttribute("ALERT_TYPE", (Object)"error");
            req.setAttribute("ALERT_SUMMARY", (Object)"alert.Summary");
            req.setAttribute("MBEAN_MESSAGE", (Object)errMsg);
            req.setAttribute("HAS_MBEAN_MESSAGE", (Object)"true");
            req.setAttribute("HAS_ERROR_MESSAGE", (Object)"true");
        }
        return isAddRuleSuccessful;
    }

    private boolean testMbeanExist(HttpServletRequest req, String jarFileName) {
        String errMsg = "";
        try {
            String which = req.getParameter("which");
            String implClass = req.getParameter("implClass");
            req.setAttribute("implClass", (Object)implClass);
            String domainRoot = Util.getDomainRoot();
            if (which.equals("server")) {
                jarFileName = req.getParameter("DirectoryDeployField");
                FileUtil.extractMbeanJarFile(domainRoot, jarFileName);
                req.setAttribute("uploadedFileName", (Object)jarFileName);
                req.setAttribute("implClass", (Object)implClass);
                String nm = new File(jarFileName).getName();
                int index = nm.indexOf(".");
                if (index > 0) {
                    nm = nm.substring(0, index);
                }
                req.setAttribute("fileName", (Object)nm);
                String listPage = req.getParameter("upload.listPage");
                if (listPage != null && !listPage.equals("")) {
                    req.setAttribute("listPage", (Object)listPage);
                }
            } else if (which.equals("skip")) {
                req.setAttribute("implClass", (Object)implClass);
                req.setAttribute("uploadedFileName", (Object)Util.getMessage(this.bundle, "common.NA", null));
                String listPage = req.getParameter("upload.listPage");
                if (listPage != null && !listPage.equals("")) {
                    req.setAttribute("listPage", (Object)listPage);
                }
            } else if (which.equals("client")) {
                FileUtil.extractMbeanJarFile(domainRoot, jarFileName);
            }
            Object[] params = new Object[]{implClass};
            String[] types = new String[]{"java.lang.String"};
            MBeanUtil.invoke("com.sun.appserv:type=applications,category=config", "getMBeanInfo", params, types);
            return true;
        }
        catch (IOException ioEx) {
            errMsg = ioEx.getMessage();
        }
        catch (Exception ex) {
            errMsg = ex.getCause() == null ? ex.getLocalizedMessage() : ex.getCause().getLocalizedMessage();
        }
        req.setAttribute("AppType", (Object)"mbean");
        req.setAttribute("ALERT_TYPE", (Object)"error");
        req.setAttribute("ALERT_SUMMARY", (Object)"alert.Summary");
        req.setAttribute("MBEAN_MESSAGE", (Object)errMsg);
        req.setAttribute("HAS_MBEAN_MESSAGE", (Object)"true");
        req.setAttribute("HAS_ERROR_MESSAGE", (Object)"true");
        return false;
    }

    private String getFileName(String filePath) {
        String name = new File(filePath).getName();
        int index = name.indexOf(".");
        if (index > 0) {
            return name.substring(0, index);
        }
        return filePath;
    }
}

