/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.taglib;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.JspDisplayEvent;
import com.sun.enterprise.tools.admingui.util.Util;
import com.sun.web.ui.model.CCPropertySheetModelInterface;
import com.sun.web.ui.taglib.propertysheet.CCPropertySheetTag;
import com.sun.web.ui.view.propertysheet.CCPropertySheet;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DataSheetTag
extends CCPropertySheetTag {
    private int iCurrentSection = 0;
    private ArrayList dataObjects = null;
    private static final String DATA_ELEMENT = "dataValue";
    private static final String TEMPLATE_ELEMENT = "sectionTemplate";
    private final String Milliseconds = Util.getMessage("label.Milliseconds");
    private final String Seconds = Util.getMessage("label.Seconds");
    private final String Minutes = Util.getMessage("label.Minutes");
    private final String Hours = Util.getMessage("label.Hours");
    private final String Days = Util.getMessage("label.Days");
    private final String Weeks = Util.getMessage("label.Weeks");

    public void reset() {
        super.reset();
        this.dataObjects = null;
    }

    protected String getHTMLStringInternal(Tag parent, PageContext pageContext, View view) throws JspException {
        if (parent == null) {
            throw new IllegalArgumentException("parent cannot be null.");
        }
        if (pageContext == null) {
            throw new IllegalArgumentException("pageContext cannot be null.");
        }
        if (view == null) {
            throw new IllegalArgumentException("view cannot be null.");
        }
        this.checkChildType(view, CCPropertySheet.class);
        CCPropertySheet field = (CCPropertySheet)view;
        this.containerView = field.getContainerView() != null ? field.getContainerView() : (ContainerView)field.getParent();
        CCPropertySheetModelInterface model = field.getModel();
        if (model == null) {
            throw new IllegalArgumentException("PropertySheet model cannot be null");
        }
        if (model.getDocument() == null) {
            throw new RuntimeException("The property sheet model getDocument() returned null.\nBe sure a valid XML file was supplied to the property sheet model.");
        }
        this.setParent(parent);
        this.setPageContext(pageContext);
        if (field.getShowJumpLinks() != null) {
            this.setShowJumpLinks(field.getShowJumpLinks().toString());
        }
        NonSyncStringBuffer buffer = new NonSyncStringBuffer(8192);
        try {
            field.beginDisplay((DisplayEvent)new JspDisplayEvent((Tag)this, pageContext));
        }
        catch (ModelControlException e) {
            throw new JspException(e.getRootCause());
        }
        this.numberOfSections = 0;
        this.appendSections(buffer, this.getSections(model), model);
        this.appendData(buffer, this.getTemplates(model), model);
        this.appendJavaScript(buffer);
        return buffer.toString();
    }

    private Node findMatchingTemplate(NodeList templates, Object data) {
        for (int i = 0; i < templates.getLength(); ++i) {
            Node template = templates.item(i);
            String cls = this.getAttributeValue(template, "class", null);
            if (cls != null) {
                try {
                    Class<?> clazz = Class.forName(cls);
                    if (clazz.isInstance(data)) {
                        return template;
                    }
                }
                catch (Exception ex) {
                    if (!Util.isLoggableINFO()) continue;
                    Util.logINFO("Error in finding class: " + cls + "\n" + ex.getMessage());
                }
                continue;
            }
            if (!Util.isLoggableINFO()) continue;
            Util.logINFO("XML error: No class specified for section template.");
        }
        return null;
    }

    private NodeList getSectionsForProcessing(NodeList templates, CCPropertySheetModelInterface model) {
        Object[] objs = (Object[])model.getValue("DataObjects");
        if (objs == null) {
            return null;
        }
        this.dataObjects = new ArrayList();
        MyNodeList sections = new MyNodeList();
        for (int i = 0; i < objs.length; ++i) {
            Node template = this.findMatchingTemplate(templates, objs[i]);
            if (template != null) {
                sections.add(template);
                this.dataObjects.add(objs[i]);
                continue;
            }
            if (!Util.isLoggableINFO()) continue;
            Util.logINFO("Could not find matching template.");
            Util.logINFO("OBJECT CLASS: " + objs[i].getClass().getName());
            try {
                Util.logINFO("    name: " + this.evaluate(objs[i], "$getName", null, null));
                Util.logINFO("    desc: " + this.evaluate(objs[i], "$getDescription", null, null));
                continue;
            }
            catch (Exception ex) {
                Util.logINFO("error in evaluate: " + ex.getMessage());
            }
        }
        return sections;
    }

    private Object getCurrentData() {
        return this.dataObjects.get(this.iCurrentSection);
    }

    private void appendData(NonSyncStringBuffer buffer, NodeList templates, CCPropertySheetModelInterface model) throws JspException {
        NodeList sections = this.getSectionsForProcessing(templates, model);
        if (sections == null || sections.getLength() == 0) {
            return;
        }
        this.appendSections(buffer, sections, model);
    }

    protected void appendSections(NonSyncStringBuffer buffer, NodeList sections, CCPropertySheetModelInterface model) throws JspException {
        boolean added = this.numberOfSections != 0 && !this.hasJumpLinks();
        this.numberOfSections = sections.getLength();
        if (this.numberOfSections == 0) {
            return;
        }
        this.appendJumpLinks(buffer, sections, model);
        for (int i = 0; i < this.numberOfSections; ++i) {
            Node section = sections.item(i);
            if (!this.isVisible(section, model)) continue;
            if (added) {
                this.appendSeparator(buffer);
            }
            this.iCurrentSection = i;
            this.appendSection(buffer, section, model);
            if (this.hasJumpLinks()) {
                this.appendBackToTop(buffer);
            } else {
                buffer.append(this.getSpacerHTMLString("10", "1"));
            }
            added = true;
        }
    }

    protected void appendProperty(NonSyncStringBuffer buffer, Node property, CCPropertySheetModelInterface model, int level) throws JspException {
        boolean colspan;
        buffer.append("<tr>\n");
        String labelId = null;
        boolean hasNoValueElement = this.hasNoValueElement(property);
        boolean bl = colspan = this.isSpan(property) || hasNoValueElement;
        if (!colspan) {
            labelId = this.appendLabel(buffer, property, model, level);
        }
        if (colspan) {
            buffer.append("<td valign=\"top\" colspan=\"2\"><div class=\"");
        } else {
            buffer.append("<td valign=\"top\"><div class=\"");
        }
        buffer.append(this.getDivClass(colspan, level)).append("\">");
        NodeList subNodes = property.getChildNodes();
        for (int i = 0; i < subNodes.getLength(); ++i) {
            Node subNode = subNodes.item(i);
            String nodeName = subNode.getNodeName();
            if (nodeName.equalsIgnoreCase("cc")) {
                boolean isTableTag;
                if (i != 0) {
                    buffer.append("\n");
                }
                if (isTableTag = this.isTableTag(subNode, colspan, level)) {
                    this.preTableFormat(buffer);
                }
                labelId = this.appendValue(buffer, subNode, labelId, level > 1 || !colspan);
                if (!isTableTag) continue;
                this.postTableFormat(buffer, colspan, level);
                continue;
            }
            if (nodeName.equalsIgnoreCase("fieldhelp")) {
                this.appendFieldHelp(buffer, this.getNameHTML(subNode));
                continue;
            }
            if (nodeName.equalsIgnoreCase("ccgroup")) {
                this.appendValueSet(buffer, subNode, model, level + 1);
                continue;
            }
            if (nodeName.equalsIgnoreCase("label")) {
                if (!hasNoValueElement) continue;
                String labelHTML = this.getNameHTML(subNode);
                String style = level > 1 ? "LblLev3Txt" : "LblLev2Txt";
                buffer.append(this.getLabelHTMLString(style, null, null, this.isError(property, model), this.isRequired(property), labelHTML));
                continue;
            }
            if (nodeName.equalsIgnoreCase(DATA_ELEMENT)) {
                labelId = this.appendDataValue(buffer, subNode, labelId, model);
                continue;
            }
            String html = subNode.getNodeValue();
            if (html == null) continue;
            buffer.append(html.trim());
        }
        buffer.append("</div></td></tr>\n");
    }

    private String convert(long value, String unit) {
        if (unit == null || value == 0L) {
            return "";
        }
        TimeData t = null;
        if (unit.equalsIgnoreCase(this.Milliseconds)) {
            t = new TimeData((value + 500L) / 1000L);
        } else if (unit.equalsIgnoreCase(this.Seconds)) {
            t = new TimeData(value);
        } else if (unit.equalsIgnoreCase(this.Minutes)) {
            t = new TimeData(value * 60L);
        } else {
            return "";
        }
        return "  (" + t.toString() + ")";
    }

    private long getLongValue(Object value) {
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        return new Long(value.toString());
    }

    private String evaluate(Object data, String methodName, String formatType, String unit) throws Exception {
        if (methodName.indexOf(36) != 0) {
            throw new RuntimeException("Method Names must begin with a '$': " + methodName);
        }
        methodName = methodName.substring(1);
        Method method = null;
        try {
            method = data.getClass().getMethod(methodName, null);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException("Method '" + methodName + "' not found!", ex);
        }
        Object value = method.invoke(data, (Object[])null);
        if (formatType == null || formatType.equalsIgnoreCase("String")) {
            return value.toString();
        }
        if (formatType.equalsIgnoreCase("Date")) {
            Date date = new Date(this.getLongValue(value));
            return date.toString();
        }
        if (formatType.equalsIgnoreCase("Number")) {
            long longValue = this.getLongValue(value);
            String html = NumberFormat.getInstance().format(longValue);
            if (unit == null) {
                return html;
            }
            return html + "&nbsp;" + Util.getMessage(unit) + this.convert(longValue, unit);
        }
        throw new RuntimeException("Unknown format type for Method: " + methodName);
    }

    private String appendDataValue(NonSyncStringBuffer buff, Node dataNode, String labelId, CCPropertySheetModelInterface model) {
        String methodName = this.getAttributeValue(dataNode, "method", null);
        String formatType = this.getAttributeValue(dataNode, "formatType", "String");
        String unit = this.getAttributeValue(dataNode, "unit", null);
        try {
            if (unit != null && unit.startsWith("$")) {
                unit = this.evaluate(this.getCurrentData(), unit, "String", null);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        String value = "No Method defined!";
        try {
            if (methodName != null) {
                value = this.evaluate(this.getCurrentData(), methodName, formatType, unit);
            }
        }
        catch (Exception ex) {
            value = ex.getMessage();
        }
        if (labelId != null) {
            buff.append("<span id=\"").append(labelId).append("\" class=\"ConDefTxt\">").append(value).append("</span>");
        } else {
            buff.append(value);
        }
        return null;
    }

    private NodeList getTemplates(CCPropertySheetModelInterface model) {
        return model.getDocument().getElementsByTagName(TEMPLATE_ELEMENT);
    }

    protected String getDefaultValue(Node node) throws JspException {
        String html = this.getAttributeValue(node, "defaultValue", null);
        if (html != null) {
            if (html.indexOf(36) == 0) {
                try {
                    return this.getMessage(this.evaluate(this.getCurrentData(), html, "String", null));
                }
                catch (Exception ex) {
                    return ex.getMessage();
                }
            }
            return this.getMessage(html);
        }
        return "";
    }

    protected boolean hasNoValueElement(Node propertyNode) {
        NodeList subNodes = propertyNode.getChildNodes();
        for (int i = 0; i < subNodes.getLength(); ++i) {
            Node valueNode = subNodes.item(i);
            String nodeName = valueNode.getNodeName();
            if (nodeName == null || !nodeName.equalsIgnoreCase("cc") && !nodeName.equalsIgnoreCase(DATA_ELEMENT)) continue;
            return false;
        }
        return true;
    }

    protected void appendJumpLinks(NonSyncStringBuffer buff, NodeList sections) throws JspException {
        int count = this.numberOfSections;
        if (count == 0) {
            return;
        }
        String[] names = new String[count];
        String[] anchors = new String[count];
        for (int i = 0; i < count; ++i) {
            Node sectionNode = sections.item(i);
            this.iCurrentSection = i;
            names[i] = this.getNameHTML(sectionNode);
            anchors[i] = this.getAnchor(sectionNode);
            if (!anchors[i].equals("")) continue;
            anchors[i] = names[i];
        }
        buff.append("<div class=\"ConJmpScnDiv\">\n<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr>\n");
        if (count < 5) {
            this.appendJumpLinks(buff, names, anchors, count, 2);
        } else if (count < 10) {
            this.appendJumpLinks(buff, names, anchors, count, 3);
        } else {
            this.appendJumpLinks(buff, names, anchors, count, 4);
        }
        buff.append("</tr></table></div>\n");
    }

    protected boolean hasJumpLinks() {
        if (this.numberOfSections > 2) {
            return new Boolean(this.getShowJumpLinks());
        }
        return false;
    }

    private class TimeData {
        private long seconds = 0L;
        private long minutes = 0L;
        private long hours = 0L;
        private long days = 0L;
        private long weeks = 0L;
        private static final long oneWeek = 604800L;
        private static final long oneDay = 86400L;
        private static final long oneHour = 3600L;
        private static final long oneMinute = 60L;

        public TimeData(long secs) {
            this.seconds = secs;
            if (this.seconds >= 604800L) {
                this.weeks = this.seconds / 604800L;
                this.seconds -= this.weeks * 604800L;
            }
            if (this.seconds >= 86400L) {
                this.days = this.seconds / 86400L;
                this.seconds -= this.days * 86400L;
            }
            if (this.seconds >= 3600L) {
                this.hours = this.seconds / 3600L;
                this.seconds -= this.hours * 3600L;
            }
            if (this.seconds >= 60L) {
                this.minutes = this.seconds / 60L;
                this.seconds -= this.minutes * 60L;
            }
        }

        public String toString() {
            String str = "&nbsp;";
            if (this.weeks > 0L) {
                str = str + this.weeks + "&nbsp;" + DataSheetTag.this.Weeks + ",&nbsp;";
            }
            if (this.days > 0L || str.length() > 6) {
                str = str + this.days + "&nbsp;" + DataSheetTag.this.Days + ",&nbsp;";
            }
            if (this.hours > 0L || str.length() > 6) {
                str = str + this.hours + "&nbsp;" + DataSheetTag.this.Hours + ",&nbsp;";
            }
            if (this.minutes > 0L || str.length() > 6) {
                str = str + this.minutes + "&nbsp;" + DataSheetTag.this.Minutes + ",&nbsp;";
            }
            if (this.seconds > 0L || str.length() > 6) {
                str = str + this.seconds + "&nbsp;" + DataSheetTag.this.Seconds + "&nbsp;";
            }
            return str;
        }
    }

    private class MyNodeList
    extends ArrayList
    implements NodeList {
        private MyNodeList() {
        }

        public Node item(int i) {
            return (Node)super.get(i);
        }

        public int getLength() {
            return super.size();
        }
    }
}

