/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.jsfext.component.factory.basic;

import com.sun.enterprise.tools.jsfext.component.ComponentUtil;
import com.sun.enterprise.tools.jsfext.component.factory.ComponentFactoryBase;
import com.sun.enterprise.tools.jsfext.component.factory.basic.TreeAdaptor;
import com.sun.enterprise.tools.jsfext.layout.descriptor.LayoutComponent;
import com.sun.enterprise.tools.jsfext.util.Util;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

public class DynamicTreeNodeFactory
extends ComponentFactoryBase {
    public static final String TREE_ADAPTOR_CLASS = "treeAdaptorClass";

    public UIComponent create(FacesContext context, LayoutComponent descriptor, UIComponent parent) {
        TreeAdaptor treeAdaptor = this.getTreeAdaptor(context, descriptor, parent);
        treeAdaptor.init();
        Object currentObj = treeAdaptor.getTreeNodeObject();
        return this.processNode(context, treeAdaptor, currentObj, parent);
    }

    protected TreeAdaptor getTreeAdaptor(FacesContext ctx, LayoutComponent desc, UIComponent parent) {
        TreeAdaptor adaptor = null;
        Object cls = desc.getEvaluatedOption(ctx, TREE_ADAPTOR_CLASS, parent);
        if (cls == null) {
            throw new IllegalArgumentException("'treeAdaptorClass' must be specified!");
        }
        try {
            Class adaptorClass = Util.getClass(cls);
            adaptor = (TreeAdaptor)adaptorClass.getMethod("getInstance", FacesContext.class, LayoutComponent.class, UIComponent.class).invoke((Object)null, ctx, desc, parent);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
        return adaptor;
    }

    protected UIComponent processNode(FacesContext ctx, TreeAdaptor adaptor, Object currentObj2, UIComponent parent) {
        String id = adaptor.getId(currentObj2);
        String factoryClass = adaptor.getFactoryClass(currentObj2);
        Map props = adaptor.getFactoryOptions(currentObj2);
        Properties properties = Util.mapToProperties(props);
        UIComponent node = ComponentUtil.getChild(parent, id, factoryClass, properties);
        if (parent != null) {
            parent.getFacets().remove(id);
            parent.getChildren().add(node);
        }
        this.configureTreeNode(ctx, adaptor, node, currentObj2);
        List children = adaptor.getChildTreeNodeObjects(currentObj2);
        if (children != null) {
            for (Object currentObj2 : children) {
                this.processNode(ctx, adaptor, currentObj2, node);
            }
        }
        return node;
    }

    protected void configureTreeNode(FacesContext ctx, TreeAdaptor adaptor, UIComponent treeNode, Object currentObj) {
        Iterator it;
        Map handlersByType;
        Map facets = adaptor.getFacets(treeNode, currentObj);
        Map treeNodeFacets = treeNode.getFacets();
        if (facets != null) {
            for (String facetName : facets.keySet()) {
                Object facetValue = facets.get(facetName);
                if (facetValue == null) continue;
                treeNodeFacets.put(facetName, facetValue);
            }
        }
        if ((handlersByType = adaptor.getHandlersByType(treeNode, currentObj)) != null && (it = handlersByType.keySet().iterator()).hasNext()) {
            String eventType = null;
            Map compAttrs = treeNode.getAttributes();
            while (it.hasNext()) {
                eventType = (String)it.next();
                compAttrs.put(eventType, handlersByType.get(eventType));
            }
        }
    }
}

