/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.jsfext.event.handlers;

import com.sun.enterprise.tools.jsfext.component.ComponentUtil;
import com.sun.enterprise.tools.jsfext.event.UIComponentHolder;
import com.sun.enterprise.tools.jsfext.event.handlers.HandlerContext;
import com.sun.enterprise.tools.jsfext.event.handlers.HandlerContextImpl;
import com.sun.enterprise.tools.jsfext.event.handlers.HandlerDefinition;
import com.sun.enterprise.tools.jsfext.event.handlers.IODescriptor;
import com.sun.enterprise.tools.jsfext.event.handlers.OutputMapping;
import com.sun.enterprise.tools.jsfext.util.TypeConverter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import javax.faces.component.UIComponent;

public class Handler
implements Serializable {
    private HandlerDefinition _handlerDef = null;
    private Map _inputs = new HashMap();
    private Map _outputs = new HashMap();

    public Handler(HandlerDefinition handlerDef) {
        this.setHandlerDefinition(handlerDef);
    }

    public HandlerDefinition getHandlerDefinition() {
        return this._handlerDef;
    }

    protected void setHandlerDefinition(HandlerDefinition handler) {
        this._handlerDef = handler;
    }

    public void setInputValue(String name, Object value) {
        this._inputs.put(name, value);
    }

    protected Map getInputMap() {
        return this._inputs;
    }

    public Object getInputValue(String name) {
        return this._inputs.get(name);
    }

    public Object getInputValue(HandlerContext ctx, String name) {
        IODescriptor inDesc = this.getHandlerDefinition().getInputDef(name);
        if (inDesc == null) {
            throw new RuntimeException("Attempted to get input value '" + name + "', however, this is not a declared input " + "parameter in handler definition '" + this.getHandlerDefinition().getId() + "'!  Check your handler " + " and/or the XML (near LayoutElement '" + ctx.getLayoutElement().getId(ctx.getFacesContext(), null) + "')");
        }
        Object value = this.getInputValue(name);
        if (value == null) {
            if (inDesc.isRequired()) {
                throw new RuntimeException("'" + name + "' is required for handler '" + this.getHandlerDefinition().getId() + "'!");
            }
            value = inDesc.getDefault();
        }
        EventObject event = ctx.getEventObject();
        UIComponent component = null;
        if (event instanceof UIComponentHolder) {
            component = ((UIComponentHolder)((Object)event)).getUIComponent();
        }
        if (value != null && value instanceof String) {
            value = ComponentUtil.resolveValue(ctx.getFacesContext(), ctx.getLayoutElement(), component, "" + value);
        }
        value = TypeConverter.asType(inDesc.getType(), value);
        return value;
    }

    public Object getOutputValue(HandlerContext context, String name) {
        HandlerDefinition handlerDef = this.getHandlerDefinition();
        IODescriptor outIODesc = handlerDef.getOutputDef(name);
        if (outIODesc == null) {
            throw new RuntimeException("Attempted to get output value '" + name + "' from handler '" + handlerDef.getId() + "', however, this is not a declared output parameter!  " + "Check your handler and/or the XML.");
        }
        OutputMapping outputDesc = this.getOutput(name);
        return outputDesc.getOutputType().getValue(context, outIODesc, outputDesc.getOutputKey());
    }

    public void setOutputValue(HandlerContext context, String name, Object value) {
        HandlerDefinition handlerDef = this.getHandlerDefinition();
        IODescriptor outIODesc = handlerDef.getOutputDef(name);
        if (outIODesc == null) {
            throw new RuntimeException("Attempted to set output value '" + name + "' from handler '" + handlerDef.getId() + "', however, this is not a declared output parameter!  " + "Check your handler and/or the XML.");
        }
        OutputMapping outputMapping = this.getOutput(name);
        if (outputMapping == null) {
            return;
        }
        value = TypeConverter.asType(outIODesc.getType(), value);
        EventObject event = context.getEventObject();
        UIComponent component = null;
        if (event instanceof UIComponentHolder) {
            component = ((UIComponentHolder)((Object)event)).getUIComponent();
        }
        outputMapping.getOutputType().setValue(context, outIODesc, "" + ComponentUtil.resolveValue(context.getFacesContext(), context.getLayoutElement(), component, outputMapping.getOutputKey()), value);
    }

    public void setOutputMapping(String outputName, String targetKey, String targetType) {
        if (targetKey != null && (targetKey = targetKey.trim()).length() == 0) {
            targetKey = null;
        }
        targetType = targetType.trim();
        try {
            this._outputs.put(outputName, new OutputMapping(outputName, targetKey, targetType));
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException("Unable to create OutputMapping with given information: outputName='" + outputName + "', targetKey='" + targetKey + "', targetType=" + targetType + "'", ex);
        }
    }

    public OutputMapping getOutput(String name) {
        return (OutputMapping)this._outputs.get(name);
    }

    public boolean isStatic() {
        return this.getHandlerDefinition().isStatic();
    }

    public Object invoke(HandlerContext handlerContext) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Object retVal = null;
        HandlerDefinition handlerDef = this.getHandlerDefinition();
        Method method = handlerDef.getHandlerMethod();
        Object result = handlerContext.getLayoutElement().dispatchHandlers(new HandlerContextImpl(handlerContext), handlerDef.getChildHandlers());
        if (method != null) {
            Object instance = null;
            if (!this.isStatic()) {
                instance = method.getDeclaringClass().newInstance();
            }
            if ((retVal = method.invoke(instance, handlerContext)) != null) {
                result = retVal;
            }
        }
        return result;
    }
}

