/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.jsfext.layout;

import com.sun.enterprise.tools.jsfext.component.EditorComponent;
import com.sun.enterprise.tools.jsfext.layout.LayoutViewRoot;
import com.sun.enterprise.tools.jsfext.layout.descriptor.LayoutComponent;
import com.sun.enterprise.tools.jsfext.layout.descriptor.LayoutDefinition;
import com.sun.enterprise.tools.jsfext.layout.descriptor.LayoutElement;
import com.sun.enterprise.tools.jsfext.layout.descriptor.LayoutFacet;
import com.sun.enterprise.tools.jsfext.layout.descriptor.Resource;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Locale;
import javax.faces.FactoryFinder;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class LayoutViewHandler
extends ViewHandler {
    public static final String LAVA_CHANNEL_KEY = "lavaChannel";
    private ViewHandler _oldViewHandler = null;
    static final String LAVA_CHANNEL_TARGET_KEY = "_lavaChannelTarget";
    private static final boolean EDITOR_ENABLED = true;
    private boolean _editArea = false;

    public LayoutViewHandler(ViewHandler oldViewHandler) {
        this._oldViewHandler = oldViewHandler;
    }

    public UIViewRoot createView(FacesContext context, String viewId) {
        Locale locale = null;
        String renderKitId = null;
        if (context.getViewRoot() != null) {
            locale = context.getViewRoot().getLocale();
            renderKitId = context.getViewRoot().getRenderKitId();
        }
        LayoutViewRoot viewRoot = new LayoutViewRoot();
        viewRoot.setViewId(viewId);
        viewRoot.setLayoutDefinitionKey(viewId);
        if (context.getViewRoot() == null) {
            context.setViewRoot((UIViewRoot)viewRoot);
        }
        if (locale == null) {
            locale = this.calculateLocale(context);
        }
        viewRoot.setLocale(locale);
        if (renderKitId == null) {
            renderKitId = this.calculateRenderKitId(context);
        }
        viewRoot.setRenderKitId(renderKitId);
        LayoutDefinition def = viewRoot.getLayoutDefinition(context);
        if (def != null) {
            Iterator it = def.getResources().iterator();
            Resource resource = null;
            while (it.hasNext()) {
                resource = (Resource)it.next();
                resource.getFactory().getResource(context, resource);
            }
            this.buildUIComponentTree(context, (UIComponent)viewRoot, def);
        }
        return viewRoot;
    }

    protected void buildUIComponentTree(FacesContext context, UIComponent parent, LayoutElement elt) {
        Iterator it = elt.getChildLayoutElements().iterator();
        UIComponent child = null;
        while (it.hasNext()) {
            LayoutElement childElt = (LayoutElement)it.next();
            if (childElt instanceof LayoutFacet && !((LayoutFacet)childElt).isRendered()) {
                this.buildUIComponentTree(context, parent, childElt);
            }
            if (childElt instanceof LayoutComponent) {
                try {
                    UIComponent useParent = parent;
                    if (this._editArea) {
                        useParent = this.createWrapperComponent(context, parent, childElt.getId(context, parent));
                    }
                    child = ((LayoutComponent)childElt).getChild(context, useParent);
                    if (((LayoutComponent)childElt).getOption("editableContent") != null) {
                        this._editArea = true;
                        this.buildUIComponentTree(context, child, childElt);
                        this._editArea = false;
                        continue;
                    }
                    this.buildUIComponentTree(context, child, childElt);
                    continue;
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            this.buildUIComponentTree(context, parent, childElt);
        }
    }

    private UIComponent createWrapperComponent(FacesContext context, UIComponent parent, String id) {
        EditorComponent wrapper = new EditorComponent();
        wrapper.setId(id + "_editor");
        parent.getChildren().add(wrapper);
        return wrapper;
    }

    public UIViewRoot restoreView(FacesContext context, String viewId) {
        UIViewRoot root = this._oldViewHandler.restoreView(context, viewId);
        return root;
    }

    public void renderView(FacesContext context, UIViewRoot viewToRender) throws IOException {
        LayoutDefinition def = null;
        if (viewToRender instanceof LayoutViewRoot) {
            def = ((LayoutViewRoot)viewToRender).getLayoutDefinition(context);
        }
        if (def == null) {
            this._oldViewHandler.renderView(context, viewToRender);
        } else {
            ResponseWriter writer = this.setupResponseWriter(context);
            writer.startDocument();
            UIComponent target = (UIComponent)context.getExternalContext().getRequestMap().get(LAVA_CHANNEL_TARGET_KEY);
            if (target != null) {
                LayoutViewHandler.renderComponent(context, target);
            } else {
                def.encode(context, (UIComponent)viewToRender);
            }
            writer.endDocument();
        }
    }

    private static void renderComponent(FacesContext context, UIComponent comp) throws IOException {
        if (!comp.isRendered()) {
            return;
        }
        comp.encodeBegin(context);
        if (comp.getRendersChildren()) {
            comp.encodeChildren(context);
        } else {
            UIComponent child2 = null;
            for (UIComponent child2 : comp.getChildren()) {
                LayoutViewHandler.renderComponent(context, child2);
            }
        }
        comp.encodeEnd(context);
    }

    private ResponseWriter setupResponseWriter(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (writer != null) {
            return writer;
        }
        ExternalContext extCtx = context.getExternalContext();
        ServletResponse response = (ServletResponse)extCtx.getResponse();
        RenderKitFactory renderFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        RenderKit renderKit = renderFactory.getRenderKit(context, context.getViewRoot().getRenderKitId());
        String contentTypeList = (String)extCtx.getRequestHeaderMap().get("Accept");
        if (!contentTypeList.toLowerCase().contains("text/html")) {
            contentTypeList = contentTypeList + ",text/html;q=1.0";
        }
        writer = renderKit.createResponseWriter((Writer)new OutputStreamWriter((OutputStream)response.getOutputStream()), contentTypeList, ((ServletRequest)extCtx.getRequest()).getCharacterEncoding());
        context.setResponseWriter(writer);
        response.setContentType("text/html");
        return writer;
    }

    public void writeState(FacesContext context) throws IOException {
        UIViewRoot root = context.getViewRoot();
        if (root == null || !(root instanceof LayoutViewRoot) || ((LayoutViewRoot)root).getLayoutDefinition(context) == null) {
            this._oldViewHandler.writeState(context);
        } else {
            StateManager stateManager = context.getApplication().getStateManager();
            StateManager.SerializedView view = stateManager.saveSerializedView(context);
            if (stateManager.isSavingStateInClient(context)) {
                stateManager.writeState(context, view);
            }
        }
    }

    public String getResourceURL(FacesContext context, String path) {
        return this._oldViewHandler.getResourceURL(context, path);
    }

    public String getActionURL(FacesContext context, String viewId) {
        return this._oldViewHandler.getActionURL(context, viewId);
    }

    public Locale calculateLocale(FacesContext context) {
        return this._oldViewHandler.calculateLocale(context);
    }

    public String calculateRenderKitId(FacesContext context) {
        return this._oldViewHandler.calculateRenderKitId(context);
    }
}

